const compiler_sfc_1 = require("@vue/compiler-sfc");
const plugin = () => {
    return {
        parseSFC(fileName, content) {
            if (fileName.endsWith('.vue')) {
                return (0, compiler_sfc_1.parse)(content, { sourceMap: false, ignoreEmpty: false });
            }
        },
        updateSFC(sfc, change) {
            // avoid broken @vue/compiler-sfc cache
            if (!sfc.__volar_clone) {
                sfc = JSON.parse(JSON.stringify(sfc));
                sfc.__volar_clone = true;
            }
            const blocks = [
                sfc.descriptor.template,
                sfc.descriptor.script,
                sfc.descriptor.scriptSetup,
                ...sfc.descriptor.styles,
                ...sfc.descriptor.customBlocks,
            ].filter((block) => !!block);
            const hitBlock = blocks.find(block => change.start >= block.loc.start.offset && change.end <= block.loc.end.offset);
            if (!hitBlock) {
                return;
            }
            hitBlock.content =
                hitBlock.content.substring(0, change.start - hitBlock.loc.start.offset)
                    + change.newText
                    + hitBlock.content.substring(change.end - hitBlock.loc.start.offset);
            const lengthDiff = change.newText.length - (change.end - change.start);
            for (const block of blocks) {
                if (block.loc.start.offset > change.end) {
                    block.loc.start.offset += lengthDiff;
                }
                if (block.loc.end.offset >= change.end) {
                    block.loc.end.offset += lengthDiff;
                }
            }
            return sfc;
        },
    };
};
module.exports = plugin;
//# sourceMappingURL=file-vue.js.map