import type * as ts from 'typescript/lib/tsserverlibrary';
import { LanguageServiceHost, VueCompilerOptions } from './types';
import { EmbeddedFile, SourceFile, VueLanguagePlugin } from './sourceFile';
export declare type LanguageContext = ReturnType<typeof createLanguageContext>;
export declare function getPlugins(ts: typeof import('typescript/lib/tsserverlibrary'), rootDir: string, compilerOptions: ts.CompilerOptions, _vueCompilerOptions: VueCompilerOptions, extraPlugins?: VueLanguagePlugin[]): {
    order?: number | undefined;
    parseSFC?(fileName: string, content: string): import("@vue/compiler-sfc").SFCParseResult | undefined;
    updateSFC?(oldResult: import("@vue/compiler-sfc").SFCParseResult, textChange: {
        start: number;
        end: number;
        newText: string;
    }): import("@vue/compiler-sfc").SFCParseResult | undefined;
    compileSFCTemplate?(lang: string, template: string, options?: import("@vue/compiler-core").CompilerOptions | undefined): import("@vue/compiler-core").CodegenResult | undefined;
    updateSFCTemplate?(oldResult: import("@vue/compiler-core").CodegenResult, textChange: {
        start: number;
        end: number;
        newText: string;
    }): import("@vue/compiler-core").CodegenResult | undefined;
    getEmbeddedFileNames?(fileName: string, sfc: import("./sourceFile").Sfc): string[];
    resolveEmbeddedFile?(fileName: string, sfc: import("./sourceFile").Sfc, embeddedFile: EmbeddedFile): void;
}[];
export declare function createLanguageContext(host: LanguageServiceHost, extraPlugins?: VueLanguagePlugin[], exts?: string[]): {
    typescriptLanguageServiceHost: ts.LanguageServiceHost;
    mapper: {
        get: (fileName: string) => SourceFile;
        delete: (fileName: string) => boolean;
        has: (fileName: string) => boolean;
        set: (fileName: string, vueFile: SourceFile) => SourceFile;
        getFileNames: () => string[];
        getDirs: () => string[];
        getAll: () => SourceFile[];
        getTeleport: (fileName: string) => import(".").Teleport | undefined;
        getAllEmbeddeds: () => Generator<{
            vueFile: SourceFile;
            embedded: import("./sourceFile").Embedded;
        }, void, unknown>;
        fromEmbeddedLocation: (fileName: string, start: number, end?: number | undefined, filter?: ((data: import("./types").EmbeddedFileMappingData) => boolean) | undefined, sourceMapFilter?: ((sourceMap: import(".").EmbeddedFileSourceMap) => boolean) | undefined) => Generator<{
            fileName: string;
            range: {
                start: number;
                end: number;
            };
            mapped: {
                vueFile: SourceFile;
                embedded: import("./sourceFile").Embedded;
            };
            data: import("./types").EmbeddedFileMappingData;
        } | {
            fileName: string;
            range: {
                start: number;
                end: number;
            };
            mapped?: undefined;
            data?: undefined;
        }, void, unknown>;
        fromEmbeddedFile: (file: EmbeddedFile) => SourceFile | undefined;
        fromEmbeddedFileName: (fileName: string) => {
            vueFile: SourceFile;
            embedded: import("./sourceFile").Embedded;
        } | undefined;
    };
    plugins: {
        order?: number | undefined;
        parseSFC?(fileName: string, content: string): import("@vue/compiler-sfc").SFCParseResult | undefined;
        updateSFC?(oldResult: import("@vue/compiler-sfc").SFCParseResult, textChange: {
            start: number;
            end: number;
            newText: string;
        }): import("@vue/compiler-sfc").SFCParseResult | undefined;
        compileSFCTemplate?(lang: string, template: string, options?: import("@vue/compiler-core").CompilerOptions | undefined): import("@vue/compiler-core").CodegenResult | undefined;
        updateSFCTemplate?(oldResult: import("@vue/compiler-core").CodegenResult, textChange: {
            start: number;
            end: number;
            newText: string;
        }): import("@vue/compiler-core").CodegenResult | undefined;
        getEmbeddedFileNames?(fileName: string, sfc: import("./sourceFile").Sfc): string[];
        resolveEmbeddedFile?(fileName: string, sfc: import("./sourceFile").Sfc, embeddedFile: EmbeddedFile): void;
    }[];
};
