Object.defineProperty(exports, "__esModule", { value: true });
exports.decorate = void 0;
const semver = require("semver");
const _4_7_1 = require("./4_7");
const _4_4_1 = require("./4_4");
const _4_0_1 = require("./4_0");
function decorate(ts, host, service) {
    if (semver.gte(ts.version, '4.7.0')) {
        (0, _4_7_1.default)(ts, host, service);
        return true;
    }
    else if (semver.gte(ts.version, '4.4.0')) {
        (0, _4_4_1.default)(ts, host, service);
        return true;
    }
    else if (semver.gte(ts.version, '4.0.0')) {
        (0, _4_0_1.default)(ts, host, service);
        return true;
    }
    return false;
}
exports.decorate = decorate;
//# sourceMappingURL=index.js.map