package com.bcxin.ars.util.huawei;

/**
 * 华为云会议相关接口地址
 *
 * @author llc
 * @date 2019-12-10
 */
public final class HuaweiMeetConst {

	public final static int HUAWEI_SUCCESS_CODE = 200;

	public final static String GATEWAY_URL = "https://api.meeting.huaweicloud.com";;

	/***---------------------个人相关---------------------***/

	/*** 登陆鉴权 ***/
	public final static String GET_ACCESSTOKEN = "/v1/usg/acs/auth/account";
	/*** 登陆鉴权 个人***/
	public final static String GET_SELF_ACCESSTOKEN = "/v1/usg/acs/auth/account";
    /*** 用户查询自己的信息 ***/
    public final static String GET_USERMENBER = "/v1/usg/dcs/member";

	/*** 新增用户 ***/
	public final static String ADD_USER = "/v1/usg/dcs/corp/member";


	/*** 批量删除用户 ***/
	public final static String BATCH_DELETE_USER = "/v1/usg/dcs/corp/member/delete";




	/***---------------------企业相关---------------------***/

	/*** 获取企业管理资源 ***/
	public final static String GET_MANAGE_RESOURCE = "/v1/usg/dcs/corp/resource";





	/***---------------------会议相关---------------------***/
	public final static String ADD_CONFERENCES = "/conferences";
    public final static String ADD_CONFERENCES_V1 ="/v1/mmc/management/conferences";
    //获取录屏文件信息
    public final static String RECORD_V1 = "/v1/mmc/management/record/files";
	public final static String RESOURSE_V1 = "/v1/usg/dcs/corp/resource";
	/***
	 * 会议录屏文件排序
	 */
	public final static String SORTTYPE_DSC_StartTIME ="DSC_StartTIME";
	/*历史会议*/
	public final static String HISTORY_CONFERENCES = "/historyConferences/{confuuid}";
	/*历史会议*/
	public final static String HISTORY_CONFERENCESV1 = "/v1/mmc/management/conferences/history";
	/**
	 * 添加与会者
	 */
	public final static String ADD_CONFERENCES_ATTENDEES = "/conferences/{conferenceid}/participants";
	/**
	 * 获取会控Token
	 */
	public final static String ADD_CONFERENCES_CTRL_TOKEN = "/conferences/{conferenceid}/token";


    /**
     * 录播类型。
     * 0: 禁用 。
     * 1: 直播 。
     * 2: 录播。
     * 3: 直播+录播。
     */
	public final static String RECORDTYPE_JY="0";
	public final static String RECORDTYPE_LB="2";
    /***
     * 是否使用VMR召开预约会议 是
     */
    public final static String VMRFLAG_YES="1";
    public final static String VMRFLAG_NO="0";

    /***
     * 会议模式，会议室
     */
    public final static String CONFERENCEMODEL_CLOUD="2";
    /***
     * 会议模式，个人会议
     */
    public final static String CONFERENCEMODEL_PERSON="1";
    /***
     * 会议是否自动启动录制，在录播类型为：录播、录播+直播时才生效。
     */
    public final static String AUTORECORD_YES="1";

	/**
	 * 获取云会议室 列表
	 */
    public final static String GET_CLOUD_MEETING_ROOM = "/v1/usg/dcs/corp/vmr";

	/**
	 * 云会议室回收
	 */
	public final static String RECYCLE_CLOUD_MEETING_ROOM = "/v1/usg/dcs/corp/vmr/recycle-from-member/{account}";

	/**
	 * 云会议室分配
	 */
	public final static String ASSIGN_CLOUD_MEETING_ROOT = "/v1/usg/dcs/corp/vmr/assign-to-member/{account}";
}