package com.bcxin.ars.util.gx.encry;

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;

public class AES {
    public static String encrypt(String content, String password) {
        try {
            String ENCRYPT_CHARSET = "UTF-8";
            //SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG" );
            // KeyGenerator kgen = KeyGenerator.getInstance("AES");

            Security.addProvider(new sun.security.provider.Sun());
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", new sun.security.provider.Sun());
            KeyGenerator kgen = KeyGenerator.getInstance("AES");

            secureRandom.setSeed(password.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");// 创建密码器
            byte[] byteContent = content.getBytes(ENCRYPT_CHARSET);
            cipher.init(Cipher.ENCRYPT_MODE, key);// 初始化
            byte[] result = cipher.doFinal(byteContent);
            if (result != null && result.length > 0) {
                /*
                 * 注意：
                 * return new String(result,ENCRYPT_CHARSET);
                 * 会出现javax.crypto.IllegalBlockSizeException:
                 * Input length must be multiple of 16 when decrypting with padded cipher
                 * 加密后的byte数组是不能强制转换成字符串的，
                 * 字符串和byte数组在这种情况下不是互逆的；
                 * 需要将二进制数据转换成十六进制表示
                 */
                return parseByte2HexStr(result);

            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        } catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String parseByte2HexStr(byte buf[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }


    public static String decrypt(String content, String password) {
        try {
            if (content == null) {
                return null;
            }

            byte[] newContent = parseHexStr2Byte(content);
            Security.addProvider(new sun.security.provider.Sun());
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", new sun.security.provider.Sun());
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            secureRandom.setSeed(password.getBytes());
            kgen.init(128, secureRandom);
            //kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();


            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");// 创建密码器
            cipher.init(Cipher.DECRYPT_MODE, key);// 初始化
            byte[] result = cipher.doFinal(newContent);
            if (result != null && result.length > 0) {
                return new String(result, "UTF-8");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1)
            return null;
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2),
                    16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

}
