package com.bcxin.ars.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.util.Date;
import java.util.Map;

@Component
public class JwtUtil {

    /**
     * jwt秘钥 平台固定私钥
     */
    private static final String JWT_SECRET = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";

    /**
     * millisecond 7天重新登录的时间间隔
     */
    private static final int JWT_REFRESH_TTL = 7*24*60*60*1000;

    /**
     * 由字符串生成加密key
     * @return
     */
    private static SecretKey generalKey(String stringKey){
        byte[] encodedKey = Base64.decodeBase64(stringKey);
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }

    /**
     * 创建jwt，ttlMillis为负数表示不过期
     * @param id
     * @param subject
     * @param ttlMillis
     * @return
     * @throws Exception
     */
    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setId(id)
                .setIssuedAt(new Date(System.currentTimeMillis()))
                .setSubject(subject)
                .signWith(signatureAlgorithm, generalKey(stringKey));
        if (ttlMillis >= 0) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(Map<String,String> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
//				.setId(JwtUtil.JWT_ID) // 暂时不用，减少流量
//				.setIssuedAt(new Date(System.currentTimeMillis())) //发行时间  暂时不用，减少流量
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(Map<Object,Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
//				.setId(JwtUtil.JWT_ID) // 暂时不用，减少流量
//				.setIssuedAt(new Date(System.currentTimeMillis())) //发行时间  暂时不用，减少流量
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(stringKey)); //选择的算法，和私钥值
        if (ttlMillis >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 解密jwt
     * @param jwttoken
     * @return
     * @throws Exception
     */
    public static Claims parseJWT(String jwttoken) {
        return Jwts.parser()
                .setSigningKey(generalKey(JWT_SECRET))
                .parseClaimsJws(jwttoken).getBody();
    }

    /**
     * 创建jwt
     *
     * @param subject
     * @return
     */
    public static String createJWT(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
//				.setId(JwtUtil.JWT_ID) // 暂时不用，减少流量
//				.setIssuedAt(new Date(System.currentTimeMillis())) //发行时间  暂时不用，减少流量
                .setSubject(subject) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static void main(String[] args) throws Exception {
        /* 加密*/
        Map<String, String> param = Maps.newHashMap();
        //模拟参数1
        param.put("viewCode", "PSSAB_ABTS");
        //模拟参数2
        //param.put("qiye", "111");
        //param.put("activityNo", "640100");
        //param.put("activityNo", "640100");
        //param.put("activityNo", "640100");
        //param.put("activityNo", "640100");
        //param.put("activityNo", "640100");
        //加密生成token
        String token = JwtUtil.createJWT(param);
        System.out.println("加密后数据：" + token);
token ="eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7XCJhcmVhQ29kZVwiOlwiJzExMDFfXydcIixcInZpZXdDb2RlXCI6XCJCQkRfUVlUU1wifSIsImV4cCI6MTU4OTQ0NTUxN30.oGWwHhmNdYa4iFHVVUfPdMVz7552fxLIlpZuVCL73_E";
        Map<String, Object> requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        //HttpUtil.post("http://114.116.164.42:8014/third/shanma/camera/analyze",requestMap);

        /* 解密*/
        Claims claims = JwtUtil.parseJWT(token);
        String paramStr =  claims.getSubject();
        Map<String,Object> paramMap = JSON.parseObject(paramStr, Map.class);
        System.out.println(paramMap);
    }

}
