//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.bcxin.ars.util;

import javax.crypto.*;
import javax.crypto.spec.DESKeySpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.SecureRandom;

public class CipherDESUtil {

    public CipherDESUtil() {
    }

    /**
     * 加密
     * @param datasource
     * @param password
     * @return
     * @throws Exception
     */
    public static byte[] encrypt(byte[] datasource, String password) throws Exception {
        // DES算法要求有一个可信任的随机数源
        SecureRandom random = new SecureRandom();
        //创建一个密匙工厂，然后用它把DESKeySpec转换成securekey
        DESKeySpec desKey = new DESKeySpec(password.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        //Cipher对象实际完成加密操作
        Cipher cipher = Cipher.getInstance("DES");
        //用密匙初始化Cipher对象
        cipher.init(Cipher.ENCRYPT_MODE, securekey, random);
        //现在，获取数据并加密
        //正式执行加密操作
        return cipher.doFinal(datasource);
    }

    /**
     * 解密
     * @param src
     * @param password
     * @return
     * @throws Exception
     */
    public static byte[] decrypt(byte[] src, String password) throws Exception {
        // DES算法要求有一个可信任的随机数源
        SecureRandom random = new SecureRandom();
        // 创建一个DESKeySpec对象
        DESKeySpec desKey = new DESKeySpec(password.getBytes());
        // 创建一个密匙工厂
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        // 将DESKeySpec对象转换成SecretKey对象
        SecretKey securekey = keyFactory.generateSecret(desKey);
        // Cipher对象实际完成解密操作
        Cipher cipher = Cipher.getInstance("DES");
        // 用密匙初始化Cipher对象
        cipher.init(Cipher.DECRYPT_MODE, securekey, random);
        // 真正开始解密操作
        return cipher.doFinal(src);
    }

    public static void encryptFile(String file, String destFile, String key) throws Exception {
        DESKeySpec desKey = new DESKeySpec(key.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, securekey);
        FileInputStream is = new FileInputStream(file);
        FileOutputStream out = new FileOutputStream(destFile);
        CipherInputStream cis = new CipherInputStream(is, cipher);
        byte[] buffer = new byte[1024];

        int r;
        while((r = cis.read(buffer)) > 0) {
            out.write(buffer, 0, r);
        }

        cis.close();
        is.close();
        out.close();
    }

    public static byte[] decryptFile(byte[] src, String key) throws Exception {
        DESKeySpec desKey = new DESKeySpec(key.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, securekey);
        ByteArrayInputStream is = new ByteArrayInputStream(src);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CipherOutputStream cos = new CipherOutputStream(out, cipher);
        byte[] buffer = new byte[1024];

        int r;
        while((r = is.read(buffer)) >= 0) {
            cos.write(buffer, 0, r);
        }

        cos.flush();
        cos.close();
        byte[] result = out.toByteArray();
        out.close();
        is.close();
        return result;
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();

        for(int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 255);
            if(hex.length() == 1) {
                hex = '0' + hex;
            }

            sb.append(hex.toUpperCase());
        }

        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if(hexStr.length() < 1) {
            return null;
        } else {
            byte[] result = new byte[hexStr.length() / 2];

            for(int i = 0; i < hexStr.length() / 2; ++i) {
                int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
                int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
                result[i] = (byte)(high * 16 + low);
            }

            return result;
        }
    }

    /**
     * 以特定的方式加密字符串
     * @param str
     * @return
     */
    public static String encrypt(String str){
        byte[] buf = new byte[0];
        try {
            buf = CipherDESUtil.encrypt(str.getBytes(), "PSSPLATFORM");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CipherDESUtil.parseByte2HexStr(buf);
    }

    /**
     * 以特定的方式加密字符串
     * @param str
     * @return
     */
    public static String encrypt(Long str){
        byte[] buf = new byte[0];
        try {
            buf = CipherDESUtil.encrypt(str.toString().getBytes(), "PSSPLATFORM");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CipherDESUtil.parseByte2HexStr(buf);
    }


    /**
     * 以特定的方式解密字符串
     * @param str
     * @return
     */
    public static String decrypt(String str){

        String newStr = null;
        try {
            newStr = new String(CipherDESUtil.decrypt(CipherDESUtil.parseHexStr2Byte(str), "PSSPLATFORM"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return newStr;
    }


    //public static void main(String[] args) {
    //    System.out.println(encrypt("1"));
    //    System.out.println(encrypt("2"));
    //    System.out.println(encrypt("3"));
    //    System.out.println(encrypt("4"));
    //    System.out.println(encrypt("5"));
    //
    //    System.out.println(decrypt("313BB8669AC46CA1"));
    //    System.out.println(decrypt("A493A702D4475AFD"));
    //    System.out.println(decrypt("487571272F0195E1"));
    //    System.out.println(decrypt("4647D421539EB733"));
    //    System.out.println(decrypt("E3684153A8EAD343"));
    //}
}
