/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPushUtil {
    private static final String MASTER_SECRET = "377df7750d2498f4bc045677";
    private static final String APP_KEY = "c00bd896b986a4b8d9becf6f";
    private static JPushClient jpushClient = new JPushClient("377df7750d2498f4bc045677", "c00bd896b986a4b8d9becf6f", null, ClientConfig.getInstance());
    protected static final Logger LOG = LoggerFactory.getLogger(JPushUtil.class);

    public static void sendMessage(String alert) {
        try {
            PushPayload pushPayload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.all()).setNotification(Notification.alert((Object)alert)).build();
            PushResult result = jpushClient.sendPush(pushPayload);
            if (result.isResultOK()) {
                System.out.println("\u63a8\u9001\u6210\u529f");
            } else {
                System.out.println("\u63a8\u9001\u5931\u8d25");
            }
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
        }
    }

    public static void sendMessage(String title, String alert) {
        if (StringUtils.isEmpty((String)title)) {
            JPushUtil.sendMessage(title);
        } else {
            JPushUtil.sendMessageForAndroid(title, alert);
            JPushUtil.sendMessageForIOS(title, alert);
        }
    }

    public static void sendMessage(String title, String alert, String alias) {
        if (StringUtils.isEmpty((String)alert)) {
            LOG.error("alert is empty.");
            return;
        }
        if (!StringUtils.isEmpty((String)alias)) {
            JPushUtil.sendMessageForAndroid(title, alert, alias);
            JPushUtil.sendMessageForIOS(title, alert, alias);
        }
    }

    public static void sendMessage(String title, String alert, String alias, Map<String, String> extras) {
        if (StringUtils.isEmpty((String)alert)) {
            LOG.error("alert is empty.");
            return;
        }
        if (!StringUtils.isEmpty((String)alias)) {
            JPushUtil.sendMessageForAndroid(title, alert, alias, extras);
            JPushUtil.sendMessageForIOS(title, alert, alias, extras);
        }
    }

    private static void sendMessageForAndroid(String title, String alert) {
        try {
            PushPayload pushPayload = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.all()).setNotification(Notification.android((String)alert, (String)title, null)).build();
            PushResult result = jpushClient.sendPush(pushPayload);
            if (result.isResultOK()) {
                System.out.println("\u63a8\u9001\u6210\u529f");
            } else {
                System.out.println("\u63a8\u9001\u5931\u8d25");
            }
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
        }
    }

    private static void sendMessageForAndroid(String title, String alert, String alias) {
        try {
            PushPayload pushPayload = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.alias((String[])new String[]{alias})).setNotification(Notification.android((String)alert, (String)title, null)).build();
            PushResult result = jpushClient.sendPush(pushPayload);
            if (result.isResultOK()) {
                System.out.println("\u63a8\u9001\u6210\u529f");
            } else {
                System.out.println("\u63a8\u9001\u5931\u8d25");
            }
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
        }
    }

    private static void sendMessageForAndroid(String title, String alert, String alias, Map<String, String> extras) {
        try {
            PushResult result = jpushClient.sendAndroidNotificationWithAlias(title, alert, extras, new String[]{alias});
            if (result.isResultOK()) {
                System.out.println("\u63a8\u9001\u6210\u529f");
            } else {
                System.out.println("\u63a8\u9001\u5931\u8d25");
            }
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
        }
    }

    private static void sendMessageForIOS(String title, String alert) {
        try {
            PushPayload pushPayload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)IosNotification.newBuilder().setAlert((Object)title).autoBadge().setSound("happy").build()).build()).setMessage(Message.content((String)alert)).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
            PushResult result = jpushClient.sendPush(pushPayload);
            if (result.isResultOK()) {
                System.out.println("\u63a8\u9001\u6210\u529f");
            } else {
                System.out.println("\u63a8\u9001\u5931\u8d25");
            }
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
        }
    }

    private static void sendMessageForIOS(String title, String alert, String alias) {
        try {
            PushResult result = jpushClient.sendIosNotificationWithAlias(IosAlert.newBuilder().setTitleAndBody(title, null, alert).build(), null, new String[]{alias});
            if (result.isResultOK()) {
                System.out.println("\u63a8\u9001\u6210\u529f");
            } else {
                System.out.println("\u63a8\u9001\u5931\u8d25");
            }
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
        }
    }

    private static void sendMessageForIOS(String title, String alert, String alias, Map<String, String> extras) {
        try {
            PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.alias((String[])new String[]{alias})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)title).addExtras(extras)).setContentAvailable(true).autoBadge().build()).build()).setMessage(Message.content((String)title)).setOptions(Options.newBuilder().setApnsProduction(false).setTimeToLive(90L).build()).build();
            PushResult result = jpushClient.sendPush(payload);
            if (result.isResultOK()) {
                System.out.println("\u63a8\u9001\u6210\u529f");
            } else {
                System.out.println("\u63a8\u9001\u5931\u8d25");
            }
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        String TITLE = "\u767e\u4fdd\u76fe111222";
        String ALERT = "\u4f60\u6709\u65b0\u7684\u4efb\u52a111111221112";
        String REGISTRATION_ID = "13165ffa4e3e5dc130d541";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeid", "1");
        JPushUtil.sendMessageForIOS(TITLE, ALERT, REGISTRATION_ID, map);
    }
}

