/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QRCodeUtil {
    public static String generateQRCode(String text, int width, int height, String format, String pathName) throws Exception {
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        File outputFile = new File(pathName);
        if (!outputFile.exists()) {
            outputFile.mkdirs();
        }
        int margin = 5;
        bitMatrix = QRCodeUtil.updateBit(bitMatrix, margin);
        BufferedImage bi = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        bi = QRCodeUtil.zoomInImage(bi, width, height);
        ImageIO.write((RenderedImage)bi, "jpg", outputFile);
        MatrixToImageWriter.writeToFile((BitMatrix)bitMatrix, (String)format, (File)outputFile);
        return pathName;
    }

    public static String generateBase64QRCode(String content, int width, int height, String format) throws Exception {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, width, height);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)format, (OutputStream)outputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        return "data:image/" + format + ";base64," + encoder.encodeToString(outputStream.toByteArray());
    }

    public static String generateBase64QRCodeForThirdParty(String content, int width, int height, String format) throws Exception {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, width, height);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)format, (OutputStream)outputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(outputStream.toByteArray());
    }

    private static BitMatrix updateBit(BitMatrix matrix, int margin) {
        int tempM = margin * 2;
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + tempM;
        int resHeight = rec[3] + tempM;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = margin; i < resWidth - margin; ++i) {
            for (int j = margin; j < resHeight - margin; ++j) {
                if (!matrix.get(i - margin + rec[0], j - margin + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public static BufferedImage zoomInImage(BufferedImage originalImage, int width, int height) {
        BufferedImage newImage = new BufferedImage(width, height, originalImage.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return newImage;
    }

    public static String parseQRCode(String filePath) {
        String content = "";
        try {
            File file = new File(filePath);
            BufferedImage image = ImageIO.read(file);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            MultiFormatReader formatReader = new MultiFormatReader();
            Result result = formatReader.decode(binaryBitmap, hints);
            content = result.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }
}

