/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.bcxin.ars.dto.pdf.PdfChangeDTO;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtils {
    static final Logger logger = LoggerFactory.getLogger(PDFUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPDFForTemplate(String templatePath, String pdfPath, Object obj) throws IOException, DocumentException {
        PdfReader reader = null;
        FileOutputStream out = null;
        ByteArrayOutputStream bos = null;
        PdfStamper stamper = null;
        Document doc = null;
        try {
            out = new FileOutputStream(pdfPath);
            reader = new PdfReader(templatePath);
            bos = new ByteArrayOutputStream();
            stamper = new PdfStamper(reader, (OutputStream)bos);
            AcroFields form = stamper.getAcroFields();
            for (String fieldName : form.getFields().keySet()) {
                form.setField(fieldName, BeanUtils.getProperty((Object)obj, (String)fieldName));
            }
            stamper.setFormFlattening(true);
            stamper.close();
            doc = new Document();
            PdfCopy copy = new PdfCopy(doc, (OutputStream)out);
            doc.open();
            PdfImportedPage importPage = copy.getImportedPage(new PdfReader(bos.toByteArray()), 1);
            copy.addPage(importPage);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stamper != null) {
                stamper.close();
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) throws IOException, DocumentException {
        String TemplatePDF = "d:/CompanyCertificate-2-6.pdf";
        String outFile = "d:/test.pdf";
        ArrayList<PdfChangeDTO> pdfChangeDTOList = new ArrayList<PdfChangeDTO>();
        for (int i = 0; i < 6; ++i) {
            PdfChangeDTO pdfChangeDTO = new PdfChangeDTO();
            pdfChangeDTO.setProject("\u516c\u53f8\u5730\u5740\u53d8\u66f4" + i);
            pdfChangeDTO.setAfterChange("\u897f\u5b89\u5e02\u5317\u4e8c\u73af\u897f\u6bb5\u897f\u5b89\u519c\u8d44\u5927\u53a66\u5c42\u5f04\u5c97\u8def" + i);
            pdfChangeDTO.setTime("2019-01-24");
            pdfChangeDTOList.add(pdfChangeDTO);
        }
        PDFUtils.addPDFChange(TemplatePDF, outFile, pdfChangeDTOList);
    }

    public static void addPDFChange(String templatePDF, String outFile, List<PdfChangeDTO> pdfChangeDTOList) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(templatePDF);
        PdfStamper ps = new PdfStamper(reader, (OutputStream)new FileOutputStream(outFile));
        AcroFields s = ps.getAcroFields();
        PDFUtils.insertText(ps, s, pdfChangeDTOList);
        ps.close();
        reader.close();
    }

    public static void insertText(PdfStamper ps, AcroFields s, List<PdfChangeDTO> pdfChangeDTOList) throws IOException, DocumentException {
        PdfPCell blankCell;
        List list = s.getFieldPositions("change");
        Rectangle rect = ((AcroFields.FieldPosition)list.get((int)0)).position;
        PdfContentByte cb = ps.getOverContent(1);
        PdfPTable table = new PdfPTable(4);
        table.setTotalWidth(270.0f);
        table.setWidths(new float[]{14.0f, 29.0f, 16.0f, 20.0f});
        BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
        Font font_10 = new Font(bfChinese, 10.0f, 0);
        Font font_7 = new Font(bfChinese, 8.0f, 0);
        Font font_12 = new Font(bfChinese, 12.0f, 0);
        table.addCell(PDFUtils.changeCellAlignment("\u9879   \u76ee", font_12, true, true, 28.0f));
        table.addCell(PDFUtils.changeCellAlignment("\u53d8\u66f4\u540e\u5185\u5bb9", font_12, true, true, 28.0f));
        table.addCell(PDFUtils.changeCellAlignment("\u53d8\u66f4\u65f6\u95f4", font_12, true, true, 28.0f));
        table.addCell(PDFUtils.changeCellAlignment("\u53d8\u66f4\u4e13\u7528\u7ae0", font_12, true, true, 28.0f));
        if (pdfChangeDTOList != null) {
            for (PdfChangeDTO pdfChangeDTO : pdfChangeDTOList) {
                table.addCell(PDFUtils.changeCellAlignment(pdfChangeDTO.getProject(), font_10, true, true, 0.0f));
                table.addCell(PDFUtils.changeCellAlignment(pdfChangeDTO.getAfterChange(), font_7, false, true, 0.0f));
                table.addCell(PDFUtils.changeCellAlignment(pdfChangeDTO.getTime(), font_10, true, true, 0.0f));
                blankCell = new PdfPCell();
                blankCell.setMinimumHeight(28.0f);
                table.addCell(blankCell);
            }
        } else {
            pdfChangeDTOList = new ArrayList<PdfChangeDTO>();
        }
        int size = 7 - pdfChangeDTOList.size();
        for (int i = 0; i < size; ++i) {
            blankCell = new PdfPCell();
            blankCell.setMinimumHeight(28.0f);
            table.addCell(blankCell);
            table.addCell((Phrase)new Paragraph("", font_10));
            table.addCell((Phrase)new Paragraph("", font_10));
            table.addCell(new PdfPCell(new Phrase("")));
        }
        table.writeSelectedRows(0, -1, rect.getLeft(), rect.getTop(), cb);
    }

    private static PdfPCell changeCellAlignment(String projectName, Font font, boolean horizontal, boolean vertical, float minimumHeight) {
        Paragraph paragraph = new Paragraph(projectName, font);
        paragraph.setAlignment(1);
        PdfPCell cell1 = new PdfPCell();
        cell1.setUseAscender(true);
        if (horizontal) {
            cell1.setHorizontalAlignment(1);
        }
        if (vertical) {
            cell1.setVerticalAlignment(5);
        }
        cell1.setPhrase((Phrase)paragraph);
        cell1.setMinimumHeight(minimumHeight);
        return cell1;
    }
}

