/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private static final String JWT_SECRET = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";
    private static final int JWT_REFRESH_TTL = 604800000;

    private static SecretKey generalKey(String stringKey) {
        byte[] encodedKey = Base64.decodeBase64((String)stringKey);
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }

    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(new Date(System.currentTimeMillis())).setSubject(subject).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String createJWT(Map<String, String> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String createJWT(Map<Object, Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims parseJWT(String jwttoken) {
        return (Claims)Jwts.parser().setSigningKey((Key)JwtUtil.generalKey(JWT_SECRET)).parseClaimsJws(jwttoken).getBody();
    }

    public static String createJWT(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(subject).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static void main(String[] args) throws Exception {
        HashMap param = Maps.newHashMap();
        param.put("viewCode", "PSSAB_ABTS");
        String token = JwtUtil.createJWT(param);
        System.out.println("\u52a0\u5bc6\u540e\u6570\u636e\uff1a" + token);
        token = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7XCJhcmVhQ29kZVwiOlwiJzExMDFfXydcIixcInZpZXdDb2RlXCI6XCJCQkRfUVlUU1wifSIsImV4cCI6MTU4OTQ0NTUxN30.oGWwHhmNdYa4iFHVVUfPdMVz7552fxLIlpZuVCL73_E";
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        Claims claims = JwtUtil.parseJWT(token);
        String paramStr = claims.getSubject();
        Map paramMap = (Map)JSON.parseObject((String)paramStr, Map.class);
        System.out.println(paramMap);
    }
}

