/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.bcxin.ars.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EmailUtil {
    private Logger log = LoggerFactory.getLogger(EmailUtil.class);
    @Value(value="${mail_username}")
    private String username;
    @Value(value="${mail_from}")
    private String from;
    @Value(value="${mail_password}")
    private String password;
    @Value(value="${mail_host}")
    private String host;

    public void sendEmail(String subject, String body, String to) {
        try {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.host);
            props.put("mail.smtp.auth", "true");
            props.put("mail.transport.protocol", "smtp");
            Authenticator a = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EmailUtil.this.from, EmailUtil.this.password);
                }
            };
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)a);
            MimeMessage msg = new MimeMessage(session);
            String nick = this.username;
            if (StringUtil.isEmpty(nick)) {
                nick = "\u767e\u5ddd\u4fe1";
            }
            try {
                nick = MimeUtility.encodeText((String)nick);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            msg.setFrom((Address)new InternetAddress(nick + " <" + this.from + ">"));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            msg.setSentDate(new Date());
            msg.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setContent((Object)body, "text/html;charset=UTF-8");
            multipart.addBodyPart((BodyPart)contentPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
            this.log.debug("\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff0c\u6536\u4ef6\u4eba[{}]\uff0c\u4e3b\u9898[{}]\uff0c\u53d1\u9001\u5185\u5bb9[{}]", new Object[]{to, subject, body});
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6536\u4ef6\u4eba[{}]\uff0c\u4e3b\u9898[{}]\uff0c\u53d1\u9001\u5185\u5bb9[{}]", new Object[]{to, subject, body});
            this.log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u5f02\u5e38[{}]", (Object)e.getMessage());
        }
    }
}

