package com.bcxin.ars.util;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import javax.crypto.Cipher;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAUtil {

    private final static Logger logger = LoggerFactory.getLogger(RSAUtil.class);

    private static final KeyPair KEY_PAIR = initKey();
    /**
     * 密文种子, 当想更换RSA钥匙的时候,只需要修改密文种子,即可更换
     */
    private static final String KEY = "8B0045B8A02C85E3B6B979C7F1276476";

    private static KeyPair initKey() {
        try {
            Provider provider=new org.bouncycastle.jce.provider.BouncyCastleProvider();
            Security.addProvider(provider);
            SecureRandom random = new SecureRandom(KEY.getBytes());
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", provider);
            generator.initialize(1024, random);
            return generator.generateKeyPair();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 生成public key
     *
     * @return
     */
    public static String generateBase64PublicKey() {
        RSAPublicKey key = (RSAPublicKey) KEY_PAIR.getPublic();
        return new String(Base64.encodeBase64(key.getEncoded()));
    }

    private static String generateBase64PrivateKey() {
        RSAPrivateKey key = (RSAPrivateKey) KEY_PAIR.getPrivate();
        return new String(Base64.encodeBase64(key.getEncoded()));
    }

    /**
     * 解密
     *
     * @param string
     * @return
     */
    public static String decryptBase64(String string) {
        return new String(decrypt(Base64.decodeBase64(string)));
    }

    private static byte[] decrypt(byte[] string) {
        try {
            Provider provider=new org.bouncycastle.jce.provider.BouncyCastleProvider();
            Security.addProvider(provider);
            Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", provider);
            RSAPrivateKey pbk = (RSAPrivateKey) KEY_PAIR.getPrivate();
            cipher.init(Cipher.DECRYPT_MODE, pbk);
            byte[] plainText = cipher.doFinal(string);
            return plainText;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        System.out.println(generateBase64PublicKey());
        System.out.println(generateBase64PrivateKey());
        //System.out.println(decryptBase64("MSoDwuLJEEQAIN7I8iZ0tx9ZNmO4WnZ4OeeLQXsTmgL4/DIrKpB8zekFYK0PucI41la0hiV/IQKtvT6c49w6B6gZnux0Y5pLKooP1jhIs1NQ/TK7m4CXfTQpJUcBwXbi4aflEJA3S8J6HFhBPloloe9YzF3aUNxnVWrSGcyZcrY="));
    }
}
