package com.bcxin.ars.util;

import com.xiaoleilu.hutool.codec.Base64Encoder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

/**
 * @version V1.0
 * @desc AES 加密工具类
 */
public class AESUtil {

	private static final Logger LOGGER = LoggerFactory.getLogger(AESUtil.class);

	public final static String ENCODING = "UTF-8";
	// 密钥
	public static final String AES_KEY = "2E9316AAB412DFAED10EFF5E03A1EF72";


	private static final String KEY_ALGORITHM = "AES";
	/**
	 * 加解密算法/工作模式/填充方式
	 */
	private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
	/**
	 * AES的密钥长度
	 */
	private static final Integer SECRET_KEY_LENGTH = 128;

	/**
	 * AES 加密
	 *
	 * @param text
	 *            待加密的字符串
	 * @return 加密后的byte[] 数组
	 * @throws Exception
	 */
	public static String encode(String text) throws Exception {
		try {
			String base64Key = AES_KEY;
			byte[] key = parseHexStr2Byte(base64Key);
			SecretKeySpec sKeySpec = new SecretKeySpec(key, "AES");
			Cipher cipher = Cipher.getInstance("AES");
			cipher.init(Cipher.ENCRYPT_MODE, sKeySpec);
			byte[] bjiamihou = cipher.doFinal(text.getBytes(ENCODING));
			String result = parseByte2HexStr(bjiamihou);
			return result;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 解密
	 *
	 * @param content
	 *            待解密内容
	 * @param password
	 *            解密密钥
	 * @param aesLength
	 *            AES加密类型，128、192、256
	 * @return
	 */
	public static String decrypt(String content, String password, int aesLength) {
		try {
			byte[] contentByte = parseHexStr2Byte(content);
			KeyGenerator kgen = KeyGenerator.getInstance("AES");
			SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
			random.setSeed(password.getBytes());
			kgen.init(aesLength, random);
			SecretKey secretKey = kgen.generateKey();
			byte[] enCodeFormat = secretKey.getEncoded();
			SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
			Cipher cipher = Cipher.getInstance("AES");// 创建密码器
			cipher.init(Cipher.DECRYPT_MODE, key);// 初始化
			byte[] result = cipher.doFinal(contentByte);
			return new String(result, "UTF-8");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * AES解密
	 *
	 * @param text
	 *            待解密的字符串
	 * @return 解密后的字符串
	 * @throws Exception
	 */
	public static String decode(String text) throws Exception {
		String base64Key = AES_KEY;
		byte[] key = parseHexStr2Byte(base64Key);
		SecretKeySpec sKeySpec = new SecretKeySpec(key, "AES");
		Cipher cipher = Cipher.getInstance("AES");
		cipher.init(Cipher.DECRYPT_MODE, sKeySpec);
		byte[] bjiemihou = cipher.doFinal(parseHexStr2Byte(text));
		String result = new String(bjiemihou, "UTF-8");
		return result;
	}

	/**
	 * 生成密钥 自动生成base64 编码后的AES128位密钥
	 *
	 * @throws NoSuchAlgorithmException
	 * @throws Exception
	 */
	public static String getAESKey() throws Exception {
		KeyGenerator kg = KeyGenerator.getInstance("AES");
		kg.init(128);// 要生成多少位，只需要修改这里即可128, 192或256
		SecretKey sk = kg.generateKey();
		byte[] b = sk.getEncoded();
		return parseByte2HexStr(b);
	}

	/**
	 * 将16进制转换为二进制
	 *
	 * @param hexStr
	 * @return
	 */
	public static byte[] parseHexStr2Byte(String hexStr) {
		if (hexStr.length() < 1)
			return null;
		byte[] result = new byte[hexStr.length() / 2];
		for (int i = 0; i < hexStr.length() / 2; i++) {
			int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
			int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
			result[i] = (byte) (high * 16 + low);
		}
		return result;
	}

	/**
	 * 将二进制转换成16进制
	 *
	 * @param buf
	 * @return
	 */
	public static String parseByte2HexStr(byte buf[]) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < buf.length; i++) {
			String hex = Integer.toHexString(buf[i] & 0xFF);
			if (hex.length() == 1) {
				hex = '0' + hex;
			}
			sb.append(hex.toUpperCase());
		}
		return sb.toString();
	}

	public static byte[] AES_CBC_Decrypt(byte[] data, byte[] key, byte[] iv) throws Exception {
		Cipher cipher = getCipher(Cipher.DECRYPT_MODE, key, iv);
		return cipher.doFinal(data);
	}

	private static Cipher getCipher(int mode, byte[] key, byte[] iv) throws Exception {
		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

		// 因为AES的加密块大小是128bit(16byte), 所以key是128、192、256bit无关
		// System.out.println("cipher.getBlockSize()： " +
		// cipher.getBlockSize());

		SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
		cipher.init(mode, secretKeySpec, new IvParameterSpec(iv));

		return cipher;
	}

	/**
	 * AES加密操作
	 *
	 * @param content  待加密内容
	 * @param password 加密密码
	 * @return 返回Base64转码后的加密数据
	 */
	public static String encrypt(String content, String password) {
		if (StringUtils.isAnyEmpty(content, password)) {
			LOGGER.error("AES encryption params is null");
			return null;
		}
		try {
			//创建密码器
			Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
			byte[] byteContent = content.getBytes(ENCODING);
			//初始化为加密密码器
			cipher.init(Cipher.ENCRYPT_MODE, getSecretKey(password));
			byte[] encryptByte = cipher.doFinal(byteContent);
			return Base64Encoder.encode(encryptByte);
		} catch (Exception e) {
			LOGGER.error("AES encryption operation has exception,content:{},password:{}", content, password, e);
		}
		return null;
	}

	/**
	 * AES解密操作
	 *
	 * @param encryptContent 加密的密文
	 * @param password       解密的密钥
	 * @return
	 */
	public static String decrypt(String encryptContent, String password) {
		if (StringUtils.isAnyEmpty(encryptContent, password)) {
			LOGGER.error("AES decryption params is null");
			return null;
		}
		Cipher cipher = null;
		try {
			cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
			//设置为解密模式
			cipher.init(Cipher.DECRYPT_MODE, getSecretKey(password));
			//执行解密操作
			byte[] result = cipher.doFinal(Base64.decodeBase64(encryptContent));
			return new String(result, ENCODING);
		} catch (Exception e) {
			LOGGER.error("AES decryption operation has exception,content:{},password:{}", encryptContent, password, e);
		}
		return null;
	}

	private static SecretKeySpec getSecretKey(final String password) throws NoSuchAlgorithmException {
		//生成指定算法密钥的生成器
		KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
		keyGenerator.init(SECRET_KEY_LENGTH, new SecureRandom(password.getBytes()));
		//生成密钥
		SecretKey secretKey = keyGenerator.generateKey();
		//转换成AES的密钥
		return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
	}

	public static void main(String[] args) throws Exception {
		System.out.println(AESUtil.encrypt("000087","fjtctchsoft"));
		System.out.println(AESUtil.decrypt("ZnKAnP4dzE9gGWV09ET34A==","fjtctchsoft"));
		System.out.println(AESUtil.encode("850319399854645249"));
//		String content = "692384744159051777";
//		String encodeStr = AESUtil.encode(content);
//		System.out.println(encodeStr);
//		System.out.println(AESUtil.decode("B0BB3A5A6E35AA37636E591F6E7AA964EF73D1730A665A17BF296E7910CBCF989C3C7E157DFD05FEE71BBE72F5847BC1A970298E57A3F7B48DAC557A80A06E20"));
//		System.out.println(AESUtil.decode("C3C829FEFE14793126F82ACF5A9E85FA5AF9D129701C5FC3A8E6FA21D76AD411B9959FC5B1C9924DD4255A8ACBC7D65247C180E10A73135A6E0F420DC824AE6F"));
//		System.out.println(AESUtil.decode("755CC8F8C768E569D78EFB5E2C10752DDBA6C21EA329487E480B32C8B8032596A28AB4FB1C672B7522C0FB78C29613B8F630BC314BE4ADEF17FA5A2C0DFFDB75"));
	}
}