/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util.huawei;

import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final HttpUtil httpUtil = new HttpUtil();
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager connectionManager;
    private static HttpParams params;
    private static final int MAX_CONNECTION = 15000;
    private static final int MAX_SOCKET_CONNECTION = 15000;
    private static final long MAX_MANAGER_CONNECTION = 15000L;

    private HttpUtil() {
    }

    public static HttpUtil getInstance() {
        return httpUtil;
    }

    public RestResponse sendMessage(HttpHost target, String resourceUri, RestRequest message) throws ClientProtocolException, URISyntaxException, IOException {
        if (null == target) {
            throw new NullPointerException("HttpHost target can not be null.");
        }
        RestResponse restResponse = new RestResponse();
        HttpRequestBase request = this.buildRequestMessage(message, resourceUri);
        request.setParams(params);
        HttpContext basicHttpContext = null;
        CloseableHttpResponse response = null;
        try {
            log.debug(Thread.currentThread().getName() + " before execute " + System.currentTimeMillis());
            response = httpClient.execute(target, (HttpRequest)request, basicHttpContext);
            log.debug(Thread.currentThread().getName() + " after execute " + System.currentTimeMillis());
            if (response != null) {
                Header[] headers;
                restResponse.setHttpCode(response.getStatusLine().getStatusCode());
                HttpEntity entity = response.getEntity();
                if (null != entity) {
                    restResponse.setEntity(EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                }
                if (null != (headers = response.getAllHeaders())) {
                    Map<String, List<String>> headerMap = restResponse.getHeaders();
                    for (Header header : headers) {
                        if (headerMap.containsKey(header.getName())) {
                            headerMap.get(header.getName()).add(header.getValue());
                            continue;
                        }
                        ArrayList<String> headerVals = new ArrayList<String>();
                        headerVals.add(header.getValue());
                        headerMap.put(header.getName(), headerVals);
                    }
                }
                log.debug(Thread.currentThread().getName() + " out execute " + System.currentTimeMillis());
                return restResponse;
            }
            return null;
        }
        catch (RuntimeException e) {
            log.error("httpclient error:" + e.getMessage());
        }
        catch (Exception e) {
            log.error("httpclient error:" + e.getMessage());
        }
        return null;
    }

    private HttpRequestBase buildRequestMessage(RestRequest message, String resourceUri) throws URISyntaxException, UnsupportedEncodingException {
        HttpGet request;
        if ("GET".equalsIgnoreCase(message.getHttpMethod())) {
            HttpGet httpGet = new HttpGet(resourceUri);
            this.setParameters((HttpRequestBase)httpGet, message.getParameters());
            request = httpGet;
        } else if ("POST".equalsIgnoreCase(message.getHttpMethod())) {
            HttpPost httpPost = new HttpPost(resourceUri);
            this.setParameters((HttpRequestBase)httpPost, message.getParameters());
            if (null == message.getEntity()) {
                message.setEntity("");
            }
            httpPost.setEntity((HttpEntity)new StringEntity(message.getEntity(), "UTF-8"));
            request = httpPost;
        } else if ("PUT".equalsIgnoreCase(message.getHttpMethod())) {
            HttpPut httpPut = new HttpPut(resourceUri);
            if (null == message.getEntity()) {
                message.setEntity("");
            }
            httpPut.setEntity((HttpEntity)new StringEntity(message.getEntity(), "UTF-8"));
            request = httpPut;
        } else if ("DELETE".equalsIgnoreCase(message.getHttpMethod())) {
            HttpDelete httpDelete = new HttpDelete(resourceUri);
            this.setParameters((HttpRequestBase)httpDelete, message.getParameters());
            request = httpDelete;
        } else {
            String msg = message.getHttpMethod() + " is not a valid HTTP method";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.setHttpHeaders((HttpRequestBase)request, message.getHttpHeaders());
        return request;
    }

    private void setParameters(HttpRequestBase httpRequest, Map<String, String> parameters) throws URISyntaxException {
        if (null != parameters && !parameters.isEmpty()) {
            URIBuilder uriBuilder = new URIBuilder(httpRequest.getURI());
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            httpRequest.setURI(uriBuilder.build());
        }
    }

    private void setHttpHeaders(HttpRequestBase request, Map<String, String> httpHeaders) {
        if (null != httpHeaders) {
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        params = new BasicHttpParams();
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            sslContext.init(null, new TrustManager[]{tm}, null);
            sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("SSL connect error");
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(2000);
        connectionManager.setDefaultMaxPerRoute(connectionManager.getMaxTotal());
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        params.setIntParameter("http.connection.timeout", 15000);
        params.setIntParameter("http.socket.timeout", 15000);
        params.setLongParameter("http.conn-manager.timeout", 15000L);
    }
}

