/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import java.util.HashMap;
import java.util.Map;

public class MapDistance {
    private static double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static String getDistance(String lat1Str, String lng1Str, String lat2Str, String lng2Str) {
        Double lat1 = Double.parseDouble(lat1Str);
        Double lng1 = Double.parseDouble(lng1Str);
        Double lat2 = Double.parseDouble(lat2Str);
        Double lng2 = Double.parseDouble(lng2Str);
        double radLat1 = MapDistance.rad(lat1);
        double radLat2 = MapDistance.rad(lat2);
        double difference = radLat1 - radLat2;
        double mdifference = MapDistance.rad(lng1) - MapDistance.rad(lng2);
        double distance = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(difference / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(mdifference / 2.0), 2.0)));
        distance *= EARTH_RADIUS;
        distance = Math.round(distance * 10000.0) / 10000L;
        String distanceStr = distance + "";
        distanceStr = distanceStr.substring(0, distanceStr.indexOf("."));
        return distanceStr;
    }

    public static Map getAround(String latStr, String lngStr, String raidus) {
        HashMap<String, String> map = new HashMap<String, String>();
        Double latitude = Double.parseDouble(latStr);
        Double longitude = Double.parseDouble(lngStr);
        Double degree = 111293.63611111112;
        double raidusMile = Double.parseDouble(raidus);
        Double mpdLng = Double.parseDouble((degree * Math.cos(latitude * (Math.PI / 180)) + "").replace("-", ""));
        Double dpmLng = 1.0 / mpdLng;
        Double radiusLng = dpmLng * raidusMile;
        Double minLat = latitude - radiusLng;
        Double maxLat = latitude + radiusLng;
        Double dpmLat = 1.0 / degree;
        Double radiusLat = dpmLat * raidusMile;
        Double minLng = longitude - radiusLat;
        Double maxLng = longitude + radiusLat;
        map.put("minLat", minLat + "");
        map.put("maxLat", maxLat + "");
        map.put("minLng", minLng + "");
        map.put("maxLng", maxLng + "");
        return map;
    }

    public static void main(String[] args) {
        System.out.println(MapDistance.getAround("117.11811", "36.68484", "12000"));
        System.out.println(MapDistance.getAround("117.11811", "36.68484", "3000"));
    }
}

