/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ImgUtils {
    public static String zipImageFile(File oldFile, File newFile, int width, int height, float quality) {
        if (oldFile == null) {
            return null;
        }
        try {
            BufferedImage srcFile = ImageIO.read(oldFile);
            int w = ((Image)srcFile).getWidth(null);
            int h = ((Image)srcFile).getHeight(null);
            if (width > 0) {
                double bili = (double)width / (double)w;
                height = (int)((double)h * bili);
            } else if (height > 0) {
                double bili = (double)height / (double)h;
                width = (int)((double)w * bili);
            }
            String srcImgPath = newFile.getAbsoluteFile().toString();
            System.out.println(srcImgPath);
            String subfix = "jpg";
            subfix = srcImgPath.substring(srcImgPath.lastIndexOf(".") + 1, srcImgPath.length());
            BufferedImage buffImg = null;
            buffImg = subfix.equals("png") ? new BufferedImage(width, height, 2) : new BufferedImage(width, height, 1);
            Graphics2D graphics = buffImg.createGraphics();
            graphics.setBackground(new Color(255, 255, 255));
            graphics.setColor(new Color(255, 255, 255));
            graphics.fillRect(0, 0, width, height);
            graphics.drawImage(srcFile.getScaledInstance(width, height, 4), 0, 0, null);
            ImageIO.write((RenderedImage)buffImg, subfix, new File(srcImgPath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newFile.getAbsolutePath();
    }

    public static String zipWidthHeightImageFile(File oldFile, File newFile, int width, int height, float quality) {
        if (oldFile == null) {
            return null;
        }
        String newImage = null;
        try {
            BufferedImage srcFile = ImageIO.read(oldFile);
            String srcImgPath = newFile.getAbsoluteFile().toString();
            String subfix = "jpg";
            subfix = srcImgPath.substring(srcImgPath.lastIndexOf(".") + 1, srcImgPath.length());
            BufferedImage buffImg = null;
            buffImg = subfix.equals("png") ? new BufferedImage(width, height, 2) : new BufferedImage(width, height, 1);
            Graphics2D graphics = buffImg.createGraphics();
            graphics.setBackground(new Color(255, 255, 255));
            graphics.setColor(new Color(255, 255, 255));
            graphics.fillRect(0, 0, width, height);
            graphics.drawImage(srcFile.getScaledInstance(width, height, 4), 0, 0, null);
            ImageIO.write((RenderedImage)buffImg, subfix, new File(srcImgPath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newImage;
    }

    public static boolean generateImage(String baseImg, String imgPath) {
        if (baseImg == null) {
            return false;
        }
        baseImg = baseImg.replaceFirst("data:(.+?);base64,", "");
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] b = decoder.decodeBuffer(baseImg);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            FileOutputStream out = new FileOutputStream(imgPath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getImageStr(String imgFile) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }
}

