/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTLUtil {
    public static final String LACK_P_MSG = "\u5fc5\u8981\u53c2\u6570\u786e\u5b9e";
    private static Logger log = LoggerFactory.getLogger((String)"");

    public static Map<Object, Object> init(HttpServletRequest request, Map<Object, Object> params) {
        params.put("system_params_login_ip", request.getRemoteAddr());
        Object limit = params.get("limit");
        Object offset = params.get("offset");
        if (limit != null && offset != null) {
            params.put("offset", Integer.valueOf(String.valueOf(offset)));
            params.put("limit", Integer.valueOf(String.valueOf(limit)));
        } else {
            Object page = params.get("page");
            Object rows = params.get("rows");
            if (page != null && rows != null) {
                params.put("offset", (Integer.valueOf(String.valueOf(page)) - 1) * Integer.valueOf(String.valueOf(rows)));
                params.put("limit", Integer.valueOf(String.valueOf(rows)));
            }
        }
        for (Object key : params.keySet()) {
            if ("offset".toString().equals(key) || "limit".toString().equals(key)) continue;
            params.put(key, params.get(key).toString().trim());
        }
        return params;
    }

    public static boolean pNotNull(Map<Object, Object> p, String ... key) {
        for (String k : key) {
            if (p.get(k) != null) continue;
            return false;
        }
        return true;
    }

    public static void out(Object o, HttpServletResponse resp) {
        CTLUtil.out(o, resp, "yyyy-MM-dd HH:mm:ss");
    }

    public static String toJSONDate(Object o) {
        return JSON.toJSONStringWithDateFormat((Object)o, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSONDateShort(Object o) {
        return JSON.toJSONStringWithDateFormat((Object)o, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void out(Object o, HttpServletResponse resp, String format) {
        resp.setContentType("application/json;charset=UTF-8");
        try (PrintWriter pw = null;){
            pw = resp.getWriter();
            String json = JSON.toJSONStringWithDateFormat((Object)o, (String)format, (SerializerFeature[])new SerializerFeature[0]);
            String s = json.replaceAll("\n", "").replace("\t", "");
            pw.write(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void out2(Object o, HttpServletResponse resp) {
        String format = "yyyy-MM-dd HH:mm:ss";
        resp.setHeader("Content-Type", "text/html;charset=UTF-8");
        try (PrintWriter pw = null;){
            pw = resp.getWriter();
            String json = JSON.toJSONStringWithDateFormat((Object)o, (String)format, (SerializerFeature[])new SerializerFeature[0]);
            String s = json.replaceAll("\n", "").replace("\t", "");
            pw.write(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void out(byte[] b, HttpServletResponse resp, String file) {
        if (b == null) {
            return;
        }
        resp.setHeader("Content-Type", "image/jped");
        ServletOutputStream out = null;
        try {
            out = resp.getOutputStream();
            out.write(b);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isDate(String strDate) {
        if (strDate == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }

    public static boolean isValidDate(Object string) {
        String str = String.valueOf(string);
        if (str.length() != 14) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void outBlob(HttpServletResponse resp, byte[] blob) {
        ByteArrayInputStream in = null;
        ServletOutputStream op = null;
        try {
            op = resp.getOutputStream();
            in = new ByteArrayInputStream(blob);
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf, 0, 1024)) != -1) {
                op.write(buf, 0, len);
            }
            op.close();
        }
        catch (Exception e) {
            log.error("\u8f93\u51fa\u5927\u5bf9\u8c61\u9519\u8bef", (Throwable)e);
        }
    }

    public static String str(String str) {
        return str == null ? null : ("".equals(str.trim()) ? null : str.trim());
    }

    public static String str(Object str) {
        return str == null ? null : ("".equals(String.valueOf(str).trim()) ? null : String.valueOf(str).trim());
    }

    public static String datestr(String str) {
        String s;
        String string = str == null ? null : (s = "".equals(str.trim()) ? null : str);
        if (CTLUtil.isDate(s)) {
            return s;
        }
        return null;
    }
}

