/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ImgUtils;
import com.bcxin.ars.util.StringUtil;
import java.io.File;
import java.util.Date;
import java.util.Random;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PhotoUtil {
    @Value(value="${base-folder}")
    private String baseFolder;
    @Value(value="${personImg-folder}")
    private String personImgPath = "";

    public void savePhoto(PersonBaseInfo personBaseInfo) {
        personBaseInfo.setState("0");
        if (StringUtil.isNotEmpty((String)personBaseInfo.getPhoto())) {
            Date now = new Date();
            Random random = new Random();
            int rannum = (int)(random.nextDouble() * 90.0) + 100;
            String fileName = now.getTime() + (long)rannum + ".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(this.baseFolder + this.personImgPath + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String key = this.personImgPath + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = this.baseFolder + key;
            if (ImgUtils.generateImage((String)personBaseInfo.getPhoto(), (String)targetPath)) {
                personBaseInfo.setImgPath(url);
                personBaseInfo.setState("1");
            }
            personBaseInfo.setPhoto(null);
        }
    }

    public void saveRandomPhoto(PersonBaseInfo personBaseInfo) {
        personBaseInfo.setState("0");
        if (StringUtil.isNotEmpty((String)personBaseInfo.getPhoto())) {
            Date now = new Date();
            Random random = new Random();
            int rannum = (int)(random.nextDouble() * 90.0) + 100;
            String fileName = now.getTime() + (long)rannum + ".jpg";
            String dirDate = DateUtil.systemDate.format(DateUtil.randomDate((String)"2020-07-01", (String)DateUtil.getCurrentDate()));
            File dir = new File(this.baseFolder + this.personImgPath + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String key = this.personImgPath + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = this.baseFolder + key;
            if (ImgUtils.generateImage((String)personBaseInfo.getPhoto(), (String)targetPath)) {
                personBaseInfo.setImgPath(url);
                personBaseInfo.setState("1");
            }
            personBaseInfo.setPhoto(null);
        }
    }
}

