/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import cn.jiguang.common.utils.StringUtils;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dao.task.TaskFeedbackDao;
import com.bcxin.ars.dao.task.TaskFeedbackLogDao;
import com.bcxin.ars.dao.task.TaskPersonDao;
import com.bcxin.ars.dao.task.TaskPersonScheduleDao;
import com.bcxin.ars.dao.task.UrgentTeamPersonDAO;
import com.bcxin.ars.dto.UrgentPerson;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskFeedback;
import com.bcxin.ars.model.task.TaskFeedbackLog;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.model.task.TaskStatus;
import com.bcxin.ars.service.task.TaskFeedbackLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.MessageUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskFeedbackLogServiceImpl
implements TaskFeedbackLogService {
    @Autowired
    private TaskFeedbackLogDao taskFeedbackLogDao;
    @Autowired
    private TaskFeedbackDao taskFeedbackDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private TaskPersonDao taskPersonDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private UrgentTeamPersonDAO urgentTeamPersonDAO;
    @Autowired
    private TaskPersonScheduleDao taskPersonScheduleDao;
    @Autowired
    private TaskFeedbackDao feedbackDao;
    @Autowired
    private MessageLogDao messageLogDao;

    public TaskFeedbackLog saveOrUpdate(TaskFeedbackLog taskFeedbackLog) {
        TaskFeedback taskFeedback = taskFeedbackLog.getTaskFeedback();
        if ((taskFeedback = this.taskFeedbackDao.findById(taskFeedback.getId())) == null) {
            throw new ArsException("\u6570\u636e\u5f02\u5e38:\u67e5\u627e\u4e0d\u5230\u5b50\u4efb\u52a1\u4fe1\u606f");
        }
        User currentUser = this.arsUtil.getCurrentUser();
        if (!StringUtils.isEmpty((String)taskFeedbackLog.getDutyState()) && !taskFeedbackLog.getDutyState().equals("1")) {
            Date taskEnd = DateUtil.convertStringToDate((String)(taskFeedback.getTaskDate() + " " + taskFeedback.getTaskEnd()));
            Date nowDate = new Date();
            if (nowDate.getTime() < taskEnd.getTime()) {
                taskFeedback.setFeedbackStatus("2");
            } else {
                taskFeedback.setFeedbackStatus("1");
            }
            taskFeedback.setEndTime(new Date());
            taskFeedback.setComment(taskFeedbackLog.getComment());
            taskFeedback.setUpdateTime(new Date());
            taskFeedback.setUpdateBy(currentUser.getUsername());
            taskFeedback.setPhotos(taskFeedbackLog.getImage());
            TaskStatus taskStatus = new TaskStatus();
            taskStatus.setId(Long.valueOf(3L));
            taskFeedback.setTaskStatus(taskStatus);
            this.taskFeedbackDao.update(taskFeedback);
        }
        taskFeedbackLog.setCreateTime(new Date());
        taskFeedbackLog.setUpdateBy(currentUser.getUsername());
        this.taskFeedbackLogDao.save(taskFeedbackLog);
        Long taskId = taskFeedbackLog.getTaskId();
        if (taskId != null) {
            TaskPerson taskPerson = new TaskPerson();
            taskPerson.setTaskId(taskId);
            taskPerson.setPerson(taskFeedbackLog.getPerson());
            taskPerson.setAcceptStatus(Integer.valueOf(1));
            List taskFeedbackList = this.taskFeedbackDao.findAllFeedbackByTaskid(taskPerson.getTaskId(), taskPerson.getPerson().getId());
            if (taskFeedbackList != null && taskFeedbackList.size() > 0) {
                throw new ArsException("\u7d27\u6025\u4efb\u52a1\u5df2\u63a5\u6536\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u63a5\u6536\uff01");
            }
            TaskPerson dbTaskPerson = this.taskPersonDao.findByTaskIdPersonId(taskPerson.getTaskId(), taskPerson.getPerson().getId());
            if (dbTaskPerson.getAcceptStatus().equals(4)) {
                throw new ArsException("\u7d27\u6025\u4efb\u52a1\u5df2\u8fc7\u671f\uff01");
            }
            dbTaskPerson.setAcceptStatus(taskPerson.getAcceptStatus());
            dbTaskPerson.setUpdateTime(new Date());
            this.taskPersonDao.update(dbTaskPerson);
            Task task = this.taskDao.findById(taskPerson.getTaskId());
            if (task == null) {
                task = this.taskDao.findUrgentById(taskPerson.getTaskId());
            }
            if (task.getTaskType().getId() == 4L) {
                List list = this.taskPersonDao.findUnAcceptByPersonId(taskPerson.getPerson().getId());
                for (TaskPerson tPerson : list) {
                    List tpsList = this.taskPersonScheduleDao.findByTaskPersonIdStatus(tPerson.getId(), null);
                    for (TaskPersonSchedule tps : tpsList) {
                        this.taskPersonScheduleDao.deleteDetailByPersonSchedule(tps);
                    }
                    this.taskPersonScheduleDao.deleteByTaskPersonId(tPerson.getId());
                    this.taskPersonDao.delete(tPerson);
                }
                String urgentTaskMsg = "\u7d27\u6025\u901a\u77e5\uff1a%PERSONNAME%\u88ab\u516c\u5b89\u673a\u5173\u9009\u4e2d\uff0c\u6b63\u5728\u6267\u884c\u7d27\u6025\u4efb\u52a1\u3002\u4efb\u52a1\u540d\u79f0\uff1a%TASKNAME%\uff0c\u4efb\u52a1\u5730\u5740\uff1a%ADDRESS%\u3002";
                urgentTaskMsg = urgentTaskMsg.replace("%TASKNAME%", task.getName());
                urgentTaskMsg = urgentTaskMsg.replace("%ADDRESS%", task.getAddress());
                SecurityPerson person = this.personDao.findById(taskPerson.getPerson().getId());
                MessageUtil.sendMessage((String)person.getPhone(), (String)urgentTaskMsg.replace("%PERSONNAME%", person.getRealName()), (MessageLogDao)this.messageLogDao);
                SecurityCompany company = person.getRelation().getCompany();
                List personList = this.urgentTeamPersonDAO.queryUrgentPersonByCompnyId(company.getId());
                if (personList != null) {
                    for (UrgentPerson urgentPerson : personList) {
                        if (!urgentPerson.isInCharge()) continue;
                        String urgentChargeTaskMsg = "\u7d27\u6025\u901a\u77e5\uff1a%PERSONNAME%\u88ab\u516c\u5b89\u673a\u5173\u9009\u4e2d\uff0c\u6b63\u5728\u6267\u884c\u7d27\u6025\u4efb\u52a1\u3002\u4efb\u52a1\u540d\u79f0\uff1a%TASKNAME%\uff0c\u4efb\u52a1\u5730\u5740\uff1a%ADDRESS%\u3002";
                        urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%TASKNAME%", task.getName());
                        urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%ADDRESS%", task.getAddress());
                        MessageUtil.sendMessage((String)urgentPerson.getPhone(), (String)urgentChargeTaskMsg.replace("%PERSONNAME%", person.getRealName()), (MessageLogDao)this.messageLogDao);
                    }
                }
            }
            try {
                this.createTaskFeedbackByTask(task, taskPerson.getPerson().getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return taskFeedbackLog;
    }

    private void createTaskFeedbackByTask(Task task, long personId) {
        TaskPerson taskPerson;
        Long nativeCode = this.arsUtil.getCurrentNatvie();
        if (nativeCode == null) {
            nativeCode = task.getNativeCode();
        }
        if ((taskPerson = this.taskPersonDao.findByTaskIdPersonId(task.getId(), Long.valueOf(personId))) != null && taskPerson.getAcceptStatus() != null && taskPerson.getAcceptStatus().equals(1) && task.getTaskType().getId().equals(4L)) {
            TaskFeedback feedback = new TaskFeedback();
            feedback.setNativeCode(nativeCode);
            feedback.setPerson(taskPerson.getPerson());
            feedback.setTask(task);
            feedback.setTaskStart(DateUtil.convertDateToString((Date)DateUtil.convertStringToDate((String)task.getStartDate()), (String)"HH:mm:ss"));
            TaskStatus taskStatus = new TaskStatus();
            taskStatus.setId(Long.valueOf(2L));
            feedback.setTaskStatus(taskStatus);
            feedback.setScheduleId(Long.valueOf(1L));
            feedback.setTaskDate(DateUtil.getCurrentDate());
            feedback.setScheduleName("\u7d27\u6025\u4efb\u52a1");
            feedback.setStartTime(new Date());
            feedback.setCreateTime(new Date());
            feedback.setUpdateTime(new Date());
            this.feedbackDao.save(feedback);
        }
    }

    public List<TaskFeedbackLog> findFeedbackLogList(Long personId, Long feedbackId) {
        return this.taskFeedbackLogDao.findFeedbackLogList(personId, feedbackId);
    }
}

