/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.SysDataChangeLogDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.SysDataChangeLog;
import com.bcxin.ars.service.sys.SysDataChangeLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDataChangeLogServiceImpl
implements SysDataChangeLogService {
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private SysDataChangeLogDao sysDataChangeLogDao;
    @Autowired
    private ArsUtil arsUtil;

    public void save(SysDataChangeLog detail) {
        User currentUser = this.arsUtil.getCurrentUser();
        detail.setActive(Boolean.valueOf(true));
        detail.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        detail.setCreateTime(new Date());
        detail.setUpdateTime(new Date());
        detail.setUpdateflag(Boolean.valueOf(true));
        detail.setUpdateBy(currentUser == null ? "system" : currentUser.getUsername());
        this.sysDataChangeLogDao.save(detail);
    }

    public void importBatch(List<SysDataChangeLog> list) {
        this.sysDataChangeLogDao.saveBatch(list);
    }

    public List<SysDataChangeLog> findDSOutList(String startDate) {
        List list = this.sysDataChangeLogDao.searchFromInToOutForExport(startDate);
        if (list.size() > 0) {
            this.sysDataChangeLogDao.updateFlag(list);
        }
        return list;
    }
}

