/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.SyncFailLogDao;
import com.bcxin.ars.dao.sys.SyncDataDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.SyncFailLog;
import com.bcxin.ars.model.sys.ConfigSyncData;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SyncDataService;
import com.bcxin.ars.util.CipherDESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.EmailUtils;
import com.bcxin.ars.util.Encodes;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="syncDataService")
@Transactional
public class SyncDataServiceImpl
implements SyncDataService {
    private Logger logger = LoggerFactory.getLogger(SyncDataServiceImpl.class);
    @Autowired
    private SyncDataDao syncDataDao;
    @Autowired
    private SyncFailLogDao syncFailLogDao;
    @Autowired
    private ConfigService configService;
    @Value(value="${ftp-folder}")
    private String ftpFolder;
    @Value(value="${ftp-temp-folder}")
    private String tempftpFolder;

    public void syncData() {
        String file;
        Boolean isSuccess;
        ArrayList resultList;
        String currentEnviName;
        EmailUtils email;
        Config syncDataNotifier;
        Config police;
        long startTime;
        block12: {
            startTime = System.currentTimeMillis();
            police = this.configService.findByKey("police");
            syncDataNotifier = new Config();
            Config currentEnvi = new Config();
            if (police != null && police.getValue().equals("0")) {
                syncDataNotifier = this.configService.findByKey("syncDataNotifier");
                currentEnvi = this.configService.findByKey("current_native_name");
            }
            email = new EmailUtils();
            currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();
            List configList = this.syncDataDao.getConfigSyncDataList();
            Long syncBatchId = this.syncDataDao.getNextVal("seq_syncBatchId");
            resultList = new ArrayList();
            isSuccess = true;
            Object obj = SpringUtils.getBean(SyncDataDao.class);
            Class<?> c = obj.getClass();
            ArrayList syncRecode = new ArrayList();
            file = "D:\\syncData.zip";
            try {
                ZipEntry ze;
                ZipFile zf = new ZipFile(file);
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                ZipInputStream zin = new ZipInputStream(in);
                while ((ze = zin.getNextEntry()) != null) {
                    String line;
                    if (ze.isDirectory()) continue;
                    BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                    char[] buff = new char[1024];
                    StringBuffer content = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        content.append(line);
                    }
                    br.close();
                    String datajsonStr = new String(CipherDESUtil.decrypt((byte[])Encodes.decodeHex((String)content.toString()), (String)Constants.APPROVAL_KEY));
                    List dataList = JSONArray.parseArray((String)datajsonStr, Map.class);
                    String fileName = ze.getName().substring(0, ze.getName().indexOf(".data"));
                    String tableName = "";
                    try {
                        for (ConfigSyncData config : configList) {
                            int insertLength;
                            if (!fileName.equals(config.getFileName())) continue;
                            tableName = config.getTableName();
                            Method method = c.getMethod(config.getInsertSyncFun(), List.class, Long.class);
                            int i = 0;
                            for (insertLength = dataList.size(); insertLength > 500; insertLength -= 500) {
                                method.invoke(obj, dataList.subList(i, i + 500), syncBatchId);
                                i += 500;
                            }
                            if (insertLength > 0) {
                                method.invoke(obj, dataList.subList(i, i + insertLength), syncBatchId);
                            }
                            HashMap<String, Object> param = new HashMap<String, Object>();
                            HashMap<String, Object> result = new HashMap<String, Object>();
                            param.put("syncBatchId", syncBatchId);
                            param.put("sql", config.getInsertSql());
                            int insertCount = this.syncDataDao.executeInsertSql(param);
                            param.remove("sql");
                            param.put("sql", config.getUpdateSql());
                            int updateCount = this.syncDataDao.executeUpdateSql(param);
                            param.remove("sql");
                            param.put("sql", config.getDeleteSql());
                            this.syncDataDao.executeDeleteSql(param);
                            result.put("tableName", tableName);
                            result.put("insertCount", insertCount);
                            result.put("updateCount", updateCount);
                            resultList.add(result);
                        }
                    }
                    catch (Exception e) {
                        isSuccess = false;
                        e.printStackTrace();
                        if (police == null || !police.getValue().equals("0") || syncDataNotifier == null || syncDataNotifier.getValue() == null) continue;
                        email.sendEmail("\u767e\u4fdd\u76fe\u5916\u7f51\u540c\u6b65\u8868\u51fa\u9519", "\u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u6587\u4ef6\u540d:\u3010" + fileName + "\u3011\n\u8868\u540d:\u3010" + tableName + "\u3011\n\u5f02\u5e38\u4fe1\u606f" + e.getMessage().toString(), syncDataNotifier.getValue());
                    }
                }
                zin.closeEntry();
                zin.close();
                zf.close();
                ((InputStream)in).close();
            }
            catch (Exception e) {
                isSuccess = false;
                e.printStackTrace();
                if (police == null || !police.getValue().equals("0") || syncDataNotifier == null || syncDataNotifier.getValue() == null) break block12;
                email.sendEmail("\u767e\u4fdd\u76fe\u5916\u7f51\u89e3\u538b\u538b\u7f29\u5305\u51fa\u9519", "\u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u6587\u4ef6\u540d:\u3010" + file + "\u3011\n\u5f02\u5e38\u4fe1\u606f:\u3010" + e.getMessage().toString() + "\u3011", syncDataNotifier.getValue());
            }
        }
        if (isSuccess.booleanValue()) {
            long endTime = System.currentTimeMillis();
            String jsonStr = JSON.toJSONString(resultList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            jsonStr = jsonStr.replace("tableName", "\u540c\u6b65\u8868\u540d").replace("insertCount", "\u63d2\u5165\u8bb0\u5f55").replace("updateCount", "\u66f4\u65b0\u8bb0\u5f55");
            if (police != null && police.getValue().equals("0") && syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                email.sendEmail("\u767e\u4fdd\u76fe\u5916\u7f51\u6210\u529f\u540c\u6b65\u6587\u4ef6", " \u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u540c\u6b65\u8017\u65f6:\u3010" + (endTime - startTime) + "ms\u3011\n\u6587\u4ef6\u540d:\u3010" + file + "\u3011\n\u540c\u6b65\u8be6\u60c5:\u3010" + jsonStr + "\u3011", syncDataNotifier.getValue());
            }
            System.out.println("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
        }
    }

    public void syncDataByJava(String datajsonStr, File fs) {
        Boolean isSuccess;
        ArrayList resultList;
        String currentEnviName;
        EmailUtils email;
        Config syncDataNotifier;
        Config police;
        long startTime;
        block9: {
            startTime = System.currentTimeMillis();
            police = this.configService.findByKey("police");
            syncDataNotifier = new Config();
            Config currentEnvi = new Config();
            if (police != null && police.getValue().equals("0")) {
                syncDataNotifier = this.configService.findByKey("syncDataNotifier");
                currentEnvi = this.configService.findByKey("current_native_name");
            }
            email = new EmailUtils();
            currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();
            List configList = this.syncDataDao.getConfigSyncDataList();
            Long syncBatchId = this.syncDataDao.getNextVal("seq_syncBatchId");
            resultList = new ArrayList();
            isSuccess = true;
            Object obj = SpringUtils.getBean(SyncDataDao.class);
            Class<?> c = obj.getClass();
            SyncFailLog syncFailLog = new SyncFailLog();
            Date date = new Date();
            syncFailLog.setCreateTime(date);
            syncFailLog.setUpdateTime(date);
            syncFailLog.setUpdateBy("syncAdmin");
            syncFailLog.setActive(Boolean.valueOf(true));
            ArrayList syncRecode = new ArrayList();
            List dataList = JSONArray.parseArray((String)datajsonStr, Map.class);
            String fileName = fs.getName().substring(0, fs.getName().indexOf("_"));
            String tableName = "";
            try {
                for (ConfigSyncData config : configList) {
                    int insertLength;
                    if (!fileName.equals(config.getFileName())) continue;
                    tableName = config.getTableName();
                    Method method = c.getMethod(config.getInsertSyncFun(), List.class, Long.class);
                    int i = 0;
                    for (insertLength = dataList.size(); insertLength > 500; insertLength -= 500) {
                        method.invoke(obj, dataList.subList(i, i + 500), syncBatchId);
                        i += 500;
                    }
                    if (insertLength > 0) {
                        method.invoke(obj, dataList.subList(i, i + insertLength), syncBatchId);
                    }
                    Map<String, String> param = new HashMap();
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    param = this.getColumn(Class.forName(config.getJavaObjectUrl()));
                    if (param != null) {
                        param.put("syncBatchId", (String)((Object)syncBatchId));
                        param.put("tableName", tableName);
                        param.put("syncTableName", config.getSyncTableName());
                        int insertCount = this.syncDataDao.insertSql(param);
                        int updateCount = this.syncDataDao.updateSql(param);
                        this.syncDataDao.deleteSql(param);
                        result.put("tableName", tableName);
                        result.put("insertCount", insertCount);
                        result.put("updateCount", updateCount);
                        resultList.add(result);
                        break;
                    }
                    syncFailLog.setErrorMessage("\u767e\u4fdd\u76fe\u5916\u7f51\u540c\u6b65\u8868\u51fa\u9519\uff1a\u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u6587\u4ef6\u540d:\u3010" + fileName + "\u3011\n\u8868\u540d:\u3010" + tableName + "\u3011\n\u5f02\u5e38\u4fe1\u606f\uff1a\u81ea\u5b9a\u4e49\u6ce8\u89e3\u83b7\u53d6\u503c\u4e3a\u7a7a");
                    syncFailLog.setFailTableName(tableName);
                    this.syncFailLogDao.save(syncFailLog);
                }
            }
            catch (Exception e) {
                isSuccess = false;
                syncFailLog.setErrorMessage("\u767e\u4fdd\u76fe\u5916\u7f51\u540c\u6b65\u8868\u51fa\u9519\uff1a\u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u6587\u4ef6\u540d:\u3010" + fileName + "\u3011\n\u8868\u540d:\u3010" + tableName + "\u3011\n\u5f02\u5e38\u4fe1\u606f" + e.getMessage());
                syncFailLog.setFailTableName(tableName);
                this.syncFailLogDao.save(syncFailLog);
                e.printStackTrace();
                if (police == null || !police.getValue().equals("0") || syncDataNotifier == null || syncDataNotifier.getValue() == null) break block9;
                email.sendEmail("\u767e\u4fdd\u76fe\u5916\u7f51\u540c\u6b65\u8868\u51fa\u9519", "\u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u6587\u4ef6\u540d:\u3010" + fileName + "\u3011\n\u8868\u540d:\u3010" + tableName + "\u3011\n\u540c\u6b65\u5f02\u5e38\u4fe1\u606f" + e.toString(), syncDataNotifier.getValue());
            }
        }
        if (isSuccess.booleanValue()) {
            long endTime = System.currentTimeMillis();
            String jsonStr = JSON.toJSONString(resultList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            jsonStr = jsonStr.replace("tableName", "\u540c\u6b65\u8868\u540d").replace("insertCount", "\u63d2\u5165\u8bb0\u5f55").replace("updateCount", "\u66f4\u65b0\u8bb0\u5f55");
            if (police != null && police.getValue().equals("0") && syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                email.sendEmail("\u767e\u4fdd\u76fe\u5916\u7f51\u6210\u529f\u540c\u6b65\u6587\u4ef6", " \u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u540c\u6b65\u8017\u65f6:\u3010" + (endTime - startTime) + "ms\u3011\n\u6587\u4ef6\u540d:\u3010" + fs + "\u3011\n\u540c\u6b65\u8be6\u60c5:\u3010" + jsonStr + "\u3011", syncDataNotifier.getValue());
            }
            System.out.println("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
        }
    }

    private Map getColumn(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        Field[] fields = ((Class)object).getDeclaredFields();
        String columnStr = "";
        String updateColumn = "";
        String foreachColumn = "";
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ModelAnnotation.class)) continue;
            ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
            String column = "`" + resource.column() + "`";
            columnStr = columnStr + column + ",";
            foreachColumn = foreachColumn + "${item." + column + "},";
            updateColumn = updateColumn + "a." + column + "=b." + column + ",";
        }
        if (columnStr != "") {
            map.put("tableColumn", columnStr.substring(0, columnStr.length() - 1));
            map.put("foreachColumn", foreachColumn.substring(0, foreachColumn.length() - 1));
            map.put("updateColumn", updateColumn.substring(0, updateColumn.length() - 1));
            return map;
        }
        return null;
    }

    public void createDataSyncFile(String syncStartDate, String syncEndDate) {
        long startTime = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)syncStartDate)) {
            syncStartDate = DateUtil.getYesterday();
        }
        List configList = this.syncDataDao.getConfigSyncDataList();
        ArrayList filePathList = new ArrayList();
        Config police = this.configService.findByKey("police");
        Config syncDataNotifier = new Config();
        Config currentEnvi = new Config();
        if (police != null && police.getValue().equals("0")) {
            syncDataNotifier = this.configService.findByKey("syncDataNotifier");
            currentEnvi = this.configService.findByKey("current_native_name");
        }
        EmailUtils email = new EmailUtils();
        String currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();
        for (ConfigSyncData config : configList) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("sql", "SELECT * FROM `" + config.getTableName() + "` limit 100");
            List dataList = this.syncDataDao.executeSelectSql(param);
            if (dataList == null || dataList.size() <= 0) continue;
            try {
                String dataJsonStr = JSONArray.toJSONString((Object)dataList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])dataJsonStr.getBytes(), (String)Constants.APPROVAL_KEY));
                this.writeTxtFile(content, config.getFileName());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (police == null || !police.getValue().equals("0") || syncDataNotifier == null || syncDataNotifier.getValue() == null) continue;
                email.sendEmail("\u767e\u4fdd\u76fe\u5916\u7f51\u751f\u6210\u6570\u636e\u6587\u4ef6\u51fa\u9519", "\u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u6587\u4ef6\u540d:\u3010" + config.getFileName() + ".data\u3011\n\u5f02\u5e38\u4fe1\u606f:\u3010" + e.getMessage().toString() + "\u3011", syncDataNotifier.getValue());
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
    }

    private String writeTxtFile(String readStr, String type) {
        String fullFilePath = "";
        try {
            String basePath = this.tempftpFolder;
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;
            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa\u8def\u5f84:");
            }
            fullFilePath = filePath + fileName + fileType;
            File newFile = new File(fullFilePath);
            Files.write((byte[])readStr.getBytes(), (File)newFile);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return fullFilePath;
    }
}

