/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.SecurityScopeDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sb.TrainChangeDao;
import com.bcxin.ars.dao.sb.TrainChangeDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.TrainChangeSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.TrainChange;
import com.bcxin.ars.model.sb.TrainChangeworkexperience;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.TrainChangeService;
import com.bcxin.ars.service.sb.TrainChangeworkexperienceService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=TrainChange.class)
public class TrainChangeServiceImpl
implements TrainChangeService {
    @Autowired
    private TrainChangeDao trainChangeDao;
    @Autowired
    private TrainChangeDaoAop trainChangeDaoAop;
    @Autowired
    private TrainChangeworkexperienceService workexperienceService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityScopeDao securityScopeDao;

    public TrainChange findById(long id) {
        TrainChange result = this.trainChangeDao.findById(Long.valueOf(id));
        if (result != null) {
            result.setApproval(this.approvalDAO.findBybusinessidAndType(Long.valueOf(id), "013"));
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public List<TrainChange> findByBatchId(List<Approval> approvalList) {
        return this.trainChangeDao.findByBatchId(approvalList);
    }

    public Map searchForPrintf(long id) {
        return this.trainChangeDao.searchForPrintf(id);
    }

    public void updateBatch(List<TrainChange> list) {
        this.trainChangeDaoAop.updateBatch(list);
    }

    public void saveOrUpdate(TrainChange trainChange) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (trainChange.getOrgid() == null) {
            if (trainChange.getDistrictOrgId() != null) {
                trainChange.setOrgid(Long.valueOf(Long.parseLong(trainChange.getDistrictOrgId())));
            } else if (trainChange.getCityOrgId() != null) {
                trainChange.setOrgid(Long.valueOf(Long.parseLong(trainChange.getCityOrgId())));
            } else {
                Police police = (Police)this.policeDao.findByType("1").get(0);
                trainChange.setOrgid(police.getId());
            }
        }
        Long userId = currentUser.getId();
        SecurityCompany company = this.securityCompanyDao.findByUserid(userId);
        if (!trainChange.getApprovalstate().equals("001") && company != null) {
            if (StringUtil.isNotEmpty((String)trainChange.getSecurityScopes())) {
                String oldSecurityScope = company.getSecurityScopeType();
                if (StringUtil.isEmpty((String)oldSecurityScope) && (StringUtil.isEmpty((String)company.getInstitutionType()) || company.getInstitutionType().equals("0102") || company.getInstitutionType().equals("0105"))) {
                    throw new ArsException("\u5355\u4f4d\u539f\u670d\u52a1\u8303\u56f4\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7ef4\u62a4\uff01");
                }
                if (ObjectUtil.equal((Object)oldSecurityScope, (Object)trainChange.getSecurityScopes())) {
                    throw new ArsException("\u670d\u52a1\u8303\u56f4\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
                }
            }
            if (StringUtil.isNotEmpty((String)trainChange.getCompanyname()) && company.getName().equals(trainChange.getCompanyname())) {
                throw new ArsException("\u5355\u4f4d\u540d\u79f0\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (StringUtil.isNotEmpty((String)trainChange.getAddress()) && company.getLocation() != null && company.getLocation().equals(trainChange.getAddress())) {
                throw new ArsException("\u5355\u4f4d\u5730\u5740\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            List checkTrainChanges = this.trainChangeDao.findApproveByUserId(userId);
            if (checkTrainChanges != null && checkTrainChanges.size() > 0) {
                String checkMsg = "";
                for (TrainChange checkTrainChange : checkTrainChanges) {
                    if (StringUtil.isNotEmpty((String)trainChange.getNdlegalname()) && StringUtil.isNotEmpty((String)checkTrainChange.getNdlegalname())) {
                        checkMsg = checkMsg + "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)trainChange.getAddress()) && StringUtil.isNotEmpty((String)checkTrainChange.getAddress())) {
                        checkMsg = checkMsg + "\u529e\u516c\u5730\u5740\u3001";
                    }
                    if (!StringUtil.isNotEmpty((String)trainChange.getCompanyname()) || !StringUtil.isNotEmpty((String)checkTrainChange.getCompanyname())) continue;
                    checkMsg = checkMsg + "\u5355\u4f4d\u540d\u79f0\u3001";
                }
                if (StringUtil.isNotEmpty((String)checkMsg)) {
                    checkMsg = checkMsg.substring(0, checkMsg.length() - 1) + "\u5df2\u63d0\u4ea4\u6b63\u5728\u5ba1\u6279\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\uff01";
                    throw new ArsException(checkMsg);
                }
            }
        }
        trainChange.setActive(Boolean.valueOf(true));
        trainChange.setUpdateTime(new Date());
        trainChange.setUpdateBy(currentUser.getUsername());
        trainChange.setUserid(userId);
        trainChange.setOldaddress(company.getLocation());
        trainChange.setOldcompanyname(company.getName());
        if (trainChange.getId() == null) {
            trainChange.setCreateTime(new Date());
            this.trainChangeDao.save(trainChange);
            if (trainChange.getApprovalstate().equals("002")) {
                this.approvalUtil.saveApproval("013", trainChange.getId(), "activitiTrainChangeapprovalProcess");
            }
        } else {
            TrainChange dbTrainChange = this.trainChangeDao.findById(trainChange.getId());
            boolean activity = true;
            if (StringUtil.isNotEmpty((String)dbTrainChange.getApprovalstate()) && dbTrainChange.getApprovalstate().equals("002") && dbTrainChange.getOrgid().toString().equals(trainChange.getOrgid().toString())) {
                activity = false;
                if (!StringUtil.isEmpty((String)trainChange.getCompanyname()) || !StringUtil.isEmpty((String)trainChange.getOldcompanyname())) {
                    Approval approval;
                    String oldCompanyName;
                    String companyName = StringUtil.isEmpty((String)trainChange.getCompanyname()) ? trainChange.getOldcompanyname() : trainChange.getCompanyname();
                    String string = oldCompanyName = StringUtil.isEmpty((String)dbTrainChange.getCompanyname()) ? dbTrainChange.getOldcompanyname() : dbTrainChange.getCompanyname();
                    if (!companyName.equals(oldCompanyName) && (approval = this.approvalDAO.findBybusinessidAndType(trainChange.getId(), "013")) != null) {
                        this.approvalUtil.updateContent(approval, StringUtil.isEmpty((String)trainChange.getCompanyname()) ? trainChange.getOldcompanyname() : trainChange.getCompanyname());
                    }
                }
            }
            BeanUtils.copyPropertiesIgnore((Object)trainChange, (Object)dbTrainChange, (String)"active,createTime,userid", (Boolean)true);
            dbTrainChange.setNdlegalbrith(trainChange.getNdlegalbrith());
            dbTrainChange.setUpdateBy(currentUser.getUsername());
            dbTrainChange.setUpdateTime(new Date());
            if (trainChange.getApprovalstate() == null || "".equals(trainChange.getApprovalstate()) || trainChange.getApprovalstate().equals("002")) {
                dbTrainChange.setApprovalstate("002");
                dbTrainChange.setChargecensorstatus("");
                dbTrainChange.setTrainCensorstatus("");
            }
            this.trainChangeDaoAop.update(dbTrainChange);
            if (activity && "002".equals(dbTrainChange.getApprovalstate())) {
                this.approvalUtil.saveApproval("013", dbTrainChange.getId(), "activitiTrainChangeapprovalProcess");
            }
        }
    }

    public void saveOrUpdateForIntegrate(TrainChange trainChange, User currentUser) {
        Long userId = currentUser.getId();
        SecurityCompany company = this.securityCompanyDao.findByUserid(userId);
        if (!trainChange.getApprovalstate().equals("001") && company != null) {
            String oldSecurityScope;
            if (StringUtil.isNotEmpty((String)trainChange.getSecurityScopes()) && (oldSecurityScope = company.getSecurityScopeType()).equals(trainChange.getSecurityScopes())) {
                throw new ArsException("\u670d\u52a1\u8303\u56f4\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (StringUtil.isNotEmpty((String)trainChange.getCompanyname()) && company.getName().equals(trainChange.getCompanyname())) {
                throw new ArsException("\u5355\u4f4d\u540d\u79f0\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (StringUtil.isNotEmpty((String)trainChange.getAddress()) && company.getLocation() != null && company.getLocation().equals(trainChange.getAddress())) {
                throw new ArsException("\u5355\u4f4d\u5730\u5740\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (trainChange.getBgregisteredMoney() != null && company.getRegisteredMoney() != null && trainChange.getBgregisteredMoney().toString().equals(company.getRegisteredMoney().toString())) {
                throw new ArsException("\u6ce8\u518c\u8d44\u672c\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            List checkTrainChanges = this.trainChangeDao.findApproveByUserId(userId);
            if (checkTrainChanges != null && checkTrainChanges.size() > 0) {
                String checkMsg = "";
                for (TrainChange checkTrainChange : checkTrainChanges) {
                    if (StringUtil.isNotEmpty((String)trainChange.getNdlegalname()) && StringUtil.isNotEmpty((String)checkTrainChange.getNdlegalname())) {
                        checkMsg = checkMsg + "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)trainChange.getAddress()) && StringUtil.isNotEmpty((String)checkTrainChange.getAddress())) {
                        checkMsg = checkMsg + "\u529e\u516c\u5730\u5740\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)trainChange.getCompanyname()) && StringUtil.isNotEmpty((String)checkTrainChange.getCompanyname())) {
                        checkMsg = checkMsg + "\u5355\u4f4d\u540d\u79f0\u3001";
                    }
                    if (trainChange.getBgregisteredMoney() != null && checkTrainChange.getBgregisteredMoney() != null) {
                        checkMsg = checkMsg + "\u6ce8\u518c\u8d44\u672c\u3001";
                    }
                    if (!StringUtil.isNotEmpty((String)trainChange.getSecurityScopes()) || !StringUtil.isNotEmpty((String)checkTrainChange.getSecurityScopes())) continue;
                    checkMsg = checkMsg + "\u670d\u52a1\u8303\u56f4\u3001";
                }
            }
        }
        if (null != trainChange.getSecurityScopes() && !trainChange.getSecurityScopes().contains("20") || null == trainChange.getSecurityScopes()) {
            trainChange.setOtherSecScopeType(null);
        }
        if (trainChange.getId() == null) {
            trainChange.setActive(Boolean.valueOf(true));
            trainChange.setCreateTime(new Date());
            trainChange.setUpdateTime(new Date());
            trainChange.setUpdateBy(currentUser.getUsername());
            trainChange.setUserid(userId);
            trainChange.setOldaddress(company.getLocation());
            trainChange.setOldcompanyname(company.getName());
            if (company.getRegisteredMoney() != null) {
                trainChange.setOldregisteredMoney(company.getRegisteredMoney().toString());
            }
            String securityScopes = company.getSecurityScopeType();
            trainChange.setOldsecurityScopes(securityScopes);
            this.trainChangeDao.save(trainChange);
            this.approvalUtil.saveApprovalForIntegrate("013", trainChange.getId(), "activitiTrainChangeapprovalProcess", currentUser);
        }
    }

    public void saveOrUpdateForDS(TrainChange trainChange) {
        TrainChange dbTrainChange = this.trainChangeDao.findById(trainChange.getId());
        if (trainChange.getActive() == null) {
            trainChange.setActive(Boolean.valueOf(true));
        }
        if (dbTrainChange != null) {
            if (trainChange.getUpdateTime().getTime() > dbTrainChange.getUpdateTime().getTime()) {
                trainChange.setNdtrainCensorstatus(dbTrainChange.getNdtrainCensorstatus());
                trainChange.setTrainCensorstatus(dbTrainChange.getTrainCensorstatus());
                trainChange.setChargecensorstatus(dbTrainChange.getChargecensorstatus());
                this.trainChangeDaoAop.update(trainChange);
            }
        } else {
            this.trainChangeDao.save(trainChange);
        }
    }

    public void updatePoliceId(TrainChange trainChange) {
        Approval approval = this.approvalDAO.getById(trainChange.getApprovalId());
        TrainChange dbTrainChange = this.trainChangeDao.findById(trainChange.getId());
        dbTrainChange.setPoliceid(trainChange.getPoliceid());
        dbTrainChange.setUpdateTime(new Date());
        this.trainChangeDaoAop.update(dbTrainChange);
        approval.setPoliceid(trainChange.getPoliceid());
        approval.setRoleid(null);
        approval.setUpdateTime(new Date());
        this.approvalDAO.update(approval);
    }

    public TrainChangeSearchDto search(TrainChangeSearchDto dto) {
        TrainChangeSearchDto resultDto = new TrainChangeSearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = this.policeDao.findById(currentUser.getOrgid());
        if (police != null) {
            String areacode = police.getAreacode();
            if (areacode.endsWith("0000")) {
                dto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                dto.setDistrict(areacode.substring(0, 4) + "__");
            } else {
                dto.setDistrict(areacode);
            }
        }
        List list = this.trainChangeDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.trainChangeDao.searchCount(dto));
        return resultDto;
    }

    public TrainChangeSearchDto searchCompanyCertificate(TrainChangeSearchDto dto) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        TrainChangeSearchDto resultDto = new TrainChangeSearchDto();
        List list = this.trainChangeDao.searchCompanyCertificate(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.trainChangeDao.searchCompanyCertificateCount(dto));
        return resultDto;
    }

    public void delete(TrainChange trainChange) {
        User currentUser = this.arsUtil.getCurrentUser();
        trainChange.setUpdateBy(currentUser.getUsername());
        trainChange.setUpdateTime(new Date());
        this.trainChangeDaoAop.delete(trainChange);
    }

    public TrainChange findByUser(Long userid) {
        return this.trainChangeDao.findByUser(userid);
    }

    public void updateAndSaveWorkExperience(TrainChange trainChange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post) {
        this.saveOrUpdate(trainChange);
        User currentUser = this.arsUtil.getCurrentUser();
        this.workexperienceService.deleteByTrainChangeId(trainChange.getId());
        TrainChangeworkexperience trainChangeworkexperience = null;
        if (startdate != null) {
            for (int i = 0; i < startdate.length; ++i) {
                trainChangeworkexperience = new TrainChangeworkexperience();
                trainChangeworkexperience.setActive(Boolean.valueOf(true));
                if (workCompanyname.length > i) {
                    trainChangeworkexperience.setCompanyname(workCompanyname[i]);
                }
                trainChangeworkexperience.setCreateTime(new Date());
                if (enddate.length > i) {
                    trainChangeworkexperience.setEnddate(enddate[i]);
                }
                trainChangeworkexperience.setTrainChangeId(trainChange.getId());
                if (post.length > i) {
                    trainChangeworkexperience.setPost(post[i]);
                }
                trainChangeworkexperience.setStartdate(startdate[i]);
                trainChangeworkexperience.setUpdateBy(currentUser.getUsername());
                trainChangeworkexperience.setUpdateTime(new Date());
                this.workexperienceService.saveOrUpdate(trainChangeworkexperience);
            }
        }
    }

    public List<TrainChange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.trainChangeDao.searchForDataSynchronization(searchDto);
    }

    public List<TrainChange> findAll() {
        return this.trainChangeDao.findAll();
    }

    public PageResult searchTrainChangeList_table(Map<Object, Object> p) {
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else if (police != null) {
            areacode = police.getAreacode();
        }
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("district", areacode.substring(0, 4) + "__");
            } else {
                p.put("district", areacode);
            }
        }
        if (police != null && police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
        }
        if (p.get("checkType") != null && currentUser != null) {
            p.put("userid", currentUser.getId());
        }
        return new PageResult(Integer.valueOf(this.trainChangeDao.countTrainChangeList(p)), (Object)this.trainChangeDao.searchTrainChangeList(p));
    }

    public void saveOrUpdateForApproval(TrainChange trainChange) {
        trainChange.setUpdateTime(new Date());
        this.trainChangeDaoAop.update(trainChange);
    }

    public void updateCensorStatus(TrainChange trainChange) {
        this.trainChangeDaoAop.update(trainChange);
    }

    public List<TrainChange> findApprovePassByCompanyId(Long companyId) {
        return this.trainChangeDao.findApprovePassByCompanyId(companyId);
    }

    public void saveOrUpdateForApprovalImport(TrainChange trainChange) {
        this.trainChangeDaoAop.update(trainChange);
    }

    public void searchForPage(TrainChangeSearchDto dto, AjaxPageResponse<TrainChange> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.trainChangeDao.searchForPage(dto, page);
    }
}

