/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.msg.NewsCompanyRelationshipDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.msg.NewsCompanyRelationship;
import com.bcxin.ars.service.msg.NewsCompanyRelationshipService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=NewsCompanyRelationship.class)
@DataSyncOutAnnotation(getClazz=NewsCompanyRelationship.class)
public class NewsCompanyRelationshipServiceImpl
implements NewsCompanyRelationshipService {
    Logger logger = LoggerFactory.getLogger(NewsCompanyRelationshipServiceImpl.class);
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private NewsCompanyRelationshipDao newsCompanyRelationshipDao;

    public List<NewsCompanyRelationship> findDSOutList(String startDate) {
        return this.newsCompanyRelationshipDao.searchFromInToOutForExport(startDate);
    }

    public void saveOrUpdateForImport(NewsCompanyRelationship newsCompanyRelationship) {
        try {
            newsCompanyRelationship.setUpdateflag(Boolean.valueOf(false));
            NewsCompanyRelationship dbNewsCompanyRelationship = this.newsCompanyRelationshipDao.findById(newsCompanyRelationship.getId());
            if (dbNewsCompanyRelationship == null) {
                newsCompanyRelationship.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsCompanyRelationship.getUpdateTime(), (int)1));
                this.newsCompanyRelationshipDao.saveForDS(newsCompanyRelationship);
            } else if (newsCompanyRelationship.getUpdateTime().getTime() > dbNewsCompanyRelationship.getUpdateTime().getTime()) {
                newsCompanyRelationship.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsCompanyRelationship.getUpdateTime(), (int)1));
                this.newsCompanyRelationshipDao.updateForDS(newsCompanyRelationship);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<NewsCompanyRelationship> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.newsCompanyRelationshipDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(NewsCompanyRelationship newsCompanyRelationship) {
        NewsCompanyRelationship dbnewsCompanyRelationship;
        newsCompanyRelationship.setUpdateflag(Boolean.valueOf(false));
        if (newsCompanyRelationship.getActive() == null) {
            newsCompanyRelationship.setActive(Boolean.valueOf(true));
        }
        if ((dbnewsCompanyRelationship = this.newsCompanyRelationshipDao.findById(newsCompanyRelationship.getId())) != null && newsCompanyRelationship.getUpdateTime().getTime() > dbnewsCompanyRelationship.getUpdateTime().getTime()) {
            this.newsCompanyRelationshipDao.updateForDS(newsCompanyRelationship);
        }
    }

    public void importBatch(List<NewsCompanyRelationship> list) {
        List dbList = this.newsCompanyRelationshipDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (NewsCompanyRelationship detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.newsCompanyRelationshipDao.saveBatch(list);
        }
    }
}

