/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.SecurityGuardDao;
import com.bcxin.ars.dao.SecurityGuardDaoAop;
import com.bcxin.ars.dao.sb.SbSponsorlicenseManagerDao;
import com.bcxin.ars.dao.sb.SbSponsorlicenseVmanagerDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGuardSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.SecurityGuard;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SbSponsorlicenseManager;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.service.SecurityGuardService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.date.DateField;
import com.xiaoleilu.hutool.date.DateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SecurityGuard.class, getMethodName="updateFlagForOutToIn", getImportType=ImportType.BATCH)
@DataSyncOutAnnotation(getClazz=SecurityGuard.class)
public class SecurityGuardServiceImpl
implements SecurityGuardService {
    @Resource
    private SecurityGuardDao securityGuardDao;
    @Resource
    private SecurityGuardDaoAop securityGuardDaoAop;
    @Resource
    private ArsUtil arsUtil;
    @Resource
    private SponsorlicenseDao sponsorlicenseDao;
    @Resource
    private SbSponsorlicenseManagerDao sbSponsorlicenseManagerDao;
    @Resource
    private SbSponsorlicenseVmanagerDao sbSponsorlicenseVmanagerDao;

    public SecurityGuard findById(long id) {
        return this.securityGuardDao.findById(Long.valueOf(id));
    }

    public SecurityGuard findByIdNumber(String idNumber) {
        return this.securityGuardDao.findByIdNum(idNumber);
    }

    public AjaxResult saveOrUpdate(SecurityGuard securityGuard) {
        AjaxResult result = new AjaxResult();
        SecurityGuard dbSecurityGuard = new SecurityGuard();
        String userName = this.arsUtil.getCurrentUser().getUsername();
        if (securityGuard.getId() != null) {
            dbSecurityGuard = this.securityGuardDao.findById(securityGuard.getId());
            if (!dbSecurityGuard.getIdNumber().equals(securityGuard.getIdNumber()) && (dbSecurityGuard = this.securityGuardDao.findByIdNum(securityGuard.getIdNumber())) != null) {
                result.setSuccessful(false);
                result.setMsg("\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff01");
                return result;
            }
            securityGuard.setUpdateBy(userName);
            securityGuard.setUpdateTime(new Date());
            securityGuard.setUpdateflag(Boolean.valueOf(true));
            this.securityGuardDaoAop.update(securityGuard);
        } else {
            dbSecurityGuard = this.securityGuardDao.findByIdNum(securityGuard.getIdNumber());
            if (dbSecurityGuard != null) {
                result.setSuccessful(false);
                result.setMsg("\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff01");
                return result;
            }
            securityGuard.setActive(Boolean.valueOf(true));
            securityGuard.setCreateTime(new Date());
            securityGuard.setUpdateBy(userName);
            securityGuard.setUpdateTime(new Date());
            securityGuard.setUpdateflag(Boolean.valueOf(true));
            this.securityGuardDao.save(securityGuard);
        }
        result.setSuccessful(true);
        return result;
    }

    public List<Map<String, String>> saveSecurityGuard(List<Map<String, String>> dataList, User loginUser) {
        int insertLength;
        Long importBatchId = new IdWorker().nextId();
        int i = 0;
        for (insertLength = dataList.size(); insertLength > 2000; insertLength -= 2000) {
            this.securityGuardDao.insertTempBatchGuardImport(dataList.subList(i, i + 2000), importBatchId);
            i += 2000;
        }
        if (insertLength > 0) {
            this.securityGuardDao.insertTempBatchGuardImport(dataList.subList(i, i + insertLength), importBatchId);
        }
        this.securityGuardDao.checkIdNumNoRepeat(importBatchId);
        this.securityGuardDao.checkInOtherCom(importBatchId);
        this.securityGuardDao.insertSecurityGuardInfo(importBatchId);
        List tempInputPerList = this.securityGuardDao.getTempImportGuardList(importBatchId);
        this.securityGuardDao.deleteTempBatchGuardImport(importBatchId);
        return tempInputPerList;
    }

    public String validateSecurityGuard(BusinessCommon businessCommon) {
        StringBuffer result = new StringBuffer("");
        if (businessCommon.getClass().equals(Sponsorlicense.class)) {
            Sponsorlicense sponsor = (Sponsorlicense)businessCommon;
            String legalPersonNo = sponsor.getLegalPersonNo();
            String managerNo = sponsor.getSbSponsorlicenseManager().getIdnum();
            String vManagerNo = sponsor.getSbSponsorlicenseVmanager().getVidnum();
            if (StringUtil.isNotEmpty((String)legalPersonNo)) {
                result.append(this.validateGuard("legal", legalPersonNo));
            }
            if (StringUtil.isNotEmpty((String)managerNo)) {
                for (String manage : managerNo.split(",")) {
                    result.append(this.validateGuard("manage", manage));
                }
            }
            if (StringUtil.isNotEmpty((String)vManagerNo)) {
                for (String manage : vManagerNo.split(",")) {
                    result.append(this.validateGuard("vmanage", manage));
                }
            }
        } else if (businessCommon.getClass().equals(Traincompanyapply.class)) {
            Traincompanyapply traincompany = (Traincompanyapply)businessCommon;
            if (StringUtil.isNotEmpty((String)traincompany.getTraincreditcode())) {
                result.append(this.validateGuard("legal", traincompany.getLegalcode()));
            }
            if (StringUtil.isNotEmpty((String)traincompany.getLegalcode())) {
                result.append(this.validateGuard("ndlegal", traincompany.getTraincreditcode()));
            }
        }
        return result.toString();
    }

    private String validateGuard(String type, String legalPersonNo) {
        SecurityGuard guard = this.securityGuardDao.findByIdNum(legalPersonNo);
        if (guard == null) {
            return type + ":0:" + legalPersonNo + ";";
        }
        if (StringUtil.isNotEmpty((String)guard.getSecurityCompany()) && StringUtil.isNotEmpty((String)guard.getServiceStartTime()) && StringUtil.isNotEmpty((String)guard.getServiceEndTime()) && com.xiaoleilu.hutool.date.DateUtil.isIn((Date)com.xiaoleilu.hutool.date.DateUtil.date(), (Date)com.xiaoleilu.hutool.date.DateUtil.parseDate((String)guard.getServiceStartTime()), (Date)com.xiaoleilu.hutool.date.DateUtil.parseDate((String)guard.getServiceEndTime()))) {
            return type + ":-1:" + legalPersonNo + ";";
        }
        return "";
    }

    public static void main(String[] args) {
        System.out.println(com.xiaoleilu.hutool.date.DateUtil.date());
        System.out.println(com.xiaoleilu.hutool.date.DateUtil.isIn((Date)com.xiaoleilu.hutool.date.DateUtil.date(), (Date)com.xiaoleilu.hutool.date.DateUtil.parseDate((String)"2019-08-01"), (Date)com.xiaoleilu.hutool.date.DateUtil.parseDate((String)"2019-09-12")));
        System.out.println(com.xiaoleilu.hutool.date.DateUtil.isIn((Date)com.xiaoleilu.hutool.date.DateUtil.date(), (Date)com.xiaoleilu.hutool.date.DateUtil.parseDate((String)"2019-08-01"), (Date)com.xiaoleilu.hutool.date.DateUtil.parseDate((String)"2019-10-01")));
    }

    public void importBatch(List<SecurityGuard> list) {
        List dbList = this.securityGuardDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (SecurityGuard detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception exception) {}
            }
            this.securityGuardDaoAop.saveBatch(list);
        }
    }

    public List<SecurityGuard> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.securityGuardDao.searchForDataSynchronization(dto);
    }

    public void updateFlagForOutToIn(List<SecurityGuard> list) {
        this.securityGuardDaoAop.updateFlagForOutToIn(list);
    }

    public List<SecurityGuard> findDSOutList(String startDate) {
        return this.securityGuardDao.searchForExport(startDate);
    }

    public void search(SecurityGuardSearchDto dto, AjaxPageResponse<SecurityGuard> page) {
        this.securityGuardDao.search(dto, page);
    }

    public void updateSecurityCompany(BusinessCommon businessCommon) {
        User currentUser = this.arsUtil.getCurrentUser();
        ArrayList<String> idNums = new ArrayList<String>();
        if (businessCommon.getClass().equals(Sponsorlicense.class)) {
            Sponsorlicense sponsor = (Sponsorlicense)businessCommon;
            String legalPersonNo = sponsor.getLegalPersonNo();
            List managers = this.sbSponsorlicenseManagerDao.findBySponsorId(sponsor.getId());
            List vmanagers = this.sbSponsorlicenseVmanagerDao.findBySponsorId(sponsor.getId());
            if (StringUtil.isNotEmpty((String)legalPersonNo)) {
                idNums.add(legalPersonNo);
            }
            if (managers != null && managers.size() > 0) {
                for (SbSponsorlicenseManager manager : managers) {
                    idNums.add(manager.getIdnum());
                }
            }
            if (vmanagers != null && vmanagers.size() > 0) {
                for (SbSponsorlicenseManager manager : vmanagers) {
                    idNums.add(manager.getVidnum());
                }
            }
        } else if (businessCommon.getClass().equals(Traincompanyapply.class)) {
            Traincompanyapply traincompany = (Traincompanyapply)businessCommon;
            if (StringUtil.isNotEmpty((String)traincompany.getTraincreditcode())) {
                idNums.add(traincompany.getTraincreditcode());
            }
            if (StringUtil.isNotEmpty((String)traincompany.getLegalcode())) {
                idNums.add(traincompany.getLegalcode());
            }
        }
        if (idNums.size() > 0) {
            SecurityGuard securityGuard = new SecurityGuard();
            securityGuard.setUpdateTime(new Date());
            securityGuard.setUpdateflag(Boolean.valueOf(true));
            securityGuard.setSecurityCompany(businessCommon.getCompanyname());
            securityGuard.setUpdateBy(currentUser.getUsername());
            securityGuard.setServiceStartTime(DateUtil.convertDateToString((Date)businessCommon.getCreateTime(), (String)"yyyy-MM-dd"));
            try {
                DateTime endServiceTime = com.xiaoleilu.hutool.date.DateUtil.offset((Date)com.xiaoleilu.hutool.date.DateUtil.parseDate((String)securityGuard.getServiceStartTime()), (DateField)DateField.YEAR, (int)3);
                securityGuard.setServiceEndTime(DateUtil.convertDateToString((Date)endServiceTime, (String)"yyyy-MM-dd"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.securityGuardDaoAop.batchUpdateByIdNums(idNums, securityGuard);
        }
    }
}

