/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityGoodThingDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGoodThingDetailDTO;
import com.bcxin.ars.dto.SecurityGoodThingDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityGoodThing;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityGoodThingService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SecurityGoodThing.class)
public class SecurityGoodThingServiceImpl
implements SecurityGoodThingService {
    @Autowired
    private SecurityGoodThingDao securityGoodThingDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ArsUtil arsUtil;

    public void save(SecurityGoodThing securityGoodThing) {
        Long id = this.arsUtil.getCurrentUser().getId();
        String realname = this.arsUtil.getCurrentUser().getRealname();
        if (this.arsUtil.getCurrentUser().getPlatform() == 2) {
            securityGoodThing.setUserid(this.arsUtil.getCurrentUser().getId());
        }
        SecurityPerson dbPerson = this.securityPersonDao.findById(securityGoodThing.getPersonId());
        securityGoodThing.setUserid(id);
        securityGoodThing.setCreateTime(new Date());
        securityGoodThing.setUpdateTime(new Date());
        securityGoodThing.setActive(Boolean.valueOf(true));
        securityGoodThing.setUpdateBy(realname);
        securityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
        securityGoodThing.setPhone(dbPerson.getPhone());
        securityGoodThing.setIdNumber(dbPerson.getIdNumber());
        this.securityGoodThingDao.save(securityGoodThing);
    }

    public List<SecurityGoodThing> findByUserid(Long userid) {
        return this.securityGoodThingDao.findByUserid(userid);
    }

    public SecurityGoodThing findById(Long id) {
        return this.securityGoodThingDao.findById(id);
    }

    public SecurityGoodThingDto search(SecurityGoodThingDto dto) {
        List securityGoodThings = this.securityGoodThingDao.search(dto);
        Long searchCount = this.securityGoodThingDao.searchCount(dto);
        dto.setData(securityGoodThings);
        dto.setTotalCount(searchCount);
        return dto;
    }

    public AjaxResult searchGoodThing(SecurityGoodThingDto dto) {
        AjaxResult result = new AjaxResult();
        try {
            User user = this.arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
                result.setData((Object)this.search(dto));
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public SecurityGoodThing updateById(SecurityGoodThing securityGoodThing) {
        String realname = this.arsUtil.getCurrentUser().getRealname();
        SecurityGoodThing dbSecurityGoodThing = this.securityGoodThingDao.findById(securityGoodThing.getId());
        SecurityPerson dbPerson = this.securityPersonDao.findById(securityGoodThing.getPersonId());
        dbSecurityGoodThing.setUpdateTime(new Date());
        dbSecurityGoodThing.setActive(Boolean.valueOf(true));
        dbSecurityGoodThing.setUpdateBy(realname);
        dbSecurityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
        dbSecurityGoodThing.setContent(securityGoodThing.getContent());
        dbSecurityGoodThing.setDepartment(securityGoodThing.getDepartment());
        dbSecurityGoodThing.setGoodThingDate(securityGoodThing.getGoodThingDate());
        dbSecurityGoodThing.setIdNumber(dbPerson.getIdNumber());
        dbSecurityGoodThing.setName(securityGoodThing.getName());
        dbSecurityGoodThing.setPersonId(securityGoodThing.getPersonId());
        dbSecurityGoodThing.setPhone(dbPerson.getPhone());
        dbSecurityGoodThing.setRemark(securityGoodThing.getRemark());
        return this.securityGoodThingDao.updateById(dbSecurityGoodThing);
    }

    public AjaxResult deleteGoodThing(long id) {
        AjaxResult result = new AjaxResult();
        try {
            User user = this.arsUtil.getCurrentUser();
            if (user != null) {
                SecurityGoodThing securityGoodThing = new SecurityGoodThing();
                securityGoodThing.setId(Long.valueOf(id));
                securityGoodThing.setUpdateBy(user.getRealname());
                securityGoodThing.setUserid(user.getId());
                securityGoodThing.setUpdateTime(new Date());
                this.securityGoodThingDao.delete(securityGoodThing);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public AjaxResult deleteAllGoodThing() {
        AjaxResult result = new AjaxResult();
        try {
            User user = this.arsUtil.getCurrentUser();
            if (user != null) {
                SecurityGoodThing securityGoodThing = new SecurityGoodThing();
                securityGoodThing.setUserid(user.getId());
                securityGoodThing.setUpdateBy(user.getUsername());
                securityGoodThing.setUpdateTime(new Date());
                this.securityGoodThingDao.deleteByUserid(securityGoodThing);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public List<SecurityGoodThing> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.securityGoodThingDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(SecurityGoodThing securityGoodThing) {
        if (securityGoodThing.getActive() == null) {
            securityGoodThing.setActive(Boolean.valueOf(true));
        }
        if (!securityGoodThing.getActive().booleanValue()) {
            this.securityGoodThingDao.delete(securityGoodThing);
        } else {
            SecurityGoodThing dbSecurityGoodThing = this.securityGoodThingDao.findById(securityGoodThing.getId());
            if (dbSecurityGoodThing == null) {
                this.securityGoodThingDao.saveForDS(securityGoodThing);
            } else if (securityGoodThing.getUpdateTime().getTime() > dbSecurityGoodThing.getUpdateTime().getTime()) {
                this.securityGoodThingDao.updateById(securityGoodThing);
            }
        }
    }

    public SecurityGoodThingDetailDTO findByIdForPerson(Long id) {
        return this.securityGoodThingDao.findByIdForPerson(id);
    }

    public void exportSecurityGoodThing(List<SecurityGoodThing> data, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u597d\u4eba\u597d\u4e8b\u4fe1\u606f");
            String[] handers = new String[]{"\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7", "\u624b\u673a\u53f7", "\u6240\u5c5e\u516c\u53f8", "\u65e5\u671f", "\u597d\u4eba\u597d\u4e8b\u5185\u5bb9"};
            HSSFRow rowFirst = sheet1.createRow(0);
            CellStyle style = ExcelUtil.getCommonTitleStyle((HSSFWorkbook)wb);
            for (int i = 0; i < handers.length; ++i) {
                HSSFCell cell = rowFirst.createCell(i);
                sheet1.setColumnWidth(i, 5000);
                cell.setCellValue(handers[i]);
            }
            int index = 1;
            HSSFRow row = null;
            for (SecurityGoodThing securityGoodThing : data) {
                row = sheet1.createRow(index++);
                HSSFCell nameCell = row.createCell(0);
                nameCell.setCellValue(securityGoodThing.getName());
                HSSFCell socialCodeCell = row.createCell(1);
                socialCodeCell.setCellValue(securityGoodThing.getIdNumber());
                HSSFCell legalPersonCell = row.createCell(2);
                legalPersonCell.setCellValue(securityGoodThing.getPhone());
                HSSFCell phoneCell = row.createCell(3);
                phoneCell.setCellValue(securityGoodThing.getCompanyName());
                HSSFCell addressCell = row.createCell(4);
                addressCell.setCellValue(securityGoodThing.getGoodThingDate());
                HSSFCell locationCell = row.createCell(5);
                locationCell.setCellValue(securityGoodThing.getContent());
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PageResult searchSecuritygoodthingList_table(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.securityGoodThingDao.countSecuritygoodthingList(p)), (Object)this.securityGoodThingDao.searchSecuritygoodthingList(p));
    }

    public void deleteGoodThingByGoodDeedsId(Long goodDeedsId) {
        this.securityGoodThingDao.deleteGoodThingByGoodDeedsId(goodDeedsId);
    }

    public void saveOrUpdateForSAAS(SecurityGoodThing securityGoodThing) {
        User user = this.arsUtil.getCurrentUser();
        SecurityPerson dbPerson = this.securityPersonDao.findById(securityGoodThing.getPersonId());
        SecurityGoodThing dbSecurityGoodThing = this.securityGoodThingDao.findByGoodDeedsId(securityGoodThing.getGoodDeedsId());
        if (dbSecurityGoodThing != null) {
            String realname = user.getRealname();
            dbSecurityGoodThing.setUpdateTime(new Date());
            dbSecurityGoodThing.setActive(Boolean.valueOf(true));
            dbSecurityGoodThing.setUpdateBy(realname);
            if (null != dbPerson && null != dbPerson.getRelation() && null != dbPerson.getRelation().getCompany()) {
                dbSecurityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
            }
            dbSecurityGoodThing.setContent(securityGoodThing.getContent());
            dbSecurityGoodThing.setDepartment(securityGoodThing.getDepartment());
            dbSecurityGoodThing.setGoodThingDate(securityGoodThing.getGoodThingDate());
            if (null != dbPerson) {
                dbSecurityGoodThing.setIdNumber(dbPerson.getIdNumber());
            }
            dbSecurityGoodThing.setName(securityGoodThing.getName());
            dbSecurityGoodThing.setPersonId(securityGoodThing.getPersonId());
            if (null != dbPerson) {
                dbSecurityGoodThing.setPhone(dbPerson.getPhone());
            }
            if (StringUtil.isEmpty((String)securityGoodThing.getGoodDeedsType())) {
                dbSecurityGoodThing.setGoodDeedsType(securityGoodThing.getGoodDeedsType());
            }
            dbSecurityGoodThing.setRemark(securityGoodThing.getRemark());
            this.securityGoodThingDao.updateByGoodDeedsId(dbSecurityGoodThing);
        } else {
            Long id = this.arsUtil.getCurrentUser().getId();
            String realname = this.arsUtil.getCurrentUser().getRealname();
            if (this.arsUtil.getCurrentUser().getPlatform() == 2) {
                securityGoodThing.setUserid(this.arsUtil.getCurrentUser().getId());
            }
            securityGoodThing.setUserid(id);
            securityGoodThing.setCreateTime(new Date());
            securityGoodThing.setUpdateTime(new Date());
            securityGoodThing.setActive(Boolean.valueOf(true));
            securityGoodThing.setUpdateBy(realname);
            if (null != dbPerson && null != dbPerson.getRelation() && null != dbPerson.getRelation().getCompany()) {
                securityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
            }
            if (null != dbPerson) {
                securityGoodThing.setPhone(dbPerson.getPhone());
            }
            if (null != dbPerson) {
                securityGoodThing.setIdNumber(dbPerson.getIdNumber());
            }
            this.securityGoodThingDao.save(securityGoodThing);
        }
    }

    public SecurityGoodThing findByGoodDeedsId(Long goodDeedsId) {
        return this.securityGoodThingDao.findByGoodDeedsId(goodDeedsId);
    }

    public List<SecurityGoodThing> query(SecurityGoodThingDto dto, AjaxPageResponse<SecurityGoodThing> ajaxPageResponse) {
        return this.securityGoodThingDao.query(dto, ajaxPageResponse);
    }
}

