/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ComStateChangeLogDao;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.OrderPersonDao;
import com.bcxin.ars.dao.OrganizationDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.RoleDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityCompanyDaoAop;
import com.bcxin.ars.dao.SecurityCompanyInsuranceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserDaoAop;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ComInfoDto;
import com.bcxin.ars.dto.CompanySearchDto;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PersonStudyDTO;
import com.bcxin.ars.dto.PersonStudySearchDTO;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.SecurityPersonDTO;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.UserVo;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.page.CompanyDto;
import com.bcxin.ars.dto.page.CompanyPageSearchDto;
import com.bcxin.ars.dto.report.CompanyReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.report.SupervisionDto;
import com.bcxin.ars.dto.report.SupervisionSearchDto;
import com.bcxin.ars.dto.report.TaskExecutionDto;
import com.bcxin.ars.dto.report.TestTrainDto;
import com.bcxin.ars.dto.sys.SysareaSearchDTO;
import com.bcxin.ars.dto.v5.CompanyV5Dto;
import com.bcxin.ars.dto.v5.V5PageDto;
import com.bcxin.ars.dto.v5.V5ResultDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.ComStateChangeLog;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.Role;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanyInsurance;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.SearchHistoryService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Base64Img;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.EntityForWebServiceUtil;
import com.bcxin.ars.util.KeyAndDefauleVal;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.Sha1Util;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ThirdPartyURL;
import com.bcxin.ars.util.message.messageUtils;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.bcxin.ars.webservice.Bagsxxb;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Zpxxb;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SecurityCompany.class)
@DataSyncOutAnnotation(getClazz=SecurityCompany.class, getImportType=ImportType.FOREACH, getMethodName="saveForImport")
public class SecurityCompanyServiceImpl
extends BaseService
implements SecurityCompanyService {
    private static Logger logger = LoggerFactory.getLogger(SecurityCompanyServiceImpl.class);
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityCompanyDaoAop securityCompanyDaoAop;
    @Autowired
    private OrganizationDao orgDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserDaoAop userDaoAop;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private ApprovalDAO approvalDao;
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private SecurityCompanyInsuranceDao securityCompanyInsuranceDao;
    @Autowired
    private ProblemPersonDao problemPersonDao;
    @Autowired
    private UserService userService;
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;
    @Autowired
    private SearchHistoryService searchHistoryService;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SysareaService sysareaService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private OrderPersonDao orderPersonDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private SecurityPersonService personService;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ComStateChangeLogDao comStateChangeLogDao;
    @Autowired
    private ClientUtil clientUtil;
    @Value(value="${temp-folder}")
    private String tempFolder;
    @Value(value="${base-folder}")
    private String baseFolder;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private ConfigUtils configUtils;

    public PageResult querysecurityCompanyList(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.securityCompanyDao.queryAllCnt(p)), (Object)this.securityCompanyDao.querySercurityCompanyList(p));
    }

    public int getAllCount(Map<Object, Object> p) {
        return this.securityCompanyDao.queryAllCnt(p);
    }

    public Map queryCompanyStatistics(Map<Object, Object> p) {
        return this.securityCompanyDao.queryCompanyStatistics(p);
    }

    public int getInitCount(Map<Object, Object> p) {
        return this.securityCompanyDao.queryInitCnt(p);
    }

    public int getNotInitCount(Map<Object, Object> p) {
        return this.securityCompanyDao.queryNotInitCnt(p);
    }

    public int getNewAddCount(Map<Object, Object> p) {
        return this.securityCompanyDao.queryNewAddCnt(p);
    }

    public SecurityCompany queryCompanyDetail(Long id) {
        return this.securityCompanyDao.queryCompanyDetail(id);
    }

    public List<SecurityCompany> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.securityCompanyDao.searchForDataSynchronization(dto);
    }

    public SecurityCompany findById(Long id) {
        return this.securityCompanyDao.findById(id);
    }

    public SecurityCompany findByComId(Long id) {
        return this.securityCompanyDao.findByComId(id);
    }

    public SecurityCompany findByComTaskId(Long id) {
        return this.securityCompanyDao.findByComTaskId(id);
    }

    public void searchConfessComForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.securityCompanyDao.searchConfessComForPage(dto, page);
    }

    public SecurityCompany findByUserid(Long userid) {
        return this.securityCompanyDao.findByUserid(userid);
    }

    public SecurityCompany findByUserName(String userName) {
        return this.securityCompanyDao.findByUserName(userName);
    }

    public List<SecurityCompany> findByAll(String type) {
        return this.securityCompanyDao.findByAll(type);
    }

    public List<SecurityCompany> findByAllExceptHaveCer(String type) {
        return this.securityCompanyDao.findByAllExceptHaveCer(type);
    }

    public List<SecurityCompany> findByAllForBj(String type) {
        return this.securityCompanyDao.findByAllForBj(type);
    }

    public SecurityCompany findBySocialCode(String socialCode) {
        return this.securityCompanyDao.findBySocialCode(socialCode);
    }

    public CompanySearchDto search(CompanySearchDto dto) {
        String areacode;
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        if (user != null && user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        if ((areacode = user.getPolice().getAreacode()).endsWith("0000")) {
            dto.setOrgLevel("1");
        } else if (areacode.endsWith("00")) {
            dto.setOrgLevel("2");
        } else {
            dto.setOrgLevel("3");
        }
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            this.searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_COMPANY, user);
        }
        List data = this.securityCompanyDao.search(dto);
        Long count = this.securityCompanyDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public CompanySearchDto searchForPersonInsuredState(CompanySearchDto dto) {
        List data = this.securityCompanyDao.search(dto);
        Long count = this.securityCompanyDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    private AjaxResult sendToSaas(SecurityCompany securityCompany) {
        AjaxResult result;
        ComInfoDto comInfoDto = new ComInfoDto();
        comInfoDto.setComName(securityCompany.getName());
        if (StringUtil.isNotEmpty((String)securityCompany.getAreaCode())) {
            comInfoDto.setRegProvince(securityCompany.getAreaCode().substring(0, 2) + "0000");
            comInfoDto.setRegCity(securityCompany.getAreaCode().substring(0, 4) + "00");
        }
        comInfoDto.setRegArea(securityCompany.getAreaCode());
        comInfoDto.setRegAddress(securityCompany.getAddress());
        if (StringUtil.isNotEmpty((String)securityCompany.getOfficeAreaCode())) {
            comInfoDto.setWorkProvince(securityCompany.getOfficeAreaCode().substring(0, 2) + "0000");
            comInfoDto.setWorkCity(securityCompany.getOfficeAreaCode().substring(0, 4) + "00");
        }
        comInfoDto.setWorkArea(securityCompany.getOfficeAreaCode());
        comInfoDto.setWorkAddress(securityCompany.getLocation());
        comInfoDto.setLegalRepPhone(securityCompany.getUser().getPhone());
        comInfoDto.setUserName(securityCompany.getUser().getUsername());
        comInfoDto.setEconomicType(securityCompany.getEconomicType());
        comInfoDto.setIndustryType("01");
        comInfoDto.setComType(securityCompany.getCompanyType());
        comInfoDto.setInstitutionType(securityCompany.getInstitutionType());
        comInfoDto.setIsBbdRegister("1");
        comInfoDto.setSafeRange(securityCompany.getSecurityScopeType());
        comInfoDto.setRegAmount(securityCompany.getRegisteredMoney() != null ? securityCompany.getRegisteredMoney() + "" : null);
        comInfoDto.setLegalRepName(securityCompany.getLegalPerson());
        comInfoDto.setIdCardNo(securityCompany.getLegalPersonNo());
        comInfoDto.setLicenceOrg(securityCompany.getGiveLicenseName());
        if (securityCompany.getGiveLicenseDate() != null) {
            comInfoDto.setLicenceDate(DateUtil.convertDateToString((Date)securityCompany.getGiveLicenseDate(), (String)"yyyy-MM-dd"));
        }
        if (!(result = this.saasInterfaceUtil.callInterface("/system/com-base-info/save", comInfoDto)).isSuccessful()) {
            throw new ArsException(securityCompany.getName() + result.getMsg());
        }
        if (result.getData() != null) {
            Long perId = ((JSONObject)result.getData()).getLong("perId");
            String comId = ((JSONObject)result.getData()).getString("comId");
            securityCompany.setComId(comId);
            securityCompany.setPerId(perId);
            securityCompany.setMobilePhone(securityCompany.getUser().getPhone());
            this.createManageAccount(securityCompany);
        }
        securityCompany.setCompanyCode(this.createCompanyCode(securityCompany.getInstitutionType()));
        return result;
    }

    public void resetCompanyCode() {
        List companyList = this.securityCompanyDao.findByErrorCompanyCode();
        if (companyList.size() > 0) {
            for (SecurityCompany company : companyList) {
                company.setCompanyCode(this.createCompanyCode(company.getInstitutionType()));
                company.setUpdateTime(new Date());
                this.securityCompanyDao.update(company);
            }
        }
    }

    private String createCompanyCode(String institutionType) {
        String maxCompanyCode = "";
        Config nativeConfig = this.configUtils.getConfigByKey("current_native");
        if (nativeConfig == null) {
            new ArsException("\u7f3a\u5c11\u7701\u4efd\u914d\u7f6e\u4fe1\u606f");
        }
        StringBuffer companyCode = new StringBuffer();
        if ("0102".equals(institutionType)) {
            maxCompanyCode = this.securityCompanyDao.searchMaxCompanyCode("BAG");
            if (StringUtils.isEmpty((Object)maxCompanyCode)) {
                companyCode.append("BAG").append(nativeConfig.getValue()).append("00000001");
            } else {
                companyCode.append(maxCompanyCode.substring(0, 5));
                companyCode.append(StringUtil.addZeroForNum((String)String.valueOf(Long.valueOf(maxCompanyCode.substring(6)) + 1L), (int)8));
            }
        } else if ("0103".equals(institutionType)) {
            maxCompanyCode = this.securityCompanyDao.searchMaxCompanyCode("BAP");
            if (StringUtils.isEmpty((Object)maxCompanyCode)) {
                companyCode.append("BAP").append(nativeConfig.getValue()).append("00000001");
            } else {
                companyCode.append(maxCompanyCode.substring(0, 5));
                companyCode.append(StringUtil.addZeroForNum((String)String.valueOf(Long.valueOf(maxCompanyCode.substring(6)) + 1L), (int)8));
            }
        } else if ("0104".equals(institutionType)) {
            maxCompanyCode = this.securityCompanyDao.searchMaxCompanyCode("BAZ");
            if (StringUtils.isEmpty((Object)maxCompanyCode)) {
                companyCode.append("BAZ").append(nativeConfig.getValue()).append("00000001");
            } else {
                companyCode.append(maxCompanyCode.substring(0, 5));
                companyCode.append(StringUtil.addZeroForNum((String)String.valueOf(Long.valueOf(maxCompanyCode.substring(6)) + 1L), (int)8));
            }
        }
        return companyCode.toString();
    }

    public void saveOrUpdateForFX(SecurityCompany company) {
        if (company == null) {
            throw new ArsException("\u5b89\u4fdd\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        company.setUpdateTime(new Date());
        this.securityCompanyDaoAop.update(company);
    }

    @Deprecated
    public void saveInsuranceCompany(SecurityCompany company) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany dbcompany = null;
        if (currentUser.getPlatform() == 2) {
            dbcompany = this.findByUserid(currentUser.getId());
        } else if (currentUser.getPlatform() == 1) {
            dbcompany = company;
        }
        if (dbcompany == null) {
            throw new ArsException("\u5b89\u4fdd\u516c\u53f8\u4fe1\u606f\u9519\u8bef\u3002");
        }
        User user = dbcompany.getUser();
        if (company.getSecurityCompanyInsurance() != null) {
            String[] insurance_company = company.getSecurityCompanyInsurance().getInsurance_company().split(",");
            String[] insurance_product = company.getSecurityCompanyInsurance().getInsurance_product().split(",");
            String[] protection_date = company.getSecurityCompanyInsurance().getProtection_date().split(",");
            String[] insured_num = company.getSecurityCompanyInsurance().getInsured_num().split(",");
            String[] premium_person = company.getSecurityCompanyInsurance().getPremium_person().split(",");
            String[] ywsg = company.getSecurityCompanyInsurance().getYwsg().split(",");
            String[] jtyw = company.getSecurityCompanyInsurance().getJtyw().split(",");
            String[] ywyl = company.getSecurityCompanyInsurance().getYwyl().split(",");
            String[] zdcj = company.getSecurityCompanyInsurance().getZdcj().split(",");
            String[] jyjt = company.getSecurityCompanyInsurance().getJyjt().split(",");
            String[] flfy = company.getSecurityCompanyInsurance().getFlfy().split(",");
            String[] end_date = company.getSecurityCompanyInsurance().getEnd_date().split(",");
            String[] insurance_number = company.getSecurityCompanyInsurance().getInsurance_number().split(",");
            String[] insurance_pic = company.getSecurityCompanyInsurance().getInsurance_pic().split(",");
            int[] a = new int[]{insurance_company.length, insurance_product.length, protection_date.length, insured_num.length, premium_person.length, ywsg.length, jtyw.length, ywyl.length, zdcj.length, jyjt.length, flfy.length, end_date.length, insurance_number.length};
            int count = StringUtil.getMax((int[])a);
            if (insurance_company != null && insurance_company.length > 0) {
                this.securityCompanyInsuranceDao.deleteBySid(user.getId().longValue());
                for (int i = 0; i < count; ++i) {
                    SecurityCompanyInsurance securityCompanyInsurance = new SecurityCompanyInsurance();
                    securityCompanyInsurance.setActive(Boolean.valueOf(true));
                    securityCompanyInsurance.setCreateTime(new Date());
                    securityCompanyInsurance.setUpdateTime(new Date());
                    securityCompanyInsurance.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
                    securityCompanyInsurance.setCompany_id(user.getId());
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getProtection_date()) && protection_date.length > i && !protection_date[i].equals("")) {
                        securityCompanyInsurance.setProtection_date(protection_date[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getPremium_person()) && premium_person.length > i && !premium_person[i].equals("")) {
                        securityCompanyInsurance.setPremium_person(premium_person[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getInsured_num()) && insured_num.length > i && !insured_num[i].equals("")) {
                        securityCompanyInsurance.setInsured_num(insured_num[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getInsurance_product()) && insurance_product.length > i) {
                        securityCompanyInsurance.setInsurance_product(insurance_product[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getInsurance_company()) && insurance_company.length > i) {
                        securityCompanyInsurance.setInsurance_company(insurance_company[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getYwsg()) && ywsg.length > i) {
                        securityCompanyInsurance.setYwsg(ywsg[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getJtyw()) && jtyw.length > i) {
                        securityCompanyInsurance.setJtyw(jtyw[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getYwyl()) && ywyl.length > i) {
                        securityCompanyInsurance.setYwyl(ywyl[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getZdcj()) && zdcj.length > i) {
                        securityCompanyInsurance.setZdcj(zdcj[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getJyjt()) && jyjt.length > i) {
                        securityCompanyInsurance.setJyjt(jyjt[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getFlfy()) && flfy.length > i) {
                        securityCompanyInsurance.setFlfy(flfy[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getEnd_date()) && end_date.length > i) {
                        securityCompanyInsurance.setEnd_date(end_date[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getInsurance_number()) && insurance_number.length > i) {
                        securityCompanyInsurance.setInsurance_number(insurance_number[i]);
                    }
                    if (!StringUtils.isEmpty((Object)company.getSecurityCompanyInsurance().getInsurance_pic()) && insurance_pic.length > i) {
                        securityCompanyInsurance.setInsurance_pic(insurance_pic[i]);
                    }
                    if ("0".equals(company.getPolicyLine())) {
                        securityCompanyInsurance.setActive(Boolean.valueOf(false));
                    }
                    this.securityCompanyInsuranceDao.save(securityCompanyInsurance);
                }
            }
        }
    }

    public void saveOrUpdateForSAAS(SecurityCompany company) {
        SecurityCompany dbCompany;
        Police police;
        User currentUser = this.arsUtil.getCurrentUser();
        if (null != currentUser) {
            company.setUpdateBy(currentUser.getUsername());
        } else {
            company.setUpdateBy(company.getUser().getUsername());
        }
        company.setUpdateTime(new Date());
        if (company.getId() == null) {
            if (this.securityCompanyDao.findByName(company.getName()) != null) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            company.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        }
        if ("11".equals(this.configUtils.getCurrentNative()) && StringUtil.isNotEmpty((String)company.getOrgId()) && (police = this.policeDao.findById(Long.valueOf(Long.parseLong(company.getOrgId())))) != null) {
            if ("4".equals(police.getOrgtype())) {
                Police parentPolice = this.policeDao.findByOrgIdsAndOrgType(police.getPath().split("/"), "3");
                if (parentPolice != null) {
                    company.setDistrictOrgId(parentPolice.getId().toString());
                    company.setDistrictOrgName(parentPolice.getOrgname());
                }
            } else {
                company.setDistrictOrgId(company.getOrgId());
                company.setDistrictOrgName(company.getOrgName());
            }
        }
        if ((dbCompany = this.securityCompanyDao.findById(company.getId())) == null) {
            company.setCreateTime(new Date());
            company.setActive(Boolean.valueOf(true));
            company.setExported(true);
            if (null != this.arsUtil.getCurrentNatvie()) {
                company.setNativeCode(this.arsUtil.getCurrentNatvie());
            }
            company.setSecurityAmount(Integer.valueOf(0));
            company.setCompanyCode(this.createCompanyCode(company.getInstitutionType()));
            this.securityCompanyDao.save(company);
            this.createManageAccount(company);
        } else {
            if (dbCompany != null && company.getId().longValue() != dbCompany.getId().longValue()) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            if (Constants.COMPANY_STATE_4.equals(dbCompany.getCompanyState())) {
                company.setCompanyState(dbCompany.getCompanyState());
            }
            BeanUtils.copyPropertiesIgnore((Object)company, (Object)dbCompany, (Boolean)true);
            if (!StringUtils.isEmpty((Object)company.getBusinessLicense())) {
                dbCompany.setBusinessLicense(this.getPhotoPath(company.getBusinessLicense()));
            }
            if (!StringUtils.isEmpty((Object)company.getPublicSecurityLicense())) {
                dbCompany.setPublicSecurityLicense(this.getPhotoPath(company.getPublicSecurityLicense()));
            }
            this.securityCompanyDaoAop.update(dbCompany);
        }
    }

    private void createManageAccount(SecurityCompany company) {
        if (company.getPerId() != null && StringUtil.isNotEmpty((String)company.getMobilePhone())) {
            SecurityPersonDTO personDTO = new SecurityPersonDTO();
            personDTO.setPhone(company.getMobilePhone());
            personDTO.setRealName("\u4e3b\u7ba1\u7406\u5458");
            personDTO.setInsured("0");
            personDTO.setIncumbencyStatus("1");
            personDTO.setAreacode(company.getAreaCode());
            personDTO.setPhone(company.getMobilePhone());
            personDTO.setId(company.getPerId());
            personDTO.setActive(Boolean.valueOf(true));
            personDTO.setCreateTime(new Date());
            personDTO.setUpdateTime(new Date());
            personDTO.setEntrydate(new Date());
            personDTO.setUpdateBy("system");
            personDTO.setUpdateflag(Boolean.valueOf(false));
            personDTO.setPersonType("1");
            this.personService.saveOrUpdateForSaas(personDTO, company);
        }
    }

    public void saveOrUpdate(SecurityCompany company) {
        SecurityCompany dbCompany;
        Police police;
        if (company.getId() == null) {
            if (this.securityCompanyDao.findByName(company.getName()) != null) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            company.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        }
        if ("11".equals(this.configUtils.getCurrentNative()) && StringUtil.isNotEmpty((String)company.getOrgId()) && (police = this.policeDao.findById(Long.valueOf(Long.parseLong(company.getOrgId())))) != null) {
            if ("4".equals(police.getOrgtype())) {
                Police parentPolice = this.policeDao.findByOrgIdsAndOrgType(police.getPath().split("/"), "3");
                if (parentPolice != null) {
                    company.setDistrictOrgId(parentPolice.getId().toString());
                    company.setDistrictOrgName(parentPolice.getOrgname());
                }
            } else {
                company.setDistrictOrgId(company.getOrgId());
                company.setDistrictOrgName(company.getOrgName());
            }
        }
        if ((dbCompany = this.securityCompanyDao.findById(company.getId())) == null) {
            Config policeConfig = this.configUtils.getConfigByKey("police");
            if (null != policeConfig && "0".equals(policeConfig.getValue())) {
                company.setExported(true);
                company.setUpdateflag(Boolean.valueOf(false));
            } else {
                company.setExported(false);
                company.setUpdateflag(Boolean.valueOf(true));
            }
            company.setCreateTime(new Date());
            company.setUpdateTime(company.getCreateTime());
            company.setActive(Boolean.valueOf(true));
            company.setNativeCode(this.arsUtil.getCurrentNatvie());
            company.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            company.setSecurityAmount(Integer.valueOf(0));
            if (!this.configUtils.isIntranet()) {
                this.sendToSaas(company);
            }
            this.securityCompanyDao.save(company);
        } else {
            if (dbCompany != null && company.getId().longValue() != dbCompany.getId().longValue()) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            SecurityCompany dbCom = this.securityCompanyDao.findById(company.getId());
            if (dbCom != null) {
                BeanUtils.copyPropertiesIgnore((Object)company, (Object)dbCom, (Boolean)true);
                if (!this.configUtils.isIntranet()) {
                    this.updateToSAAS(dbCom);
                }
                dbCom.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
                dbCom.setUpdateTime(new Date());
                if (!StringUtils.isEmpty((Object)company.getBusinessLicense())) {
                    dbCom.setBusinessLicense(this.getPhotoPath(company.getBusinessLicense()));
                }
                if (!StringUtils.isEmpty((Object)company.getPublicSecurityLicense())) {
                    dbCom.setPublicSecurityLicense(this.getPhotoPath(company.getPublicSecurityLicense()));
                }
                if (company.getUpdateflag() != null) {
                    dbCom.setUpdateflag(company.getUpdateflag());
                } else {
                    dbCom.setUpdateflag(Boolean.valueOf(false));
                }
                this.securityCompanyDaoAop.update(dbCom);
            } else {
                throw new RuntimeException("\u5b89\u4fdd\u516c\u53f8\u4e0d\u5b58\u5728\uff0cID:" + company.getId());
            }
        }
    }

    private void updateToSAAS(SecurityCompany securityCompany) {
        AjaxResult result;
        ComInfoDto comInfoDto = new ComInfoDto();
        comInfoDto.setComName(securityCompany.getName());
        comInfoDto.setRegProvince(securityCompany.getAreaCode().substring(0, 2) + "0000");
        comInfoDto.setRegCity(securityCompany.getAreaCode().substring(0, 4) + "00");
        comInfoDto.setRegArea(securityCompany.getAreaCode());
        comInfoDto.setRegAddress(securityCompany.getAddress());
        if (StringUtil.isNotEmpty((String)securityCompany.getOfficeAreaCode())) {
            comInfoDto.setWorkProvince(securityCompany.getOfficeAreaCode().substring(0, 2) + "0000");
            comInfoDto.setWorkCity(securityCompany.getOfficeAreaCode().substring(0, 4) + "00");
            comInfoDto.setWorkArea(securityCompany.getOfficeAreaCode());
        }
        comInfoDto.setWorkAddress(securityCompany.getLocation());
        comInfoDto.setLegalRepPhone(securityCompany.getUser().getPhone());
        comInfoDto.setUserName(securityCompany.getUser().getUsername());
        if (StringUtil.isEmpty((String)securityCompany.getComId())) {
            throw new ArsException(securityCompany.getName() + "ComID\u6570\u636e\u5f02\u5e38");
        }
        comInfoDto.setComId(Long.valueOf(securityCompany.getComId()));
        comInfoDto.setEconomicType(securityCompany.getEconomicType());
        comInfoDto.setComType(securityCompany.getCompanyType());
        comInfoDto.setInstitutionType(securityCompany.getInstitutionType());
        comInfoDto.setSafeRange(securityCompany.getSecurityScopeType());
        comInfoDto.setRegAmount(securityCompany.getRegisteredMoney() != null ? securityCompany.getRegisteredMoney() + "" : null);
        comInfoDto.setLegalRepName(securityCompany.getLegalPerson());
        comInfoDto.setIdCardNo(securityCompany.getLegalPersonNo());
        comInfoDto.setLicenceOrg(securityCompany.getGiveLicenseName());
        if (securityCompany.getGiveLicenseDate() != null) {
            comInfoDto.setLicenceDate(DateUtil.convertDateToString((Date)securityCompany.getGiveLicenseDate(), (String)"yyyy-MM-dd"));
        }
        if (!(result = this.saasInterfaceUtil.callInterface("/thirdPlat/bbd-callBack/complete-xmbg-approve", comInfoDto)).isSuccessful()) {
            throw new ArsException(securityCompany.getName() + result.getMsg());
        }
    }

    private String changeToSAASSafeRange(String securityScopeType) {
        if (StringUtil.isNotEmpty((String)securityScopeType)) {
            HashMap<String, String> safeRangeMap = new HashMap<String, String>();
            if ("61".equals(this.configUtils.getCurrentNative())) {
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "10");
                safeRangeMap.put("5", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");
            } else {
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");
            }
            StringBuffer safeRange = new StringBuffer();
            for (String scopeId : securityScopeType.split(",")) {
                safeRange.append((String)safeRangeMap.get(scopeId) + ",");
            }
            return safeRange.toString().substring(0, safeRange.toString().length() - 1);
        }
        return null;
    }

    public String changeToARSSafeRange(String securityScopeType) {
        if (StringUtil.isNotEmpty((String)securityScopeType)) {
            HashMap<String, String> safeRangeMap = new HashMap<String, String>();
            if ("61".equals(this.configUtils.getCurrentNative())) {
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "5");
                safeRangeMap.put("10", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");
            } else {
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");
            }
            StringBuffer safeRange = new StringBuffer();
            for (String scopeId : securityScopeType.split(",")) {
                safeRange.append((String)safeRangeMap.get(scopeId) + ",");
            }
            return safeRange.toString().substring(0, safeRange.toString().length() - 1);
        }
        return null;
    }

    public void saveForImport(SecurityCompany company) {
        boolean flag = true;
        SecurityCompany dbCompany = this.securityCompanyDao.findById(company.getId());
        if (dbCompany != null) {
            flag = false;
        }
        if (flag) {
            company.setExported(true);
            company.setCompanyCode(this.createCompanyCode(company.getInstitutionType()));
            company.setLocal(Boolean.valueOf(true));
            this.sendToSaas(company);
            this.securityCompanyDao.save(company);
        }
    }

    public void getOrgChildren(List<Organization> orgList, Organization org, int level) {
        String es = "";
        for (int i = 1; i < level; ++i) {
            es = es + "  ";
        }
        org.setName(es + org.getName());
        orgList.add(org);
        if (org.getChildren().size() > 0) {
            ++level;
            for (Organization o : org.getChildren()) {
                this.getOrgChildren(orgList, o, level);
            }
        }
    }

    public void getNativeChildren(List<TreeView> nativeList, TreeView treeView, int level) {
        String es = "";
        for (int i = 1; i < level; ++i) {
            es = es + "  ";
        }
        boolean flag = true;
        for (TreeView naView : nativeList) {
            if (!naView.getCode().equals(treeView.getCode())) continue;
            flag = false;
        }
        if (flag) {
            treeView.setText(es + treeView.getText());
            nativeList.add(treeView);
            if (treeView.getNodes() != null && treeView.getNodes().size() > 0) {
                ++level;
                for (TreeView o : treeView.getNodes()) {
                    this.getNativeChildren(nativeList, o, level);
                }
            }
        }
    }

    public void buildTemplate(SecurityCompany company, File file) throws Exception {
        int i;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet1 = wb.createSheet("\u586b\u5199\u8303\u4f8b\u8bf4\u660e");
        HSSFSheet sheet2 = wb.createSheet("\u4eba\u5458\u4fe1\u606f");
        HSSFSheet sheet3 = wb.createSheet("\u53c2\u8003\u6570\u636e");
        wb.setSheetHidden(2, true);
        List orgList = this.orgDao.findByCompany(company.getId());
        ArrayList<Organization> orgs = new ArrayList<Organization>();
        int level = 1;
        for (Organization org : orgList) {
            this.getOrgChildren(orgs, org, level);
        }
        String[] orgArr = new String[orgs.size()];
        for (int i2 = 0; i2 < orgs.size(); ++i2) {
            orgArr[i2] = ((Organization)orgs.get(i2)).getName() + "-" + ((Organization)orgs.get(i2)).getId();
        }
        List roles = this.roleDao.findByCompany(company.getId());
        String[] roleArr = new String[roles.size()];
        for (int i3 = 0; i3 < roles.size(); ++i3) {
            roleArr[i3] = ((Role)roles.get(i3)).getName() + "-" + ((Role)roles.get(i3)).getId();
        }
        String[] edu = new String[]{"\u521d\u4e2d-1", "\u4e2d\u804c-2", "\u6280\u6821-3", "\u666e\u901a\u9ad8\u4e2d-4", "\u4e13\u79d1-5", "\u672c\u79d1-6", "\u7855\u58eb-7", "\u535a\u58eb-8"};
        String[] profession_level = new String[]{"\u521d\u7ea7\u4fdd\u5b89\u5458-1", "\u4e2d\u7ea7\u4fdd\u5b89\u5458-2", "\u9ad8\u7ea7\u4fdd\u5b89\u5458-3", "\u4fdd\u5b89\u5e08-4", "\u9ad8\u7ea7\u4fdd\u5b89\u5e08-5"};
        String[] politics = new String[]{"\u515a\u5458-1", "\u56e2\u5458-2", "\u7fa4\u4f17-3"};
        String[] marriage = new String[]{"\u5df2\u5a5a-1", "\u672a\u5a5a-2", "\u79bb\u5f02-3"};
        String[] blood = new String[]{"A-A", "B-B", "AB-AB", "O-O", "Rh\u9633-Rh\u9633", "Rh\u9634-Rh\u9634"};
        String[] personType = new String[]{"\u5185\u52e4\u4eba\u5458-1", "\u666e\u901a\u4fdd\u5b89\u5458-2", "\u6b66\u88c5\u62bc\u8fd0\u4eba\u5458-3"};
        String[] nationality = new String[]{"\u4e2d\u56fd-\u4e2d\u56fd", "\u963f\u9c81\u5df4-\u963f\u9c81\u5df4", "\u963f\u5bcc\u6c57-\u963f\u5bcc\u6c57", "\u5b89\u54e5\u62c9-\u5b89\u54e5\u62c9", "\u5b89\u572d\u62c9-\u5b89\u572d\u62c9", "\u963f\u5c14\u5df4\u5c3c\u4e9a-\u963f\u5c14\u5df4\u5c3c\u4e9a", "\u5b89\u9053\u5c14-\u5b89\u9053\u5c14", "\u8377\u5c5e\u5b89\u7684\u5217\u65af-\u8377\u5c5e\u5b89\u7684\u5217\u65af", "\u963f\u8054\u914b-\u963f\u8054\u914b", "\u963f\u6839\u5ef7-\u963f\u6839\u5ef7", "\u4e9a\u7f8e\u5c3c\u4e9a-\u4e9a\u7f8e\u5c3c\u4e9a", "\u7f8e\u5c5e\u8428\u6469\u4e9a-\u7f8e\u5c5e\u8428\u6469\u4e9a", "\u5357\u6781\u6d32-\u5357\u6781\u6d32", "\u6cd5\u5c5e\u5357\u90e8\u9886\u571f-\u6cd5\u5c5e\u5357\u90e8\u9886\u571f", "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe-\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe", "\u6fb3\u5927\u5229\u4e9a-\u6fb3\u5927\u5229\u4e9a", "\u5965\u5730\u5229-\u5965\u5730\u5229", "\u963f\u585e\u62dc\u7586-\u963f\u585e\u62dc\u7586", "\u5e03\u9686\u8fea-\u5e03\u9686\u8fea", "\u6bd4\u5229\u65f6-\u6bd4\u5229\u65f6", "\u8d1d\u5b81-\u8d1d\u5b81", "\u5e03\u57fa\u7eb3\u6cd5\u7d22-\u5e03\u57fa\u7eb3\u6cd5\u7d22", "\u5b5f\u52a0\u62c9\u56fd-\u5b5f\u52a0\u62c9\u56fd", "\u4fdd\u52a0\u5229\u4e9a-\u4fdd\u52a0\u5229\u4e9a", "\u5df4\u6797-\u5df4\u6797", "\u5df4\u54c8\u9a6c-\u5df4\u54c8\u9a6c", "\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3-\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3", "\u767d\u4fc4\u7f57\u65af-\u767d\u4fc4\u7f57\u65af", "\u4f2f\u5229\u5179-\u4f2f\u5229\u5179", "\u767e\u5e55\u5927-\u767e\u5e55\u5927", "\u73bb\u5229\u7ef4\u4e9a-\u73bb\u5229\u7ef4\u4e9a", "\u5df4\u897f-\u5df4\u897f", "\u5df4\u5df4\u591a\u65af-\u5df4\u5df4\u591a\u65af", "\u6587\u83b1-\u6587\u83b1", "\u4e0d\u4e39-\u4e0d\u4e39", "\u5e03\u7ef4\u5c9b-\u5e03\u7ef4\u5c9b", "\u535a\u8328\u74e6\u7eb3-\u535a\u8328\u74e6\u7eb3", "\u4e2d\u975e-\u4e2d\u975e", "\u52a0\u62ff\u5927-\u52a0\u62ff\u5927", "\u79d1\u79d1\u65af\u7fa4\u5c9b-\u79d1\u79d1\u65af\u7fa4\u5c9b", "\u745e\u58eb-\u745e\u58eb", "\u667a\u5229-\u667a\u5229", "\u79d1\u7279\u8fea\u74e6-\u79d1\u7279\u8fea\u74e6", "\u5580\u9ea6\u9686-\u5580\u9ea6\u9686", "\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd-\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd", "\u521a\u679c-\u521a\u679c", "\u5e93\u514b\u7fa4\u5c9b-\u5e93\u514b\u7fa4\u5c9b", "\u54e5\u4f26\u6bd4\u4e9a-\u54e5\u4f26\u6bd4\u4e9a", "\u79d1\u6469\u7f57-\u79d1\u6469\u7f57", "\u4f5b\u5f97\u89d2-\u4f5b\u5f97\u89d2", "\u54e5\u65af\u8fbe\u9ece\u52a0-\u54e5\u65af\u8fbe\u9ece\u52a0", "\u53e4\u5df4-\u53e4\u5df4", "\u5723\u8bde\u5c9b-\u5723\u8bde\u5c9b", "\u5f00\u66fc\u7fa4\u5c9b-\u5f00\u66fc\u7fa4\u5c9b", "\u585e\u6d66\u8def\u65af-\u585e\u6d66\u8def\u65af", "\u6377\u514b-\u6377\u514b", "\u5fb7\u56fd-\u5fb7\u56fd", "\u5409\u5e03\u63d0-\u5409\u5e03\u63d0", "\u591a\u7c73\u5c3c\u52a0-\u591a\u7c73\u5c3c\u52a0", "\u4e39\u9ea6-\u4e39\u9ea6", "\u591a\u7c73\u5c3c\u5bb6\u5171\u548c\u56fd-\u591a\u7c73\u5c3c\u5bb6\u5171\u548c\u56fd", "\u963f\u5c14\u53ca\u5229\u4e9a-\u963f\u5c14\u53ca\u5229\u4e9a", "\u5384\u74dc\u591a\u5c14-\u5384\u74dc\u591a\u5c14", "\u57c3\u53ca-\u57c3\u53ca", "\u5384\u7acb\u7279\u91cc\u4e9a-\u5384\u7acb\u7279\u91cc\u4e9a", "\u897f\u6492\u54c8\u62c9-\u897f\u6492\u54c8\u62c9", "\u897f\u73ed\u7259-\u897f\u73ed\u7259", "\u7231\u6c99\u5c3c\u4e9a-\u7231\u6c99\u5c3c\u4e9a", "\u57c3\u585e\u4fc4\u6bd4\u4e9a-\u57c3\u585e\u4fc4\u6bd4\u4e9a", "\u82ac\u5170-\u82ac\u5170", "\u6590\u6d4e-\u6590\u6d4e", "\u9a6c\u5c14\u7ef4\u7eb3\u65af\u7fa4\u5c9b-\u9a6c\u5c14\u7ef4\u7eb3\u65af\u7fa4\u5c9b", "\u6cd5\u56fd-\u6cd5\u56fd", "\u6cd5\u7f57\u7fa4\u5c9b-\u6cd5\u7f57\u7fa4\u5c9b", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a-\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a", "\u52a0\u84ec-\u52a0\u84ec", "\u82f1\u56fd\uff08\u72ec\u7acb\u9886\u571f\u516c\u6c11\u3001\u51fa\u56fd\u4e0d\u7528\uff09-\u82f1\u56fd\uff08\u72ec\u7acb\u9886\u571f\u516c\u6c11\u3001\u51fa\u56fd\u4e0d\u7528\uff09", "\u82f1\u56fd\uff08\u6d77\u5916\u56fd\u6c11\uff0c\u51fa\u56fd\u4e0d\u7528\uff09-\u82f1\u56fd\uff08\u6d77\u5916\u56fd\u6c11\uff0c\u51fa\u56fd\u4e0d\u7528\uff09", "\u82f1\u56fd\uff08\u6d77\u5916\u516c\u6c11\uff0c\u51fa\u56fd\u4e0d\u7528\uff09-\u82f1\u56fd\uff08\u6d77\u5916\u516c\u6c11\uff0c\u51fa\u56fd\u4e0d\u7528\uff09", "\u82f1\u56fd\uff08\u4fdd\u62a4\u516c\u6c11\uff0c\u51fa\u56fd\u4e0d\u7528\uff09-\u82f1\u56fd\uff08\u4fdd\u62a4\u516c\u6c11\uff0c\u51fa\u56fd\u4e0d\u7528\uff09", "\u82f1\u56fd-\u82f1\u56fd", "\u82f1\u56fd\uff08\u96b6\u5c5e\uff0c\u51fa\u56fd\u4e0d\u7528\uff09-\u82f1\u56fd\uff08\u96b6\u5c5e\uff0c\u51fa\u56fd\u4e0d\u7528\uff09", "\u683c\u9c81\u5409\u4e9a-\u683c\u9c81\u5409\u4e9a", "\u52a0\u7eb3-\u52a0\u7eb3", "\u76f4\u5e03\u7f57\u9640-\u76f4\u5e03\u7f57\u9640", "\u51e0\u5185\u4e9a-\u51e0\u5185\u4e9a", "\u74dc\u5fb7\u7f57\u666e-\u74dc\u5fb7\u7f57\u666e", "\u5188\u6bd4\u4e9a-\u5188\u6bd4\u4e9a", "\u51e0\u5185\u4e9a\u6bd4\u7ecd-\u51e0\u5185\u4e9a\u6bd4\u7ecd", "\u8d64\u9053\u51e0\u5185\u4e9a-\u8d64\u9053\u51e0\u5185\u4e9a", "\u5e0c\u814a-\u5e0c\u814a", "\u683c\u6797\u7eb3\u8fbe-\u683c\u6797\u7eb3\u8fbe", "\u683c\u9675\u5170-\u683c\u9675\u5170", "\u5371\u5730\u9a6c\u62c9-\u5371\u5730\u9a6c\u62c9", "\u6cd5\u5c5e\u572d\u4e9a\u90a3-\u6cd5\u5c5e\u572d\u4e9a\u90a3", "\u5173\u5c9b-\u5173\u5c9b", "\u572d\u4e9a\u90a3-\u572d\u4e9a\u90a3", "\u9999\u6e2f-\u9999\u6e2f", "\u8d6b\u5fb7\u5c9b\u548c\u9ea6\u514b\u5510\u7eb3\u5c9b-\u8d6b\u5fb7\u5c9b\u548c\u9ea6\u514b\u5510\u7eb3\u5c9b", "\u6d2a\u90fd\u62c9\u65af-\u6d2a\u90fd\u62c9\u65af", "\u514b\u7f57\u5730\u4e9a-\u514b\u7f57\u5730\u4e9a", "\u6d77\u5730-\u6d77\u5730", "\u5308\u7259\u5229-\u5308\u7259\u5229", "\u5370\u5ea6\u5c3c\u897f\u4e9a-\u5370\u5ea6\u5c3c\u897f\u4e9a", "\u5370\u5ea6-\u5370\u5ea6", "\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u571f-\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u571f", "\u7231\u5c14\u5170-\u7231\u5c14\u5170", "\u4f0a\u6717-\u4f0a\u6717", "\u4f0a\u62c9\u514b-\u4f0a\u62c9\u514b", "\u51b0\u5c9b-\u51b0\u5c9b", "\u4ee5\u8272\u5217-\u4ee5\u8272\u5217", "\u610f\u5927\u5229-\u610f\u5927\u5229", "\u7259\u4e70\u52a0-\u7259\u4e70\u52a0", "\u7ea6\u65e6-\u7ea6\u65e6", "\u65e5\u672c-\u65e5\u672c", "\u7ea6\u7ff0\u65af\u987f\u5c9b-\u7ea6\u7ff0\u65af\u987f\u5c9b", "\u54c8\u8428\u514b\u65af\u5766-\u54c8\u8428\u514b\u65af\u5766", "\u80af\u5c3c\u4e9a-\u80af\u5c3c\u4e9a", "\u5409\u5c14\u5409\u65af\u65af\u5766-\u5409\u5c14\u5409\u65af\u65af\u5766", "\u67ec\u57d4\u5be8-\u67ec\u57d4\u5be8", "\u57fa\u91cc\u5df4\u65af-\u57fa\u91cc\u5df4\u65af", "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af-\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af", "\u97e9\u56fd\uff08\u5357\u671d\u9c9c\uff09-\u97e9\u56fd\uff08\u5357\u671d\u9c9c\uff09", "\u79d1\u5a01\u7279-\u79d1\u5a01\u7279", "\u8001\u631d-\u8001\u631d", "\u9ece\u5df4\u5ae9-\u9ece\u5df4\u5ae9", "\u5229\u6bd4\u91cc\u4e9a-\u5229\u6bd4\u91cc\u4e9a", "\u5229\u6bd4\u4e9a-\u5229\u6bd4\u4e9a", "\u5723\u5362\u897f\u4e9a-\u5723\u5362\u897f\u4e9a", "\u5217\u652f\u6566\u571f\u767b-\u5217\u652f\u6566\u571f\u767b", "\u65af\u91cc\u5170\u5361-\u65af\u91cc\u5170\u5361", "\u83b1\u7d22\u6258-\u83b1\u7d22\u6258", "\u7acb\u9676\u5b9b-\u7acb\u9676\u5b9b", "\u5362\u68ee\u5821-\u5362\u68ee\u5821", "\u62c9\u8131\u7ef4\u4e9a-\u62c9\u8131\u7ef4\u4e9a", "\u6fb3\u95e8-\u6fb3\u95e8", "\u6469\u6d1b\u54e5-\u6469\u6d1b\u54e5", "\u6469\u7eb3\u54e5-\u6469\u7eb3\u54e5", "\u6469\u5c14\u591a\u74e6-\u6469\u5c14\u591a\u74e6", "\u9a6c\u8fbe\u52a0\u65af\u52a0-\u9a6c\u8fbe\u52a0\u65af\u52a0", "\u9a6c\u5c14\u4ee3\u592b-\u9a6c\u5c14\u4ee3\u592b", "\u58a8\u897f\u54e5-\u58a8\u897f\u54e5", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b-\u9a6c\u7ecd\u5c14\u7fa4\u5c9b", "\u4e2d\u9014\u5c9b-\u4e2d\u9014\u5c9b", "\u9a6c\u5176\u987f-\u9a6c\u5176\u987f", "\u9a6c\u91cc-\u9a6c\u91cc", "\u9a6c\u8033\u4ed6-\u9a6c\u8033\u4ed6", "\u7f05\u7538-\u7f05\u7538", "\u8499\u53e4-\u8499\u53e4", "\u5317\u9a6c\u91cc\u4e9a\u7eb3-\u5317\u9a6c\u91cc\u4e9a\u7eb3", "\u83ab\u6851\u6bd4\u514b-\u83ab\u6851\u6bd4\u514b", "\u6bdb\u91cc\u5854\u5c3c\u4e9a-\u6bdb\u91cc\u5854\u5c3c\u4e9a", "\u8499\u7279\u585e\u62c9\u7279-\u8499\u7279\u585e\u62c9\u7279", "\u9a6c\u63d0\u5c3c\u514b-\u9a6c\u63d0\u5c3c\u514b", "\u6bdb\u91cc\u6c42\u65af-\u6bdb\u91cc\u6c42\u65af", "\u9a6c\u62c9\u7ef4-\u9a6c\u62c9\u7ef4", "\u9a6c\u6765\u897f\u4e9a-\u9a6c\u6765\u897f\u4e9a", "\u9a6c\u7ea6\u7279-\u9a6c\u7ea6\u7279", "\u7eb3\u7c73\u6bd4\u4e9a-\u7eb3\u7c73\u6bd4\u4e9a", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a-\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a", "\u5c3c\u65e5\u5c14-\u5c3c\u65e5\u5c14", "\u8bfa\u798f\u514b\u5c9b-\u8bfa\u798f\u514b\u5c9b", "\u5c3c\u65e5\u5229\u4e9a-\u5c3c\u65e5\u5229\u4e9a", "\u5c3c\u52a0\u62c9\u74dc-\u5c3c\u52a0\u62c9\u74dc", "\u7ebd\u57c3-\u7ebd\u57c3", "\u8377\u5170-\u8377\u5170", "\u632a\u5a01-\u632a\u5a01", "\u5c3c\u6ce2\u5c14-\u5c3c\u6ce2\u5c14", "\u7459\u9c81-\u7459\u9c81", "\u4e2d\u95f4\u5730\u5e26-\u4e2d\u95f4\u5730\u5e26", "\u65b0\u897f\u5170-\u65b0\u897f\u5170", "\u963f\u66fc-\u963f\u66fc", "\u5df4\u57fa\u65af\u5766-\u5df4\u57fa\u65af\u5766", "\u5df4\u62ff\u9a6c-\u5df4\u62ff\u9a6c", "\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b-\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b", "\u79d8\u9c81-\u79d8\u9c81", "\u83f2\u5f8b\u5bbe-\u83f2\u5f8b\u5bbe", "\u8d1d\u52b3-\u8d1d\u52b3", "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a-\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a", "\u6ce2\u5170-\u6ce2\u5170", "\u6ce2\u591a\u9ece\u5404-\u6ce2\u591a\u9ece\u5404", "\u671d\u9c9c-\u671d\u9c9c", "\u8461\u8404\u7259-\u8461\u8404\u7259", "\u5df4\u62c9\u572d-\u5df4\u62c9\u572d", "\u5df4\u52d2\u65af\u5766-\u5df4\u52d2\u65af\u5766", "\u6cd5\u5c5e\u83e0\u5229\u5c3c\u897f\u4e9a-\u6cd5\u5c5e\u83e0\u5229\u5c3c\u897f\u4e9a", "\u5361\u5854\u5c14-\u5361\u5854\u5c14", "\u7559\u5c3c\u6c6a-\u7559\u5c3c\u6c6a", "\u7f57\u9a6c\u5c3c\u4e9a-\u7f57\u9a6c\u5c3c\u4e9a", "\u4fc4\u7f57\u65af-\u4fc4\u7f57\u65af", "\u5362\u65fa\u8fbe-\u5362\u65fa\u8fbe", "\u6c99\u7279\u963f\u62c9\u4f2f-\u6c99\u7279\u963f\u62c9\u4f2f", "\u82cf\u4e39-\u82cf\u4e39", "\u585e\u5185\u52a0\u5c14-\u585e\u5185\u52a0\u5c14", "\u585e\u5c14\u7ef4\u4e9a-\u585e\u5c14\u7ef4\u4e9a", "\u65b0\u52a0\u5761-\u65b0\u52a0\u5761", "\u5357\u4e54\u6cbb\u4e9a\u5c9b\u548c\u5357\u6851\u5fb7\u97e6\u5947\u5c9b-\u5357\u4e54\u6cbb\u4e9a\u5c9b\u548c\u5357\u6851\u5fb7\u97e6\u5947\u5c9b", "\u5723\u8d6b\u52d2\u62ff-\u5723\u8d6b\u52d2\u62ff", "\u65af\u74e6\u5c14\u5df4\u7fa4\u5c9b-\u65af\u74e6\u5c14\u5df4\u7fa4\u5c9b", "\u6240\u7f57\u95e8\u7fa4\u5c9b-\u6240\u7f57\u95e8\u7fa4\u5c9b", "\u585e\u62c9\u5229\u6602-\u585e\u62c9\u5229\u6602", "\u8428\u5c14\u74e6\u591a-\u8428\u5c14\u74e6\u591a", "\u5723\u9a6c\u529b\u8bfa-\u5723\u9a6c\u529b\u8bfa", "\u7d22\u9a6c\u91cc-\u7d22\u9a6c\u91cc", "\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686-\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686", "\u585e\u73ed-\u585e\u73ed", "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4-\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4", "\u82cf\u91cc\u5357-\u82cf\u91cc\u5357", "\u65af\u6d1b\u4f10\u514b-\u65af\u6d1b\u4f10\u514b", "\u65af\u6d1b\u6587\u5c3c\u4e9a-\u65af\u6d1b\u6587\u5c3c\u4e9a", "\u745e\u5178-\u745e\u5178", "\u65af\u5a01\u58eb\u5170-\u65af\u5a01\u58eb\u5170", "\u9521\u91d1-\u9521\u91d1", "\u585e\u820c\u5c14-\u585e\u820c\u5c14", "\u53d9\u5229\u4e9a-\u53d9\u5229\u4e9a", "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b-\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b", "\u4e4d\u5f97-\u4e4d\u5f97", "\u591a\u54e5-\u591a\u54e5", "\u6cf0\u56fd-\u6cf0\u56fd", "\u5854\u5409\u514b\u65af\u5766-\u5854\u5409\u514b\u65af\u5766", "\u6258\u514b\u52b3-\u6258\u514b\u52b3", "\u571f\u5e93\u66fc\u65af\u5766-\u571f\u5e93\u66fc\u65af\u5766", "\u4e1c\u5e1d\u6c76-\u4e1c\u5e1d\u6c76", "\u6c64\u52a0-\u6c64\u52a0", "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5-\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5", "\u7a81\u5c3c\u65af-\u7a81\u5c3c\u65af", "\u571f\u8033\u5176-\u571f\u8033\u5176", "\u56fe\u74e6\u5362-\u56fe\u74e6\u5362", "\u53f0\u6e7e-\u53f0\u6e7e", "\u5766\u6851\u5c3c\u4e9a-\u5766\u6851\u5c3c\u4e9a", "\u4e4c\u5e72\u8fbe-\u4e4c\u5e72\u8fbe", "\u4e4c\u514b\u5170-\u4e4c\u514b\u5170", "\u7f8e\u5c5e\u592a\u5e73\u6d0b\u5404\u7fa4\u5c9b-\u7f8e\u5c5e\u592a\u5e73\u6d0b\u5404\u7fa4\u5c9b", "\u8054\u5408\u56fd-\u8054\u5408\u56fd", "\u8054\u5408\u56fd-\u8054\u5408\u56fd", "\u8054\u5408\u56fd-\u8054\u5408\u56fd", "\u4e4c\u62c9\u572d-\u4e4c\u62c9\u572d", "\u7f8e\u56fd-\u7f8e\u56fd", "\u4e4c\u5179\u522b\u514b\u65af\u5766-\u4e4c\u5179\u522b\u514b\u65af\u5766", "\u68b5\u8482\u5188-\u68b5\u8482\u5188", "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af-\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af", "\u59d4\u5185\u745e\u62c9-\u59d4\u5185\u745e\u62c9", "\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b-\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b", "\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b-\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b", "\u8d8a\u5357-\u8d8a\u5357", "\u74e6\u52aa\u963f\u56fe-\u74e6\u52aa\u963f\u56fe", "\u5a01\u514b\u5c9b-\u5a01\u514b\u5c9b", "\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3\u7fa4\u5c9b-\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3\u7fa4\u5c9b", "\u897f\u8428\u6469\u4e9a-\u897f\u8428\u6469\u4e9a", "\u65e0\u56fd\u7c4d\uff08\u65e0\u56fd\u7c4d\u4eba\uff09-\u65e0\u56fd\u7c4d\uff08\u65e0\u56fd\u7c4d\u4eba\uff09", "\u65e0\u56fd\u7c4d\uff08\u96be\u6c11\uff09-\u65e0\u56fd\u7c4d\uff08\u96be\u6c11\uff09", "\u65e0\u56fd\u7c4d\uff08\u672a\u58f0\u660e\u56fd\u7c4d\uff09-\u65e0\u56fd\u7c4d\uff08\u672a\u58f0\u660e\u56fd\u7c4d\uff09", "\u4e5f\u95e8-\u4e5f\u95e8", "\u5357\u65af\u62c9\u592b-\u5357\u65af\u62c9\u592b", "\u5357\u975e-\u5357\u975e", "\u624e\u4f0a\u5c14-\u624e\u4f0a\u5c14", "\u8d5e\u6bd4\u4e9a-\u8d5e\u6bd4\u4e9a", "\u6d25\u5df4\u5e03\u97e6-\u6d25\u5df4\u5e03\u97e6", "\u56fd\u7c4d\u4e0d\u8be6-\u56fd\u7c4d\u4e0d\u8be6"};
        String[] handers = new String[]{"\u90e8\u95e8\u540d\u79f0", "\u59d3\u540d", "\u624b\u673a\u53f7\u7801", "\u8eab\u4efd\u8bc1", "\u89d2\u8272\u540d\u79f0", "\u4eba\u5458\u7c7b\u522b", "\u5b66\u5386", "\u56fd\u7c4d", "\u8eab\u9ad8", "\u804c\u4e1a\u8bc1\u4e66", "\u8bc1\u4e66\u53f7", "\u653f\u6cbb\u9762\u8c8c", "\u5a5a\u59fb\u72b6\u6001", "\u8840\u578b", "\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u53f7", "\u5bb6\u5ead\u4f4f\u5740", "\u73b0\u4f4f\u5730\u5740"};
        String[] example = new String[]{"\u8303\u4f8b1", "\u4fdd\u5b89\u4e00\u90e8", "\u5f20\u4e09\t", "15962368569\t", "250216188512021234", "\u5927\u961f\u957f", "\u666e\u901a\u4fdd\u5b89\u5458", "\u521d\u4e2d", "\u4e2d\u56fd", "185", "\u521d\u7ea7\u4fdd\u5b89\u5458", "C0015253", "\u515a\u5458", "\u672a\u5a5a", "A", "C123456", "\u798f\u5efa\u7701\u4e09\u660e\u5e02\u5c24\u6eaa\u53bf\u5927\u7530\u9547\u5c16\u7802\u675125\u53f7", "\u798f\u5efa\u7701\u53a6\u95e8\u5e02\u601d\u660e\u533a\u83b2\u524d\u8def23\u53f7"};
        String[] note = new String[]{"\u586b\u5199\u8bf4\u660e\r\n", " \u4e0b\u62c9\u9009\u62e9\r\n*\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236\r\n \r\n", " \u76f4\u63a5\u586b\u5199\r\n*\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u8bf7\u7559\u610f\u4e0d\u8981\u8f93\u5165\u7a7a\u683c\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u540e\u7eed\u4eba\u5458\u8eab\u4efd\u9a8c\u8bc1\u4e0d\u901a\u8fc7\r\n \r\n", " \u76f4\u63a5\u586b\u5199\r\n*\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u5982\u679c\u4eceWord\u6216\u5176\u4ed6\u6587\u6863\u62f7\u8d1d\u7c98\u8d34\u5230Excel\uff0c\u8bf7\u6ce8\u610f\u683c\u5f0f\u201d\r\n\t \r\n\t", " \u76f4\u63a5\u586b\u5199\r\n*\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u5982\u679c\u4eceWord\u6216\u5176\u4ed6\u6587\u6863\u62f7\u8d1d\u7c98\u8d34\u5230Excel\uff0c\u8bf7\u4f7f\u7528\u53f3\u952e\u9009\u62e9\u6027\u7c98\u8d34\u201c\u6570\u503c\u201d\r\n", " \u4e0b\u62c9\u9009\u62e9\r\n*\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236\r\n", " \u4e0b\u62c9\u9009\u62e9\r\n*\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236\r\n", " \u4e0b\u62c9\u9009\u62e9\r\n\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236\r\n", " \u4e0b\u62c9\u9009\u62e9\r\n\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236\r\n", " \u76f4\u63a5\u586b\u5199\r\n\u975e\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u53ea\u5141\u8bb8\u586b\u5199\u6570\u5b57\r\n", " \u4e0b\u62c9\u9009\u62e9\r\n\u975e\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236 \r\n", " \u76f4\u63a5\u586b\u5199\r\n\u975e\u5fc5\u586b\u5b57\u6bb5 \r\n", " \u4e0b\u62c9\u9009\u62e9\r\n\u975e\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236 \r\n", " \u4e0b\u62c9\u9009\u62e9\r\n\u975e\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236 \r\n", " \u4e0b\u62c9\u9009\u62e9\r\n\u975e\u5fc5\u586b\u5b57\u6bb5\r\n\u6ce8\uff1a\u6309\u8868\u4e2d\u9009\u9879\u4e0b\u62c9\u9009\u62e9\uff0c\u4e0d\u53ef\u624b\u52a8\u586b\u5199\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u5bfc\u5165\u4e0d\u6210\u529f\uff1b\u5982\u9700\u5c06\u67d0\u884c\u5df2\u9009\u62e9\u7684\u4fe1\u606f\u5411\u4e0b\u590d\u5236\uff0c\u8bf7\u7559\u610f\u540c\u65f6\u6309\u4f4fctrl\u952e\u548c\u201c+\u201d\u518d\u5411\u4e0b\u590d\u5236 \r\n", " \u76f4\u63a5\u586b\u5199\r\n\u975e\u5fc5\u586b\u5b57\u6bb5 \r\n", " \u76f4\u63a5\u586b\u5199\r\n\u975e\u5fc5\u586b\u5b57\u6bb5 \r\n", " \u76f4\u63a5\u586b\u5199\r\n\u975e\u5fc5\u586b\u5b57\u6bb5 \r\n"};
        ArrayList<String[]> downData = new ArrayList<String[]>();
        downData.add(orgArr);
        downData.add(roleArr);
        downData.add(personType);
        downData.add(edu);
        downData.add(nationality);
        downData.add(profession_level);
        downData.add(politics);
        downData.add(marriage);
        downData.add(blood);
        CellStyle style1 = ExcelUtil.getNecessaryTitleStyle((HSSFWorkbook)wb);
        CellStyle style2 = ExcelUtil.getCommonTitleStyle((HSSFWorkbook)wb);
        CellStyle style3 = ExcelUtil.getExampleStyle((HSSFWorkbook)wb);
        CellStyle style4 = ExcelUtil.getExample1Style((HSSFWorkbook)wb);
        CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
        Integer[] downRows = new Integer[]{0, 4, 5, 6, 7, 9, 11, 12, 13};
        ExcelUtil.region((int)0, (int)0, (int)0, (int)0, (int)18, (Workbook)wb);
        HSSFRow row0 = sheet1.createRow(0);
        row0.setHeight((short)500);
        ExcelUtil.setValueAt((CellStyle)style4, (int)0, (int)0, (String)"\u586b\u5199\u8303\u4f8b\u8bf4\u660e\uff08\u6ce8\uff1a\u5177\u4f53\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u5728\u53f3\u4fa7\u8868\u683c\u586b\u5199\uff09\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n", (HSSFWorkbook)wb, (HSSFRow)row0);
        HSSFRow row1 = sheet1.createRow(1);
        row1.setHeight((short)500);
        ExcelUtil.region((int)0, (int)1, (int)2, (int)0, (int)0, (Workbook)wb);
        ExcelUtil.setValueAt((CellStyle)style3, (int)1, (int)0, (String)"\u5b57\u6bb5", (HSSFWorkbook)wb, (HSSFRow)row1);
        ExcelUtil.region((int)0, (int)1, (int)1, (int)1, (int)8, (Workbook)wb);
        ExcelUtil.setValueAt((CellStyle)style3, (int)1, (int)1, (String)"\u5fc5\u586b\u9879", (HSSFWorkbook)wb, (HSSFRow)row1);
        ExcelUtil.region((int)0, (int)1, (int)1, (int)9, (int)18, (Workbook)wb);
        ExcelUtil.setValueAt((CellStyle)style3, (int)1, (int)7, (String)"\u975e\u5fc5\u586b", (HSSFWorkbook)wb, (HSSFRow)row1);
        HSSFRow row2 = sheet1.createRow(2);
        row2.setHeight((short)500);
        HSSFRow row3 = sheet1.createRow(3);
        row3.setHeight((short)700);
        HSSFRow row4 = sheet1.createRow(4);
        row4.setHeight((short)3800);
        HSSFRow rowFirst = sheet2.createRow(0);
        for (i = 0; i < handers.length; ++i) {
            HSSFCell cell = rowFirst.createCell(i);
            HSSFCell cell2 = row2.createCell(i + 1);
            sheet2.setColumnWidth(i, 5000);
            sheet2.setDefaultColumnStyle(i, stringStyle);
            sheet1.setColumnWidth(i, 5000);
            sheet1.setDefaultColumnStyle(i, stringStyle);
            if (i <= 7) {
                cell.setCellStyle(style1);
                cell2.setCellStyle(style1);
            } else {
                cell.setCellStyle(style2);
                cell2.setCellStyle(style2);
            }
            cell.setCellValue(handers[i]);
            cell2.setCellValue(handers[i]);
        }
        for (i = 0; i < example.length; ++i) {
            HSSFCell cell3 = row3.createCell(i);
            HSSFCell cell4 = row4.createCell(i);
            sheet1.setColumnWidth(i, 5000);
            sheet1.setDefaultColumnStyle(i, stringStyle);
            cell3.setCellStyle(style3);
            cell4.setCellStyle(style3);
            cell3.setCellValue(example[i]);
            cell4.setCellValue(note[i]);
        }
        String[] arr = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"};
        int index = 0;
        HSSFRow row = null;
        for (int r = 0; r < downRows.length; ++r) {
            String[] dlData = (String[])downData.get(r);
            int rownum = downRows[r];
            String strFormula = "\u53c2\u8003\u6570\u636e!$" + arr[index] + "$1:$" + arr[index] + "$" + dlData.length;
            sheet3.setColumnWidth(r, 5000);
            sheet2.addValidationData((DataValidation)ExcelUtil.setDataValidation((String)strFormula, (int)1, (int)5000, (int)rownum, (int)rownum));
            for (int j = 0; j < dlData.length; ++j) {
                if (index == 0) {
                    row = sheet3.createRow(j);
                    sheet3.setColumnWidth(j, 5000);
                    row.createCell(0).setCellValue(dlData[j]);
                    continue;
                }
                int rowCount = sheet3.getLastRowNum();
                if (j <= rowCount) {
                    sheet3.getRow(j).createCell(index).setCellValue(dlData[j]);
                    continue;
                }
                sheet3.setColumnWidth(j, 5000);
                sheet3.createRow(j).createCell(index).setCellValue(dlData[j]);
            }
            ++index;
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        wb.close();
    }

    public List<ReportData> findAllAreaReport() {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        CompanySearchDto dto = new CompanySearchDto();
        String areacode = user.getPolice().getAreacode();
        dto.setComArea(areacode);
        if (areacode.endsWith("0000")) {
            dto.setAreaCode(areacode.substring(0, 2) + "____");
            dto.setOrgLevel("1");
        } else if (areacode.endsWith("00")) {
            dto.setAreaCode(areacode.substring(0, 4) + "__");
            dto.setOrgLevel("2");
        } else {
            dto.setOrgLevel("3");
        }
        dto.setPath(user.getPolice().getPath());
        dto.setUserid(user.getId());
        return this.securityCompanyDao.findAllAreaReport(dto);
    }

    public Map<String, String[]> findAllScaleReport() {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        CompanySearchDto dto = new CompanySearchDto();
        dto.setPath(user.getPolice().getPath());
        dto.setUserid(user.getId());
        List list = this.securityCompanyDao.findAllScaleReport(dto);
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public Map<String, String[]> findAllTaskLevelReport() {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        CompanySearchDto dto = new CompanySearchDto();
        dto.setPath(user.getPolice().getPath());
        dto.setUserid(user.getId());
        List list = this.securityCompanyDao.findAllTaskLevelReport(dto);
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public List<ReportData> findProfessionLevelReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        return this.securityCompanyDao.findProfessionLevelReport(id);
    }

    public Map<String, String[]> findNativeReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        List list = this.securityCompanyDao.findNativeReport(id);
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public Map<String, String[]> findTaskCatalogReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        List list = this.securityCompanyDao.findTaskCatalogReport(id);
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public List<ReportData> findTaskLevelReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        SecurityCompany company = null;
        CompanySearchDto companySearchDto = new CompanySearchDto();
        if (user.getPlatform().equals(2)) {
            company = this.securityCompanyDao.findByUserid(user.getId());
        }
        if ((user == null || user.getPlatform() == 1) && company == null) {
            companySearchDto.setPath(user.getPolice().getPath());
            companySearchDto.setUserid(user.getId());
            companySearchDto.setCompanyId(id);
        }
        return this.securityCompanyDao.findTaskLevelReportByCompany(companySearchDto);
    }

    public List<ReportData> findSecurityPersonReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        CompanySearchDto dto = new CompanySearchDto();
        if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        dto.setCompanyId(id);
        return this.securityCompanyDao.findSecurityPersonReport(dto);
    }

    public List<ReportData> findSecurityPersonStudyReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            return null;
        }
        return this.securityCompanyDao.findSecurityPersonStudyReport(id);
    }

    public Long getSecurityTotalCount(Long id) {
        User user = this.arsUtil.getCurrentUser();
        return this.securityCompanyDao.getSecurityTotalCount(id);
    }

    public AjaxResult checkCompanyPolicy() {
        AjaxResult result = new AjaxResult();
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 2) {
            result.setSuccessful(false);
            result.setMsg("\u767b\u5f55\u5f02\u5e38");
        } else {
            SecurityCompany company = this.securityCompanyDao.findByUserid(user.getId());
            if (StringUtil.isNotEmpty((String)company.getOrderNo())) {
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
            }
        }
        return result;
    }

    public List<ReportData> getStudyListDesc(Long id) {
        return this.securityCompanyDao.getStudyListDesc(id);
    }

    public Long findNoPowerCount(Long id) {
        return this.securityCompanyDao.findNoPowerCount(id);
    }

    public PersonStudySearchDTO personStudySearch(PersonStudySearchDTO dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        List data = this.securityCompanyDao.findPersonStudyList(dto);
        int rate = 0;
        for (PersonStudyDTO personStudyDTO : data) {
            rate = 0;
            for (PersonStudyDTO personStudy : data) {
                if (personStudyDTO.getPersonid() == personStudy.getPersonid() || personStudyDTO.getStudyprogress() <= personStudy.getStudyprogress()) continue;
                ++rate;
            }
            personStudyDTO.setRate(rate == 0 ? "0" : rate * 100 / data.size() + "");
        }
        Long count = this.securityCompanyDao.searchPersonStudyCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public void resetPwd(Long companyid) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = this.securityCompanyDao.findById(companyid);
        User user = company.getUser();
        user.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
        user.setUpdateTime(new Date());
        user.setUpdateBy(currentUser.getUsername());
        this.userDaoAop.updatePassword(user);
        company.setUpdateTime(new Date());
        this.securityCompanyDaoAop.update(company);
    }

    public void deleteCompany(Long companyid) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = this.securityCompanyDao.findById(companyid);
        User user = company.getUser();
        company.setUpdateTime(new Date());
        company.setUpdateBy(currentUser.getUsername());
        this.securityCompanyDaoAop.delete(company);
        user.setUpdateTime(new Date());
        user.setUpdateBy(currentUser.getUsername());
        this.userDaoAop.delete(user);
    }

    public void revokeCompany(Long companyid) {
        User currentUser = this.arsUtil.getCurrentUser();
        ComStateChangeLog changeLog = new ComStateChangeLog();
        SecurityCompany company = this.securityCompanyDao.findById(companyid);
        changeLog.setComId(company.getId());
        changeLog.setComName(company.getName());
        changeLog.setOldState(company.getCompanyState());
        company.setUpdateTime(new Date());
        company.setUpdateBy(currentUser.getUsername());
        company.setCompanyState(Constants.COMPANY_STATE_4);
        this.securityCompanyDaoAop.revoke(company);
        changeLog.setUserId(currentUser.getId());
        changeLog.setNewState(Constants.COMPANY_STATE_4);
        changeLog.setUpdateflag(Boolean.valueOf(true));
        changeLog.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        changeLog.setActive(Boolean.valueOf(true));
        changeLog.setCreateTime(new Date());
        changeLog.setUpdateTime(new Date());
        changeLog.setUpdateBy(currentUser.getRealname());
        this.comStateChangeLogDao.save(changeLog);
    }

    public String getNewUsername(SecurityCompany company) {
        String username = "";
        if (StringUtil.isNotEmpty((String)company.getUsername())) {
            username = company.getUsername();
        } else if (null != company && StringUtil.isNotEmpty((String)company.getAreaCode())) {
            String regexp;
            Long serialNum;
            if (StringUtil.isEmpty((String)company.getInstitutionType())) {
                company.setInstitutionType("0102");
            }
            username = null == (serialNum = this.userDao.findByUsernameRegexp(regexp = company.getAreaCode().substring(0, 4) + company.getInstitutionType() + "01")) || serialNum == 0L ? regexp + "0001" : regexp + String.format("%4s", serialNum + 1L).replaceAll(" ", "0");
        }
        return username;
    }

    public void updateCompany(SecurityCompany company) {
        String username = this.getNewUsername(company);
        if (company.getId() == null) {
            company.setInit(Boolean.valueOf(false));
            company.setCompanyState(Constants.COMPANY_STATE_0);
            SecurityCompany dbCompany = this.securityCompanyDao.findByName(company.getName());
            if (dbCompany != null) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            User existUser = this.userDao.findByUsername(username, String.valueOf(2));
            if (existUser != null) {
                throw new ArsException("\u7528\u6237\u540d\u5df2\u5b58\u5728!");
            }
            User user = company.getUser();
            user.setUsername(username);
            user.setPhone(company.getUser().getPhone());
            user.setRealname(company.getName());
            user.setPhoto(company.getUser().getPhoto());
            user.setPlatform(Integer.valueOf(2));
            User dbUser = this.userDao.findById(user.getId());
            if (dbUser == null) {
                if (!StringUtil.isNotEmpty((String)user.getPassword())) {
                    user.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
                }
                user.setNativeCode(this.arsUtil.getCurrentNatvie());
                user.setInit(Boolean.valueOf(false));
                user.setActive(Boolean.valueOf(true));
                user.setCreateTime(new Date());
                user.setUpdateTime(user.getCreateTime());
                user.setUpdateflag(Boolean.valueOf(true));
                if (this.arsUtil.getCurrentUser() != null) {
                    user.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
                }
                user.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                this.userDao.save(user);
                company.setUser(user);
            } else {
                dbUser.setUpdateTime(new Date());
                dbUser.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
                if (dbUser != null) {
                    if (user.getActive() != null && user.getActive().booleanValue()) {
                        dbUser.setActive(Boolean.valueOf(true));
                    }
                    if (user.getInit() != null && user.getInit().booleanValue()) {
                        dbUser.setInit(Boolean.valueOf(true));
                    }
                    if (!StringUtils.isEmpty((Object)user.getRealname())) {
                        dbUser.setRealname(user.getRealname());
                    }
                    if (!StringUtils.isEmpty((Object)user.getPhone())) {
                        dbUser.setPhone(user.getPhone());
                    }
                    if (!StringUtils.isEmpty((Object)user.getPhoto())) {
                        dbUser.setPhoto(user.getPhoto());
                    }
                    dbUser.setUpdateflag(Boolean.valueOf(true));
                    this.userDaoAop.update(dbUser);
                    company.setUser(dbUser);
                }
            }
        } else {
            SecurityCompany dbCompany = this.securityCompanyDao.findByName(company.getName());
            if (dbCompany != null && dbCompany.getId().intValue() != company.getId().intValue()) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            User existUser = this.userDao.findByUsername(username, String.valueOf(2));
            if (existUser != null && dbCompany != null && dbCompany.getUser().getId().intValue() != existUser.getId().intValue()) {
                throw new ArsException("\u3010" + username + "\u3011\u767b\u9646\u7528\u6237\u540d\u5df2\u5b58\u5728!");
            }
            if (dbCompany == null) {
                dbCompany = this.securityCompanyDao.findById(company.getId());
            }
            dbCompany.getUser().setPhoto(company.getUser().getPhoto());
            dbCompany.getUser().setPhone(company.getUser().getPhone());
            dbCompany.getUser().setRealname(company.getName());
            dbCompany.getUser().setUsername(company.getUsername());
            dbCompany.getUser().setUpdateflag(Boolean.valueOf(true));
            this.userService.saveOrUpdateCompanyUser(dbCompany.getUser(), String.valueOf(2));
            company.setUser(dbCompany.getUser());
            if (dbCompany.getAreaCode() != null && !dbCompany.getAreaCode().equalsIgnoreCase(company.getAreaCode())) {
                this.personDao.updateAreaCodeByCompany(company);
            }
        }
        this.saveOrUpdate(company);
    }

    public void updateCompanyAccout(SecurityCompany company) {
        String username = this.getNewUsername(company);
        User user = company.getUser();
        user.setUsername(username);
        user.setPhone(company.getUser().getPhone() == null ? "" : company.getUser().getPhone());
        user.setRealname(company.getName());
        user.setPhoto(company.getUser().getPhoto());
        user.setPlatform(Integer.valueOf(2));
        if (StringUtils.isEmpty((Object)user.getPhoto()) && user.getPlatform() == 1) {
            user.setPhoto("assets/images/defaultHead/police.png");
        }
        if (user.getId() == null) {
            if (!StringUtil.isNotEmpty((String)user.getPassword())) {
                user.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
            }
            user.setNativeCode(this.arsUtil.getCurrentNatvie());
            user.setInit(Boolean.valueOf(false));
            user.setActive(Boolean.valueOf(true));
            user.setCreateTime(new Date());
            user.setUpdateTime(user.getCreateTime());
            if (this.arsUtil.getCurrentUser() != null) {
                user.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            }
            this.userDao.save(user);
            company.setUser(user);
        } else {
            User dbUser = this.userDao.findById(user.getId());
            dbUser.setUpdateTime(new Date());
            dbUser.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            if (dbUser != null) {
                if (user.getActive() != null && user.getActive().booleanValue()) {
                    dbUser.setActive(Boolean.valueOf(true));
                }
                if (user.getInit() != null && user.getInit().booleanValue()) {
                    dbUser.setInit(Boolean.valueOf(true));
                }
                if (!StringUtils.isEmpty((Object)user.getRealname())) {
                    dbUser.setRealname(user.getRealname());
                }
                if (!StringUtils.isEmpty((Object)user.getPhone())) {
                    dbUser.setPhone(user.getPhone());
                }
                if (!StringUtils.isEmpty((Object)user.getPhoto())) {
                    dbUser.setPhoto(user.getPhoto());
                }
                this.userDaoAop.update(dbUser);
                company.setUser(dbUser);
            }
        }
        new Thread(() -> {
            UserVo u = new UserVo();
            u.setOid(user.getId().toString());
            u.setcName(company.getName());
            u.setOwnedIndustry("20");
            u.setNatureManagement("3");
            if (company.getSecurityAmount() != null) {
                u.setcNum(company.getSecurityAmount().toString());
            } else {
                u.setcNum("0");
            }
            u.setBusinessAddress(company.getLocation());
            u.setBusinessAddressImg(company.getBusinessLicense());
            u.setIdType("02");
            u.setIdCard(company.getSocialCode());
            u.setTelephone(company.getCentralOfficeTel());
            u.setTerminalType("1");
            u.setCompanyType("3");
            u.setRoleName("COMMON-ONE-HEAD");
            HashMap<String, Object> companyMap = new HashMap<String, Object>();
            companyMap.put("companyVo", u);
            companyMap.put("token", Sha1Util.entryptPassword((String)("ARS" + company.getUser().getId())));
            String companyUrl = ThirdPartyURL.BAILIANBAO + "/api/user/saveCompany";
            String companyData = messageUtils.packageMap(companyMap, (String)"ARS");
            try {
                messageUtils.doPost2((String)companyUrl, (String)companyData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public CompanySearchDto searchForManager(CompanySearchDto dto) {
        String areacode;
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        if (user == null || user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        if (StringUtil.isNotEmpty((String)(areacode = dto.getAreaCode()))) {
            if (areacode.endsWith("0000")) {
                dto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                dto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                dto.setAreaCode(areacode);
            }
        }
        CompanySearchDto resultDto = new CompanySearchDto();
        List list = this.securityCompanyDao.searchForManager(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.securityCompanyDao.searchForManagerCount(dto));
        return resultDto;
    }

    public PageResult searchForManagerList_table(Map<Object, Object> p) {
        String areacode;
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser == null || currentUser.getPlatform() != 1) {
            return null;
        }
        if (currentUser == null || currentUser.getPlatform() == 1) {
            p.put("path", currentUser.getPolice().getPath());
            p.put("userid", currentUser.getId());
        }
        if (p.get("areaCode") != null && StringUtil.isNotEmpty((String)(areacode = p.get("areaCode").toString()))) {
            if (areacode.endsWith("0000")) {
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("district", areacode.substring(0, 4) + "__");
            } else {
                p.put("district", areacode);
            }
        }
        return new PageResult(this.securityCompanyDao.countSearchForManagerList_table(p), (Object)this.securityCompanyDao.searchForManagerList_table(p));
    }

    public void exportCompanys(List<SecurityCompany> companys, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u4fdd\u5b89\u516c\u53f8\u4fe1\u606f");
            String[] handers = new String[]{"\u516c\u53f8\u540d\u79f0", "\u8425\u4e1a\u6267\u7167\u53f7", "\u6cd5\u4eba", "\u6cd5\u4eba\u624b\u673a\u53f7", "\u6240\u5c5e\u7701\u5e02\u533a", "\u516c\u53f8\u5730\u5740", "\u516c\u53f8\u7c7b\u578b", "\u6ce8\u518c\u8d44\u91d1"};
            HSSFRow rowFirst = sheet1.createRow(0);
            CellStyle style = ExcelUtil.getCommonTitleStyle((HSSFWorkbook)wb);
            for (int i = 0; i < handers.length; ++i) {
                HSSFCell cell = rowFirst.createCell(i);
                sheet1.setColumnWidth(i, 5000);
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]);
            }
            int index = 1;
            HSSFRow row = null;
            for (SecurityCompany company : companys) {
                row = sheet1.createRow(index++);
                HSSFCell nameCell = row.createCell(0);
                nameCell.setCellStyle(style);
                nameCell.setCellValue(company.getName());
                HSSFCell socialCodeCell = row.createCell(1);
                socialCodeCell.setCellStyle(style);
                socialCodeCell.setCellValue(company.getSocialCode());
                HSSFCell legalPersonCell = row.createCell(2);
                legalPersonCell.setCellStyle(style);
                legalPersonCell.setCellValue(company.getLegalPerson());
                HSSFCell phoneCell = row.createCell(3);
                phoneCell.setCellStyle(style);
                phoneCell.setCellValue(company.getUser().getPhone());
                HSSFCell addressCell = row.createCell(4);
                addressCell.setCellStyle(style);
                addressCell.setCellValue(company.getProvince() + company.getCity() + company.getArea());
                HSSFCell locationCell = row.createCell(5);
                locationCell.setCellStyle(style);
                locationCell.setCellValue(company.getLocation());
                HSSFCell companyTypeCell = row.createCell(6);
                companyTypeCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)company.getCompanyType())) {
                    companyTypeCell.setCellValue(company.getCompanyType().equals("1") ? "\u5408\u4f5c\u4f01\u4e1a" : "\u6c11\u8425\u4f01\u4e1a");
                }
                HSSFCell registeredMoneyCell = row.createCell(7);
                registeredMoneyCell.setCellStyle(style);
                if (StringUtils.isEmpty((Object)company.getRegisteredMoney())) continue;
                registeredMoneyCell.setCellValue(company.getRegisteredMoney() + "\u4e07\u5143");
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportCompanysData(List<SecurityCompany> companys, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u4fdd\u5b89\u516c\u53f8\u4fe1\u606f");
            String[] handers = new String[]{"id", "native_code", "user_id", "update_time", "update_by", "active", "name", "legal_person", "social_code", "central_office_name", "central_office_legal_person", "central_office_tel", "tel", "security_amount", "task_amount", "province", "city", "area", "areacode", "location", "insurance_number", "emergency_agreement", "business_license", "public_security_license", "init", "longitude", "latitude", "orderNo", "business_license_number", "principal", "principal_phone", "principal_id", "registered_money", "fixed_assets", "turnover_year", "annual_profits", "public_security_license_number", "national", "economic_type", "company_type", "human_defense_level", "risk_assessment_level", "security_association", "economic_type_legal_person", "is_subsidiary", "armed_escort_level", "security_technology_level", "rawid", "inrawid"};
            HSSFRow rowFirst = sheet1.createRow(0);
            CellStyle style = ExcelUtil.getCommonTitleStyle((HSSFWorkbook)wb);
            for (int i = 0; i < handers.length; ++i) {
                HSSFCell cell = rowFirst.createCell(i);
                sheet1.setColumnWidth(i, 5000);
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]);
            }
            int index = 1;
            HSSFRow row = null;
            for (SecurityCompany company : companys) {
                row = sheet1.createRow(index++);
                HSSFCell idCell = row.createCell(0);
                idCell.setCellStyle(style);
                idCell.setCellValue((double)company.getId().longValue());
                HSSFCell native_codeCell = row.createCell(1);
                native_codeCell.setCellStyle(style);
                if (company.getNativeCode() != null) {
                    native_codeCell.setCellValue((double)company.getNativeCode().longValue());
                }
                HSSFCell user_idCell = row.createCell(2);
                user_idCell.setCellStyle(style);
                if (company.getUser().getId() != null) {
                    user_idCell.setCellValue((double)company.getUser().getId().longValue());
                }
                HSSFCell update_timeCell = row.createCell(3);
                update_timeCell.setCellStyle(style);
                if (company.getUpdateTime() != null) {
                    update_timeCell.setCellValue(DateUtil.convertDateToString((Date)company.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                HSSFCell update_byCell = row.createCell(4);
                update_byCell.setCellStyle(style);
                if (company.getUpdateBy() != null) {
                    update_byCell.setCellValue(company.getUpdateBy());
                }
                HSSFCell activeCell = row.createCell(5);
                activeCell.setCellStyle(style);
                if (company.getActive() != null) {
                    activeCell.setCellValue(company.getActive().booleanValue());
                }
                HSSFCell nameCell = row.createCell(6);
                nameCell.setCellStyle(style);
                if (company.getName() != null) {
                    nameCell.setCellValue(company.getName());
                }
                HSSFCell legal_personCell = row.createCell(7);
                legal_personCell.setCellStyle(style);
                if (company.getLegalPerson() != null) {
                    legal_personCell.setCellValue(company.getLegalPerson());
                }
                HSSFCell social_codeCell = row.createCell(8);
                social_codeCell.setCellStyle(style);
                if (company.getSocialCode() != null) {
                    social_codeCell.setCellValue(company.getSocialCode());
                }
                HSSFCell central_office_nameCell = row.createCell(9);
                central_office_nameCell.setCellStyle(style);
                if (company.getCentralOfficeName() != null) {
                    central_office_nameCell.setCellValue(company.getCentralOfficeName());
                }
                HSSFCell central_office_legal_personCell = row.createCell(10);
                central_office_legal_personCell.setCellStyle(style);
                if (company.getCentralOfficeLegalPerson() != null) {
                    central_office_legal_personCell.setCellValue(company.getCentralOfficeLegalPerson());
                }
                HSSFCell central_office_telCell = row.createCell(11);
                central_office_telCell.setCellStyle(style);
                if (company.getCentralOfficeTel() != null) {
                    central_office_telCell.setCellValue(company.getCentralOfficeTel());
                }
                HSSFCell telCell = row.createCell(12);
                telCell.setCellStyle(style);
                if (company.getTel() != null) {
                    telCell.setCellValue(company.getTel());
                }
                HSSFCell security_amountCell = row.createCell(13);
                security_amountCell.setCellStyle(style);
                if (company.getSecurityAmount() != null) {
                    security_amountCell.setCellValue((double)company.getSecurityAmount().intValue());
                }
                HSSFCell task_amountCell = row.createCell(14);
                task_amountCell.setCellStyle(style);
                if (company.getTaskAmount() != null) {
                    task_amountCell.setCellValue((double)company.getTaskAmount().intValue());
                }
                HSSFCell provinceCell = row.createCell(15);
                provinceCell.setCellStyle(style);
                if (company.getProvince() != null) {
                    provinceCell.setCellValue(company.getProvince());
                }
                HSSFCell cityCell = row.createCell(16);
                cityCell.setCellStyle(style);
                if (company.getCity() != null) {
                    cityCell.setCellValue(company.getCity());
                }
                HSSFCell areaCell = row.createCell(17);
                areaCell.setCellStyle(style);
                if (company.getArea() != null) {
                    areaCell.setCellValue(company.getArea());
                }
                HSSFCell areacodeCell = row.createCell(18);
                areacodeCell.setCellStyle(style);
                if (company.getAreaCode() != null) {
                    areacodeCell.setCellValue(company.getAreaCode());
                }
                HSSFCell locationCell = row.createCell(19);
                locationCell.setCellStyle(style);
                if (company.getLocation() != null) {
                    locationCell.setCellValue(company.getLocation());
                }
                HSSFCell insurance_numberCell = row.createCell(20);
                insurance_numberCell.setCellStyle(style);
                if (company.getInsuranceNumber() != null) {
                    insurance_numberCell.setCellValue(company.getInsuranceNumber());
                }
                HSSFCell emergency_agreementCell = row.createCell(21);
                emergency_agreementCell.setCellStyle(style);
                if (company.getEmergencyAgreement() != null) {
                    emergency_agreementCell.setCellValue(company.getEmergencyAgreement().booleanValue());
                }
                HSSFCell business_licenseCell = row.createCell(22);
                business_licenseCell.setCellStyle(style);
                if (company.getBusinessLicense() != null) {
                    business_licenseCell.setCellValue(company.getBusinessLicense());
                }
                HSSFCell public_security_licenseCell = row.createCell(23);
                public_security_licenseCell.setCellStyle(style);
                if (company.getPublicSecurityLicense() != null) {
                    public_security_licenseCell.setCellValue(company.getPublicSecurityLicense());
                }
                HSSFCell initCell = row.createCell(24);
                initCell.setCellStyle(style);
                if (company.getInit() != null) {
                    initCell.setCellValue(company.getInit().booleanValue());
                }
                HSSFCell longitudeCell = row.createCell(25);
                longitudeCell.setCellStyle(style);
                if (company.getLongitude() != null) {
                    longitudeCell.setCellValue(company.getLongitude());
                }
                HSSFCell latitudeCell = row.createCell(26);
                latitudeCell.setCellStyle(style);
                if (company.getLatitude() != null) {
                    latitudeCell.setCellValue(company.getLatitude());
                }
                HSSFCell orderNoCell = row.createCell(27);
                orderNoCell.setCellStyle(style);
                if (company.getOrderNo() != null) {
                    orderNoCell.setCellValue(company.getOrderNo());
                }
                HSSFCell business_license_numberCell = row.createCell(28);
                business_license_numberCell.setCellStyle(style);
                if (company.getBusinessLicensNnumber() != null) {
                    business_license_numberCell.setCellValue(company.getBusinessLicensNnumber());
                }
                HSSFCell principalCell = row.createCell(29);
                principalCell.setCellStyle(style);
                if (company.getPrincipal() != null) {
                    principalCell.setCellValue(company.getPrincipal());
                }
                HSSFCell principal_phoneCell = row.createCell(30);
                principal_phoneCell.setCellStyle(style);
                if (company.getPrincipalPhone() != null) {
                    principal_phoneCell.setCellValue(company.getPrincipalPhone());
                }
                HSSFCell principal_idCell = row.createCell(31);
                principal_idCell.setCellStyle(style);
                if (company.getPrincipalId() != null) {
                    principal_idCell.setCellValue(company.getPrincipalId());
                }
                HSSFCell registered_moneyCell = row.createCell(32);
                registered_moneyCell.setCellStyle(style);
                if (company.getRegisteredMoney() != null) {
                    registered_moneyCell.setCellValue(company.getRegisteredMoney().doubleValue());
                }
                HSSFCell fixed_assetsCell = row.createCell(33);
                fixed_assetsCell.setCellStyle(style);
                if (company.getFixedAssets() != null) {
                    fixed_assetsCell.setCellValue(company.getFixedAssets().doubleValue());
                }
                HSSFCell turnover_yearCell = row.createCell(34);
                turnover_yearCell.setCellStyle(style);
                if (company.getTurnoverYear() != null) {
                    turnover_yearCell.setCellValue(company.getTurnoverYear().doubleValue());
                }
                HSSFCell annual_profitsCell = row.createCell(35);
                annual_profitsCell.setCellStyle(style);
                if (company.getAnnualProfits() != null) {
                    annual_profitsCell.setCellValue(company.getAnnualProfits().doubleValue());
                }
                HSSFCell public_security_license_numberCell = row.createCell(36);
                public_security_license_numberCell.setCellStyle(style);
                if (company.getPublicSecurityLicenseNumber() != null) {
                    public_security_license_numberCell.setCellValue(company.getPublicSecurityLicenseNumber());
                }
                HSSFCell nationalCell = row.createCell(37);
                nationalCell.setCellStyle(style);
                if (company.getNational() != null) {
                    nationalCell.setCellValue(company.getNational());
                }
                HSSFCell economic_typeCell = row.createCell(38);
                economic_typeCell.setCellStyle(style);
                if (company.getPrincipal() != null) {
                    principalCell.setCellValue(company.getPrincipal());
                }
                HSSFCell company_typeCell = row.createCell(39);
                company_typeCell.setCellStyle(style);
                if (company.getCompanyType() != null) {
                    company_typeCell.setCellValue(company.getCompanyType());
                }
                HSSFCell human_defense_levelCell = row.createCell(40);
                human_defense_levelCell.setCellStyle(style);
                if (company.getHumanDefenseLevel() != null) {
                    human_defense_levelCell.setCellValue(company.getHumanDefenseLevel());
                }
                HSSFCell risk_assessment_levelCell = row.createCell(41);
                risk_assessment_levelCell.setCellStyle(style);
                if (company.getRiskAssessmentLevel() != null) {
                    risk_assessment_levelCell.setCellValue(company.getRiskAssessmentLevel());
                }
                HSSFCell security_associationCell = row.createCell(42);
                security_associationCell.setCellStyle(style);
                if (company.getSecurityAssociation() != null) {
                    security_associationCell.setCellValue(company.getSecurityAssociation());
                }
                HSSFCell economic_type_legal_personCell = row.createCell(43);
                economic_type_legal_personCell.setCellStyle(style);
                if (company.getEconomicTypeLegalPerson() != null) {
                    economic_type_legal_personCell.setCellValue(company.getEconomicTypeLegalPerson());
                }
                HSSFCell is_subsidiaryCell = row.createCell(44);
                is_subsidiaryCell.setCellStyle(style);
                if (company.getIsSubsidiary() != null) {
                    is_subsidiaryCell.setCellValue(company.getIsSubsidiary());
                }
                HSSFCell armed_escort_levelCell = row.createCell(45);
                armed_escort_levelCell.setCellStyle(style);
                if (company.getArmedEscortLevel() != null) {
                    armed_escort_levelCell.setCellValue(company.getArmedEscortLevel());
                }
                HSSFCell security_technology_levelCell = row.createCell(46);
                security_technology_levelCell.setCellStyle(style);
                if (company.getSecurityTechnologyLevel() != null) {
                    security_technology_levelCell.setCellValue(company.getSecurityTechnologyLevel());
                }
                HSSFCell rawidCell = row.createCell(47);
                rawidCell.setCellStyle(style);
                if (company.getRawid() != null) {
                    rawidCell.setCellValue((double)company.getRawid().longValue());
                }
                HSSFCell inrawidCell = row.createCell(48);
                inrawidCell.setCellStyle(style);
                if (company.getInrawid() == null) continue;
                inrawidCell.setCellValue((double)company.getInrawid().longValue());
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildCompanyTemplate(File file) throws Exception {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser != null) {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u4fdd\u5b89\u516c\u53f8\u4fe1\u606f");
            HSSFSheet sheet2 = wb.createSheet("\u53c2\u8003\u6570\u636e");
            wb.setSheetHidden(1, true);
            SysareaSearchDTO searchDto = new SysareaSearchDTO();
            searchDto.setPaging(false);
            List nativeList = this.sysareaService.searchForCompany(searchDto);
            ArrayList<TreeView> trees = new ArrayList<TreeView>();
            for (TreeView treeView : nativeList) {
                int level = 0;
                this.getNativeChildren(trees, treeView, level);
            }
            String[] nativeArr = new String[trees.size()];
            for (int i = 0; i < trees.size(); ++i) {
                nativeArr[i] = ((TreeView)trees.get(i)).getText() + "-" + ((TreeView)trees.get(i)).getCode();
            }
            String[] handers = new String[]{"\u516c\u53f8\u540d\u79f0", "\u8425\u4e1a\u6267\u7167\u53f7\u7801", "\u6cd5\u4eba\u59d3\u540d", "\u6cd5\u4eba\u624b\u673a\u53f7", "\u6240\u5c5e\u533a\u57df\uff08\u7701\u5e02\u533a\uff09", "\u516c\u53f8\u5730\u5740", "\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u53f7", "\u6ce8\u518c\u8d44\u91d1\uff08\u4e07\u5143\uff09"};
            ArrayList<String[]> downData = new ArrayList<String[]>();
            downData.add(nativeArr);
            Integer[] downRows = new Integer[]{4};
            HSSFRow rowFirst = sheet1.createRow(0);
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle((HSSFWorkbook)wb);
            CellStyle style2 = ExcelUtil.getCommonTitleStyle((HSSFWorkbook)wb);
            CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            for (int i = 0; i < handers.length; ++i) {
                HSSFCell cell = rowFirst.createCell(i);
                sheet1.setColumnWidth(i, 5000);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                if (i <= 4) {
                    cell.setCellStyle(style1);
                } else {
                    cell.setCellStyle(style2);
                }
                cell.setCellValue(handers[i]);
            }
            String[] arr = new String[]{"A", "B", "C", "D", "E", "F", "G"};
            int index = 0;
            HSSFRow row = null;
            for (int r = 0; r < downRows.length; ++r) {
                String[] dlData = (String[])downData.get(r);
                int rownum = downRows[r];
                String strFormula = "\u53c2\u8003\u6570\u636e!$" + arr[index] + "$1:$" + arr[index] + "$" + dlData.length;
                sheet2.setColumnWidth(r, 5000);
                sheet1.addValidationData((DataValidation)ExcelUtil.setDataValidation((String)strFormula, (int)1, (int)5000, (int)rownum, (int)rownum));
                for (int j = 0; j < dlData.length; ++j) {
                    if (index == 0) {
                        row = sheet2.createRow(j);
                        sheet2.setColumnWidth(j, 5000);
                        row.createCell(0).setCellValue(dlData[j]);
                        continue;
                    }
                    int rowCount = sheet2.getLastRowNum();
                    if (j <= rowCount) {
                        sheet2.getRow(j).createCell(index).setCellValue(dlData[j]);
                        continue;
                    }
                    sheet2.setColumnWidth(j, 5000);
                    sheet2.createRow(j).createCell(index).setCellValue(dlData[j]);
                }
                ++index;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
    }

    public Map<String, Object> importCompany(File excel) throws Exception {
        ArrayList saveList;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        User loginUser = this.arsUtil.getCurrentUser();
        if (loginUser != null && loginUser.getPlatform() == 1) {
            saveList = new ArrayList();
            ArrayList<Map<String, String>> faildList = new ArrayList<Map<String, String>>();
            FileInputStream inStream = new FileInputStream(excel);
            Workbook workBook = WorkbookFactory.create((InputStream)inStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 1;
            while (flag) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    try {
                        Object treeView2;
                        String companyname = ExcelUtil.getCellValue((Cell)row.getCell(0));
                        data.put("companyname", companyname);
                        Cell cellsocialCode = row.getCell(1);
                        cellsocialCode.setCellType(1);
                        String socialCode = ExcelUtil.getCellValue((Cell)cellsocialCode);
                        data.put("socialCode", socialCode);
                        String legalPerson = ExcelUtil.getCellValue((Cell)row.getCell(2));
                        data.put("legalPerson", legalPerson);
                        Cell cellphone = row.getCell(3);
                        cellphone.setCellType(1);
                        String phone = ExcelUtil.getCellValue((Cell)cellphone);
                        data.put("phone", phone);
                        String area = ExcelUtil.getCellValue((Cell)row.getCell(4));
                        data.put("area", area);
                        area = area.substring(area.lastIndexOf("-") + 1);
                        String location = ExcelUtil.getCellValue((Cell)row.getCell(5));
                        data.put("location", location);
                        Cell cellpublicSecurityLicenseNumber = row.getCell(6);
                        String publicSecurityLicenseNumber = "";
                        if (cellpublicSecurityLicenseNumber != null) {
                            cellpublicSecurityLicenseNumber.setCellType(1);
                            publicSecurityLicenseNumber = ExcelUtil.getCellValue((Cell)cellpublicSecurityLicenseNumber);
                            data.put("publicSecurityLicenseNumber", publicSecurityLicenseNumber);
                        }
                        Cell cellregisteredMoney = row.getCell(7);
                        String registeredMoney = "";
                        if (cellregisteredMoney != null) {
                            cellregisteredMoney.setCellType(1);
                            registeredMoney = ExcelUtil.getCellValue((Cell)cellregisteredMoney);
                            data.put("registeredMoney", registeredMoney);
                        }
                        SysareaSearchDTO searchDto = new SysareaSearchDTO();
                        searchDto.setPaging(false);
                        List nativeList = this.sysareaService.searchForCompany(searchDto);
                        ArrayList<TreeView> trees = new ArrayList<TreeView>();
                        for (Object treeView2 : nativeList) {
                            int level = 0;
                            this.getNativeChildren(trees, (TreeView)treeView2, level);
                        }
                        boolean codeflag = false;
                        treeView2 = trees.iterator();
                        while (treeView2.hasNext()) {
                            TreeView treeView3 = (TreeView)treeView2.next();
                            if (!treeView3.getCode().equals(area)) continue;
                            codeflag = true;
                            break;
                        }
                        if (!codeflag) {
                            throw new ArsException("\u6240\u5c5e\u533a\u57df\u8d85\u51fa\u8303\u56f4");
                        }
                        User user = new User();
                        user.setPhone(phone);
                        user.setRealname(companyname);
                        user.setUsername(socialCode);
                        user.setPlatform(Integer.valueOf(2));
                        user.setInit(Boolean.valueOf(false));
                        SecurityCompany company = new SecurityCompany();
                        company.setUser(user);
                        company.setName(companyname);
                        company.setSocialCode(socialCode);
                        company.setLegalPerson(legalPerson);
                        company.setAreaCode(area);
                        if (StringUtil.isNotEmpty((String)location)) {
                            company.setLocation(location);
                        }
                        if (StringUtil.isNotEmpty((String)publicSecurityLicenseNumber)) {
                            company.setPublicSecurityLicenseNumber(publicSecurityLicenseNumber);
                        }
                        if (StringUtil.isNotEmpty((String)registeredMoney)) {
                            company.setRegisteredMoney(new BigDecimal(registeredMoney));
                        }
                        logger.info("update... " + company);
                        this.updateCompany(company);
                    }
                    catch (Exception e) {
                        if (e instanceof ArsException) {
                            data.put("errorMsg", e.getMessage());
                        } else {
                            data.put("errorMsg", "\u6570\u636e\u95ee\u9898");
                        }
                        faildList.add(data);
                        logger.error("\u6279\u91cf\u5f55\u5165\u9519\u8bef\uff1a" + (String)data.get("socialCode"), (Throwable)e);
                    }
                } else {
                    flag = false;
                }
                ++i;
            }
            if (faildList.size() > 0) {
                resultMap.put("faildFilePath", this.buildFaildList(faildList));
            }
        } else {
            throw new RuntimeException("\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u9519\u8bef, user:" + loginUser);
        }
        resultMap.put("successIds", saveList);
        return resultMap;
    }

    public Map<String, Object> importCompanyData(File excel) throws Exception {
        ArrayList saveList;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        User loginUser = this.arsUtil.getCurrentUser();
        if (loginUser != null && loginUser.getPlatform() == 1) {
            saveList = new ArrayList();
            ArrayList<Map<String, String>> faildList = new ArrayList<Map<String, String>>();
            FileInputStream inStream = new FileInputStream(excel);
            Workbook workBook = WorkbookFactory.create((InputStream)inStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 1;
            while (flag) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    try {
                        String id = ExcelUtil.getCellValue((Cell)row.getCell(0));
                        data.put("id", id);
                        String native_code = ExcelUtil.getCellValue((Cell)row.getCell(1));
                        data.put("native_code", native_code);
                        String user_id = ExcelUtil.getCellValue((Cell)row.getCell(2));
                        data.put("user_id", user_id);
                        String update_time = ExcelUtil.getCellValue((Cell)row.getCell(3));
                        data.put("update_time", update_time);
                        String update_by = ExcelUtil.getCellValue((Cell)row.getCell(4));
                        data.put("update_by", update_by);
                        String active = ExcelUtil.getCellValue((Cell)row.getCell(5));
                        data.put("active", active);
                        String name = ExcelUtil.getCellValue((Cell)row.getCell(6));
                        data.put("name", name);
                        String legal_person = ExcelUtil.getCellValue((Cell)row.getCell(7));
                        data.put("legal_person", legal_person);
                        String social_code = ExcelUtil.getCellValue((Cell)row.getCell(8));
                        data.put("social_code", social_code);
                        String central_office_name = ExcelUtil.getCellValue((Cell)row.getCell(9));
                        data.put("central_office_name", central_office_name);
                        String central_office_legal_person = ExcelUtil.getCellValue((Cell)row.getCell(10));
                        data.put("central_office_legal_person", central_office_legal_person);
                        String central_office_tel = ExcelUtil.getCellValue((Cell)row.getCell(11));
                        data.put("central_office_tel", central_office_tel);
                        String tel = ExcelUtil.getCellValue((Cell)row.getCell(12));
                        data.put("tel", tel);
                        String security_amount = ExcelUtil.getCellValue((Cell)row.getCell(13));
                        data.put("security_amount", security_amount);
                        String task_amount = ExcelUtil.getCellValue((Cell)row.getCell(14));
                        data.put("task_amount", task_amount);
                        String province = ExcelUtil.getCellValue((Cell)row.getCell(15));
                        data.put("province", province);
                        String city = ExcelUtil.getCellValue((Cell)row.getCell(16));
                        data.put("city", city);
                        String area = ExcelUtil.getCellValue((Cell)row.getCell(17));
                        data.put("area", area);
                        String areacode = ExcelUtil.getCellValue((Cell)row.getCell(18));
                        data.put("areacode", areacode);
                        String location = ExcelUtil.getCellValue((Cell)row.getCell(19));
                        data.put("location", location);
                        String insurance_number = ExcelUtil.getCellValue((Cell)row.getCell(20));
                        data.put("insurance_number", insurance_number);
                        String emergency_agreement = ExcelUtil.getCellValue((Cell)row.getCell(21));
                        data.put("emergency_agreement", emergency_agreement);
                        String business_license = ExcelUtil.getCellValue((Cell)row.getCell(22));
                        data.put("business_license", business_license);
                        String public_security_license = ExcelUtil.getCellValue((Cell)row.getCell(23));
                        data.put("public_security_license", public_security_license);
                        String init = ExcelUtil.getCellValue((Cell)row.getCell(24));
                        data.put("init", init);
                        String latitude = ExcelUtil.getCellValue((Cell)row.getCell(25));
                        data.put("latitude", latitude);
                        String longitude = ExcelUtil.getCellValue((Cell)row.getCell(26));
                        data.put("longitude", longitude);
                        String orderNo = ExcelUtil.getCellValue((Cell)row.getCell(27));
                        data.put("orderNo", orderNo);
                        String business_license_number = ExcelUtil.getCellValue((Cell)row.getCell(28));
                        data.put("business_license_number", business_license_number);
                        String principal = ExcelUtil.getCellValue((Cell)row.getCell(29));
                        data.put("principal", principal);
                        String principal_phone = ExcelUtil.getCellValue((Cell)row.getCell(30));
                        data.put("principal_phone", principal_phone);
                        String principal_id = ExcelUtil.getCellValue((Cell)row.getCell(31));
                        data.put("principal_id", principal_id);
                        String registered_money = ExcelUtil.getCellValue((Cell)row.getCell(32));
                        data.put("registered_money", registered_money);
                        String fixed_assets = ExcelUtil.getCellValue((Cell)row.getCell(33));
                        data.put("fixed_assets", fixed_assets);
                        String turnover_year = ExcelUtil.getCellValue((Cell)row.getCell(34));
                        data.put("turnover_year", turnover_year);
                        String annual_profits = ExcelUtil.getCellValue((Cell)row.getCell(35));
                        data.put("annual_profits", annual_profits);
                        String public_security_license_number = ExcelUtil.getCellValue((Cell)row.getCell(36));
                        data.put("public_security_license_number", public_security_license_number);
                        String national = ExcelUtil.getCellValue((Cell)row.getCell(37));
                        data.put("national", national);
                        String economic_type = ExcelUtil.getCellValue((Cell)row.getCell(38));
                        data.put("economic_type", economic_type);
                        String company_type = ExcelUtil.getCellValue((Cell)row.getCell(39));
                        data.put("company_type", company_type);
                        String human_defense_level = ExcelUtil.getCellValue((Cell)row.getCell(40));
                        data.put("human_defense_level", human_defense_level);
                        String risk_assessment_level = ExcelUtil.getCellValue((Cell)row.getCell(41));
                        data.put("risk_assessment_level", risk_assessment_level);
                        String security_association = ExcelUtil.getCellValue((Cell)row.getCell(42));
                        data.put("security_association", security_association);
                        String economic_type_legal_person = ExcelUtil.getCellValue((Cell)row.getCell(43));
                        data.put("economic_type_legal_person", economic_type_legal_person);
                        String is_subsidiary = ExcelUtil.getCellValue((Cell)row.getCell(44));
                        data.put("is_subsidiary", is_subsidiary);
                        String armed_escort_level = ExcelUtil.getCellValue((Cell)row.getCell(45));
                        data.put("armed_escort_level", armed_escort_level);
                        String security_technology_level = ExcelUtil.getCellValue((Cell)row.getCell(46));
                        data.put("security_technology_level", security_technology_level);
                        String rawid = ExcelUtil.getCellValue((Cell)row.getCell(47));
                        data.put("rawid", rawid);
                        String inrawid = ExcelUtil.getCellValue((Cell)row.getCell(48));
                        data.put("inrawid", inrawid);
                        SecurityCompany securityCompany = new SecurityCompany();
                        if (StringUtil.isNotEmpty((String)id)) {
                            securityCompany.setId(Long.valueOf(Long.parseLong(id)));
                        }
                        if (StringUtil.isNotEmpty((String)native_code)) {
                            securityCompany.setNativeCode(Long.valueOf(Long.parseLong(native_code)));
                        }
                        if (StringUtil.isNotEmpty((String)user_id)) {
                            User user = new User();
                            user.setId(Long.valueOf(Long.parseLong(user_id)));
                            securityCompany.setUser(user);
                        }
                        if (StringUtil.isNotEmpty((String)update_time)) {
                            securityCompany.setUpdateTime(DateUtil.convertStringToDate((String)update_time));
                        }
                        if (StringUtil.isNotEmpty((String)update_by)) {
                            securityCompany.setUpdateBy(update_by);
                        }
                        if (StringUtil.isNotEmpty((String)active)) {
                            securityCompany.setActive(Boolean.valueOf(!active.equals("FALSE")));
                        }
                        if (StringUtil.isNotEmpty((String)name)) {
                            securityCompany.setName(name);
                        }
                        if (StringUtil.isNotEmpty((String)legal_person)) {
                            securityCompany.setLegalPerson(legal_person);
                        }
                        if (StringUtil.isNotEmpty((String)social_code)) {
                            securityCompany.setSocialCode(social_code);
                        }
                        if (StringUtil.isNotEmpty((String)central_office_name)) {
                            securityCompany.setCentralOfficeName(central_office_name);
                        }
                        if (StringUtil.isNotEmpty((String)central_office_legal_person)) {
                            securityCompany.setCentralOfficeLegalPerson(central_office_legal_person);
                        }
                        if (StringUtil.isNotEmpty((String)update_by)) {
                            securityCompany.setUpdateBy(update_by);
                        }
                        if (StringUtil.isNotEmpty((String)update_time)) {
                            securityCompany.setUpdateTime(DateUtil.convertStringToDate((String)update_time));
                        }
                        if (StringUtil.isNotEmpty((String)central_office_tel)) {
                            securityCompany.setCentralOfficeTel(central_office_tel);
                        }
                        if (StringUtil.isNotEmpty((String)tel)) {
                            securityCompany.setTel(tel);
                        }
                        if (StringUtil.isNotEmpty((String)security_amount)) {
                            securityCompany.setSecurityAmount(Integer.valueOf(Integer.parseInt(security_amount)));
                        }
                        if (StringUtil.isNotEmpty((String)task_amount)) {
                            securityCompany.setTaskAmount(Integer.valueOf(Integer.parseInt(task_amount)));
                        }
                        if (StringUtil.isNotEmpty((String)province)) {
                            securityCompany.setProvince(province);
                        }
                        if (StringUtil.isNotEmpty((String)city)) {
                            securityCompany.setCity(city);
                        }
                        if (StringUtil.isNotEmpty((String)area)) {
                            securityCompany.setArea(area);
                        }
                        if (StringUtil.isNotEmpty((String)areacode)) {
                            securityCompany.setAreaCode(areacode);
                        }
                        if (StringUtil.isNotEmpty((String)location)) {
                            securityCompany.setLocation(location);
                        }
                        if (StringUtil.isNotEmpty((String)insurance_number)) {
                            securityCompany.setInsuranceNumber(insurance_number);
                        }
                        if (StringUtil.isNotEmpty((String)emergency_agreement)) {
                            securityCompany.setEmergencyAgreement(Boolean.valueOf(!emergency_agreement.equals("FALSE")));
                        }
                        if (StringUtil.isNotEmpty((String)business_license)) {
                            securityCompany.setBusinessLicense(business_license);
                        }
                        if (StringUtil.isNotEmpty((String)public_security_license)) {
                            securityCompany.setPublicSecurityLicense(public_security_license);
                        }
                        if (StringUtil.isNotEmpty((String)init)) {
                            securityCompany.setInit(Boolean.valueOf(!init.equals("FALSE")));
                        }
                        if (StringUtil.isNotEmpty((String)longitude)) {
                            securityCompany.setLongitude(longitude);
                        }
                        if (StringUtil.isNotEmpty((String)latitude)) {
                            securityCompany.setLatitude(latitude);
                        }
                        if (StringUtil.isNotEmpty((String)orderNo)) {
                            securityCompany.setOrderNo(orderNo);
                        }
                        if (StringUtil.isNotEmpty((String)business_license_number)) {
                            securityCompany.setBusinessLicensNnumber(business_license_number);
                        }
                        if (StringUtil.isNotEmpty((String)principal)) {
                            securityCompany.setPrincipal(principal);
                        }
                        if (StringUtil.isNotEmpty((String)principal_phone)) {
                            securityCompany.setPrincipalPhone(principal_phone);
                        }
                        if (StringUtil.isNotEmpty((String)principal_id)) {
                            securityCompany.setPrincipalId(principal_id);
                        }
                        if (StringUtil.isNotEmpty((String)registered_money)) {
                            securityCompany.setRegisteredMoney(new BigDecimal(registered_money));
                        }
                        if (StringUtil.isNotEmpty((String)fixed_assets)) {
                            securityCompany.setFixedAssets(new BigDecimal(fixed_assets));
                        }
                        if (StringUtil.isNotEmpty((String)turnover_year)) {
                            securityCompany.setTurnoverYear(new BigDecimal(principal_phone));
                        }
                        if (StringUtil.isNotEmpty((String)annual_profits)) {
                            securityCompany.setAnnualProfits(new BigDecimal(annual_profits));
                        }
                        if (StringUtil.isNotEmpty((String)public_security_license_number)) {
                            securityCompany.setPublicSecurityLicenseNumber(public_security_license_number);
                        }
                        if (StringUtil.isNotEmpty((String)national)) {
                            securityCompany.setNational(national);
                        }
                        if (StringUtil.isNotEmpty((String)economic_type)) {
                            securityCompany.setEconomicType(economic_type);
                        }
                        if (StringUtil.isNotEmpty((String)company_type)) {
                            securityCompany.setCompanyType(company_type);
                        }
                        if (StringUtil.isNotEmpty((String)human_defense_level)) {
                            securityCompany.setHumanDefenseLevel(human_defense_level);
                        }
                        if (StringUtil.isNotEmpty((String)risk_assessment_level)) {
                            securityCompany.setRiskAssessmentLevel(risk_assessment_level);
                        }
                        if (StringUtil.isNotEmpty((String)security_association)) {
                            securityCompany.setSecurityAssociation(security_association);
                        }
                        if (StringUtil.isNotEmpty((String)economic_type_legal_person)) {
                            securityCompany.setEconomicTypeLegalPerson(economic_type_legal_person);
                        }
                        if (StringUtil.isNotEmpty((String)is_subsidiary)) {
                            securityCompany.setIsSubsidiary(is_subsidiary);
                        }
                        if (StringUtil.isNotEmpty((String)armed_escort_level)) {
                            securityCompany.setArmedEscortLevel(armed_escort_level);
                        }
                        if (StringUtil.isNotEmpty((String)security_technology_level)) {
                            securityCompany.setSecurityTechnologyLevel(security_technology_level);
                        }
                        if (StringUtil.isNotEmpty((String)rawid)) {
                            securityCompany.setRawid(Long.valueOf(Long.parseLong(rawid)));
                        }
                        if (StringUtil.isNotEmpty((String)inrawid)) {
                            securityCompany.setInrawid(Long.valueOf(Long.parseLong(inrawid)));
                        }
                        logger.info("saveOrupdate... " + securityCompany);
                        boolean isSave = false;
                        if (securityCompany.getId() == null) {
                            throw new ArsException("id\u7f3a\u5931");
                        }
                        SecurityCompany dbSecurityCompany = this.securityCompanyDao.findById(securityCompany.getId());
                        if (dbSecurityCompany == null) {
                            this.securityCompanyDao.save(securityCompany);
                        } else if (securityCompany.getUpdateTime().getTime() > dbSecurityCompany.getUpdateTime().getTime()) {
                            securityCompany.setId(dbSecurityCompany.getId());
                            this.securityCompanyDaoAop.update(securityCompany);
                            isSave = true;
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof ArsException) {
                            data.put("errorMsg", e.getMessage());
                        } else {
                            data.put("errorMsg", "\u6570\u636e\u95ee\u9898");
                        }
                        faildList.add(data);
                        logger.error("\u6279\u91cf\u5f55\u5165\u9519\u8bef\uff1a" + (String)data.get("socialCode"), (Throwable)e);
                    }
                } else {
                    flag = false;
                }
                ++i;
            }
            if (faildList.size() > 0) {
                resultMap.put("faildFilePath", this.buildFaildList(faildList));
            }
        } else {
            throw new RuntimeException("\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u9519\u8bef, user:" + loginUser);
        }
        resultMap.put("successIds", saveList);
        return resultMap;
    }

    private String buildFaildList(List<Map<String, String>> data) throws Exception {
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(this.tempFolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_\u4fdd\u5b89\u516c\u53f8\u5bfc\u5165\u5931\u8d25\u8bb0\u5f55.xls";
        String templateName = this.tempFolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        File file = new File(templateName);
        this.buildCompanyTemplate(file);
        if (file != null && file.length() > 0L) {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(0);
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle((HSSFWorkbook)workbook);
            int index = 1;
            for (Map<String, String> map : data) {
                HSSFRow row = sheet.createRow(index);
                sheet.setColumnWidth(8, 5000);
                row.createCell(0).setCellValue(map.get("companyname"));
                row.createCell(1).setCellValue(map.get("socialCode"));
                row.createCell(2).setCellValue(map.get("legalPerson"));
                row.createCell(3).setCellValue(map.get("phone"));
                row.createCell(4).setCellValue(map.get("area"));
                row.createCell(5).setCellValue(map.get("location"));
                row.createCell(6).setCellValue(map.get("publicSecurityLicenseNumber"));
                row.createCell(7).setCellValue(map.get("registeredMoney"));
                Cell errorMsgCell = row.createCell(8);
                errorMsgCell.setCellStyle(style1);
                errorMsgCell.setCellValue(map.get("errorMsg"));
                ++index;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
            workbook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    public void saveOrUpdateForDS(SecurityCompany securityCompany) {
        if (securityCompany.getActive() == null) {
            securityCompany.setActive(Boolean.valueOf(true));
        }
        if (!securityCompany.getActive().booleanValue()) {
            this.securityCompanyDaoAop.delete(securityCompany);
            return;
        }
        SecurityCompany dbSecurityCompany = this.findById(securityCompany.getId());
        if (dbSecurityCompany == null) {
            this.securityCompanyDao.save(securityCompany);
            new Thread(() -> {
                try {
                    this.buildWebServiceEntity(securityCompany);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }).start();
            new Thread(() -> {
                try {
                    String photo = securityCompany.getUser().getPhoto();
                    if (StringUtil.isNotEmpty((String)photo) && photo.startsWith("getResource.do?path=") && StringUtil.isNotEmpty((String)securityCompany.getCompanyCode())) {
                        String fileType = photo.substring(photo.lastIndexOf("."));
                        photo = Base64Img.encodeBase64File((String)photo, (String)this.baseFolder);
                        Zpxxb zpxxb = new Zpxxb();
                        zpxxb.setSfzh(securityCompany.getCompanyCode());
                        zpxxb.setZpxx(securityCompany.getCompanyCode() + fileType);
                        zpxxb.setZpnr(photo);
                        zpxxb.setZpfl("02");
                        this.clientUtil.send("xxba_zpxxb", (Object)zpxxb);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }).start();
        } else if (securityCompany.getUpdateTime().getTime() > dbSecurityCompany.getUpdateTime().getTime()) {
            this.securityCompanyDaoAop.update(securityCompany);
        }
    }

    public SecurityCompany findByRawId(Long rawid) {
        return this.securityCompanyDao.findByRawId(rawid);
    }

    public SecurityCompany findByInRawId(Long inrawid) {
        return this.securityCompanyDao.findByInRawId(inrawid);
    }

    public List<SecurityCompany> searchForExportData(CompanySearchDto dto) {
        if (StringUtil.isNotEmpty((String)dto.getAreaCode())) {
            if (dto.getAreaCode().endsWith("0000")) {
                dto.setAreaCode(dto.getAreaCode().substring(0, 2) + "____");
            } else if (dto.getAreaCode().endsWith("00")) {
                dto.setAreaCode(dto.getAreaCode().substring(0, 4) + "____");
            }
        }
        return this.securityCompanyDao.searchForExportData(dto);
    }

    public void updateExport(SecurityCompany securityCompany) {
        this.securityCompanyDaoAop.update(securityCompany);
    }

    private void buildWebServiceEntity(SecurityCompany company) throws Exception {
        logger.info("\u4e0a\u62a5\u90e8\u7ea7\u6570\u636e\u3010\u4fdd\u5b89\u516c\u53f8\u3011\u2026\u2026");
        System.out.println("company==" + company.toString());
        Bagsxxb bagsxxb = new Bagsxxb();
        HashMap<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        Config config = this.configDao.findByKey("current_native");
        map.put("bagsbm", new KeyAndDefauleVal("companyCode", (Object)company.getCompanyCode()));
        map.put("bagsmc", new KeyAndDefauleVal("name", null));
        if (config != null) {
            map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", (Object)(config.getValue() + "GBF" + company.getPublicSecurityLicenseNumber())));
        } else {
            map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", (Object)("GBF" + company.getPublicSecurityLicenseNumber())));
        }
        map.put("gj", new KeyAndDefauleVal("national", null));
        map.put("zcdxz", new KeyAndDefauleVal("location", null));
        map.put("zczj", new KeyAndDefauleVal("registeredMoney", null));
        map.put("frsfzh", new KeyAndDefauleVal("legalPersonNo", null));
        map.put("frxm", new KeyAndDefauleVal("legalPerson", null));
        map.put("fzrsfzh", new KeyAndDefauleVal("principalId", null));
        map.put("fzrxm", new KeyAndDefauleVal("principal", null));
        map.put("fzrdh", new KeyAndDefauleVal("principalPhone", null));
        map.put("jjlx", new KeyAndDefauleVal("economicType", null));
        map.put("gdzc", new KeyAndDefauleVal("fixedAssets", null));
        map.put("nyye", new KeyAndDefauleVal("turnoverYear", null));
        map.put("nls", new KeyAndDefauleVal("annualProfits", null));
        map.put("gslx", new KeyAndDefauleVal("companyType", null));
        try {
            EntityForWebServiceUtil.copy(map, (Object)company, (Object)bagsxxb);
            logger.info("bagsxxb==" + bagsxxb.toString());
            bagsxxb.setKhsl("1");
            bagsxxb.setBgbs("1");
            bagsxxb.setZjjk("1");
            bagsxxb.setGslx("1");
            this.clientUtil.send("xxba_bagsxxb", (Object)bagsxxb);
            logger.info("\u4e0a\u62a5\u6210\u529f\u4fdd\u5b89\u516c\u53f8\u2026\u2026");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public CompanyReportData dataStatisticsReport(ReportDataSearchDto searchDto) {
        CompanyReportData data;
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        Date startDate = new Date();
        Date startLastDate = new Date();
        Date endDate = new Date();
        Date endLastDate = new Date();
        if (StringUtil.isNotEmpty((String)searchDto.getType())) {
            if (searchDto.getType().equals("2")) {
                startDate = DateUtil.getDayBegin();
                endDate = DateUtil.getDayEnd();
                startLastDate = DateUtil.getBeginDayOfYesterday();
                endLastDate = DateUtil.getEndDayOfYesterDay();
            } else if (searchDto.getType().equals("3")) {
                startDate = DateUtil.getBeginDayOfWeek();
                endDate = DateUtil.getEndDayOfWeek();
                startLastDate = DateUtil.getBeginDayOfLastWeek();
                endLastDate = DateUtil.getEndDayOfLastWeek();
            } else if (searchDto.getType().equals("4")) {
                startDate = DateUtil.getBeginDayOfMonth();
                endDate = DateUtil.getEndDayOfMonth();
                startLastDate = DateUtil.getBeginDayOfLastMonth();
                endLastDate = DateUtil.getEndDayOfLastMonth();
            } else if (searchDto.getType().equals("1")) {
                startDate = DateUtil.getBeginDayOfYear();
                endDate = DateUtil.getEndDayOfYear();
                startLastDate = DateUtil.getBeginDayOfLastYear();
                endLastDate = DateUtil.getEndDayOfLastYear();
            }
        }
        ReportDataSearchDto searchLastDto = new ReportDataSearchDto();
        searchLastDto.setType(searchDto.getType());
        searchLastDto.setAreaCode(searchDto.getAreaCode());
        CompanyReportData lastData = null;
        if (StringUtil.isNotEmpty((String)searchLastDto.getType()) && !searchDto.getType().equals("100")) {
            searchDto.setStartTime(DateUtil.convertDateToString((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss"));
            searchDto.setEndTime(DateUtil.convertDateToString((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
            searchLastDto.setStartTime(DateUtil.convertDateToString((Date)startLastDate, (String)"yyyy-MM-dd HH:mm:ss"));
            searchLastDto.setEndTime(DateUtil.convertDateToString((Date)endLastDate, (String)"yyyy-MM-dd HH:mm:ss"));
            lastData = this.securityCompanyDao.dataStatisticsInitReport(searchLastDto);
        }
        if ((data = this.securityCompanyDao.dataStatisticsInitReport(searchDto)) == null) {
            data = new CompanyReportData();
        }
        if (StringUtil.isEmpty((String)searchDto.getType())) {
            List reportDatas = this.securityCompanyDao.dataStatisticsAddReport(searchDto);
            for (ReportData reportData : reportDatas) {
                if (reportData.getName().equals(DateUtil.getCurrentDate((String)"yyyy"))) {
                    data.setThisYearTotal(reportData.getValue());
                }
                if (!reportData.getName().equals(DateUtil.getLastYear())) continue;
                data.setLastYearTotal(reportData.getValue());
            }
            if (data.getThisYearTotal() == null) {
                data.setLastYearTotal(Long.valueOf(0L));
            }
            if (data.getLastYearTotal() == null) {
                data.setLastYearTotal(Long.valueOf(0L));
            }
            if (data.getLastYearTotal() > 0L) {
                data.setLastYearRate(df.format((double)(data.getThisYearTotal() - data.getLastYearTotal()) * 100.0 / (double)data.getLastYearTotal().longValue()));
            } else if (data.getThisYearTotal() < 1L) {
                data.setLastYearRate("0");
            } else {
                data.setLastYearRate("100");
            }
        } else if (lastData != null) {
            if (lastData.getInitCount() < 1L) {
                if (data.getInitCount() < 1L) {
                    data.setInitRate("0");
                } else {
                    data.setInitRate("100");
                }
            } else {
                data.setInitRate(df.format((double)(data.getInitCount() - lastData.getInitCount()) * 100.0 / (double)lastData.getInitCount().longValue()));
            }
            if (lastData.getUnInitCount() < 1L) {
                if (data.getUnInitCount() < 1L) {
                    data.setUnInitRate("0");
                } else {
                    data.setUnInitRate("100");
                }
            } else {
                data.setUnInitRate(df.format((double)(data.getUnInitCount() - lastData.getUnInitCount()) * 100.0 / (double)lastData.getUnInitCount().longValue()));
            }
            if (lastData.getTotal() < 1L) {
                if (data.getTotal() < 1L) {
                    data.setTotalRate("0");
                } else {
                    data.setTotalRate("100");
                }
            } else {
                data.setTotalRate(df.format((double)(data.getTotal() - lastData.getTotal()) * 100.0 / (double)lastData.getTotal().longValue()));
            }
        }
        return data;
    }

    public SupervisionSearchDto supervisionSearch(SupervisionSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        List supervisions = this.securityCompanyDao.supervisionSearch(searchDto);
        for (SupervisionDto supervisionDto : supervisions) {
            Long unPolicyCount = this.personDao.findUnPolicyByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setUnPolicyCount(unPolicyCount);
            supervisionDto.setPolicyCount(Long.valueOf(supervisionDto.getTotal() - unPolicyCount));
            Long approvalCount = this.approvalDao.findCountByUserId(supervisionDto.getUserId());
            supervisionDto.setPermitCount(approvalCount);
            Long taskCount = this.taskDao.findTotalByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTaskCount(taskCount);
            Long cycleTaskCount = this.taskDao.findCycleCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setCycleTaskCount(cycleTaskCount);
            Long temporaryTaskCount = this.taskDao.findTemporaryCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTemporaryTaskCount(temporaryTaskCount);
        }
        searchDto.setData(supervisions);
        searchDto.setTotalCount(this.securityCompanyDao.supervisionSearchCount(searchDto));
        return searchDto;
    }

    public PageResult querySupervisionList(SupervisionSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        List supervisions = this.securityCompanyDao.supervisionSearch(searchDto);
        for (SupervisionDto supervisionDto : supervisions) {
            Long unPolicyCount = this.personDao.findUnPolicyByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setUnPolicyCount(unPolicyCount);
            supervisionDto.setPolicyCount(Long.valueOf(supervisionDto.getTotal() - unPolicyCount));
            Long approvalCount = this.approvalDao.findCountByUserId(supervisionDto.getUserId());
            supervisionDto.setPermitCount(approvalCount);
            Long taskCount = this.taskDao.findTotalByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTaskCount(taskCount);
            Long cycleTaskCount = this.taskDao.findCycleCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setCycleTaskCount(cycleTaskCount);
            Long temporaryTaskCount = this.taskDao.findTemporaryCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTemporaryTaskCount(temporaryTaskCount);
        }
        return new PageResult(Integer.valueOf(this.securityCompanyDao.supervisionSearchCount(searchDto).intValue()), (Object)supervisions);
    }

    public Long supervisionSearchCount(SupervisionSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        return this.securityCompanyDao.supervisionSearchCount(searchDto);
    }

    public Long dataStatisticsPersonTotalReport(SupervisionSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        return this.securityCompanyDao.dataStatisticsPersonTotalReport(searchDto);
    }

    public Long dataStatisticsPolicyReport(SupervisionSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        return this.securityCompanyDao.dataStatisticsPolicyReport(searchDto);
    }

    public JSONObject supervisionTotal(SupervisionSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        JSONObject data = new JSONObject();
        Long personTotal = this.securityCompanyDao.dataStatisticsPersonTotalReport(searchDto);
        Long policyTotal = this.securityCompanyDao.dataStatisticsPolicyReport(searchDto);
        DecimalFormat df = new DecimalFormat("#0.00");
        String policyRate = "";
        policyRate = personTotal == null || personTotal < 1L ? "0" : (policyTotal == null || personTotal < 1L ? "0" : df.format((double)policyTotal.longValue() * 100.0 / (double)personTotal.longValue()));
        data.put("companyCount", (Object)this.securityCompanyDao.supervisionSearchCount(searchDto));
        data.put("initCount", (Object)this.securityCompanyDao.dataStatisticsInitTotalReport(searchDto));
        data.put("policyRate", (Object)policyRate);
        return data;
    }

    public JSONObject supervisionDetail(Long companyId) {
        JSONObject data = new JSONObject();
        JSONObject policyInfo = new JSONObject();
        JSONObject appInfo = new JSONObject();
        JSONObject approvalInfo = new JSONObject();
        JSONObject testInfo = new JSONObject();
        SecurityCompany company = this.securityCompanyDao.findById(companyId);
        TaskExecutionDto taskInfo = this.taskDao.findTaskExecutionReport(companyId);
        List approvalReports = this.approvalDao.getTypeGroupByUserId(company.getUser().getId());
        Long personcertificateCount = 0L;
        Long crosscompanyCount = 0L;
        Long subsidiaryCount = 0L;
        Long traincompanyCount = 0L;
        Long legalchangeCount = 0L;
        for (ReportData reportData : approvalReports) {
            if (reportData.getName().equals("004")) {
                personcertificateCount = reportData.getValue();
                continue;
            }
            if (reportData.getName().equals("005")) {
                crosscompanyCount = reportData.getValue();
                continue;
            }
            if (reportData.getName().equals("003")) {
                subsidiaryCount = reportData.getValue();
                continue;
            }
            if (reportData.getName().equals("002")) {
                traincompanyCount = reportData.getValue();
                continue;
            }
            if (!reportData.getName().equals("007")) continue;
            legalchangeCount = reportData.getValue();
        }
        approvalInfo.put("personcertificateCount", (Object)personcertificateCount);
        approvalInfo.put("crosscompanyCount", (Object)crosscompanyCount);
        approvalInfo.put("subsidiaryCount", (Object)subsidiaryCount);
        approvalInfo.put("traincompanyCount", (Object)traincompanyCount);
        approvalInfo.put("legalchangeCount", (Object)legalchangeCount);
        Long personCount = this.personDao.countPersonByCompanyId(companyId);
        Long initCount = this.personDao.countInitPersonByCompanyId(companyId);
        Long authCount = this.personDao.countAuthPersonByCompanyId(companyId);
        Long unAuthCount = this.personDao.countUnAuthPersonByCompanyId(companyId);
        appInfo.put("personCount", (Object)personCount);
        appInfo.put("initCount", (Object)initCount);
        appInfo.put("authCount", (Object)authCount);
        appInfo.put("unAuthCount", (Object)unAuthCount);
        Long unPolicyCount = this.personDao.findUnPolicyByCompanyId(companyId);
        Long policyCount = personCount - unPolicyCount;
        Long quotaCount = this.personDao.countQuotaPersonByCompanyId(companyId);
        Long unQuotaCount = policyCount - quotaCount;
        Long socialSecurityCount = this.personDao.countSocialSecurityPersonByCompanyId(companyId);
        Long unSocialSecurityCount = personCount - socialSecurityCount;
        String socialSecurityName = "";
        policyInfo.put("personTotal", (Object)personCount);
        policyInfo.put("policyCount", (Object)policyCount);
        policyInfo.put("unPolicyCount", (Object)unPolicyCount);
        policyInfo.put("quotaCount", (Object)quotaCount);
        policyInfo.put("unQuotaCount", (Object)unQuotaCount);
        policyInfo.put("socialSecurityCount", (Object)socialSecurityCount);
        policyInfo.put("unSocialSecurityCount", (Object)unSocialSecurityCount);
        policyInfo.put("socialSecurityName", (Object)socialSecurityName);
        TestTrainDto testTrain = this.securityCompanyDao.dataStatisticsTestTrainReport(companyId);
        Long noCertificateCount = this.securityCompanyDao.getNoCertificateCount(companyId);
        testTrain.setNoCertificateCount(noCertificateCount.toString());
        Config coninsConfig = this.configService.findByKey("train_url");
        String url = coninsConfig.getValue() + "/train/systemuser/bbd/findexamtrain" + "?companyid=" + companyId + "&trackid=8";
        try {
            String resultStr = messageUtils.getJsonByInternet((String)url);
            JSONObject result = (JSONObject)JSONObject.parse((String)resultStr);
            JSONObject resultData = (JSONObject)result.get((Object)"data");
            JsonParser jsonParser = new JsonParser();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String zgzsTrainCount = "0";
        String certificateCount = "0";
        String onGuardCount = "0";
        zgzsTrainCount = this.orderPersonDao.countByCompanyIdAndTrainType(companyId, "8").toString();
        certificateCount = this.personcertificateDao.countCertificateByCompanyId(companyId).toString();
        onGuardCount = this.personDao.countAuthPersonByCompanyId(companyId).toString();
        testInfo.put("zgzsTrainCount", (Object)zgzsTrainCount);
        testInfo.put("certificateCount", (Object)certificateCount);
        testInfo.put("noCertificateCount", (Object)noCertificateCount);
        testInfo.put("onGuardCount", (Object)onGuardCount);
        data.put("companyInfo", (Object)company);
        data.put("policyInfo", (Object)policyInfo);
        data.put("taskInfo", (Object)taskInfo);
        data.put("appInfo", (Object)appInfo);
        data.put("approvalInfo", (Object)approvalInfo);
        data.put("testInfo", (Object)testInfo);
        return data;
    }

    public JSONObject companySecurityDetail(Long companyId) {
        JSONObject data = new JSONObject();
        SecurityCompany company = this.securityCompanyDao.findById(companyId);
        company.setSecurityAmount(Integer.valueOf(this.securityCompanyDao.countForSecurityPerson(companyId)));
        data.put("certificationCount", (Object)this.securityCompanyDao.countForCertifity(companyId));
        data.put("companyInfo", (Object)company);
        if (company.getUser() != null) {
            Long company_id = company.getUser().getId();
            List insurances = this.securityCompanyInsuranceDao.findByCompanyId(company_id);
            data.put("insuranceInfos", (Object)insurances);
        }
        return data;
    }

    public void updateOperatorphone(SecurityCompany securityCompany) {
        this.securityCompanyDaoAop.updateOperatorphone(securityCompany);
    }

    public List<SecurityCompany> searchForExport(String startDate) {
        return this.securityCompanyDao.searchForExport(startDate);
    }

    public List<ZTree> getCompanyTree() {
        CompanySearchDto searchDto = new CompanySearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setUserid(currentUser.getId());
        searchDto.setPath(currentUser.getPolice().getPath());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        List list = this.securityCompanyDao.getCompanyTree(searchDto);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (ZTree zTree : list) {
            Integer count2;
            Integer count1;
            if (!zTree.getType().equals("1")) continue;
            String key = zTree.getpId();
            String key1 = key.substring(0, 2) + "0000";
            String key2 = key.substring(0, 4) + "00";
            Integer count = (Integer)countMap.get(key);
            if (count == null) {
                count = 0;
            }
            if ((count1 = (Integer)countMap.get(key1)) == null) {
                count1 = 0;
            }
            if ((count2 = (Integer)countMap.get(key2)) == null) {
                count2 = 0;
            }
            if (key.endsWith("0000")) {
                count1 = count1 + 1;
                countMap.put(key1, count1);
                continue;
            }
            if (key.endsWith("00")) {
                count1 = count1 + 1;
                countMap.put(key1, count1);
                count2 = count2 + 1;
                countMap.put(key2, count2);
                continue;
            }
            count = count + 1;
            countMap.put(key, count);
            count1 = count1 + 1;
            countMap.put(key1, count1);
            count2 = count2 + 1;
            countMap.put(key2, count2);
        }
        for (ZTree zTree : list) {
            if (!zTree.getType().equals("0")) continue;
            zTree.setName(zTree.getName() + "(" + countMap.get(zTree.getId()) + ")");
        }
        return list;
    }

    public void batchSendMessage(List<String> phones) {
        User loginUser = this.arsUtil.getCurrentUser();
        if (loginUser != null) {
            SecurityCompany company = null;
            if (loginUser.getPlatform() == 2) {
                company = this.securityCompanyDao.findByUserid(loginUser.getId());
            }
            if (company != null) {
                MessageUtil.sendMessage(phones, (String)"\u5c0a\u656c\u7684\u7528\u6237\uff0c%COMPANYNAME%\u5df2\u4e3a\u60a8\u5bfc\u5165\u4fe1\u606f\uff0c\u8d26\u53f7\u4e3a\u8eab\u4efd\u8bc1\u53f7\u6216\u624b\u673a\u53f7\uff0c\u521d\u59cb\u5bc6\u7801\u4e3a\uff1abcx123456\uff0c\u8bf7\u5c3d\u5feb\u767b\u5f55\u4fee\u6539\u5bc6\u7801\u3002\u70b9\u51fb http://baibaodun.cn/download.html \u4e0b\u8f7d\u767e\u4fdd\u76fe\u3002".replaceAll("%COMPANYNAME%", company.getName()), (MessageLogDao)this.messageLogDao);
            }
        }
    }

    public SecurityCompany getCurrentUserCompany() {
        User loginUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = null;
        if (loginUser != null && loginUser.getPlatform() == 2) {
            company = this.securityCompanyDao.findByUserid(loginUser.getId());
        }
        return company;
    }

    public List<Map<String, String>> batchImportPerson(List<Map<String, String>> list, int batchId, User user, SecurityCompany company) {
        this.securityCompanyDao.insertTmpBatchImportPerson(list, batchId);
        String passWord = Sha1Util.entryptPassword((String)"Baoan#12345678");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("prm_batchId", batchId);
        paramMap.put("prm_companyId", company.getId());
        paramMap.put("prm_userId", user.getId());
        paramMap.put("prm_areaCode", company.getAreaCode());
        paramMap.put("prm_passWord", passWord);
        this.securityCompanyDao.prc_batchImportPerson(paramMap);
        String prm_success = paramMap.get("prm_success").toString();
        if (prm_success.equalsIgnoreCase("0")) {
            throw new ArsException("\u5bfc\u5165\u4eba\u5458\u5931\u8d25\uff01");
        }
        List failList = this.securityCompanyDao.getFailList(batchId);
        this.securityCompanyDao.deleteTmpBatchImportPerson(batchId);
        return failList;
    }

    public List<SecurityCompany> findDSOutList(String startDate) {
        List companyList = this.securityCompanyDao.searchForExport(startDate);
        companyList.forEach(company -> {
            company.setExported(true);
            this.securityCompanyDao.updateExportFlag(company);
        });
        return companyList;
    }

    public void importBatch(List<SecurityCompany> list) {
        List dbList = this.securityCompanyDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (SecurityCompany detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.securityCompanyDaoAop.saveBatch(list);
        }
    }

    public void searchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        page.setData(this.securityCompanyDao.searchForPageV2(dto));
        page.setTotal((long)this.securityCompanyDao.searchForPageV2Count(dto));
    }

    public void situationForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.securityCompanyDao.situationForPage(dto, page);
    }

    public void updateCertificatesPhoto(List<SecurityCompany> companys) {
        this.securityCompanyDao.updateCertificatesPhoto(companys);
    }

    public List<SecurityCompany> findSubCompany(String parentId) {
        return this.securityCompanyDao.findSubCompany(parentId);
    }

    public List<String> selectCompanyName(String institutionType) {
        return this.securityCompanyDao.selectCompanyName(institutionType);
    }

    public static void main(String[] args) {
        V5PageDto pageDto;
        HttpResponse response = HttpUtil.createPost((String)"http://v5qy.test.baibaodun.cn/v3/public/company-info").contentType("application/json").body(String.format("{'pageSize':'%s','pageIndex':'%s','name':'%s'}", "10", "1", "\u516c\u53f8")).execute();
        System.out.println(response.body());
        V5ResultDto resultDto = (V5ResultDto)JSON.parseObject((String)response.body(), V5ResultDto.class);
        if (resultDto.isSuccess() && resultDto.getData() != null && (pageDto = (V5PageDto)JSON.parseObject((String)JSON.toJSONString((Object)resultDto.getData()), V5PageDto.class)).getData() != null && pageDto.getData().size() > 0) {
            List companyV5Dtos = JSONArray.parseArray((String)JSON.toJSONString((Object)pageDto.getData()), CompanyV5Dto.class);
            for (CompanyV5Dto companyV5Dto : companyV5Dtos) {
                System.out.println(companyV5Dto.getAddress());
            }
        }
        System.out.println(resultDto.getStatus());
    }

    public void publicSearchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        if ("1".equals(this.configUtils.getValueByKey("BJ_PUBLIC_QUERY_FORM_V5"))) {
            V5PageDto pageDto;
            HttpResponse response = HttpUtil.createPost((String)(this.configUtils.getValueByKey("V5_TENANT_URL") + "v3/public/company-info")).contentType("application/json").body(String.format("{'pageSize':'%s','pageIndex':'%s','name':'%s'}", dto.getPageSize(), dto.getPageNumber(), StringUtil.isEmpty((String)dto.getName()) ? "" : dto.getName())).execute();
            V5ResultDto resultDto = (V5ResultDto)JSON.parseObject((String)response.body(), V5ResultDto.class);
            if (resultDto.isSuccess() && resultDto.getData() != null && (pageDto = (V5PageDto)JSON.parseObject((String)JSON.toJSONString((Object)resultDto.getData()), V5PageDto.class)).getData() != null && pageDto.getData().size() > 0) {
                List companyV5Dtos = JSONArray.parseArray((String)JSON.toJSONString((Object)pageDto.getData()), CompanyV5Dto.class);
                ArrayList<CompanyDto> companyDtos = new ArrayList<CompanyDto>();
                for (CompanyV5Dto companyV5Dto : companyV5Dtos) {
                    CompanyDto companyDto = new CompanyDto();
                    companyDto.setPublicSecurityLicenseNumber(companyV5Dto.getCerNo());
                    companyDto.setName(companyV5Dto.getComName());
                    companyDto.setGiveLicenseDate(companyV5Dto.getCerDate());
                    companyDto.setLegalPerson(companyV5Dto.getLegalPerson());
                    companyDto.setTel(companyV5Dto.getTel());
                    companyDto.setRegisteredMoney(StrUtil.isEmpty((CharSequence)companyV5Dto.getRegisteredMoney()) ? null : new BigDecimal(companyV5Dto.getRegisteredMoney()));
                    companyDto.setAddress(companyV5Dto.getAddress());
                    companyDto.setLocation(companyV5Dto.getLocation());
                    companyDto.setSecurityScopeType(companyV5Dto.getSecurityScopeType());
                    companyDto.setFromV5(true);
                    companyDtos.add(companyDto);
                }
                page.setData(companyDtos);
                page.setTotal((long)pageDto.getTotal());
                page.setTotalPage((long)(pageDto.getTotal() / pageDto.getPageSize() + (pageDto.getTotal() % pageDto.getPageSize() > 0 ? 0 : 1)));
            }
            return;
        }
        this.securityCompanyDao.publicSearchForPage(dto, page);
    }
}

