/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.service.SecurityCompanyPersonService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecurityCompanyPersonServiceImpl
implements SecurityCompanyPersonService {
    @Autowired
    private SecurityCompanyPersonDao companyPersonDao;
    @Autowired
    private ArsUtil arsUtil;

    public Long save(SecurityCompanyPerson companyPerson) {
        companyPerson.setActive(Boolean.valueOf(true));
        if (companyPerson.getCreateTime() == null) {
            companyPerson.setCreateTime(new Date());
        }
        companyPerson.setUpdateTime(new Date());
        companyPerson.setUpdateBy(this.arsUtil.getCurrentUser() == null ? "system" : this.arsUtil.getCurrentUser().getUsername());
        return this.companyPersonDao.save(companyPerson);
    }

    public void saveBatch(List<SecurityCompanyPerson> list) {
        this.companyPersonDao.saveBatch(list);
    }

    public void saveOrUpdateForDS(SecurityCompanyPerson companyPerson) {
        if (companyPerson.getActive() == null) {
            companyPerson.setActive(Boolean.valueOf(true));
        }
        if (!companyPerson.getActive().booleanValue()) {
            this.companyPersonDao.delete(companyPerson);
        } else {
            SecurityCompanyPerson dbCompanyPerson = this.companyPersonDao.findById(companyPerson.getId());
            if (dbCompanyPerson == null) {
                this.companyPersonDao.save(companyPerson);
            } else if (companyPerson.getUpdateTime().getTime() > dbCompanyPerson.getUpdateTime().getTime()) {
                this.companyPersonDao.updateForDS(companyPerson);
            }
        }
    }

    public void update(SecurityCompanyPerson companyPerson) {
        companyPerson.setUpdateTime(new Date());
        this.companyPersonDao.update(companyPerson);
    }

    public List<SecurityCompanyPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return null;
    }

    public void delete(SecurityCompanyPerson companyPerson) {
        companyPerson.setUpdateTime(new Date());
        companyPerson.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
        this.companyPersonDao.delete(companyPerson);
    }

    public SecurityCompanyPerson findByPerson(SecurityPerson person) {
        return this.companyPersonDao.findByPersonId(person.getId());
    }

    public SecurityCompanyPerson findSingleByPerson(SecurityPerson person) {
        return this.companyPersonDao.findSingleByPersonId(person.getId());
    }

    public List<SecurityCompanyPerson> findByRoleId(Long roleId) {
        return this.companyPersonDao.findByRoleId(roleId);
    }

    public List<SecurityCompanyPerson> findByOrgId(Long orgId) {
        return this.companyPersonDao.findByOrgId(orgId);
    }

    public SecurityCompanyPerson findByPersonAndCompany(Long personId, Long companyId) {
        return this.companyPersonDao.findByPersonAndCompany(personId, companyId);
    }

    public void deleteByPersonId(Long personId) {
        this.companyPersonDao.deleteByPersonId(personId);
    }

    public SecurityCompanyPerson findById(Long Id) {
        return this.companyPersonDao.findById(Id);
    }
}

