/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SearchHistoryDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.HistorySearchDto;
import com.bcxin.ars.model.SearchHistory;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SearchHistoryService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SearchHistoryServiceImpl
implements SearchHistoryService {
    @Autowired
    private SearchHistoryDao searchHistoryDao;
    @Autowired
    private ArsUtil arsUtil;

    public void save(SearchHistory searchHistory) {
        this.searchHistoryDao.save(searchHistory);
    }

    public List<SearchHistory> findByUserid(Long userid) {
        return this.searchHistoryDao.findByUserid(userid);
    }

    public SearchHistory findById(Long id) {
        return this.searchHistoryDao.findById(id);
    }

    public void save(String context, String searchType, User user) {
        SearchHistory searchHistory = new SearchHistory();
        searchHistory.setActive(Boolean.valueOf(true));
        searchHistory.setContext(context);
        searchHistory.setSearchType(searchType);
        searchHistory.setCreateTime(new Date());
        searchHistory.setUpdateBy(user.getRealname());
        searchHistory.setUpdateTime(new Date());
        searchHistory.setUserid(user.getId());
        this.searchHistoryDao.save(searchHistory);
    }

    public void saveOrUpdate(String context, String searchType, User user) {
        HistorySearchDto dto = new HistorySearchDto();
        dto.setContext(context);
        dto.setSearchType(searchType);
        dto.setUserid(user.getId());
        dto.setPaging(false);
        SearchHistory searchHistory = null;
        List data = this.searchHistoryDao.search(dto);
        if (data == null || data.size() < 1) {
            searchHistory = new SearchHistory();
            searchHistory.setActive(Boolean.valueOf(true));
            searchHistory.setContext(context);
            searchHistory.setSearchType(searchType);
            searchHistory.setCreateTime(new Date());
            searchHistory.setUpdateBy(user.getRealname());
            searchHistory.setUpdateTime(new Date());
            searchHistory.setUserid(user.getId());
            this.searchHistoryDao.save(searchHistory);
        } else {
            searchHistory = (SearchHistory)data.get(0);
            searchHistory.setUpdateTime(new Date());
            this.searchHistoryDao.update(searchHistory);
        }
    }

    public HistorySearchDto search(HistorySearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            return null;
        }
        List data = this.searchHistoryDao.search(dto);
        Long count = this.searchHistoryDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public AjaxResult searchHistory(HistorySearchDto dto) {
        AjaxResult result = new AjaxResult();
        try {
            User user = this.arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
                result.setData((Object)this.search(dto));
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public AjaxResult deleteHistory(long id) {
        AjaxResult result = new AjaxResult();
        try {
            User user = this.arsUtil.getCurrentUser();
            if (user != null) {
                SearchHistory searchHistory = new SearchHistory();
                searchHistory.setId(Long.valueOf(id));
                searchHistory.setUpdateBy(user.getUsername());
                searchHistory.setUpdateTime(new Date());
                this.searchHistoryDao.delete(searchHistory);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public AjaxResult deleteAllHistory() {
        AjaxResult result = new AjaxResult();
        try {
            User user = this.arsUtil.getCurrentUser();
            if (user != null) {
                SearchHistory searchHistory = new SearchHistory();
                searchHistory.setUserid(user.getId());
                searchHistory.setUpdateBy(user.getUsername());
                searchHistory.setUpdateTime(new Date());
                this.searchHistoryDao.deleteByUserid(searchHistory);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public void searchForPage(HistorySearchDto searchDto, AjaxPageResponse<SearchHistory> page) {
        User user = this.arsUtil.getCurrentUser();
        searchDto.setUserid(user.getId());
        this.searchHistoryDao.seachForPage(searchDto, page);
    }
}

