/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbPunishDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbPunishSearchDto;
import com.bcxin.ars.model.SbPunish;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbPunishService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SbPunish.class)
public class SbPunishServiceImpl
implements SbPunishService {
    @Autowired
    private SbPunishDao sbPunishDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ArsUtil arsUtil;

    public void saveOrUpdate(SbPunish sbPunish) {
        User user = this.arsUtil.getCurrentUser();
        SbPunish dbSbPunish = this.sbPunishDao.findById(sbPunish.getId());
        if (dbSbPunish != null) {
            dbSbPunish.setUpdateTime(new Date());
            dbSbPunish.setUpdateBy(user.getRealname());
            if (!StringUtils.isEmpty((Object)sbPunish.getDepartname())) {
                dbSbPunish.setDepartname(sbPunish.getDepartname());
            }
            if (!StringUtils.isEmpty((Object)sbPunish.getEmployeeid())) {
                dbSbPunish.setEmployeeid(sbPunish.getEmployeeid());
            }
            if (!StringUtils.isEmpty((Object)sbPunish.getIdNumber())) {
                dbSbPunish.setIdNumber(sbPunish.getIdNumber());
            }
            if (!StringUtils.isEmpty((Object)sbPunish.getName())) {
                dbSbPunish.setName(sbPunish.getName());
            }
            if (!StringUtils.isEmpty((Object)sbPunish.getRemarks())) {
                dbSbPunish.setRemarks(sbPunish.getRemarks());
            }
            if (!StringUtils.isEmpty((Object)sbPunish.getPunishContext())) {
                dbSbPunish.setPunishContext(sbPunish.getPunishContext());
            }
            if (!StringUtils.isEmpty((Object)sbPunish.getPunishDate())) {
                dbSbPunish.setPunishDate(sbPunish.getPunishDate());
            }
            if (!StringUtils.isEmpty((Object)sbPunish.getPunishReason())) {
                dbSbPunish.setPunishReason(sbPunish.getPunishReason());
            }
            dbSbPunish.setIsByPolice(sbPunish.getIsByPolice());
            dbSbPunish.setPunishCompany(sbPunish.getPunishCompany());
            this.sbPunishDao.update(dbSbPunish);
        } else {
            if (user.getPlatform() == 2) {
                sbPunish.setUserid(user.getId());
            }
            sbPunish.setCreateTime(new Date());
            sbPunish.setUpdateTime(sbPunish.getCreateTime());
            sbPunish.setActive(Boolean.valueOf(true));
            sbPunish.setUpdateBy(user.getUsername());
            this.sbPunishDao.save(sbPunish);
        }
    }

    public void delete(SbPunish sbPunish) {
        sbPunish.setUpdateTime(new Date());
        this.sbPunishDao.delete(sbPunish);
    }

    public SbPunish findById(long id) {
        return this.sbPunishDao.findById(Long.valueOf(id));
    }

    public SbPunishSearchDto search(SbPunishSearchDto dto) {
        SbPunishSearchDto resultDto = new SbPunishSearchDto();
        List list = this.sbPunishDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.sbPunishDao.count(dto)));
        return resultDto;
    }

    public List<SbPunish> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.sbPunishDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(SbPunish sbPunish) {
        if (sbPunish.getActive() == null) {
            sbPunish.setActive(Boolean.valueOf(true));
        }
        if (!sbPunish.getActive().booleanValue()) {
            this.sbPunishDao.delete(sbPunish);
        } else {
            SbPunish dbSbPunish = this.sbPunishDao.findById(sbPunish.getId());
            if (dbSbPunish == null) {
                this.sbPunishDao.saveForDS(sbPunish);
            } else if (sbPunish.getUpdateTime().getTime() > dbSbPunish.getUpdateTime().getTime()) {
                this.sbPunishDao.update(sbPunish);
            }
        }
    }

    public void saveOrUpdateForSAAS(List<SbPunish> sbPunishList) {
        List dbSbPunishlist;
        User user = this.arsUtil.getCurrentUser();
        if (null != sbPunishList && null != sbPunishList.get(0) && null != (dbSbPunishlist = this.sbPunishDao.findByPenaltyId(sbPunishList.get(0).getPenaltyId())) && dbSbPunishlist.size() > 0) {
            this.sbPunishDao.deleteByPenaltyId(sbPunishList.get(0).getPenaltyId());
        }
        for (SbPunish sbPunish : sbPunishList) {
            if (user.getPlatform() == 2) {
                sbPunish.setUserid(user.getId());
            }
            sbPunish.setCreateTime(new Date());
            sbPunish.setUpdateTime(sbPunish.getCreateTime());
            sbPunish.setActive(Boolean.valueOf(true));
            sbPunish.setUpdateBy(user.getUsername());
            this.sbPunishDao.save(sbPunish);
        }
    }

    public List<SbPunish> findByPenaltyId(Long id) {
        return this.sbPunishDao.findByPenaltyId(id);
    }

    public void deleteByPenaltyId(Long penaltyId) {
        this.sbPunishDao.deleteByPenaltyId(penaltyId);
    }
}

