/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.OrderDao;
import com.bcxin.ars.dao.OrderPersonDao;
import com.bcxin.ars.dao.OrderTransactionDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.TrainOrderVo;
import com.bcxin.ars.dto.sb.OrderSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Order;
import com.bcxin.ars.model.OrderPerson;
import com.bcxin.ars.model.OrderTransaction;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.OrderNoLogService;
import com.bcxin.ars.service.OrderService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ThirdPartyURL;
import com.bcxin.ars.util.message.messageUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Order.class)
public class OrderServiceImpl
implements OrderService {
    private Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderDao orderDao;
    @Autowired
    private OrderPersonDao orderPersonDao;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrderTransactionDao orderTransactionDao;
    @Autowired
    private OrderNoLogService orderNoLogService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ArsUtil arsUtil;

    public void save(Order order) {
        this.orderDao.save(order);
    }

    public void saveOrUpdate(Order order) {
        User user = this.arsUtil.getCurrentUser();
        if (order.getId() == null) {
            order.setCreateTime(new Date());
            order.setUpdateBy(user.getUsername());
            order.setUpdateTime(new Date());
            this.orderDao.save(order);
        } else {
            Order dbOrder = this.orderDao.findById(order.getId());
            dbOrder.setAmount(order.getAmount());
            dbOrder.setRandomOrderNo(order.getRandomOrderNo());
            dbOrder.setRemarks(order.getRemarks());
            dbOrder.setSendaddress(order.getSendaddress());
            dbOrder.setSignatory(order.getSignatory());
            dbOrder.setTel(order.getTel());
            dbOrder.setUpdateTime(new Date());
            dbOrder.setUpdateBy(user.getUsername());
            this.orderDao.update(dbOrder);
        }
    }

    public Order findById(Long id) {
        return this.orderDao.findById(id);
    }

    public void createOrder(Order order, Long[] personIds) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = this.companyDao.findByUserid(currentUser.getId());
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        if (order.getDateType().equals("1")) {
            ((Calendar)calendar).add(2, 1);
        } else if (order.getDateType().equals("2")) {
            ((Calendar)calendar).add(2, 3);
        } else if (order.getDateType().equals("3")) {
            ((Calendar)calendar).add(2, 6);
        } else {
            ((Calendar)calendar).add(1, 1);
        }
        if (order.getId() != null) {
            Order dbOrder = this.orderDao.findById(order.getId());
            if (dbOrder == null) {
                throw new ArsException("\u8ba2\u5355\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
            }
            dbOrder.setUpdateTime(new Date());
            dbOrder.setCountnumber(Integer.valueOf(personIds.length));
            dbOrder.setEffectiveendtime(calendar.getTime());
            dbOrder.setEffectivestarttime(date);
            dbOrder.setAmount(Double.parseDouble(order.getUnitprice()) * (double)dbOrder.getCountnumber().intValue() + "");
            dbOrder.setSendaddress(order.getSendaddress());
            dbOrder.setSignatory(order.getSignatory());
            dbOrder.setTel(order.getTel());
            dbOrder.setRandomOrderNo(DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss"));
            this.orderDao.update(dbOrder);
            OrderPerson orderPerson = new OrderPerson();
            orderPerson.setOrderid(order.getId());
            orderPerson.setUpdateBy(currentUser.getUsername());
            orderPerson.setUpdateTime(new Date());
            this.orderPersonDao.removeByOrderId(orderPerson);
        } else {
            order.setOrdernumber(this.orderNoLogService.getNewOrderNo());
            order.setRandomOrderNo(DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss"));
            order.setCreateTime(new Date());
            order.setUpdateTime(new Date());
            order.setUserid(currentUser.getId());
            order.setUpdateBy(currentUser.getUsername());
            order.setActive(Boolean.valueOf(true));
            order.setCompanyname(company.getName());
            order.setCountnumber(Integer.valueOf(personIds.length));
            order.setEffectiveendtime(calendar.getTime());
            order.setEffectivestarttime(date);
            order.setOrderstate("1");
            order.setPaystate("1");
            order.setOrdertype("1");
            order.setAmount(Double.parseDouble(order.getUnitprice()) * (double)order.getCountnumber().intValue() + "");
            this.orderDao.save(order);
            this.createTransactionByOrderId(order.getId());
        }
        for (Long personId : personIds) {
            SecurityPerson person = this.personDao.findById(personId);
            OrderPerson orderPerson = new OrderPerson();
            orderPerson.setActive(Boolean.valueOf(true));
            orderPerson.setCompanyid(company.getId());
            orderPerson.setCompanyname(company.getName());
            orderPerson.setCreateTime(new Date());
            orderPerson.setName(person.getRealName());
            orderPerson.setOrderid(order.getId());
            orderPerson.setPersonid(personId);
            orderPerson.setPersonlevel(person.getProfessionLevel() == null ? "" : person.getProfessionLevel() + "");
            orderPerson.setPhone(person.getPhone());
            orderPerson.setTrainorgid(order.getTrainorgid());
            orderPerson.setTraintype(order.getTraintype());
            orderPerson.setUpdateBy(currentUser.getUsername());
            orderPerson.setUpdateTime(new Date());
            orderPerson.setIdentitynumber(person.getIdNumber());
            orderPerson.setGroupid(order.getTraintype());
            this.orderPersonDao.save(orderPerson);
        }
    }

    public void createOrderForBxMF(Order order, Long[] personIds, User user) {
        SecurityCompany company = this.companyDao.findByUserid(user.getId());
        order.setCreateTime(new Date());
        order.setUpdateTime(new Date());
        order.setUserid(user.getId());
        order.setCountnumber(Integer.valueOf(personIds.length));
        order.setUpdateBy(user.getUsername());
        order.setActive(Boolean.valueOf(true));
        this.orderDao.save(order);
        Config coninsConfig = this.configService.findByKey("train_url");
        List securityPersonList = personIds.length > 0 ? this.personDao.findBatch(personIds) : new ArrayList();
        if (null != securityPersonList && securityPersonList.size() > 0) {
            ArrayList<OrderPerson> orderPersonList = new ArrayList<OrderPerson>();
            for (SecurityPerson person : securityPersonList) {
                OrderPerson orderPerson = new OrderPerson();
                orderPerson.setActive(Boolean.valueOf(true));
                orderPerson.setCompanyid(company.getId());
                orderPerson.setCompanyname(company.getName());
                orderPerson.setCreateTime(new Date());
                orderPerson.setName(person.getRealName());
                orderPerson.setPhone(person.getPhone());
                orderPerson.setOrderid(order.getId());
                orderPerson.setPersonid(person.getId());
                orderPerson.setPersonlevel(person.getProfessionLevel() + "");
                orderPerson.setIdentitynumber(person.getIdNumber());
                orderPerson.setGroupid(order.getTraintype());
                orderPerson.setUpdateBy(user.getUsername());
                orderPerson.setUpdateTime(new Date());
                orderPerson.setTraintype("2");
                orderPersonList.add(orderPerson);
            }
            this.orderPersonDao.saveBatch(orderPersonList);
            new Thread(() -> {
                for (SecurityPerson person : securityPersonList) {
                    Config groupid = this.configService.findByKey("groupid");
                    String groupidValue = "11";
                    if (groupid != null) {
                        groupidValue = groupid.getValue();
                    }
                    Date date = new Date();
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(date);
                    ((Calendar)calendar).add(1, 1);
                    String url = coninsConfig.getValue() + "/train/systemuser/addauthtrack" + "?identitynumber=" + person.getIdNumber() + "&groupid=" + groupidValue + "&name=" + person.getRealName() + "&mobile=" + person.getPhone() + "&orderID=" + person.getRelation().getCompany().getUser().getUsername() + person.getRelation().getCompany().getUser().getId() + DateUtil.convertDateToString((Date)date, (String)"yyyyMMdd") + "&startdate=" + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd") + "&enddate=" + DateUtil.convertDateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd") + "&companyid=" + person.getRelation().getCompany().getId() + "&companyname=" + person.getRelation().getCompany().getName() + "&tOrderType=1&certificate=" + (person.getProfessionLevel() == null ? "" : person.getProfessionLevel());
                    messageUtils.getJsonByInternet((String)url);
                }
            }).start();
        }
    }

    public void createOrderForBx(Order order, Long[] personIds, User user) {
        SecurityCompany company = this.companyDao.findByUserid(user.getId());
        order.setCreateTime(new Date());
        order.setUpdateTime(new Date());
        order.setUserid(user.getId());
        order.setUpdateBy(user.getUsername());
        order.setActive(Boolean.valueOf(true));
        order.setCountnumber(Integer.valueOf(personIds.length));
        this.orderDao.save(order);
        for (Long personId : personIds) {
            SecurityPerson person = this.personDao.findById(personId);
            OrderPerson orderPerson = new OrderPerson();
            orderPerson.setActive(Boolean.valueOf(true));
            orderPerson.setCompanyid(company.getId());
            orderPerson.setCompanyname(company.getName());
            orderPerson.setCreateTime(new Date());
            orderPerson.setName(person.getRealName());
            orderPerson.setOrderid(order.getId());
            orderPerson.setPersonid(personId);
            orderPerson.setPersonlevel(person.getProfessionLevel() + "");
            orderPerson.setPhone(person.getPhone());
            orderPerson.setIdentitynumber(person.getIdNumber());
            orderPerson.setGroupid("1");
            orderPerson.setUpdateBy(user.getUsername());
            orderPerson.setUpdateTime(new Date());
            this.orderPersonDao.save(orderPerson);
        }
    }

    public void createTransactionByOrderId(Long orderId) {
        User user = this.arsUtil.getCurrentUser();
        Order order = this.findById(orderId);
        OrderTransaction transaction = new OrderTransaction();
        transaction.setActive(Boolean.valueOf(true));
        transaction.setCreateTime(new Date());
        transaction.setOrderid(orderId);
        transaction.setPaystate("1");
        transaction.setSubmitordertime(new Date());
        transaction.setUpdateBy(user.getRealname());
        transaction.setUpdateTime(new Date());
        transaction.setOrdernum(order.getOrdernumber());
        this.orderTransactionDao.save(transaction);
    }

    public Order findByOrderNo(String orderNo) {
        return this.orderDao.findByOrderNo(orderNo);
    }

    public void update(Order order) {
        order.setUpdateTime(new Date());
        this.orderDao.update(order);
    }

    public List<Order> findByUserid(Long userid) {
        return this.orderDao.findByUserid(userid);
    }

    public OrderSearchDto findByTrainorgid(OrderSearchDto dto) {
        OrderSearchDto resultDto = new OrderSearchDto();
        List list = this.orderDao.findByTrainorgid(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.orderDao.countOrder(dto)));
        return resultDto;
    }

    public void sendOrderInfoToFENXIAO(Order order) {
        User user = this.userDao.findById(order.getUserid());
        SecurityCompany company = this.companyDao.findByUserid(order.getUserid());
        TrainOrderVo trainOrder = new TrainOrderVo();
        trainOrder.setAmount(order.getAmount() + "");
        trainOrder.setBuyPolicy("\u662f");
        trainOrder.setDealDate(DateUtil.getCurrentDateTime());
        trainOrder.setEndDate(DateUtil.convertDateToString((Date)order.getEffectiveendtime(), (String)"yyyy-MM-dd HH:mm:ss"));
        trainOrder.setFcy(order.getAmount() + "");
        trainOrder.setName(order.getGoodsname());
        trainOrder.setNumber(order.getCountnumber() + "");
        trainOrder.setOrderDate(DateUtil.convertDateToString((Date)order.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        trainOrder.setOrderNo(order.getOrdernumber());
        trainOrder.setPaymentDate(DateUtil.getCurrentDateTime());
        trainOrder.setPaymentStage("1");
        trainOrder.setPaymentType("\u94f6\u8054");
        trainOrder.setPurchaser(user.getRealname());
        trainOrder.setSign("ARS");
        trainOrder.setStartDate(DateUtil.convertDateToString((Date)order.getEffectivestarttime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (order.getTrainorgid() == 100L) {
            trainOrder.setCompanyId("857766457153536000");
            trainOrder.setVenue("851309406021816320");
        } else if (order.getTrainorgid() == 200L) {
            trainOrder.setCompanyId("859346883567841280");
            trainOrder.setVenue("851309406021816320");
        } else if (order.getTrainorgid() == 300L) {
            trainOrder.setCompanyId("859302890435952640");
            trainOrder.setVenue("851309407473045504");
        }
        HashMap<String, TrainOrderVo> map = new HashMap<String, TrainOrderVo>();
        map.put("reportVo", trainOrder);
        String url = ThirdPartyURL.FENXIAO + "/api/interaction/policy/saveInsOrderFormForRest";
        try {
            String resultStr = messageUtils.doPost2((String)url, (String)messageUtils.packageMap(map, (String)"ARS"));
            String status = messageUtils.getStringValueByKey((String)resultStr, (String)"status");
            if (StringUtil.isNotEmpty((String)status) && "200".equals(status)) {
                System.out.print("\u6210\u529f");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void orderCancel(Long orderId) {
        Order dbOrder = this.orderDao.findById(orderId);
        dbOrder.setOrderstate("2");
        dbOrder.setUpdateTime(new Date());
        this.orderDao.update(dbOrder);
    }

    public List<Order> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.orderDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(Order order) {
        if (order.getActive() == null) {
            order.setActive(Boolean.valueOf(true));
        }
        if (!order.getActive().booleanValue()) {
            this.orderDao.delete(order);
        } else {
            Order dbOrder = this.orderDao.findById(order.getId());
            if (dbOrder == null) {
                this.orderDao.saveForDS(order);
            } else if (order.getUpdateTime().getTime() > dbOrder.getUpdateTime().getTime()) {
                this.orderDao.update(order);
            }
        }
    }

    public Order findByRandomOrderNo(String orderNo) {
        return this.orderDao.findByRandomOrderNo(orderNo);
    }

    public AjaxResult checkExistOrderByPersonIds(Long[] personIds, String traintype) {
        AjaxResult result = new AjaxResult();
        List personList = this.orderDao.checkExistOrderByPersonIds(personIds, traintype);
        if (personList != null && personList.size() > 0) {
            result.setData((Object)personList);
            result.setSuccessful(false);
        } else {
            result.setSuccessful(true);
        }
        return result;
    }

    public void personTrainInit() {
        DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
        searchDto.setPaging(false);
        searchDto.setStartDate(DateUtil.getYesterday());
        searchDto.setEndDate(DateUtil.getTomorrow());
        List personList = this.personDao.findAll(searchDto);
        Config coninsConfig = this.configService.findByKey("train_url");
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(1, 1);
        for (SecurityPerson person : personList) {
            Config groupid = this.configService.findByKey("groupid");
            String groupidValue = "11";
            if (groupid != null) {
                groupidValue = groupid.getValue();
            }
            if (person.getRelation() == null || person.getRelation().getCompany() == null) continue;
            String url = coninsConfig.getValue() + "/train/systemuser/addauthtrack" + "?identitynumber=" + person.getIdNumber() + "&groupid=" + groupidValue + "&name=" + person.getRealName() + "&mobile=" + person.getPhone() + "&orderID=" + person.getRelation().getCompany().getUser().getUsername() + person.getRelation().getCompany().getUser().getId() + "&startdate=" + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd HH:mm:ss") + "&enddate=" + DateUtil.convertDateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss") + "&companyid=" + person.getRelation().getCompany().getId() + "&companyname=" + person.getRelation().getCompany().getName() + "&tOrderType=1&certificate=" + (person.getProfessionLevel() == null ? "" : person.getProfessionLevel());
            messageUtils.getJsonByInternet((String)url);
        }
    }
}

