/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.gx;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.gx.InternetPlusBusinessDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.gx.InternetPlusBusiness;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.gx.InterfaceNoticeService;
import com.bcxin.ars.util.gx.HttpClientUtil;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InterfaceNoticeServiceImpl
implements InterfaceNoticeService {
    private static String url = "http://71.4.152.20/gzmhgxhlwService/gzmh/ars-rest/callback";
    private static final Logger logger = LoggerFactory.getLogger(InterfaceNoticeServiceImpl.class);
    @Autowired
    ApprovalDAO approvalDAO;
    @Autowired
    PoliceDao policeDao;
    @Autowired
    InternetPlusBusinessDao internetPlusBusinessDao;

    public void approvalNotice(Approval approval) {
        try {
            InternetPlusBusiness internetPlusBusiness = this.internetPlusBusinessDao.findByBusinessId(approval.getBusinessid());
            if (internetPlusBusiness == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sdono", (Object)internetPlusBusiness.getSdono());
            if (approval != null) {
                if (approval.getApprovalstate().equals("002")) {
                    jsonObject.put("status", (Object)"0");
                } else if (approval.getApprovalstate().equals("005")) {
                    jsonObject.put("status", (Object)"0");
                } else if (approval.getApprovalstate().equals("003")) {
                    jsonObject.put("status", (Object)"31");
                } else if (approval.getApprovalstate().equals("004")) {
                    jsonObject.put("status", (Object)"3");
                }
                jsonObject.put("reason", (Object)approval.getApprovalreason());
                Police police = this.policeDao.findById(approval.getOrgid());
                jsonObject.put("dealUnit", (Object)police.getOrgname());
                jsonObject.put("dealUnitCode", (Object)police.getCode());
                jsonObject.put("dealPoliceName", (Object)approval.getApprovalperson());
                jsonObject.put("dealPolciePid", (Object)"");
                jsonObject.put("dealPoliceNo", (Object)"");
                jsonObject.put("dealUserId", (Object)approval.getUpdateBy());
                jsonObject.put("dealPoliceTel", (Object)"");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String updateTime = simpleDateFormat.format(approval.getUpdateTime());
                jsonObject.put("rebackDate", (Object)updateTime);
            }
            logger.info("\u5ba1\u6279\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a" + jsonObject);
            String result = HttpClientUtil.doPost((String)url, (JSONObject)jsonObject, (String)"UTF-8");
            logger.info("\u5ba1\u6279\u901a\u77e5\u54cd\u5e94\u53c2\u6570\uff1a" + result);
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u901a\u77e5httpclient error:" + e.getMessage());
        }
    }
}

