/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersoncertificateAppealHandle
implements AppealHandle {
    private static Logger logger = LoggerFactory.getLogger(PersoncertificateAppealHandle.class);
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;
    @Autowired
    private ConfigUtils configUtils;

    public void handle(Appeal appeal) {
        Personcertificate personcertificate = this.personcertificateDao.findById(appeal.getBusinessid());
        if ("003".equals(appeal.getAppealState())) {
            personcertificate.setApprovalstate("005");
            if ("11".equals(this.configUtils.getCurrentNative()) || "61".equals(this.configUtils.getCurrentNative())) {
                personcertificate.setCensorStatus("006");
            } else {
                personcertificate.setCensorStatus("003");
            }
            personcertificate.setApprovalreason(null);
            personcertificate.setUpdateTime(new Date());
        } else if ("004".equals(appeal.getAppealState())) {
            personcertificate.setApprovalstate("004");
            if ("11".equals(this.configUtils.getCurrentNative()) || "61".equals(this.configUtils.getCurrentNative())) {
                personcertificate.setCensorStatus("007");
            } else {
                personcertificate.setCensorStatus("004");
            }
            personcertificate.setApprovalreason(appeal.getAppealReson());
            personcertificate.setUpdateTime(new Date());
        }
        this.personcertificateDaoAop.update(personcertificate);
        if (!this.configUtils.getCurrentNative().equals("61")) {
            this.syncToBKT(personcertificate);
        } else if (personcertificate.getCity().equals("610600") || personcertificate.getCity().equals("611000")) {
            this.syncToBKT(personcertificate);
        }
    }

    public void syncToBKT(Personcertificate personcertificate) {
        JSONArray paramArr = new JSONArray();
        JSONObject param = new JSONObject();
        param.put("qualifyApplyId", (Object)(personcertificate.getId() + ""));
        param.put("backgroundStatus", (Object)personcertificate.getCensorStatus());
        param.put("approvalState", (Object)personcertificate.getApprovalstate());
        param.put("backgroundFailReason", (Object)personcertificate.getApprovalreason());
        param.put("backgroundType", (Object)"2");
        paramArr.add((Object)param);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("personList", JSON.toJSONString((Object)paramArr));
        AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/qualify/person/backgroundStatus", paramMap);
        if (!result.isSuccessful()) {
            logger.error("\u3010\u8d44\u683c\u8bc1\u62a5\u540d\u7533\u8bc9\u7ed3\u679c\u3011" + result.getMsg());
        }
    }

    public void handle(List<Appeal> list) {
        if (list != null && list.size() > 0) {
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            ArrayList<Personcertificate> personcertificateList = new ArrayList<Personcertificate>();
            for (Appeal appeal : list) {
                this.handle(appeal);
                Personcertificate personcertificate = this.personcertificateDao.findById(appeal.getBusinessid());
                if ("003".equals(appeal.getAppealState())) {
                    personcertificate.setApprovalstate("005");
                    if ("11".equals(this.configUtils.getCurrentNative()) || "61".equals(this.configUtils.getCurrentNative())) {
                        personcertificate.setCensorStatus("006");
                    } else {
                        personcertificate.setCensorStatus("003");
                    }
                    personcertificate.setApprovalreason(null);
                    personcertificate.setUpdateTime(new Date());
                } else if ("004".equals(appeal.getAppealState())) {
                    personcertificate.setApprovalstate("004");
                    if ("11".equals(this.configUtils.getCurrentNative()) || "61".equals(this.configUtils.getCurrentNative())) {
                        personcertificate.setCensorStatus("007");
                    } else {
                        personcertificate.setCensorStatus("004");
                    }
                    personcertificate.setApprovalreason(appeal.getAppealReson());
                    personcertificate.setUpdateTime(new Date());
                }
                param = new JSONObject();
                param.put("qualifyApplyId", (Object)(personcertificate.getId() + ""));
                param.put("backgroundStatus", (Object)personcertificate.getCensorStatus());
                param.put("approvalState", (Object)personcertificate.getApprovalstate());
                param.put("backgroundFailReason", (Object)personcertificate.getApprovalreason());
                param.put("backgroundType", (Object)"2");
                if (!this.configUtils.getCurrentNative().equals("61")) {
                    paramArr.add((Object)param);
                } else if (personcertificate.getCity().equals("610600") || personcertificate.getCity().equals("611000")) {
                    paramArr.add((Object)param);
                }
                personcertificateList.add(personcertificate);
            }
            if (paramArr.size() > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("personList", JSON.toJSONString((Object)paramArr));
                AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/qualify/person/backgroundStatus", paramMap);
                if (!result.isSuccessful()) {
                    logger.error("\u3010\u8d44\u683c\u8bc1\u62a5\u540d\u7533\u8bc9\u7ed3\u679c\u3011" + result.getMsg());
                }
            }
            this.personcertificateDaoAop.updateBatch(personcertificateList);
        }
    }
}

