package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.*;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.huawei.HttpBuildUtil;
import com.bcxin.ars.util.huawei.HuaweiMeetConst;
import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author linqinglin
 * @date 2019/12/19 0019 16:12
 */
@Component
public class HuaweiMeetUtil {

    private static Logger logger = LoggerFactory.getLogger(HuaweiMeetUtil.class);

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ConfigUtils configUtils;

    @Value("${heiweiPrefixKey}")
    private String heiweiPrefixKey;

    /**
     * 调华为云接口
     * @param url 接口地址
     * @param paramObj 传参
     * @param superAdmin 是否云会议超管账号（定时器使用超管账号）
     */
    public AjaxResult callInterface(String method,String url , Map<String, String> headMap,Object paramObj, boolean superAdmin){
        //对象转map
        Map<String,Object> paramMap = BeanUtil.beanToMap(paramObj);
        return callInterface(method,url,headMap,paramMap,superAdmin);
    }
    /****
     * 用户查询自己的信息
     * @return
     */
    public QueryUserResultDTO getConferenceUserInfo(){
        //返回对象
        QueryUserResultDTO resultDto =null;
        //请求路径
        String url = HuaweiMeetConst.GATEWAY_URL +HuaweiMeetConst.GET_USERMENBER;
        Map<String,String> paramMap = new HashedMap();
        //华为云会议超管帐号信息
        String account = StringUtil.EMPTY;
        String password = StringUtil.EMPTY;
        Long userId = Constants.HeiweiconferenceUserId;
        ConferenceAccount conferenceAccount = arsUtil.getConferenceAccount();
        if (conferenceAccount == null) {
            throw new ArsException("账号有误，该账号未开通华为云会议权限！");
        }
        account = conferenceAccount.getAccount();
        password = conferenceAccount.getPassword();
        //用户ID
        userId = Constants.HeiweiconferenceUserId;
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        try {
            // 获取华为云会议的accessToken
            String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
            String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());
            paramMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(Constants.METHOD_GET, paramMap, JSON.toJSONString(paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            resultDto = JSON.parseObject(response.getEntity().toString(), QueryUserResultDTO.class);
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
            }else {
                interfaceLog.setResult(e.getMessage());
            }
        }
        interfaceLog.setUpdateTime(new Date());
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();
        return resultDto;
    }
    /****
     * V1调华为云接口
     * @param method 方法
     * @param url
     * @param headMap 头部参数
     * @param paramMap 请求参数
     * @return
     */
    public AjaxResult callInterfaceCloudV1(String method,String url , Map<String, String> headMap, Map<String,Object> paramMap){
        url = HuaweiMeetConst.GATEWAY_URL + url;

        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;

        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }

        try {
            //调用华为云会议接口
            if(headMap == null) {
                headMap = new HashMap<>();
                String account = StringUtil.EMPTY;
                String password = StringUtil.EMPTY;
                Long userId = Constants.HeiweiconferenceUserId;
                ConferenceAccount conferenceAccount = arsUtil.getConferenceAccount();
                if (conferenceAccount == null) {
                    throw new ArsException("账号有误，该账号未开通华为云会议权限！");
                }
                account = conferenceAccount.getAccount();
                password = conferenceAccount.getPassword();
                userId = conferenceAccount.getUserid();

                // 获取华为云会议的accessToken
                String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
                String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());
                headMap.put("Authorization", "Basic " + authorization);
            }
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap, JSON.toJSONString(paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            List<ConferenceInfo> resultDto = JSONArray.parseArray(response.getEntity().toString(),ConferenceInfo.class);
            /**********0 代表接口返回成功 **********/
            if (resultDto!=null   && resultDto.size()>0) {
                data = resultDto.get(0);
            } else {
                result = false;
            }
        }catch (Exception e){
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }else {
                msg = e.getMessage();
                interfaceLog.setResult(msg);
            }
        }
        interfaceLog.setUpdateTime(new Date());
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }


    /***
     * V1版本调华为云接口
     * @param method 方法
     * @param url
     * @param headMap 头部参数
     * @param paramMap 请求参数
     * @param superAdmin 是否超管
     * @return
     */
    public AjaxResult callInterfaceV1(String method,String url , Map<String, String> headMap, Map<String,Object> paramMap, boolean superAdmin){
        url = HuaweiMeetConst.GATEWAY_URL + url;

        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;

        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }

        try {
            //调用华为云会议接口
            if(headMap == null) {
                headMap = new HashMap<>();
                String account = StringUtil.EMPTY;
                String password = StringUtil.EMPTY;
                Long userId = Constants.HeiweiconferenceUserId;
                if(superAdmin){
                    account = configUtils.getValueByKey(Constants.HeiweiconferenceAccount);
                    password = configUtils.getValueByKey(Constants.HeiweiconferencePassword);
                    userId = Constants.HeiweiconferenceUserId;
                }else {
                    ConferenceAccount conferenceAccount = arsUtil.getConferenceAccount();
                    if (conferenceAccount == null) {
                        throw new ArsException("账号有误，该账号未开通华为云会议权限！");
                    }
                    account = conferenceAccount.getAccount();
                    password = conferenceAccount.getPassword();
                    userId = conferenceAccount.getUserid();
                }

                // 获取华为云会议的accessToken
                String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
                String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());
                headMap.put("Authorization", "Basic " + authorization);
            }
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap, JSON.toJSONString(paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            List<ConferenceInfo> resultDto = JSONArray.parseArray(response.getEntity().toString(),ConferenceInfo.class);
            /**********0 代表接口返回成功 **********/
            if (resultDto!=null   && resultDto.size()>0) {
                data = resultDto.get(0);
            } else {
                result = false;
            }
        }catch (Exception e){
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }else {
                msg = e.getMessage();
                interfaceLog.setResult(msg);
            }
        }
        interfaceLog.setUpdateTime(new Date());
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }

    /***
     * 查询历史会议列表
     * @param method 方法
     * @param url
     * @param paramMap 请求参数
     * @return
     */
    public AjaxResult callInterfaceV1History(String method,String url ,Map<String,String> paramMap){
        url = HuaweiMeetConst.GATEWAY_URL + url;
        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //调用华为云会议接口
            Map<String, String> headMap = new HashMap<>();
            String account = configUtils.getValueByKey(Constants.HeiweiconferenceAccount);
            String password = configUtils.getValueByKey(Constants.HeiweiconferencePassword);
            Long userId = Constants.HeiweiconferenceUserId;
            // 获取华为云会议的accessToken
            String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap,null,paramMap);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            RestListConfResponse resultDto = JSON.parseObject(response.getEntity().toString(), RestListConfResponse.class);
            /**********0 代表接口返回成功 **********/
            if (resultDto!=null) {
                data = resultDto.getData();
            } else {
                result = false;
            }
        }catch (Exception e){
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }else {
                msg = e.getMessage();
                interfaceLog.setResult(msg);
            }
        }
        interfaceLog.setUpdateTime(new Date());
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }
    /***
     * V1版本调华为云接口录播文件
     * @param method 方法
     * @param url
     * @param paramMap 请求参数
     * @return
     */
    public AjaxResult callInterfaceV1Record(String method,String url ,Map<String,String> paramMap){
        url = HuaweiMeetConst.GATEWAY_URL + url;
        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //调用华为云会议接口
            Map<String, String> headMap = new HashMap<>();
            String account = configUtils.getValueByKey(Constants.HeiweiconferenceAccount);
            String password = configUtils.getValueByKey(Constants.HeiweiconferencePassword);
            Long userId = Constants.HeiweiconferenceUserId;
            // 获取华为云会议的accessToken
            String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap, null,paramMap);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            PageRecordFile resultDto = JSON.parseObject(response.getEntity().toString(), PageRecordFile.class);
            /**********0 代表接口返回成功 **********/
            if (resultDto!=null) {
                data = resultDto;
            } else {
                result = false;
            }
        }catch (Exception e){
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }else {
                msg = e.getMessage();
                interfaceLog.setResult(msg);
            }
        }
        interfaceLog.setUpdateTime(new Date());
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }

    public AjaxResult callInterfaceV2Record(String method,String url ,Map<String,String> paramMap,ConferenceAccount conferenceAccount){
        url = HuaweiMeetConst.GATEWAY_URL + url;
        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //调用华为云会议接口
            Map<String, String> headMap = new HashMap<>();
            String account = conferenceAccount.getAccount();
            String password = conferenceAccount.getPassword();
            Long userId = conferenceAccount.getUserid();
            // 获取华为云会议的accessToken
            String accessToken =arsUtil.getHuaweiMeetSelfAccessToken(account,password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap, null,paramMap);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            PageRecordFile resultDto = JSON.parseObject(response.getEntity().toString(), PageRecordFile.class);
            /**********0 代表接口返回成功 **********/
            if (resultDto!=null) {
                data = resultDto;
            } else {
                result = false;
            }
        }catch (Exception e){
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }else {
                msg = e.getMessage();
                interfaceLog.setResult(msg);
            }
        }
        interfaceLog.setUpdateTime(new Date());
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }
    /***
     * V1版本调华为云接口资源使用情况查询
     * @param method 方法
     * @param url
     * @return
     *//*
    public AjaxResult callInterfaceV1Resourse(String method,String url){
        url = HuaweiMeetConst.GATEWAY_URL + url;
        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        //日志
        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //调用华为云会议接口
            Map<String,String> headMap = new HashMap<>();
            String account = configUtils.getValueByKey(Constants.HeiweiconferenceAccount);
            String password = configUtils.getValueByKey(Constants.HeiweiconferencePassword);
            Long userId = Constants.HeiweiconferenceUserId;
            // 获取华为云会议的accessToken
            String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap, null,null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            JSONObject jsonObj = JSONObject.parseObject(response.getEntity().toString());
            String recordCapability = jsonObj.getString("recordCapability");
            ResDetailDTO resultDto = JSON.parseObject(recordCapability, ResDetailDTO.class);
            *//**********0 代表接口返回成功 **********//*
            if (resultDto!=null) {
                data = resultDto;
            } else {
                result = false;
            }
        }catch (Exception e){
            result = false;
            logger.error(e.getMessage(),e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        *//**
         * 异步保存
         *//*
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }*/
    /***
     * V1版本调华为云接口删除录播文件
     * @param method 方法
     * @param url
     * @param paramMap 请求参数
     * @return
     */
    public AjaxResult callInterfaceV1ReDe(String method,String url , Map<String,String> paramMap){
        url = HuaweiMeetConst.GATEWAY_URL + url;

        String msg = StringUtil.EMPTY;
        Boolean result = true;
        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //调用华为云会议接口
            Map<String, String> headMap = new HashMap<>();
            String account = configUtils.getValueByKey(Constants.HeiweiconferenceAccount);
            String password = configUtils.getValueByKey(Constants.HeiweiconferencePassword);
            Long userId = Constants.HeiweiconferenceUserId;
            // 获取华为云会议的accessToken
            String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap, null,paramMap);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            //非200请求失败
            if(response.getHttpCode() != 200){
                result = false;
            }
        }catch (Exception e){
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }else {
                msg = e.getMessage();
                interfaceLog.setResult(msg);
            }
        }
        interfaceLog.setUpdateTime(new Date());
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg);
    }


    /***
     * 调华为云接口
     * @param method 方法
     * @param url
     * @param headMap 头部参数
     * @param paramMap 请求参数
     * @param superAdmin 是否超管
     * @return
     */
    public AjaxResult callInterface(String method,String url , Map<String, String> headMap, Map<String,Object> paramMap, boolean superAdmin){
        url = HuaweiMeetConst.GATEWAY_URL + url;

        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;

        User currentUser = arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }

        try {
            //调用华为云会议接口
            if(headMap == null) {
                headMap = new HashMap<>();
                String account = StringUtil.EMPTY;
                String password = StringUtil.EMPTY;
                Long userId = Constants.HeiweiconferenceUserId;
                if(superAdmin){
                    account = configUtils.getValueByKey(Constants.HeiweiconferenceAccount);
                    password = configUtils.getValueByKey(Constants.HeiweiconferencePassword);
                    userId = Constants.HeiweiconferenceUserId;
                }else {
                    ConferenceAccount conferenceAccount = arsUtil.getConferenceAccount();
                    if (conferenceAccount == null) {
                        throw new ArsException("账号有误，该账号未开通华为云会议权限！");
                    }
                    account = conferenceAccount.getAccount();
                    password = conferenceAccount.getPassword();
                    userId = conferenceAccount.getUserid();
                }

                // 获取华为云会议的accessToken
                String accessToken =arsUtil.getHuaweiMeetAccessToken(account,password, userId);
                String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());
                headMap.put("Authorization", "Basic " + authorization);
            }
            RestRequest restRequest = HttpBuildUtil.buildRestRequest(method, headMap, JSON.toJSONString(paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            interfaceLog.setResult(response.getEntity());
            HuaWeiResultDto resultDto = JSON.parseObject(response.getEntity().toString(), HuaWeiResultDto.class);
            /**********0 代表接口返回成功 **********/
            if (ObjectUtil.equal(resultDto.getReturnCode(), 0)) {
                 data = resultDto.getData();
            } else {
                result = false;
                msg = resultDto.getReturnDesc();
            }
        }catch (Exception e){
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            if(StringUtil.isNotEmpty(interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }else {
                msg = e.getMessage();
                interfaceLog.setResult(msg);
            }
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result);
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "调用华为云会议接口失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }

    public static void main(String[] args) {
        String json ="{\"te1080pHardCount\":{\"sumCount\":0,\"usedCount\":0},\"te720pHardCount\":{\"sumCount\":0,\"usedCount\":0},\"teSoftCount\":{\"sumCount\":10,\"usedCount\":9},\"roomCount\":{\"sumCount\":0,\"usedCount\":0},\"recordCapability\":{\"sumCount\":20,\"usedCount\":0},\"confCallCount\":{\"sumCount\":2,\"usedCount\":0},\"liveCount\":{\"sumCount\":0,\"usedCount\":0},\"thirdPartyHardCount\":{\"sumCount\":0,\"usedCount\":0},\"vmr\":[],\"enablePstn\":false,\"enableSMS\":true,\"enableHybridCloud\":false,\"enableCloudDisk\":null,\"enableUc\":true}";
        //方法一
        JSONObject jsonObj = JSONObject.parseObject(json);
        String recordCapability = jsonObj.getString("recordCapability");
        ResDetailDTO resultDto = JSON.parseObject(recordCapability, ResDetailDTO.class);
        System.out.println(resultDto);
    }
}
