package com.bcxin.ars.service.task.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.task.TaskPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.service.task.TaskPersonService;

@Service
@Transactional
public class TaskPersonServiceImpl implements TaskPersonService {

	@Autowired
	private TaskPersonDao taskPersonDao;
	
	@Override
	public List<TaskPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return taskPersonDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public TaskPerson findByTaskIdPersonId(Long taskId,Long personId){
		return taskPersonDao.findByTaskIdPersonId(taskId,personId);
	}

	/**
	 * 查询部分字段
	 * @param taskId
	 * @param personId
	 * @return
	 */
	@Override
	public TaskPerson findStatusByTaskIdPersonId(Long taskId,Long personId){
		return taskPersonDao.findStatusByTaskIdPersonId(taskId,personId);
	}
}
