package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.sys.SysDataChangeLogDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.SysDataChangeLog;
import com.bcxin.ars.service.sys.SysDataChangeLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2019/08/13 0013 15:47
 */
@Service
@Transactional
//@DataSyncOutAnnotation(getClazz = SysDataChangeLog.class)
public class SysDataChangeLogServiceImpl implements SysDataChangeLogService {

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Autowired
    private SysDataChangeLogDao sysDataChangeLogDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public void save(SysDataChangeLog detail) {
        User currentUser = arsUtil.getCurrentUser();
        detail.setActive(true);
        detail.setId(idGeneratorUtil.createID());
        detail.setCreateTime(new Date());
        detail.setUpdateTime(new Date());
        detail.setUpdateflag(true);
        detail.setUpdateBy(currentUser == null ? "system":currentUser.getUsername());
        sysDataChangeLogDao.save(detail);
    }

    @Override
    public void importBatch(List<SysDataChangeLog> list) {
        sysDataChangeLogDao.saveBatch(list);
    }

    @Override
    public List<SysDataChangeLog> findDSOutList(String startDate) {
        List<SysDataChangeLog> list = sysDataChangeLogDao.searchFromInToOutForExport(startDate);
        if(list.size() > 0){
            sysDataChangeLogDao.updateFlag(list);
        }
        return list;
    }
}
