package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.SyncFailLogDao;
import com.bcxin.ars.dao.sys.SyncDataDao;
import com.bcxin.ars.dto.ExportModelDTO;
import com.bcxin.ars.dto.ModelNameDTO;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.SyncFailLog;
import com.bcxin.ars.model.sys.ConfigSyncData;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SyncDataService;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

/**
 * 数据同步公共service
 * by llc 2018-08-30
 */
@Service(value = "syncDataService")
@Transactional
public class SyncDataServiceImpl implements SyncDataService {
    private Logger logger = LoggerFactory.getLogger(SyncDataServiceImpl.class);

    @Autowired
    private SyncDataDao syncDataDao;
    @Autowired
    private SyncFailLogDao syncFailLogDao;

    @Autowired
    private ConfigService configService;

    @Value("${ftp-folder}")
    private String ftpFolder;
    @Value("${ftp-temp-folder}")
    private String tempftpFolder;


    /**
     * 同步数据方法
     * by llc 2018-09-03
     */
    @Override
    public void syncData() {

        long startTime = System.currentTimeMillis();

        /*** 如果是公安外网需要取邮件发送信息 ***/
        Config police = configService.findByKey("police");
        Config syncDataNotifier = new Config();
        Config currentEnvi = new Config();
        if (police != null && police.getValue().equals("0")) {
            syncDataNotifier = configService.findByKey("syncDataNotifier");
            currentEnvi = configService.findByKey("current_native_name");
        }
        EmailUtils email = new EmailUtils();

        String currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();

        /** 获取 ConfigSyncDataList ***/
        List<ConfigSyncData> configList = syncDataDao.getConfigSyncDataList();
        //这个是获取同步批次id？作用？
        Long syncBatchId = syncDataDao.getNextVal("seq_syncBatchId");

        List<Map<String, Object>> resultList = new ArrayList<>();

        Boolean isSuccess = true;

        /*** 获取文件夹最新的压缩包 ***/

        /*** 解压压缩包里 ***/

        /*** 获取压缩包里的数据文件 ***/

        /***  注入SyncDataDao ***/
        Object obj = SpringUtils.getBean(SyncDataDao.class);
        Class<?> c = obj.getClass();

        List<Map<String, Object>> syncRecode = new ArrayList<>();
        //为啥放在D盘
        String file = "D:\\syncData.zip";
        try {
            ZipFile zf = new ZipFile(file);
            InputStream in = new BufferedInputStream(new FileInputStream(file));
            ZipInputStream zin = new ZipInputStream(in);
            ZipEntry ze;

            while ((ze = zin.getNextEntry()) != null) {
                if (ze.isDirectory()) {
                } else {
//                    System.out.println("file - " + ze.getName());
                    BufferedReader br = new BufferedReader(
                            new InputStreamReader(zf.getInputStream(ze)));
                    String line;
                    char[] buff = new char[1024];
                    StringBuffer content = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        content.append(line);
                    }
                    br.close();

                    /***  解密数据文件 ***/
                    String datajsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));

                    List dataList = JSONArray.parseArray(datajsonStr, Map.class);
                    String fileName = ze.getName().substring(0, ze.getName().indexOf(".data"));

                    String tableName = "";
                    try {

                        for (ConfigSyncData config : configList) {

                            /*** 文件去除后缀 ***/

                            /*** 压缩包里存在文件才执行同步 ***/
                            if (fileName.equals(config.getFileName())) {
                                tableName = config.getTableName();

                                Method method = c.getMethod(config.getInsertSyncFun(), List.class, Long.class);
                                /**** 由于数据量太大导致java内存溢出 ,这里分批插入 ****/
                                int insertLength = dataList.size();
                                int i = 0;
                                while (insertLength > 500) {
                                    method.invoke(obj, new Object[]{dataList.subList(i, i + 500), syncBatchId});
                                    i = i + 500;
                                    insertLength = insertLength - 500;
                                }
                                if (insertLength > 0) {
                                    method.invoke(obj, new Object[]{dataList.subList(i, i + insertLength), syncBatchId});
                                }


                                Map<String, Object> param = new HashMap<String, Object>();

                                Map<String, Object> result = new HashMap<String, Object>();

                                param.put("syncBatchId", syncBatchId);

                                /*** 插入新数据 ***/
                                param.put("sql", config.getInsertSql());
                                int insertCount = syncDataDao.executeInsertSql(param);

                                /*** 更新数据 ***/
                                param.remove("sql");
                                param.put("sql", config.getUpdateSql());
                                int updateCount = syncDataDao.executeUpdateSql(param);

                                /*** 删除同步临时表数据 ***/
                                param.remove("sql");
                                param.put("sql", config.getDeleteSql());
                                syncDataDao.executeDeleteSql(param);

                                /***  同步结果 ***/
                                result.put("tableName", tableName);
                                result.put("insertCount", insertCount);
                                result.put("updateCount", updateCount);
                                resultList.add(result);
                                break; // 跳出循环
                            }
                        }
                    } catch (Exception e) {
                        isSuccess = false;
                        e.printStackTrace();
                        /***  邮件通知 ***/
                        if (police != null && police.getValue().equals("0")) {
                            if (syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                                email.sendEmail("百保盾外网同步表出错",
                                        "同步环境:【" + currentEnviName + "外网" + "】\n" +
                                                "文件名:【" + fileName + "】\n" +
                                                "表名:【" + tableName + "】\n" +
                                                "异常信息" + e.getMessage().toString(),
                                        syncDataNotifier.getValue());
                            }
                        }
                    }
                }
            }
            zin.closeEntry();
            zin.close();
            zf.close();
            in.close();
        } catch (Exception e) {
            isSuccess = false;
            e.printStackTrace();
            /***  邮件通知 ***/
            if (police != null && police.getValue().equals("0")) {
                if (syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                    email.sendEmail("百保盾外网解压压缩包出错",
                            "同步环境:【" + currentEnviName + "外网" + "】\n" +
                                    "文件名:【" + file + "】\n" +
                                    "异常信息:【" + e.getMessage().toString() + "】",
                            syncDataNotifier.getValue());
                }
            }
        }
        if (isSuccess) {
            long endTime = System.currentTimeMillis();

            String jsonStr = JSON.toJSONString(resultList, SerializerFeature.WriteMapNullValue);

            jsonStr = jsonStr.replace("tableName", "同步表名").replace("insertCount", "插入记录").replace("updateCount", "更新记录");

            /***  同步完成邮件通知 ***/
            if (police != null && police.getValue().equals("0")) {
                if (syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                    email.sendEmail("百保盾外网成功同步文件",
                            " 同步环境:【" + currentEnviName + "外网" + "】\n" +
                                    "同步耗时:【" + (endTime - startTime) + "ms" + "】\n" +
                                    "文件名:【" + file + "】\n" +
                                    "同步详情:【" + jsonStr + "】",
                            syncDataNotifier.getValue());
                }
            }
            System.out.println("当前程序耗时：" + (endTime - startTime) + "ms");
        }
    }


    /**
     * 同步数据方法
     * by zjh 2018-09-03 （使用java生成语句）
     */
    @Override
    public void syncDataByJava(String datajsonStr, File fs) {

        long startTime = System.currentTimeMillis();

        /*** 如果是公安外网需要取邮件发送信息 ***/
        Config police = configService.findByKey("police");
        Config syncDataNotifier = new Config();
        Config currentEnvi = new Config();
        if (police != null && police.getValue().equals("0")) {
            syncDataNotifier = configService.findByKey("syncDataNotifier");
            currentEnvi = configService.findByKey("current_native_name");
        }
        EmailUtils email = new EmailUtils();

        String currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();

        /** 获取 ConfigSyncDataList ***/
        List<ConfigSyncData> configList = syncDataDao.getConfigSyncDataList();
        //这个是获取同步批次id？作用？
        Long syncBatchId = syncDataDao.getNextVal("seq_syncBatchId");

        List<Map<String, Object>> resultList = new ArrayList<>();

        Boolean isSuccess = true;

        /*** 获取文件夹最新的压缩包 ***/

        /*** 解压压缩包里 ***/

        /*** 获取压缩包里的数据文件 ***/

        /***  注入SyncDataDao ***/
        Object obj = SpringUtils.getBean(SyncDataDao.class);
        Class<?> c = obj.getClass();
        SyncFailLog syncFailLog = new SyncFailLog();
        Date date = new Date();
        syncFailLog.setCreateTime(date);
        syncFailLog.setUpdateTime(date);
        syncFailLog.setUpdateBy("syncAdmin");
        syncFailLog.setActive(true);
        List<Map<String, Object>> syncRecode = new ArrayList<>();

        List dataList = JSONArray.parseArray(datajsonStr, Map.class);
        String fileName = fs.getName().substring(0, fs.getName().indexOf("_"));

        String tableName = "";
        try {

            for (ConfigSyncData config : configList) {

                /*** 文件去除后缀 ***/

                /*** 压缩包里存在文件才执行同步 ***/
                if (fileName.equals(config.getFileName())) {
                    tableName = config.getTableName();

                    Method method = c.getMethod(config.getInsertSyncFun(), List.class, Long.class);
                    /**** 由于数据量太大导致java内存溢出 ,这里分批插入 ****/
                    int insertLength = dataList.size();
                    int i = 0;
                    while (insertLength > 500) {
                        method.invoke(obj, new Object[]{dataList.subList(i, i + 500), syncBatchId});
                        i = i + 500;
                        insertLength = insertLength - 500;
                    }
                    if (insertLength > 0) {
                        method.invoke(obj, new Object[]{dataList.subList(i, i + insertLength), syncBatchId});
                    }


                    Map<String, Object> param = new HashMap<String, Object>();

                    Map<String, Object> result = new HashMap<String, Object>();
                    param = this.getColumn(Class.forName(config.getJavaObjectUrl()));
                    if (param != null) {


                        param.put("syncBatchId", syncBatchId);


                        param.put("tableName", tableName);
                        param.put("syncTableName", config.getSyncTableName());
                        int insertCount = syncDataDao.insertSql(param);

                        /*** 更新数据 ***/

                        int updateCount = syncDataDao.updateSql(param);

                        syncDataDao.deleteSql(param);

                        /***  同步结果 ***/
                        result.put("tableName", tableName);
                        result.put("insertCount", insertCount);
                        result.put("updateCount", updateCount);
                        resultList.add(result);
                        break; // 跳出循环
                    } else {
                        syncFailLog.setErrorMessage("百保盾外网同步表出错：" +
                                "同步环境:【" + currentEnviName + "外网" + "】\n" +
                                "文件名:【" + fileName + "】\n" +
                                "表名:【" + tableName + "】\n" +
                                "异常信息：自定义注解获取值为空");
                        //为错误信息添加表名
                        syncFailLog.setFailTableName(tableName);
                        syncFailLogDao.save(syncFailLog);
                    }
                }
            }

        } catch (Exception e) {
            isSuccess = false;
            syncFailLog.setErrorMessage("百保盾外网同步表出错：" +
                    "同步环境:【" + currentEnviName + "外网" + "】\n" +
                    "文件名:【" + fileName + "】\n" +
                    "表名:【" + tableName + "】\n" +
                    "异常信息" + e.getMessage());
            //为错误信息添加表名
            syncFailLog.setFailTableName(tableName);
            syncFailLogDao.save(syncFailLog);
            e.printStackTrace();
            /***  邮件通知 ***/
            if (police != null && police.getValue().equals("0")) {
                if (syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                    email.sendEmail("百保盾外网同步表出错",
                            "同步环境:【" + currentEnviName + "外网" + "】\n" +
                                    "文件名:【" + fileName + "】\n" +
                                    "表名:【" + tableName + "】\n" +
                                    "同步异常信息" + e.toString(),
                            syncDataNotifier.getValue());
                }
            }
        }


        if (isSuccess) {
            long endTime = System.currentTimeMillis();

            String jsonStr = JSON.toJSONString(resultList, SerializerFeature.WriteMapNullValue);

            jsonStr = jsonStr.replace("tableName", "同步表名").replace("insertCount", "插入记录").replace("updateCount", "更新记录");

            /***  同步完成邮件通知 ***/
            if (police != null && police.getValue().equals("0")) {
                if (syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                    email.sendEmail("百保盾外网成功同步文件",
                            " 同步环境:【" + currentEnviName + "外网" + "】\n" +
                                    "同步耗时:【" + (endTime - startTime) + "ms" + "】\n" +
                                    "文件名:【" + fs + "】\n" +
                                    "同步详情:【" + jsonStr + "】",
                            syncDataNotifier.getValue());
                }
            }
            System.out.println("当前程序耗时：" + (endTime - startTime) + "ms");
        }
    }


    private Map getColumn(Object object) {
        Map map = new HashMap();
        Field[] fields = ((Class) object).getDeclaredFields();
        String columnStr = "";

        String updateColumn = "";
        String foreachColumn = "";
        for (Field field : fields) {
            if (field.isAnnotationPresent(ModelAnnotation.class)) {
                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                String column = "`" + resource.column() + "`";
                columnStr += column + ",";
                foreachColumn += "${item." + column + "},";
                updateColumn += "a." + column + "=" + "b." + column + ",";

            }
        }
        if (columnStr != "") {
            map.put("tableColumn", columnStr.substring(0, columnStr.length() - 1));
            map.put("foreachColumn", foreachColumn.substring(0, foreachColumn.length() - 1));
            map.put("updateColumn", updateColumn.substring(0, updateColumn.length() - 1));
            return map;
        }
        return null;
    }

    /**
     * 生成数据同步文件
     * by llc 2018-09-03
     */
    @Override
    public void createDataSyncFile(String syncStartDate, String syncEndDate) {

        long startTime = System.currentTimeMillis();

        /*** 如果界面传入的同步开始日期为空，则同步时间提前一天 ***/
        if (StringUtil.isEmpty(syncStartDate)) {
            syncStartDate = DateUtil.getYesterday();
        }

        /*** 获取 ConfigSyncDataList ***/
        List<ConfigSyncData> configList = syncDataDao.getConfigSyncDataList();

        List<String> filePathList = new ArrayList<>();

        /*** 如果是公安外网需要取邮件发送信息 ***/
        Config police = configService.findByKey("police");
        Config syncDataNotifier = new Config();
        Config currentEnvi = new Config();
        if (police != null && police.getValue().equals("0")) {
            syncDataNotifier = configService.findByKey("syncDataNotifier");
            currentEnvi = configService.findByKey("current_native_name");
        }
        EmailUtils email = new EmailUtils();
        String currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();
        for (ConfigSyncData config : configList) {
            Map<String, Object> param = new HashMap<String, Object>();
            /*** 查询数据 ***/
            param.put("sql", "SELECT * FROM `" + config.getTableName() + "` limit 100");
            List<Map<String, Object>> dataList = syncDataDao.executeSelectSql(param);

            if (dataList != null && dataList.size() > 0) {
                try {
                    String dataJsonStr = JSONArray.toJSONString(dataList, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
                    String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(dataJsonStr.getBytes(), Constants.APPROVAL_KEY));
                    writeTxtFile(content, config.getFileName());

                } catch (Exception e) {
                    e.printStackTrace();
                    /***  邮件通知 ***/
                    if (police != null && police.getValue().equals("0")) {
                        if (syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                            email.sendEmail("百保盾外网生成数据文件出错",
                                    "同步环境:【" + currentEnviName + "外网" + "】\n" +
                                            "文件名:【" + config.getFileName() + ".data" + "】\n" +
                                            "异常信息:【" + e.getMessage().toString() + "】",
                                    syncDataNotifier.getValue());
                        }
                    }
                }
            }
        }

        long endTime = System.currentTimeMillis();
        System.out.println("当前程序耗时：" + (endTime - startTime) + "ms");
    }


    /***
     * 生成数据文件
     * @param readStr
     * @param type
     * by llc 2018-09-07
     */

    private String writeTxtFile(String readStr, String type) {

        String fullFilePath = "";
        try {
            String basePath = tempftpFolder;    //路径
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;//保存路径

            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("文件夹已创建路径:");
            }
            fullFilePath = filePath + fileName + fileType;

            //文件处理：写入文件
            File newFile = new File(fullFilePath);
            Files.write(readStr.getBytes(), newFile);
        } catch (Exception e) {
            //System.out.println("导出失败！");
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
        return fullFilePath;
    }
}
