package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ReplyRarDAO;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.approve.ReplyRar;
import com.bcxin.ars.service.sys.ReplyRarService;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @ClassName：com.bcxin.ars.service.sys.impl
 * @author：zhongjianhui
 * @date：2019/1/4 17:18
 */
@Service
@Transactional
public class ReplyRarServiceImpl implements ReplyRarService {
    /***
     * 审批
     */
    @Autowired
    private ReplyRarDAO replyRarDAO;

    @Override
    public void saveReplyRar(ReplyRar replyRar) {
        replyRarDAO.save(replyRar);
    }

    @Override
    public void deleteById(long id) {
        replyRarDAO.deleteById(id);
    }

    @Override
    public PageResult findByBusinessIDAndType(Map<Object, Object> p) {
       List<ReplyRar> list= replyRarDAO.findByBusinessIDAndType(p);
       int count=replyRarDAO.countFindByBusinessIDAndType(p);
        return new PageResult(count,list);
    }
}
