package com.bcxin.ars.service.sys.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.dto.page.InterfaceLogPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.sys.InterfaceLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;

/**
 * 系统接口日志Service实现类
 *
 * @author linqinglin
 * @Date 2020-01-21 16:36:08
 */
@Service
@Transactional
public class InterfaceLogServiceImpl implements InterfaceLogService {

    Logger logger = LoggerFactory.getLogger(InterfaceLogServiceImpl.class);

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public InterfaceLog findById(Long id) {
        return interfaceLogDao.findById(id);
    }

    @Override
    public AjaxResult reCall(InterfaceLog interfaceLog) {

        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        User currentUser = arsUtil.getCurrentUser();
        //获取SaaS对接地址

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //获取结果
            HashMap hashMap = JSON.parseObject(interfaceLog.getParameters(), HashMap.class);
            String resultStr = HttpUtil.post(interfaceLog.getUrl(), hashMap);
            interfaceLog.setResult(resultStr);

            SAASResultDto resultDto = JSONObject.parseObject(resultStr, SAASResultDto.class);

            if(resultDto != null && StringUtil.isNotEmpty(resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("百保盾与Saas同步成功");
                } else {
                    result = false;
                    //错误信息
                    msg =  resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("百保盾与Saas同步失败");
                }
            }else{
                result = false;
                msg =  "没有返回结果";
                logger.info("百保盾与Saas同步失败,没有返回结果");
            }
        }catch (Exception e){
            result = false;
            logger.error(e.getMessage(),e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result);
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.update(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "百保盾与Saas同步失败:" + msg;
        }
        return new AjaxResult(result,msg,interfaceLog.getResult());
    }

    @Override
    public void searchForPage(InterfaceLogPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       interfaceLogDao.searchForPage(dto,page);
    }

}
