package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.subsidy.ImportConfigDaoAop;
import com.bcxin.ars.dao.sys.ImportConfigDao;
import com.bcxin.ars.dto.sys.ImportConfigDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ImportConfig;
import com.bcxin.ars.service.sys.ImportConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * @author  yyx
 * @date 2020-05-18
 * @desc 导入配置实现层
 */
@Service
@Transactional
public class ImportConfigServiceImpl implements ImportConfigService {

    @Autowired
    private ImportConfigDao importConfigDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ImportConfigDaoAop importConfigDaoAop;

    @Override
    public ImportConfig findById(Long id) {
        return importConfigDao.findById(id);
    }

    @Override
    public void search(ImportConfigDto importConfigDto, AjaxPageResponse<ImportConfig> page) {
        importConfigDao.search(importConfigDto,page);
    }

    @Override
    public void save(ImportConfig importConfig) {
        User currentUser = arsUtil.getCurrentUser();
        if(importConfig.getId() == null){
            importConfig.setCreateTime(new Date());
        }
        importConfig.setActive(true);
        importConfig.setUpdateBy(currentUser.getUsername());
        importConfig.setUpdateTime(new Date());
        importConfigDaoAop.save(importConfig);
    }
}
