package com.bcxin.ars.service.sx.impl;

import com.bcxin.ars.dao.SxItemsDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sx.*;
import com.bcxin.ars.service.sx.DataPushService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.sxzw.dao.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;

/***
 * 陕西政务中心数据推送
 * @author subh
 */
@Service
@Transactional
public class DataPushServiceImpl implements DataPushService {

    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(DataPushServiceImpl.class);


    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;
    /**
     * 申报
     */
    @Autowired
    private ApasinfoDao apasinfoDao;



    @Autowired
    private SxItemsDao sxItemsDao;
    /***
     * 登记（申报）信息业务表单信息
     */
    @Autowired
    private CommFormDao commFormDao;
    /***
     * 基本信息
     */
    @Autowired
     private StepBasicinfoDao stepBasicinfoDao;

    /***
     * 过程
     */
    @Autowired
    private StepProcDao stepProcDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    /***
     * 办结
     */
    @Autowired
    private StepDoneDao stepDoneDao;

    @Autowired
    private UserDao userDao;
    @Override
    public void send(Sponsorlicense p) {
            //用户信息
            User user =  userDao.findById(p.getUserid());
            /**
             * 登记（申报）信息
             */
            Apasinfo apasinfo = new Apasinfo();
            int sequence = personcertificateDao.getNextVal("seq_sxzw");
            if(StringUtil.isEmpty(p.getDistrict())) {
                p.setDistrict(p.getCity());
            }
            String projid = "XK00600700"+p.getDistrict()+DateUtil.getCurrentDateTime("yyMMdd")+sequence+"1";
            //主键
            apasinfo.setProjid(projid);
            //随机六位密码
            int rannum = (int)((Math.random()*9+1)*100000);
            apasinfo.setProjpwd(rannum+"");
            //事项基本编码
            apasinfo.setItem_code("XK00600700");
            //事项实施编码
            apasinfo.setImplement_code(p.getDistrict() + "000000A00");
            //审批事项的版本号
            apasinfo.setItemversion("V0.1");
            //事项名称
            apasinfo.setItemname("普通保安服务公司设立许可");
            //申请审批的项目的具体名称
            apasinfo.setProjectname("关于"+p.getCompanyname()+"的保安服务公司许可");
            //办件状态代码
            apasinfo.setProjectstate("02");
            //办件类型代码
            apasinfo.setInfotype("2");
            //申请人
            apasinfo.setApplyname(p.getCompanyname());
            //申请人证件号
            apasinfo.setApply_cardtypenumber(p.getLegalPersonNo());
            //姓名
            apasinfo.setContactman(p.getRepresentative());
            //身份证件号码
            apasinfo.setContactman_cardnumber(p.getLegalPersonNo());
            //移动号码
            apasinfo.setTelphone(p.getPhone());
            //邮政编码
            apasinfo.setPostcode(p.getZipcode());
            //法定代表人
            apasinfo.setLegalman(p.getRepresentative());
            //收件部门编码
            apasinfo.setDeptid("11610000016000080P");
            //收件部门名称
            apasinfo.setDeptname("省公安厅");
            //创建用户唯一标识
            if(user!=null) {
                apasinfo.setReceive_useid(user.getId().toString());
                //创建用户名称
                apasinfo.setReceive_name(user.getRoleName());
            }else{
                apasinfo.setReceive_useid("1");
                //创建用户名称
                apasinfo.setReceive_name("2");
            }
            //申报时间
            apasinfo.setReceivetime(p.getCreateTime());
            //数据产生时间
            apasinfo.setCreate_time(p.getCreateTime());
            //0-作废，1-有效
            apasinfo.setDatastate("1");
            //进入数据库时间，默认为系统时间
            apasinfo.setMaketime(new Date());
            //数据交换状态标志位，默认为0
            apasinfo.setSignstate(0L);
            //格式为 ID:NAME,ID:NAME,···
            apasinfo.setAcceptlist(p.getRepresentative());
            apasinfo.setDataver("1");
            //申报者行政区划
            apasinfo.setRegion_id(p.getDistrict()+"000000");
            //审批类型
            apasinfo.setApprove_type("01");
            //同步类型 I-插入，U-更新，D-删除
            apasinfo.setCd_operation("I");
            //申报来源
            apasinfo.setApplyfrom("2");
            //参照陕西省全省事项库规范字段sourceid
            apasinfo.setSourceid("29e80671349d45db9c042b6a316874cc");
            //系统标识
            apasinfo.setSysmark("sx_gongan_01");
            apasinfoDao.insert(apasinfo);
            /***
             * 登记（申报）信息业务表单信息
             */
            CommForm commForm = new CommForm();
            commForm.setProjid(projid);
            commForm.setDataver("1");


            UUID uuid = UUID.randomUUID();
            commForm.setUnid(uuid.toString());
            commForm.setForm_name("普通保安服务公司设立许可");
            commForm.setForm_sort("1");
            commForm.setUse_unid("1");
            //行政区划
            commForm.setRegion_id(p.getDistrict()+"000000");
            //事项所属区划
            commForm.setItemregionid(p.getDistrict()+"000000");
            //创建时间
            commForm.setCreate_time(p.getCreateTime());
            commForm.setDataver("1");
            //收件部门编码
            commForm.setDeptid("11610000016000080P");
            //进入数据库时间，默认为系统时间
            commForm.setMaketime(p.getCreateTime());
            commForm.setSignstate("1");
            //同步类型
            commForm.setCd_operation("I");
            //系统标识
            commForm.setSysmark("sx_gongan_01");
            commFormDao.insert(commForm);
           /* *//***
             * 基本信息
             */
            StepBasicinfo stepBasicinfo =  new StepBasicinfo();
            stepBasicinfo.setOrgbusno(uuid.toString());
            stepBasicinfo.setProjid(projid);
            stepBasicinfo.setDataver("1");
            stepBasicinfo.setProjpwd(rannum+"");

            stepBasicinfo.setItem_code("XK00600700");
            stepBasicinfo.setImplement_code(p.getDistrict()+"000000A00");
             stepBasicinfo.setRegion_id(p.getDistrict()+"000000");
            stepBasicinfo.setItemregionid(p.getDistrict()+"000000");
            //事项主项名称
            stepBasicinfo.setItemname("普通保安服务公司设立许可");
            //若审批事项，不按大小项分，则子项名称等于审批事项名称（可为空）
            stepBasicinfo.setSubitemname("普通保安服务公司设立许可");
            //申请审批的项目的具体名称
            stepBasicinfo.setProjectname("关于"+p.getCompanyname()+"的保安服务公司许可");
            //姓名或机构名称
            stepBasicinfo.setApplicant(p.getRepresentative());
            //移动电话
            stepBasicinfo.setApplicantmobile(p.getPhone());

            //受理单位组织机构代码
            stepBasicinfo.setAcceptdeptid("11610000016000080P");
            //受理单位名称
            stepBasicinfo.setAcceptdeptname("省公安厅");
            //同步类型
            stepBasicinfo.setCd_operation("I");

            stepBasicinfo.setAcceptdeptcode1("无");
            stepBasicinfo.setAcceptdeptcode2("无");
            //申请人类型
            stepBasicinfo.setApplyertype("2");
            //承诺时限
            stepBasicinfo.setPromisetimelimit("10");
            //1-工作日；2-自然日；3-小时；4-分钟；5-月
            stepBasicinfo.setPromisetimeunit("1");
            //0-窗口提交，1-网上提交，2-信函,3-电报，4-电传，5-传真，6-邮件,7-电子数据交换，8-其他
            stepBasicinfo.setSubmit("1");
            //环节发生时间
            stepBasicinfo.setOccurtime(p.getCreateTime());
            //进入数据库时间
            stepBasicinfo.setMaketime(p.getCreateTime());
            //数据状态
            stepBasicinfo.setStatus1("1");
            //系统标识
            stepBasicinfo.setSysmark("sx_gongan_01");
            //数据交换状态标志位，默认为0
            stepBasicinfo.setSignstate(0L);
            //
            stepBasicinfo.setCoucatalogcode("610109001000");
            stepBasicinfo.setCoutaskcode("11610000016000080P22610109001000");


            //申请人类型
            stepBasicinfo.setApplyertype("1");
            stepBasicinfo.setSourceid("29e80671349d45db9c042b6a316874cc");
            // 1-即办件，2-承诺件，3-联办件，4-上报件
            stepBasicinfo.setApprovaltype("2");
            stepBasicinfoDao.insert(stepBasicinfo);

            if(!Constants.APPROVALSTATE_DSP.equals(p.getApprovalstate())) {
                /***
                 * 审批过程信息
                 */
                StepProc stepProc = new StepProc();
                stepProc.setOrgbusno(uuid.toString());
                stepProc.setProjid(projid);
                stepProc.setDataver("1");
                stepProc.setSn(1);
                stepProc.setRegion_id(p.getDistrict()+"000000");
                stepProc.setItemregionid(p.getDistrict()+"000000");
                stepProc.setNodecode("业务审批");
                stepProc.setNodetype("2");
                stepProc.setNodeprocer("1");
                if(StringUtil.isNotEmpty(p.getApprovalperson())) {
                    stepProc.setNodename(p.getApprovalperson());
                    stepProc.setNodeprocername(p.getApprovalperson());
                }else{
                    stepProc.setNodename("system");
                    stepProc.setNodeprocername("system");
                }



                stepProc.setProcunit("1");
                stepProc.setProcunitname(p.getCompanyname());
                stepProc.setNodestate("1");
                stepProc.setNodestarttime(p.getCreateTime());
                stepProc.setNodeendtime(p.getCreateTime());
                stepProc.setNodeadv(p.getApprovalreason());
                stepProc.setNoderesult("1");
                stepProc.setOccurtime(p.getCreateTime());
                stepProc.setMaketime(p.getCreateTime());
                stepProc.setCd_operation("I");
                //业务动作
                stepProc.setEventname("1");
                //系统标识
                stepProc.setSysmark("sx_gongan_01");
                stepProcDao.insert(stepProc);

                /***
                 * 办结
                 */
                if (Constants.APPROVALSTATE_TG.equals(p.getApprovalstate())) {
                    StepDone stepDone = new StepDone();
                    stepDone.setOrgbusno(uuid.toString());
                    stepDone.setProjid(projid);
                    stepDone.setDataver("1");
                    stepDone.setRegion_id(p.getDistrict()+"000000");
                    stepDone.setItemregionid(p.getDistrict()+"000000");
                    stepDone.setDoneresult("1");
                    if(StringUtil.isNotEmpty(p.getApprovalperson())) {
                        stepDone.setTransactor(p.getApprovalperson());
                    }else{
                        stepDone.setTransactor("system");
                    }

                    if(StringUtil.isNotEmpty(p.getApprovalreason())) {
                        stepDone.setExitres(p.getApprovalreason());
                    }else{
                        stepDone.setExitres("同意");
                    }
                    stepDone.setIsfee("1");
                    stepDone.setOccurtime(p.getCreateTime());

                    stepDone.setMaketime(p.getUpdateTime());
                    stepDone.setLocaltime(p.getUpdateTime());
                    //是否快递递送结果
                    stepDone.setIsdeliveryresults("0");
                    stepDone.setCd_operation("I");
                    //系统标识
                    stepDone.setSysmark("sx_gongan_01");
                    stepDoneDao.insert(stepDone);
                }
            }
        }

    @Override
    public List<SxItems> query(int number,int start) {
        System.out.println("number："+number+"---start:"+start);
        List<SxItems> list = apasinfoDao.findItems(number,start);
        System.out.println("事项个数："+list.size());
        return list;
    }
    @Override
    public List<sxff> querysxff(int number,int start) {
        System.out.println("number："+number+"---start:"+start);
        List<sxff> list = apasinfoDao.findsxff(number,start);
        System.out.println("机构："+list.size());
        return list;
    }

    @Override
    public void save(List<SxItems> as) {
            sxItemsDao.save(as);
    }
    @Override
    public void savesxff(List<sxff> as) {
        sxItemsDao.savesxff(as);
    }
}
