package com.bcxin.ars.service.subsidy.impl;


import com.bcxin.ars.dao.sb.GradeSubsidyBatchDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.SubsidyOfflineBatchDao;
import com.bcxin.ars.dao.subsidy.SubsidyOfflineDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.subsidy.SubsidyOfflinePageSearchDto;
import com.bcxin.ars.enums.SubsidyCerType;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.subsidy.SubsidyOffline;
import com.bcxin.ars.model.subsidy.SubsidyOfflineBatch;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.msg.SysAttachmentService;
import com.bcxin.ars.service.subsidy.SubsidyOfflineService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 线下补贴审批单Service业务层处理
 * 
 * @author lin
 * @date 2020-11-12
 */
@Service
@Transactional
public class SubsidyOfflineServiceImpl implements SubsidyOfflineService {

    Logger logger = LoggerFactory.getLogger(SubsidyOfflineServiceImpl.class);

    @Autowired
    private SubsidyOfflineDao subsidyOfflineDao;

    @Autowired
    private GradeSubsidyBatchDao gradeSubsidyBatchDao;

    @Autowired
    private SubsidyOfflineBatchDao subsidyOfflineBatchDao;

    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private SysAttachmentService sysAttachmentService;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(SubsidyOffline subsidyOffline) {
        User currentUser = arsUtil.getCurrentUser();
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateBy(currentUser.getUsername());
        return subsidyOfflineDao.delete(subsidyOffline);
    }

    @Override
    public int save(SubsidyOffline subsidyOffline) {
        User currentUser = arsUtil.getCurrentUser();
        if(subsidyOffline.getId() == null){
            subsidyOffline.setCreateTime(new Date());
        }else{
            SubsidyOffline dbSubsidyOffline = subsidyOfflineDao.findById(subsidyOffline.getId());
            BeanUtils.copyPropertiesIgnore(subsidyOffline,dbSubsidyOffline,true);
            BeanUtils.copyPropertiesIgnore(dbSubsidyOffline,subsidyOffline,false);
        }

        subsidyOffline.setActive(true);
        subsidyOffline.setUpdateBy(currentUser.getUsername());
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateflag(true);
        subsidyOffline.setUserId(currentUser.getId());
        subsidyOffline.setAreaCode(currentUser.getPolice().getAreacode());
        return subsidyOfflineDao.save(subsidyOffline);
    }

    @Override
    public SubsidyOffline findById(Long id) {
        return subsidyOfflineDao.findById(id);
    }

    @Override
    public void searchForPage(SubsidyOfflinePageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        subsidyOfflineDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<SubsidyOffline> list) {
        List<SubsidyOffline> dbList = subsidyOfflineDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (SubsidyOffline subsidyOffline : list) {
                subsidyOffline.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        subsidyOffline.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, subsidyOffline.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            subsidyOfflineDao.saveBatch(list);
        }
    }

    @Override
    public List<SubsidyOffline> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return subsidyOfflineDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<SubsidyOffline> findDSOutList(String startDate) {
        return subsidyOfflineDao.findDSOutList(startDate);
    }

    @Override
    public List<SubsidyOffline> findByBatchId(List<SubsidyOffline> list) {
        return subsidyOfflineDao.findByBatchId(list);
    }

    @Override
    public void create(Long[] batchIds) {
        User user = arsUtil.getCurrentUser();
        Police police = user.getPolice();
        List<GradeSubsidyBatch> batchList = gradeSubsidyBatchDao.findbyIds(batchIds);
        SubsidyOffline subsidyOffline = new SubsidyOffline();
        subsidyOffline.setId(idWorker.nextId());
        subsidyOffline.setOrgId(user.getOrgid());
        subsidyOffline.setUserId(user.getId());
//        subsidyOffline.setAppAttachmentId(0L);
//        subsidyOffline.setResultAttachmentId(0L);
        subsidyOffline.setOffApprovalState(Constants.APPROVALSTATE_XXSPZ);
        subsidyOffline.setBatchNum(batchIds.length);
        subsidyOffline.setUpdateflag(true);
        subsidyOffline.setActive(true);
        subsidyOffline.setCreateTime(new Date());
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateBy(user.getUsername());
        subsidyOffline.setAreaCode(police.getAreacode());

        Map<Long,String> comMap = new HashMap<>();
        Date minDate = new Date();

        SubsidyOfflineBatch subsidyOfflineBatch = null;
        List<SubsidyOfflineBatch> batches = new ArrayList<>();

        BigDecimal subsidyMoney = new BigDecimal("0.00");

        for (GradeSubsidyBatch gradeSubsidyBatch : batchList) {
            subsidyOfflineBatch = new SubsidyOfflineBatch();

            subsidyOfflineBatch.setOfflineId(subsidyOffline.getId());
            subsidyOfflineBatch.setBatchId(gradeSubsidyBatch.getId());
            subsidyOfflineBatch.setUpdateflag(true);
            subsidyOfflineBatch.setId(idWorker.nextId());
            subsidyOfflineBatch.setActive(true);
            subsidyOfflineBatch.setUsed(true);
            subsidyOfflineBatch.setCreateTime(new Date());
            subsidyOfflineBatch.setUpdateTime(new Date());
            subsidyOfflineBatch.setUpdateBy(user.getUsername());

            batches.add(subsidyOfflineBatch);
            comMap.put(gradeSubsidyBatch.getCompanyid(),gradeSubsidyBatch.getCompanyname());

            if(minDate.getTime() > gradeSubsidyBatch.getCreateTime().getTime()){
                minDate = gradeSubsidyBatch.getCreateTime();
            }

            subsidyMoney = subsidyMoney.add(new BigDecimal(gradeSubsidyBatch.getSubsidyMoney()));
            gradeSubsidyBatch.setOffApprovalState(Constants.APPROVALSTATE_XXSPZ);
        }

        subsidyOffline.setSubsidyMoney(subsidyMoney.toString());
        subsidyOffline.setComNum(comMap.size());
        subsidyOffline.setCycle(DateUtil.convertDateToString(minDate,DateUtil.FORMAT14)+"—"+DateUtil.getCurrentDate(DateUtil.FORMAT14));


        //TODO 生成pdf文件
        this.createApprovePDF(subsidyOffline,batchList);
        subsidyOfflineDao.save(subsidyOffline);

        subsidyOfflineBatchDao.saveBatch(batches);

        gradeSubsidyBatchDao.saveBatch(batchList);
    }

    private void createApprovePDF(SubsidyOffline subsidyOffline,List<GradeSubsidyBatch> batchList){
        try {

            Map<String,List<GradeSubsidyBatch>> typeGroupMap = batchList.stream().collect(Collectors.groupingBy(GradeSubsidyBatch::getSubsidyCerType));
            Map<Long,List<GradeSubsidyBatch>> batchGroupMap = batchList.stream().collect(Collectors.groupingBy(GradeSubsidyBatch::getCompanyid));

            Document document = new Document(PageSize.A4, 10, 10, 10, 10);

            String dirDate = DateUtil.getCurrentDate();
            String filePath = configUtils.sysAttachmentFolder+dirDate;

            String fileName = System.currentTimeMillis()+".pdf";
            File dir = new File(filePath);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = "sysAttachment/" +dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = filePath + "/" + fileName;
            // 创建PdfWriter对象
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(targetPath));
            // 打开文档
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            this.addApprove(document,writer,subsidyOffline,typeGroupMap);

            for (Long comId : batchGroupMap.keySet()) {
                document.newPage();
                this.addReport(document,writer,subsidyOffline,batchGroupMap.get(comId));
            }
            // 关闭文档
            document.close();


            List<String> files = new ArrayList<>();
            files.add(fileName);

            logger.info("压缩并保存...");
            //FileUtil.zipFiles(files,targetPath);

            File targetFile = new File(targetPath);
            SysAttachment sysAttachment = new SysAttachment();
            sysAttachment.setPath(url);
            sysAttachment.setFileName(fileName);
            sysAttachment.setFileSize(targetFile.length());
            sysAttachmentService.saveOrUpdate(sysAttachment);
            logger.info("本地文件上传成功!");

            subsidyOffline.setAppAttachmentId(sysAttachment.getId());
            subsidyOffline.setApprovePath(url);

            FileUtil.deleteFile(fileName);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void addReport(Document document, PdfWriter writer, SubsidyOffline subsidyOffline, List<GradeSubsidyBatch> batchList) throws DocumentException {

        // 添加表格，3列
        PdfPTable table = new PdfPTable(6);
        //设置表格宽度比例为%100
        table.setWidthPercentage(100);
        // 设置表格的宽度
        table.setTotalWidth(570);
        // 也可以每列分别设置宽度
        table.setTotalWidth(new float[] { 70, 95, 130, 80, 100, 95 });
        // 锁住宽度
        table.setLockedWidth(true);
        // 设置表格上面空白宽度
        table.setSpacingBefore(10f);
        // 设置表格下面空白宽度
        table.setSpacingAfter(10f);
        // 设置表格默认为无边框
        table.getDefaultCell().setBorder(0);
        // 构建每个单元格
        PdfPCell cell1 = new PdfPCell(new Paragraph("保安员培训补贴资金情况汇总表",ItextPDFUtil.setFont(22)));
        // 设置占用列数
        cell1.setColspan(6);
        cell1.setRowspan(1);
        // 设置高度
        cell1.setFixedHeight(120);
        cell1.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell1.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell1.setBorder(Rectangle.NO_BORDER);
        table.addCell(cell1);

        String comName = batchList.get(0).getCompanyname();
        PdfPCell cell2 = new PdfPCell(new Paragraph("学校名称："+comName,ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cell2.setColspan(6);
        cell2.setRowspan(1);
        // 设置高度
        cell2.setFixedHeight(40);
        cell2.setHorizontalAlignment(Element.ALIGN_LEFT);
        cell2.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell2.setBorder(Rectangle.NO_BORDER);
        table.addCell(cell2);

        String[] titles = {"序号","补贴种类","补贴批次","补贴人数","补贴金额","合计"};

        for (String title : titles) {
            PdfPCell cellTile = new PdfPCell(new Paragraph(title,ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellTile.setColspan(1);
            cellTile.setRowspan(1);
            // 设置高度
            cellTile.setFixedHeight(40);
            cellTile.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellTile.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellTile);
        }

        Map<String,List<GradeSubsidyBatch>> typeGroupMap = batchList.stream().collect(Collectors.groupingBy(GradeSubsidyBatch::getSubsidyCerType));

        BigDecimal totalMoney = new BigDecimal(0);
        Date minDate = new Date();
        Date maxDate = new Date();
        int totalCount = 1;
        for (String subsidyCerType : typeGroupMap.keySet()) {
            int count =1;
            String title = SubsidyCerType.getByCode(subsidyCerType).getCName();
            List<GradeSubsidyBatch> typeList = typeGroupMap.get(subsidyCerType);

            BigDecimal subsidyMoney =typeList.stream().map(GradeSubsidyBatch::getSubsidyMoney_value).reduce(BigDecimal.ZERO,BigDecimal::add);

            totalMoney = totalMoney.add(subsidyMoney);
            for (GradeSubsidyBatch gradeSubsidyBatch : typeList) {
                PdfPCell cellIndex = new PdfPCell(new Paragraph(totalCount+"",ItextPDFUtil.setFont(16)));
                // 设置占用列数
                cellIndex.setColspan(1);
                cellIndex.setRowspan(1);
                // 设置高度
                cellIndex.setMinimumHeight(40);
                cellIndex.setHorizontalAlignment(Element.ALIGN_CENTER);
                cellIndex.setVerticalAlignment(Element.ALIGN_MIDDLE);
                table.addCell(cellIndex);

                if(count == 1){
                    PdfPCell cellType = new PdfPCell(new Paragraph(title,ItextPDFUtil.setFont(16)));
                    // 设置占用列数
                    cellType.setColspan(1);
                    cellType.setRowspan(typeList.size());
                    // 设置高度
                    cellType.setMinimumHeight(40);
                    cellType.setHorizontalAlignment(Element.ALIGN_CENTER);
                    cellType.setVerticalAlignment(Element.ALIGN_MIDDLE);
                    table.addCell(cellType);
                }

                PdfPCell cellText1 = new PdfPCell(new Paragraph(gradeSubsidyBatch.getBatchName(),ItextPDFUtil.setFont(16)));
                // 设置占用列数
                cellText1.setColspan(1);
                cellText1.setRowspan(1);
                // 设置高度
                cellText1.setMinimumHeight(40);
                cellText1.setHorizontalAlignment(Element.ALIGN_CENTER);
                cellText1.setVerticalAlignment(Element.ALIGN_MIDDLE);
                table.addCell(cellText1);

                PdfPCell cellText2 = new PdfPCell(new Paragraph(gradeSubsidyBatch.getPerNum(),ItextPDFUtil.setFont(16)));
                // 设置占用列数
                cellText2.setColspan(1);
                cellText2.setRowspan(1);
                // 设置高度
                cellText2.setMinimumHeight(40);
                cellText2.setHorizontalAlignment(Element.ALIGN_CENTER);
                cellText2.setVerticalAlignment(Element.ALIGN_MIDDLE);
                table.addCell(cellText2);

                PdfPCell cellText3 = new PdfPCell(new Paragraph("￥"+gradeSubsidyBatch.getSubsidyMoney(),ItextPDFUtil.setFont(16)));
                // 设置占用列数
                cellText3.setColspan(1);
                cellText3.setRowspan(1);
                // 设置高度
                cellText3.setMinimumHeight(40);
                cellText3.setHorizontalAlignment(Element.ALIGN_CENTER);
                cellText3.setVerticalAlignment(Element.ALIGN_MIDDLE);
                table.addCell(cellText3);

                if(count == 1){
                    PdfPCell cellType = new PdfPCell(new Paragraph("￥"+subsidyMoney.toString(),ItextPDFUtil.setFont(16)));
                    // 设置占用列数
                    cellType.setColspan(1);
                    cellType.setRowspan(typeList.size());
                    // 设置高度
                    cellType.setMinimumHeight(40);
                    cellType.setHorizontalAlignment(Element.ALIGN_CENTER);
                    cellType.setVerticalAlignment(Element.ALIGN_MIDDLE);
                    table.addCell(cellType);
                    maxDate = gradeSubsidyBatch.getCreateTime();
                }



                if(minDate.getTime() > gradeSubsidyBatch.getCreateTime().getTime()){
                    minDate = gradeSubsidyBatch.getCreateTime();
                }
                if(maxDate.getTime() < gradeSubsidyBatch.getCreateTime().getTime()){
                    maxDate = gradeSubsidyBatch.getCreateTime();
                }

                count++;
                totalCount++;
            }
        }
        PdfPCell cellType = new PdfPCell(new Paragraph("总计",ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cellType.setColspan(4);
        cellType.setRowspan(1);
        // 设置高度
        cellType.setFixedHeight(40);
        cellType.setHorizontalAlignment(Element.ALIGN_CENTER);
        cellType.setVerticalAlignment(Element.ALIGN_MIDDLE);
        table.addCell(cellType);
        PdfPCell cellTotal = new PdfPCell(new Paragraph("￥"+totalMoney.toString(),ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cellTotal.setColspan(2);
        cellTotal.setRowspan(1);
        // 设置高度
        cellTotal.setFixedHeight(40);
        cellTotal.setHorizontalAlignment(Element.ALIGN_CENTER);
        cellTotal.setVerticalAlignment(Element.ALIGN_MIDDLE);
        table.addCell(cellTotal);

        PdfPCell cellTime = new PdfPCell(new Paragraph("申请时间："+DateUtil.convertDateToString(minDate,DateUtil.FORMAT14)+"—"+DateUtil.convertDateToString(maxDate,DateUtil.FORMAT14),ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cellTime.setColspan(6);
        cellTime.setRowspan(1);
        // 设置高度
        cellTime.setFixedHeight(60);
        cellTime.setHorizontalAlignment(Element.ALIGN_RIGHT);
        cellTime.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cellTime.setBorder(Rectangle.NO_BORDER);
        table.addCell(cellTime);

        document.add(table);

        for (String subsidyCerType : typeGroupMap.keySet()) {
            document.newPage();
            switch (subsidyCerType){
                case "01":
                    this.addGradeDetail(document,writer,subsidyOffline,typeGroupMap.get(subsidyCerType));
                    break;
                case "02":
                    this.addSeniorityDetail(document,writer,subsidyOffline,typeGroupMap.get(subsidyCerType));
                    break;
                default:
                    break;
            }
        }
    }

    private void addGradeDetail(Document document, PdfWriter writer, SubsidyOffline subsidyOffline, List<GradeSubsidyBatch> batchList) throws DocumentException {
        // 添加表格，5列
        PdfPTable table = new PdfPTable(6);
        //设置表格宽度比例为%100
        table.setWidthPercentage(100);
        // 设置表格的宽度
        table.setTotalWidth(570);
        // 也可以每列分别设置宽度
        table.setTotalWidth(new float[] { 60, 85, 155, 80, 95, 95 });
        // 锁住宽度
        table.setLockedWidth(true);
        // 设置表格上面空白宽度
        table.setSpacingBefore(10f);
        // 设置表格下面空白宽度
        table.setSpacingAfter(10f);
        // 设置表格默认为无边框
        table.getDefaultCell().setBorder(0);
        // 构建每个单元格
        PdfPCell cell1 = new PdfPCell(new Paragraph("保安员职业技能培训补贴人员花名册",ItextPDFUtil.setFont(22)));
        // 设置占用列数
        cell1.setColspan(6);
        cell1.setRowspan(1);
        // 设置高度
        cell1.setFixedHeight(90);
        cell1.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell1.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell1.setBorder(Rectangle.NO_BORDER);
        table.addCell(cell1);

        String comName = batchList.get(0).getCompanyname();
        PdfPCell cell2 = new PdfPCell(new Paragraph("学校名称："+comName,ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cell2.setColspan(6);
        cell2.setRowspan(1);
        // 设置高度
        cell2.setFixedHeight(40);
        cell2.setHorizontalAlignment(Element.ALIGN_LEFT);
        cell2.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell2.setBorder(Rectangle.NO_BORDER);
        table.addCell(cell2);
        String[] titles = {"序号","姓名","身份证号","补贴金额","证书类型","证书编号"};

        for (String title : titles) {
            PdfPCell cellTile = new PdfPCell(new Paragraph(title,ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellTile.setColspan(1);
            cellTile.setRowspan(1);
            // 设置高度
            cellTile.setFixedHeight(40);
            cellTile.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellTile.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellTile);
        }

        int count =1;

        Date minDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(GradeSubsidyBatch::getCreateTime).distinct().min((e1, e2) -> e1.compareTo(e2)).get();
        Date maxDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(GradeSubsidyBatch::getCreateTime).distinct().max((e1, e2) -> e1.compareTo(e2)).get();

        List<GradeSubsidyRoster> rosterList = gradeSubsidyRosterDao.findBySubsidyBatchIds(batchList);


        for (GradeSubsidyRoster gradeSubsidyRoster : rosterList) {

            PdfPCell cellIndex = new PdfPCell(new Paragraph(count+"",ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellIndex.setColspan(1);
            cellIndex.setRowspan(1);
            // 设置高度
            cellIndex.setFixedHeight(40);
            cellIndex.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellIndex.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellIndex);

            PdfPCell cellText1 = new PdfPCell(new Paragraph(gradeSubsidyRoster.getName(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText1.setColspan(1);
            cellText1.setRowspan(1);
            // 设置高度
            cellText1.setFixedHeight(40);
            cellText1.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText1.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText1);

            PdfPCell cellText2 = new PdfPCell(new Paragraph(gradeSubsidyRoster.getIdNum(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText2.setColspan(1);
            cellText2.setRowspan(1);
            // 设置高度
            cellText2.setFixedHeight(40);
            cellText2.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText2.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText2);

            PdfPCell cellText3 = new PdfPCell(new Paragraph("￥"+gradeSubsidyRoster.getSubsidyMoney(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText3.setColspan(1);
            cellText3.setRowspan(1);
            // 设置高度
            cellText3.setFixedHeight(40);
            cellText3.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText3.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText3);

            PdfPCell cellText4 = new PdfPCell(new Paragraph(gradeSubsidyRoster.getCertificateType(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText4.setColspan(1);
            cellText4.setRowspan(1);
            // 设置高度
            cellText4.setFixedHeight(40);
            cellText4.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText4.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText4);

            PdfPCell cellText5 = new PdfPCell(new Paragraph(gradeSubsidyRoster.getCertificateNumber(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText5.setColspan(1);
            cellText5.setRowspan(1);
            // 设置高度
            cellText5.setFixedHeight(40);
            cellText5.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText5.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText5);
            count++;
        }

        PdfPCell cellTime = new PdfPCell(new Paragraph("申请时间："+DateUtil.convertDateToString(minDate,DateUtil.FORMAT14)+"—"+DateUtil.convertDateToString(maxDate,DateUtil.FORMAT14),ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cellTime.setColspan(6);
        cellTime.setRowspan(1);
        // 设置高度
        cellTime.setFixedHeight(40);
        cellTime.setHorizontalAlignment(Element.ALIGN_RIGHT);
        cellTime.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cellTime.setBorder(Rectangle.NO_BORDER);
        table.addCell(cellTime);

        document.add(table);

    }

    private void addSeniorityDetail(Document document, PdfWriter writer, SubsidyOffline subsidyOffline, List<GradeSubsidyBatch> batchList) throws DocumentException {
        // 添加表格，5列
        PdfPTable table = new PdfPTable(5);
        //设置表格宽度比例为%100
        table.setWidthPercentage(100);
        // 设置表格的宽度
        table.setTotalWidth(560);
        // 也可以每列分别设置宽度
        table.setTotalWidth(new float[] { 70, 112, 154, 112, 112 });
        // 锁住宽度
        table.setLockedWidth(true);
        // 设置表格上面空白宽度
        table.setSpacingBefore(10f);
        // 设置表格下面空白宽度
        table.setSpacingAfter(10f);
        // 设置表格默认为无边框
        table.getDefaultCell().setBorder(0);
        // 构建每个单元格
        PdfPCell cell1 = new PdfPCell(new Paragraph("保安员岗位资格培训补贴人员花名册",ItextPDFUtil.setFont(22)));
        // 设置占用列数
        cell1.setColspan(5);
        cell1.setRowspan(1);
        // 设置高度
        cell1.setFixedHeight(90);
        cell1.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell1.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell1.setBorder(Rectangle.NO_BORDER);
        table.addCell(cell1);

        String comName = batchList.get(0).getCompanyname();
        PdfPCell cell2 = new PdfPCell(new Paragraph("学校名称："+comName,ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cell2.setColspan(5);
        cell2.setRowspan(1);
        // 设置高度
        cell2.setFixedHeight(40);
        cell2.setHorizontalAlignment(Element.ALIGN_LEFT);
        cell2.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell2.setBorder(Rectangle.NO_BORDER);
        table.addCell(cell2);
        String[] titles = {"序号","姓名","身份证号","补贴金额","证书编号"};

        for (String title : titles) {
            PdfPCell cellTile = new PdfPCell(new Paragraph(title,ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellTile.setColspan(1);
            cellTile.setRowspan(1);
            // 设置高度
            cellTile.setFixedHeight(40);
            cellTile.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellTile.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellTile);
        }

        int count =1;

        Date minDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(GradeSubsidyBatch::getCreateTime).distinct().min((e1, e2) -> e1.compareTo(e2)).get();
        Date maxDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(GradeSubsidyBatch::getCreateTime).distinct().max((e1, e2) -> e1.compareTo(e2)).get();

        List<GradeSubsidyRoster> rosterList = gradeSubsidyRosterDao.findBySubsidyBatchIds(batchList);


        for (GradeSubsidyRoster gradeSubsidyRoster : rosterList) {

            PdfPCell cellIndex = new PdfPCell(new Paragraph(count+"",ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellIndex.setColspan(1);
            cellIndex.setRowspan(1);
            // 设置高度
            cellIndex.setFixedHeight(40);
            cellIndex.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellIndex.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellIndex);

            PdfPCell cellText1 = new PdfPCell(new Paragraph(gradeSubsidyRoster.getName(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText1.setColspan(1);
            cellText1.setRowspan(1);
            // 设置高度
            cellText1.setFixedHeight(40);
            cellText1.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText1.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText1);

            PdfPCell cellText2 = new PdfPCell(new Paragraph(gradeSubsidyRoster.getIdNum(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText2.setColspan(1);
            cellText2.setRowspan(1);
            // 设置高度
            cellText2.setFixedHeight(40);
            cellText2.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText2.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText2);

            PdfPCell cellText3 = new PdfPCell(new Paragraph("￥"+gradeSubsidyRoster.getSubsidyMoney(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText3.setColspan(1);
            cellText3.setRowspan(1);
            // 设置高度
            cellText3.setFixedHeight(40);
            cellText3.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText3.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText3);

            PdfPCell cellText4 = new PdfPCell(new Paragraph(gradeSubsidyRoster.getCertificateNumber(),ItextPDFUtil.setFont(16)));
            // 设置占用列数
            cellText4.setColspan(1);
            cellText4.setRowspan(1);
            // 设置高度
            cellText4.setFixedHeight(40);
            cellText4.setHorizontalAlignment(Element.ALIGN_CENTER);
            cellText4.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cellText4);
            count++;
        }

        PdfPCell cellTime = new PdfPCell(new Paragraph("申请时间："+DateUtil.convertDateToString(minDate,DateUtil.FORMAT14)+"—"+DateUtil.convertDateToString(maxDate,DateUtil.FORMAT14),ItextPDFUtil.setFont(16)));
        // 设置占用列数
        cellTime.setColspan(5);
        cellTime.setRowspan(1);
        // 设置高度
        cellTime.setFixedHeight(40);
        cellTime.setHorizontalAlignment(Element.ALIGN_RIGHT);
        cellTime.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cellTime.setBorder(Rectangle.NO_BORDER);
        table.addCell(cellTime);

        document.add(table);

    }

    private void addApprove(Document document, PdfWriter writer,SubsidyOffline subsidyOffline,Map<String,List<GradeSubsidyBatch>> typeGroupMap) throws DocumentException {
            // 添加表格，3列
            PdfPTable table = new PdfPTable(3);
            //设置表格宽度比例为%100
            table.setWidthPercentage(100);
            // 设置表格的宽度
            table.setTotalWidth(560);
            // 也可以每列分别设置宽度
            table.setTotalWidth(new float[] { 80, 160, 320 });
            // 锁住宽度
            table.setLockedWidth(true);
            // 设置表格上面空白宽度
            table.setSpacingBefore(10f);
            // 设置表格下面空白宽度
            table.setSpacingAfter(10f);
            // 设置表格默认为无边框
            table.getDefaultCell().setBorder(0);
            // 构建每个单元格
            PdfPCell cell1 = new PdfPCell(new Paragraph("北京市保安员培训资金补贴审批表",ItextPDFUtil.setFont(22)));
            // 设置占用列数
            cell1.setColspan(3);
            cell1.setRowspan(1);
            // 设置高度
            cell1.setFixedHeight(120);
            cell1.setHorizontalAlignment(Element.ALIGN_CENTER);
            cell1.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell1.setBorder(Rectangle.NO_BORDER);
            table.addCell(cell1);
            PdfPCell cell2 = new PdfPCell(new Paragraph("申请事项\r\n基本情况",ItextPDFUtil.setFont(16)));
            // 设置跨行
            cell2.setRowspan(typeGroupMap.size()+2);
            // 边框颜色
            cell2.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell2.setFixedHeight(40);
            // 设置内容水平居中显示
            cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell2.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cell2);

            PdfPCell cell3 = new PdfPCell(new Paragraph("补贴内容",ItextPDFUtil.setFont(16)));
            // 设置跨行
            cell3.setRowspan(typeGroupMap.size());
            // 边框颜色
            cell3.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell3.setFixedHeight(40);
            // 设置内容水平居中显示
            cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell3.setVerticalAlignment(Element.ALIGN_MIDDLE);
            table.addCell(cell3);

            String[] subsidyCerTypes = {"",""};
            for (String subsidyCerType : typeGroupMap.keySet()) {
                PdfPCell cell4 = new PdfPCell(new Paragraph(SubsidyCerType.getByCode(subsidyCerType).getCName(),ItextPDFUtil.setFont(16)));
                // 边框颜色
                cell4.setBorderColor(BaseColor.BLACK);
                // 设置高度
                cell4.setFixedHeight(40);
                // 设置内容水平居中显示
                cell4.setHorizontalAlignment(Element.ALIGN_CENTER);
                // 设置垂直居中
                cell4.setVerticalAlignment(Element.ALIGN_MIDDLE);
                cell4.setRowspan(1);
                table.addCell(cell4);
            }
            PdfPCell cell6 = new PdfPCell(new Paragraph("申请补贴周期",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell6.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell6.setFixedHeight(40);
            // 设置内容水平居中显示
            cell6.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell6.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell6.setRowspan(1);
            table.addCell(cell6);


            PdfPCell cell7 = new PdfPCell(new Paragraph(subsidyOffline.getCycle(),ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell7.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell7.setFixedHeight(40);
            // 设置内容水平居中显示
            cell7.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell7.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell7.setRowspan(1);
            table.addCell(cell7);


            PdfPCell cell8 = new PdfPCell(new Paragraph("补贴资金总额",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell8.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell8.setFixedHeight(40);
            // 设置内容水平居中显示
            cell8.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell8.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell8.setRowspan(1);
            table.addCell(cell8);


            PdfPCell cell9 = new PdfPCell(new Paragraph(subsidyOffline.getSubsidyMoney(),ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell9.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell9.setFixedHeight(40);
            // 设置内容水平居中显示
            cell9.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell9.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell9.setRowspan(1);
            table.addCell(cell9);

            PdfPCell cell10 = new PdfPCell(new Paragraph("总队主管\r\n领导意见",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell10.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell10.setFixedHeight(120);
            // 设置内容水平居中显示
            cell10.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell10.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell10.setRowspan(2);
            table.addCell(cell10);

            PdfPCell cell11 = new PdfPCell(new Paragraph("",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell11.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell11.setFixedHeight(80);
            // 设置内容水平居中显示
            cell11.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell11.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell11.setRowspan(1);
            cell11.setColspan(2);
            //隐藏下边框
            cell11.disableBorderSide(2);
            table.addCell(cell11);

            PdfPCell cell12 = new PdfPCell(new Paragraph("签字:",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell12.setBorderColor(BaseColor.BLACK);
            // 设置距左边的距离
            cell12.setPaddingLeft(10);
            cell12.setBorder(Rectangle.NO_BORDER);
            // 设置高度
            cell12.setFixedHeight(40);
            // 设置内容水平居中显示
            cell12.setHorizontalAlignment(Element.ALIGN_LEFT);
            // 设置垂直居中
            cell12.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell12.setRowspan(1);
            cell12.setColspan(1);
            table.addCell(cell12);

            PdfPCell cell13 = new PdfPCell(new Paragraph("年    月    日",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell13.setBorderColor(BaseColor.BLACK);
            //隐藏左、上、下边框
            cell13.disableBorderSide(7);
            // 设置距右边的距离
            cell13.setPaddingRight(20);
            // 设置高度
            cell13.setFixedHeight(40);
            // 设置内容水平居中显示
            cell13.setHorizontalAlignment(Element.ALIGN_RIGHT);
            // 设置垂直居中
            cell13.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell13.setRowspan(1);
            cell13.setColspan(1);
            table.addCell(cell13);

            PdfPCell cell14 = new PdfPCell(new Paragraph("保安管理\r\n支队领导\r\n意见",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell14.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell14.setFixedHeight(120);
            // 设置内容水平居中显示
            cell14.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell14.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell14.setRowspan(2);
            table.addCell(cell14);

            PdfPCell cell15 = new PdfPCell(new Paragraph("拟同意，请       审批。",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell15.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell15.setFixedHeight(80);
            // 设置内容水平居中显示
            cell15.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell15.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell15.setRowspan(1);
            cell15.setColspan(2);
            //隐藏下边框
            cell15.disableBorderSide(2);
            table.addCell(cell15);

            PdfPCell cell16 = new PdfPCell(new Paragraph("签字:",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell16.setBorderColor(BaseColor.BLACK);
            // 设置距左边的距离
            cell16.setPaddingLeft(10);
            cell16.setBorder(Rectangle.NO_BORDER);
            // 设置高度
            cell16.setFixedHeight(40);
            // 设置内容水平居中显示
            cell16.setHorizontalAlignment(Element.ALIGN_LEFT);
            // 设置垂直居中
            cell16.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell16.setRowspan(1);
            cell16.setColspan(1);
            table.addCell(cell16);

            PdfPCell cell17 = new PdfPCell(new Paragraph("年    月    日",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell17.setBorderColor(BaseColor.BLACK);
            //隐藏左、上、下边框
            cell17.disableBorderSide(7);
            // 设置距右边的距离
            cell17.setPaddingRight(20);
            // 设置高度
            cell17.setFixedHeight(40);
            // 设置内容水平居中显示
            cell17.setHorizontalAlignment(Element.ALIGN_RIGHT);
            // 设置垂直居中
            cell17.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell17.setRowspan(1);
            cell17.setColspan(1);
            table.addCell(cell17);

            PdfPCell cell18 = new PdfPCell(new Paragraph("承办人\r\n意见",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell18.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell18.setFixedHeight(120);
            // 设置内容水平居中显示
            cell18.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell18.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell18.setRowspan(2);
            table.addCell(cell18);

            PdfPCell cell19 = new PdfPCell(new Paragraph("经审核，补贴人员均符合资格，金额核对无误。",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell19.setBorderColor(BaseColor.BLACK);
            // 设置高度
            cell19.setFixedHeight(80);
            // 设置内容水平居中显示
            cell19.setHorizontalAlignment(Element.ALIGN_CENTER);
            // 设置垂直居中
            cell19.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell19.setRowspan(1);
            cell19.setColspan(2);
            //隐藏下边框
            cell19.disableBorderSide(2);
            table.addCell(cell19);

            PdfPCell cell20 = new PdfPCell(new Paragraph("签字:",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell20.setBorderColor(BaseColor.BLACK);
            // 设置距左边的距离
            cell20.setPaddingLeft(10);
            //隐藏右、上边框
            cell20.disableBorderSide(9);
            // 设置高度
            cell20.setFixedHeight(40);
            // 设置内容水平居中显示
            cell20.setHorizontalAlignment(Element.ALIGN_LEFT);
            // 设置垂直居中
            cell20.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell20.setRowspan(1);
            cell20.setColspan(1);
            table.addCell(cell20);

            PdfPCell cell21 = new PdfPCell(new Paragraph("年    月    日",ItextPDFUtil.setFont(16)));
            // 边框颜色
            cell21.setBorderColor(BaseColor.BLACK);
            //隐藏左、上边框
            cell21.disableBorderSide(5);
            // 设置距右边的距离
            cell21.setPaddingRight(20);
            // 设置高度
            cell21.setFixedHeight(40);
            // 设置内容水平居中显示
            cell21.setHorizontalAlignment(Element.ALIGN_RIGHT);
            // 设置垂直居中
            cell21.setVerticalAlignment(Element.ALIGN_MIDDLE);
            cell21.setRowspan(1);
            cell21.setColspan(1);
            table.addCell(cell21);
            document.add(table);
    }

    @Override
    public void revoke(SubsidyOffline subsidyOffline) {
        subsidyOffline.setOffApprovalState(Constants.APPROVALSTATE_YCX);
        this.updateSelective(subsidyOffline);
        subsidyOfflineDao.releaseBatch(subsidyOffline);
    }

    @Override
    public void updateSelective(SubsidyOffline subsidyOffline) {
        User currentUser = arsUtil.getCurrentUser();
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateBy(currentUser.getUsername());
        subsidyOfflineDao.updateSelective(subsidyOffline);
    }

    @Override
    public void approve(SubsidyOffline subsidyOffline){
        this.updateSelective(subsidyOffline);

        gradeSubsidyBatchDao.updateApprovalStateBySubsidyOffline(subsidyOffline);
        List<GradeSubsidyBatch> list = gradeSubsidyBatchDao.findbyOfflineId(subsidyOffline.getId());

        /***
         * 审批日志，公安端
         */
        User currentUser=arsUtil.getCurrentUser();
        for (GradeSubsidyBatch gradeSubsidyBatch : list) {
            ApprovalLog approvalLog = new ApprovalLog();
            if (currentUser == null) {
                approvalLog.setUpdateBy("system");
                approvalLog.setApprovalorg("系统自动");
                approvalLog.setApprovalperson("系统自动");
            } else {
                approvalLog.setApprovalperson(currentUser.getRealname());
                approvalLog.setUpdateBy(currentUser.getUsername());
                approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
            }
            approvalLog.setActive(true);
            approvalLog.setType(Constants.APPROVAL_LOG_IN);
            approvalLog.setCreateTime(new Date());
            approvalLog.setUpdateTime(new Date());
            approvalLog.setApprovaldate(new Date());
//            approvalLog.setApprovalreason(gradeSubsidyBatch.getReason());
            approvalLog.setApprovalstate("线下"+ApprovalState.convertCode(subsidyOffline.getOffApprovalState()));

            String businessType = BusinessType.DJZBT;
            if(Constants.SUBSIDYCERTYPE_ZGZ.equals(gradeSubsidyBatch.getSubsidyCerType())){
                businessType = BusinessType.ZGZBT;
            }
            Approval approval = approvalDAO.findBybusinessidAndType(gradeSubsidyBatch.getId(),businessType);
            approvalLog.setApprovalid(approval.getId().toString());
            approvalLogDao.save(approvalLog);
        }
    }
}
