package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.validation.BeanValidationResult;
import cn.hutool.extra.validation.ValidationUtil;
import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.appeal.AppealDao;
import com.bcxin.ars.dao.certificate.GradeCertificateDao;
import com.bcxin.ars.dao.certificate.GradeCompleteCerDao;
import com.bcxin.ars.dao.sb.GradeClassDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersonGradeDaoAop;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dao.sys.SubsidyConfigDao;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.certificate.GradeAndCertificateDto;
import com.bcxin.ars.dto.sb.PersonGradeSearchDto;
import com.bcxin.ars.dto.sys.SubsidyConfigDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.enums.SubsidyCerType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.exception.ValidateException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.model.sb.GradeClass;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.sys.SubsidyConfig;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.bcxin.ars.service.util.*;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 保安员等级证报名Service实现类
 *
 * @author linqinglin
 * @Date 2020-01-15 20:19:23
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = PersonGrade.class, getImportType = ImportType.BATCH, getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = PersonGrade.class, getImportType = ImportType.BATCH, getMethodName = "importBatchForDSIn2Out")
public class PersonGradeServiceImpl extends BaseService implements PersonGradeService {

    Logger logger = LoggerFactory.getLogger(PersonGradeServiceImpl.class);

    @Autowired
    private PersonGradeDao personGradeDao;

    @Autowired
    private PersonGradeDaoAop personGradeDaoAop;

    @Autowired
    private ComContractDao comContractDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Autowired
    private GradeCompleteCerDao gradeCompleteCerDao;

    @Autowired
    private GradeClassDao gradeClassDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private GradeCompleteCerService gradeCompleteCerService;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;

    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private SecurityPersonDaoAop securityPersonDaoAop;

    @Autowired
    private SubsidyConfigDao subsidyConfigDao;

    @Autowired
    private GradeCertificateDao gradeCertificateDao;

    @Autowired
    private ThirdTrainBackgroundDao thirdTrainBackgroundDao;

    @Autowired
    private AppealDao appealDao;

    @Override
    public void searchForPage(PersonGradeSearchDto searchDto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(searchDto);
        personGradeDao.searchForPage(searchDto, page);
    }

    @Override
    public void searchForPageBySubsity(PersonGradeSearchDto searchDto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(searchDto);
        personGradeDao.searchForPageBySubsidy(searchDto, page);
    }

    @Override
    public PersonGrade findById(Long id) {
        PersonGrade personGrade = personGradeDao.findById(id);
        if (personGrade.getContractId() != null) {
            personGrade.setContract(comContractDao.findById(personGrade.getContractId()));
        }
        personGrade.setGradeCompleteCer(gradeCompleteCerDao.findByPersonGradeId(personGrade.getId()));
        return personGrade;
    }

    @Override
    public void save(PersonGrade personGrade) {

        if (StringUtil.isNotEmpty(personGrade.getIdBackImg())) {
            personGrade.setIdBackImg(getPhotoPath(personGrade.getIdBackImg()));
        }

        if (StringUtil.isNotEmpty(personGrade.getIdFrontImg())) {
            personGrade.setIdFrontImg(getPhotoPath(personGrade.getIdFrontImg()));
        }

        if (StringUtil.isNotEmpty(personGrade.getHeadImg())) {
            personGrade.setHeadImg(getPhotoPath(personGrade.getHeadImg()));
        }

        if (StringUtil.isNotEmpty(personGrade.getMainHomeUrl())) {
            personGrade.setMainHomeUrl(getPhotoPath(personGrade.getMainHomeUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getSelfHomeUrl())) {
            personGrade.setSelfHomeUrl(getPhotoPath(personGrade.getSelfHomeUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getRegCerUrl())) {
            personGrade.setRegCerUrl(getPhotoPath(personGrade.getRegCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getGradCerUrl())) {
            personGrade.setGradCerUrl(getPhotoPath(personGrade.getGradCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getLaborTranCerUrl())) {
            personGrade.setLaborTranCerUrl(getPhotoPath(personGrade.getLaborTranCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getEmpCerUrl())) {
            personGrade.setEmpCerUrl(getPhotoPath(personGrade.getEmpCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getDischargeCerUrl())) {
            personGrade.setDischargeCerUrl(getPhotoPath(personGrade.getDischargeCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getSelfEmpCerUrl())) {
            personGrade.setSelfEmpCerUrl(getPhotoPath(personGrade.getSelfEmpCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getDemobCerUrl())) {
            personGrade.setDemobCerUrl(getPhotoPath(personGrade.getDemobCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getConversionCerUrl())) {
            personGrade.setConversionCerUrl(getPhotoPath(personGrade.getConversionCerUrl()));
        }

        if (StringUtil.isNotEmpty(personGrade.getConfirmCerUrl())) {
            personGrade.setConfirmCerUrl(getPhotoPath(personGrade.getConfirmCerUrl()));
        }


        if (personGrade.getContractId() != null) {
            ComContract contract = comContractDao.findById(personGrade.getContractId());
            if (contract != null) {
                personGrade.setContractStart(contract.getEffectStartDate());
                personGrade.setContractEnd(contract.getEffectEndDate());
            }
        }

        PersonGrade dbPersonGrade = personGradeDao.findById(personGrade.getId());
        if (dbPersonGrade == null) {
            personGrade.setCreateTime(new Date());
            personGrade.setNewest(true);
            personGrade.setInTime(new Date());
            if (StringUtil.isEmpty(personGrade.getMakeUp())) {
                personGrade.setMakeUp(Constants.MAKEUP_NO);
            }
            personGradeDaoAop.updatePast(personGrade);
        } else {
            BeanUtils.copyPropertiesIgnore(personGrade, dbPersonGrade, true);
            BeanUtils.copyPropertiesIgnore(dbPersonGrade, personGrade, false);
        }
        personGrade.setActive(true);
        personGrade.setUpdateTime(new Date());
        personGrade.setUpdateflag(true);

        if (StringUtil.isEmpty(personGrade.getMakeUp())) {
            personGrade.setMakeUp(Constants.MAKEUP_NO);
        } else if (Constants.MAKEUP_YES.equals(personGrade.getMakeUp())) {

            GradeSubsidyRoster roster = gradeSubsidyRosterDao.findByIdNumAndType(personGrade.getIdNum(), Constants.SUBSIDYCERTYPE_DJZ);

            //没申请过补贴 或者 补贴审批不通过
            if (roster != null && Constants.USED_N.equals(roster.getUsed())) {
                roster.setGradeId(personGrade.getId());
                roster.setUpdateTime(new Date());
                gradeSubsidyRosterDao.updateSelective(roster);
            }
        }
        if (StringUtil.isEmpty(personGrade.getAreaCode())) {
            SecurityCompany company = securityCompanyDao.findByComId(personGrade.getComId());
            if (company != null) {
                personGrade.setAreaCode(company.getAreaCode());
                if (StringUtil.isNotEmpty(company.getOrgId())) {
                    personGrade.setOrgId(Long.parseLong(company.getOrgId()));
                }
            }
        }
        personGradeDaoAop.save(personGrade);
    }

    @Override
    public void importBatch(List<PersonGrade> list) {
        List<PersonGrade> dbList = personGradeDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size() > 0) {
            Map<Long, PersonGrade> dbCensorStatusMap = dbList.stream().collect(Collectors.toMap(PersonGrade::getId, Function.identity()));
            for (PersonGrade personGrade : list) {
                personGrade.setUpdateflag(false);
                try {
                    PersonGrade dbPersonGrade = dbCensorStatusMap.get(personGrade.getId());
                    if (dbPersonGrade != null && dbPersonGrade.getInTime().getTime() > personGrade.getInTime().getTime()) {
                        personGrade.setCompareStatus(dbPersonGrade.getCompareStatus());
                        personGrade.setCompareReason(dbPersonGrade.getApprovalReason());
                        personGrade.setInTime(dbPersonGrade.getInTime());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            personGradeDaoAop.saveBatch(list);
        }
    }


    @Override
    public void importBatchForDSIn2Out(List<PersonGrade> list) {
        List<PersonGrade> dbList = personGradeDao.findByBatchId(list);
        if (list.size() > 0) {
            List<PersonGrade> compareList = new ArrayList<>();
            List<PersonGrade> changeList = new ArrayList<>();
            Map<Long, PersonGrade> dbCensorStatusMap = dbList.stream().collect(Collectors.toMap(PersonGrade::getId, Function.identity()));
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            for (PersonGrade personGrade : list) {
                personGrade.setUpdateflag(false);
                try {
                    PersonGrade dbPersonGrade = dbCensorStatusMap.get(personGrade.getId());
                    if (dbPersonGrade != null && (dbPersonGrade.getInTime() == null
                            || dbPersonGrade.getInTime().getTime() < personGrade.getInTime().getTime()
                    )) {
                        if (StringUtil.isEmpty(dbPersonGrade.getCensorStatus()) && StringUtil.isNotEmpty(personGrade.getCensorStatus())) {
                            param = new JSONObject();
                            param.put("gradeApplyId", personGrade.getId() + "");
                            param.put("backgroundStatus", personGrade.getCensorStatus());
                            param.put("approvalState", personGrade.getApprovalState());
                            param.put("backgroundFailReason", personGrade.getApprovalReason());
                            /**
                             * 背景筛查类型
                             * 1. 系统自动比对
                             * 2. 申诉通道
                             */
                            param.put("backgroundType", Constants.BACKGROUNDTYPE_SYSTEM);
                            paramArr.add(param);
                        }

                        if (StringUtil.isNotEmpty(personGrade.getCompareStatus())) {
                            compareList.add(personGrade);
                        }
                        personGrade.setUpdateTime(new Date());
                        changeList.add(personGrade);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (paramArr.size() > 0) {
                // 背景筛查结果同步给百课堂
                Map<String, Object> paramMap = new HashMap<>();
                paramMap.put("personList", JSON.toJSONString(paramArr));
                AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_PERSONGRADE_CENSOR_URL, paramMap);
                if (!result.isSuccessful()) {
                    throw new ArsException("【等级证报名背景筛查结果】" + result.getMsg());
                }
            }

            if (compareList.size() > 0) {
                this.compareStatusToBKT(compareList);
            }

            if (changeList.size() > 0) {
                personGradeDaoAop.saveBatchForDSIn2Out(changeList);
            }
        }
    }

    @Override
    public List<PersonGrade> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return personGradeDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<PersonGrade> findDSOutList(String startDate) {
        return personGradeDao.findDSOutList(startDate);
    }

    @Override
    public void batchUpdate(List<PersonGrade> list) {
        List<PersonGrade> dbList = personGradeDao.findByBatchId(list);

        if (dbList.size() > 0) {
            Map<Long, PersonGrade> personGradeMap = list.stream().collect(Collectors.toMap(PersonGrade::getId, Function.identity()));

            PersonGrade personGrade = null;
            for (PersonGrade dbPersonGrade : dbList) {
                personGrade = personGradeMap.get(dbPersonGrade.getId());

                if (personGrade.getContractId() != null) {
                    ComContract contract = comContractDao.findById(personGrade.getContractId());
                    if (contract != null) {
                        personGrade.setContractStart(contract.getEffectStartDate());
                        personGrade.setContractEnd(contract.getEffectEndDate());
                    }
                }

                BeanUtils.copyPropertiesIgnore(personGrade, dbPersonGrade, true);
                dbPersonGrade.setUpdateTime(new Date());
                dbPersonGrade.setUpdateflag(true);
            }
            personGradeDaoAop.saveBatch(dbList);
        }
    }

    @Override
    public void batchUpdateScore(List<PersonGrade> list) {
        List<PersonGrade> dbList = personGradeDao.findByBatchId(list);

        if (dbList.size() > 0) {
            Map<Long, PersonGrade> personGradeMap = list.stream().collect(Collectors.toMap(PersonGrade::getId, Function.identity()));
            List<GradeCertificate> gradeCerList = new ArrayList<>();
            List<GradeCompleteCer> completeCerList = new ArrayList<>();
            //鉴定证书
            GradeCertificate gradeCertificate = null;
            //结业证书
            GradeCompleteCer completeCer = null;
            PersonGrade personGrade = null;
            SecurityCompany trainCom = null;
            SecurityPerson person = null;
            GradeClass gradeClass = null;
            List<SecurityPerson> personList = new ArrayList<>();

            for (PersonGrade dbPersonGrade : dbList) {
                trainCom = securityCompanyDao.findByComId(dbPersonGrade.getTrainId());
                personGrade = personGradeMap.get(dbPersonGrade.getId());
                BeanUtils.copyPropertiesIgnore(personGrade, dbPersonGrade, true);
                dbPersonGrade.setUpdateTime(new Date());
                dbPersonGrade.setUpdateflag(true);

                gradeClass = gradeClassDao.findById(dbPersonGrade.getClassId());
                if (Constants.TEST_STATE_TG.equals(personGrade.getTestStateComplete())) {
                    //结业成绩通过
                    completeCer = this.createCompleteCer(dbPersonGrade, gradeClass, completeCerList);
                }

                if (Constants.TEST_STATE_TG.equals(personGrade.getTestState())) {
                    //鉴定成绩通过
                    person = securityPersonDao.findById(dbPersonGrade.getPersonId());
                    person.setProfessionLevel(dbPersonGrade.getGradeLevel());
                    ////证书编号
                    person.setCredential(dbPersonGrade.getCerNo());
                    ////培训机构
                    person.setTraincompanyname(dbPersonGrade.getTrainName());
                    person.setUpdateTime(new Date());
                    personList.add(person);

                    //鉴定证信息
                    gradeCertificate = gradeCertificateDao.findByIdNumAndGradeLevel(dbPersonGrade.getIdNum(), dbPersonGrade.getGradeLevel());
                    if (gradeCertificate == null) {
                        gradeCertificate = new GradeCertificate();
                        gradeCertificate.setId(idWorker.nextId());
                        gradeCertificate.setCreateTime(new Date());
                        gradeCertificate.setAppraisalGrade(dbPersonGrade.getGradeLevel());
                        gradeCertificate.setCompanyId(dbPersonGrade.getComId());
                        gradeCertificate.setCompanyName(dbPersonGrade.getComName());
                        gradeCertificate.setIdnum(dbPersonGrade.getIdNum());
                        gradeCertificate.setName(dbPersonGrade.getName());
                        gradeCertificate.setPersonGradeId(dbPersonGrade.getId());
                        gradeCertificate.setPersonId(dbPersonGrade.getPersonId());
                        gradeCertificate.setTrainId(dbPersonGrade.getTrainId());
                        gradeCertificate.setTrainOrgName(dbPersonGrade.getTrainName());
                        gradeCertificate.setProfession(Constants.PROFESSION_BAY);
                        //等级证管理-鉴定证书中的鉴定时间为实操培训的最后一天时间
                        gradeCertificate.setAppraisalTime(gradeClass.getPracticeEndDate());
                        //#6216527 【公安端】结业电子证的培训起止时间，开始时间取材料核对通过时间、结束时间取确认成绩时间。
                        if (personGrade.getCheckDate() == null) {
                            gradeCertificate.setTrainTime(gradeClass.getPracticeStartDate());
                            gradeCertificate.setTrainStartTime(DateUtil.convertDateToString(gradeClass.getPracticeStartDate(), DateUtil.FORMAT2));
                            gradeCertificate.setTrainEndTime(DateUtil.convertDateToString(gradeClass.getPracticeEndDate(), DateUtil.FORMAT2));
                        } else {
                            gradeCertificate.setTrainTime(personGrade.getCheckDate());
                            gradeCertificate.setTrainStartTime(DateUtil.convertDateToString(personGrade.getCheckDate(), DateUtil.FORMAT2));
                            gradeCertificate.setTrainEndTime(DateUtil.getCurrentDate(DateUtil.FORMAT2));
                        }


                        gradeCertificate.setUserId(trainCom.getUserid());
                        gradeCertificate.setGender(IdNumUtil.getGenderByIdCard(dbPersonGrade.getIdNum()));
                    }
                    try {
                        if (StringUtil.isNotEmpty(dbPersonGrade.getCerDate())) {
                            gradeCertificate.setCerDate(DateUtil.convertStringToDate(dbPersonGrade.getCerDate()));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    gradeCertificate.setCertificateNo(dbPersonGrade.getCerNo());
                    gradeCertificate.setPersonId(dbPersonGrade.getPersonId());
                    gradeCertificate.setUpdateTime(new Date());
                    gradeCertificate.setActive(true);
                    gradeCerList.add(gradeCertificate);
                }
            }
            personGradeDaoAop.saveBatch(dbList);

            if (completeCerList.size() > 0) {
                // 推送给SAAS
                gradeCompleteCerDao.saveBatch(completeCerList);
                this.sendCompleteCerToSAAS(completeCerList);
            }

            if (personList.size() > 0) {
                securityPersonDaoAop.updateBatch(personList);
            }

            if (gradeCerList.size() > 0) {
                gradeCertificateDao.saveBatch(gradeCerList);
                this.sendAppraisalCerToSAAS(gradeCerList);
            }
        }
    }

    private GradeCompleteCer createCompleteCer(PersonGrade personGrade, GradeClass gradeClass, List<GradeCompleteCer> completeCerList) {
        GradeCompleteCer completeCer = gradeCompleteCerDao.findByIdNum(personGrade.getIdNum(), personGrade.getGradeLevel());
        if (completeCer == null) {
            completeCer = new GradeCompleteCer();
            BeanUtils.copyPropertiesIgnore(personGrade, completeCer, true);
            completeCer.setId(idWorker.nextId());
            completeCer.setCerDate(DateUtil.getCurrentDate(DateUtil.FORMAT2));
            completeCer.setCerNo(this.generatorCer());
            completeCer.setGender(IdNumUtil.getGenderByIdCard(personGrade.getIdNum()));
            completeCer.setPersonGradeId(personGrade.getId());
            completeCer.setHeadImg(personGrade.getHeadImg());
            completeCer.setProfession(Constants.PROFESSION_BAY);

            //#6216527 【公安端】结业电子证的培训起止时间，开始时间取材料核对通过时间、结束时间取确认成绩时间。
            if (personGrade.getCheckDate() == null) {
                completeCer.setTrainStartDate(DateUtil.convertDateToString(gradeClass.getPracticeStartDate(), DateUtil.FORMAT2));
                completeCer.setTrainEndDate(DateUtil.convertDateToString(gradeClass.getPracticeEndDate(), DateUtil.FORMAT2));
            } else {
                completeCer.setTrainStartDate(DateUtil.convertDateToString(personGrade.getCheckDate(), DateUtil.FORMAT2));
                completeCer.setTrainEndDate(DateUtil.getCurrentDate(DateUtil.FORMAT2));
            }
            completeCer.setActive(true);
            completeCer.setCreateTime(new Date());
            completeCer.setUpdateTime(new Date());
            completeCer.setPersonId(personGrade.getPersonId());
            completeCerList.add(completeCer);
        }
        return completeCer;
    }

    /**
     * 批量根据人员id查询报名状态与证书类型
     *
     * @param personIds
     * @return
     */
    @Override
    public List<GradeAndCertificateDto> checkPersonRegister(Long[] personIds) {
        List<GradeAndCertificateDto> list = personGradeDao.selectSignUpByIds(personIds);
        return list;
    }

    /**
     * 批量根据人员id查询报名状态与证书类型
     *
     * @param personIds
     * @return
     */
    @Override
    public List<GradeAndCertificateDto> checkPersonRegisterV2(Long[] personIds) {
        //查询是否报名等级证
        List<GradeAndCertificateDto> listGrade = personGradeDao.selectGradeSignUpByIds(personIds);
        //查询是否报名资格证
        List<GradeAndCertificateDto> listCertificate = personcertificateDao.selectCertificateSignUpByIds(personIds);
        listGrade.forEach(grade -> {
            listCertificate.forEach(certificate -> {
                //personid相同的进行判断
                if (grade.getPersonId().equals(certificate.getPersonId())) {
                    //有等级证信息，设置为报名，将等级证报名信息返回
                    if (StringUtils.isNotEmpty(grade.getSignUpInfo())) {
                        grade.setIsSignUp(Constants.IS_SIGNUP);
                    } else {
                        //资格证报名信息不为空，则设置报名，否则设置为未报名，将资格证报名信息返回
                        grade.setIsSignUp(StringUtils.isEmpty(certificate.getSignUpInfo()) ? Constants.NO_SIGNUP : Constants.IS_SIGNUP);
                        grade.setSignUpInfo(certificate.getSignUpInfo());
                    }
                }
            });
        });
        return listGrade;
    }

    @Override
    public int checkPersonGradeCer(PersonGrade personGrade) {
        return personGradeDao.checkPersonGradeCer(personGrade);
    }

    /**
     * 推送结业证书信息给saas
     *
     * @param cerList
     */
    private void sendCompleteCerToSAAS(List<GradeCompleteCer> cerList) {
        if (!configUtils.isIntranet()) {
            PersonInfoDto personDto = null;
            for (GradeCompleteCer completeCer : cerList) {
                try {
                    personDto = new PersonInfoDto();
                    personDto.setPerId(completeCer.getPersonId());
                    personDto.setCerNo(completeCer.getCerNo());
                    personDto.setLicenceOrg(completeCer.getTrainName());
                    personDto.setLicenceDate(completeCer.getCerDate());
                    personDto.setTrainOrganName(completeCer.getTrainName());
                    personDto.setTrainStartDate(completeCer.getTrainStartDate());
                    personDto.setTrainEndDate(completeCer.getTrainEndDate());
                    personDto.setPerCerLevel("0100010" + completeCer.getGradeLevel());
                    //电子证书
                    personDto.setElectronCerUrl(gradeCompleteCerService.getBbdH5Url(completeCer.getId().toString()));
//                    personDto.setElectronCerUrl(gradeCompleteCerService.getBbdH5Url(completeCer.getPersonGradeId().toString()));
                    //                    //将结业证书信息推送给SaaS
                    AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_COMPLETECER_UPDATE, personDto);
                    if (!result.isSuccessful()) {
                        throw new ArsException(completeCer.getName() + result.getMsg());
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }

            }

        }
    }

    /**
     * 生成结业证书编号
     *
     * @return
     */
    private String generatorCer() {
        return configUtils.getValueByKey(Constants.CURRENT_NATIVE_SHORT) + personcertificateDao.getNextVal(Constants.SEQ_COMPLETE_CER);
    }

    @Override
    public void updateSelective(PersonGrade personGrade) {
        User currentUser = arsUtil.getCurrentUser();
        personGrade.setUpdateTime(new Date());
        personGrade.setUpdateBy(currentUser.getUsername());
        personGradeDaoAop.updateSelective(personGrade);
    }

    @Override
    public void compareStatusToBKT(List<PersonGrade> gradeList) {
        //train/bbd/grade/person/first/compareStatus
        //参数：personList:[{"gradeApplyId":"123123",{"compareStatus":"01"},{"compareFailReason":"错误原因"},{"compareType":"1"}]
        //备注：compareType：1. 第一次比对，报名比对，2. 第二次比对，补贴比对
        JSONArray personList = new JSONArray();
        JSONObject perObj = null;
        for (PersonGrade personGrade : gradeList) {
            perObj = new JSONObject();
            perObj.put("gradeApplyId", personGrade.getId() + "");
            perObj.put("compareStatus", personGrade.getCompareStatus());
            perObj.put("compareFailReason", personGrade.getCompareReason());
            perObj.put("compareType", "1");
            personList.add(perObj);

            Map<String, Object> paramMap = new HashMap();
            paramMap.put("personList", JSONArray.toJSONString(personList));

            AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_GRADEPERSON_COMPARESTATUS, paramMap);

            if (!result.isSuccessful()) {
                //throw new ArsException("【等级证报名补贴比对结果】"+result.getMsg());
                logger.error("【等级证报名补贴比对结果】" + result.getMsg());
            }
        }
    }

    @Override
    public void updateCompareInfo(PersonGrade personGrade) {
        personGrade.setCompareStatus(Constants.SUBSIDYSTATUS_DBD);
        personGrade.setCompareReason("");
        personGrade.setUpdateTime(new Date());
        personGradeDaoAop.updateSelective(personGrade);

        GradeSubsidyRoster roster = gradeSubsidyRosterDao.findByGradeId(personGrade.getId());
        if (roster != null) {
            roster.setResidentNature(personGrade.getResidentType());
            roster.setResidentPlace(personGrade.getResidentPlaceType());
            roster.setCerNo(personGrade.getCerNo());
            roster.setCerDate(personGrade.getCerDate());
            roster.setCertificateNumber(personGrade.getCerNo());
            roster.setCertificateDate(personGrade.getCerDate());
            roster.setSubsidyStatus(Constants.SUBSIDYSTATUS_DBD);
            roster.setReason("");
            roster.setUpdateTime(new Date());
            roster.setUpdateflag(true);
            gradeSubsidyRosterDaoAop.updateSelective(roster);
        }

        if (StringUtil.isNotEmpty(personGrade.getCerNo())) {
            GradeCertificate cer = gradeCertificateDao.findByPersonGradeId(personGrade.getId());
            cer.setCertificateNo(personGrade.getCerNo());
            if (StringUtil.isNotEmpty(personGrade.getCerDate())) {
                cer.setAppraisalTime(DateUtil.convertStringToDate(personGrade.getCerDate()));
            }
            cer.setUpdateTime(new Date());
            gradeCertificateDao.update(cer);

            SecurityPerson person = securityPersonDao.findById(cer.getPersonId());
            ////证书编号
            if (person != null) {
                person.setCredential(personGrade.getCerNo());
                person.setUpdateTime(new Date());
                securityPersonDaoAop.update(person);
            }

            List<GradeCertificate> list = new ArrayList<>();
            list.add(cer);
            this.sendAppraisalCerToSAAS(list);
        }
    }

    /**
     * 推送等级证信息给saas
     *
     * @param list
     */
    private void sendAppraisalCerToSAAS(List<GradeCertificate> list) {
        if (list != null && list.size() > 0) {
            //调公共安全服务平台接口
            int limit = 2000;
            //计算拆分次数
            int count = new Double(Math.ceil(list.size() * 1.0 / limit)).intValue();
            //存放拆分数据
            List<GradeCertificate> subList = null;
            //循环拆分次数 生成相应数据文件
            for (int i = 0; i < count; i++) {
                subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                List<GradeCertificateToSAASDto> dtoList = new ArrayList<>();
                for (GradeCertificate gradeCer : subList) {
                    GradeCertificateToSAASDto certificateDto = new GradeCertificateToSAASDto();
                    certificateDto.setPerId(gradeCer.getPersonId());
                    certificateDto.setCerNo(gradeCer.getCertificateNo());
                    certificateDto.setPerCerLevel("0100010" + gradeCer.getAppraisalGrade());
                    certificateDto.setLicenceDate(gradeCer.getAppraisalTime() == null ? "" : DateUtil.convertDateToString(gradeCer.getAppraisalTime(), DateUtil.FORMAT2));
                    certificateDto.setTrainOrganName(gradeCer.getTrainOrgName());
                    dtoList.add(certificateDto);
                }
                Map<String, Object> paramMap = new HashMap();
                paramMap.put("bayDJZListStr", JSONArray.toJSONString(dtoList));

                saasInterfaceUtil.callInterface(Constants.SAAS_GRADECERTIFICATE_URL, paramMap);
            }
        }
    }

    @Override
    public AjaxResult gradeCertificateApply(String gradeCertificate) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(gradeCertificate).getSubject();
        PersonGradeDTO personGrade = JSON.parseObject(subject, PersonGradeDTO.class);

        User currentUser = arsUtil.getCurrentUser();
        long id = idWorker.nextId();
        if (personGrade.getContractId() != null) {
            ComContract contract = comContractDao.findById(personGrade.getContractId());
            if (contract != null) {
                personGrade.setContractStart(contract.getEffectStartDate());
                personGrade.setContractEnd(contract.getEffectEndDate());
            }
        }

        // 如果身份证号不为空的话
        String idNum = personGrade.getIdNum();
        AjaxResult validResult = validApply(idNum);
        if (!validResult.isSuccessful()) {
            return validResult;
        }

        PersonGrade dbPersonGrade = personGradeDao.findById(personGrade.getId());
        if (dbPersonGrade == null) {
            // 校验一下参数
            BeanValidationResult beanValidationResult = ValidationUtil.warpValidate(personGrade, ThirdPartyTrain.class);
            // 校验不通过, 抛出异常
            if (!beanValidationResult.isSuccess()) {
                Set<String> errorMessages = beanValidationResult.getErrorMessages().stream().map((BeanValidationResult.ErrorMessage::getMessage)).collect(Collectors.toSet());
                throw new ValidateException(errorMessages);
            }
            personGrade.setId(id);
            personGrade.setCreateTime(new Date());
            personGrade.setNewest(true);
            personGrade.setInTime(new Date());
            personGrade.setNewest(true);
            // 写死, 目前就五级
            personGrade.setGradeLevel(Constants.GRADE_LEVEL_DEFAULT);
            // 默认待审核
            personGrade.setApprovalState(Constants.APPLYSTATUS_DSH);
            // 设置area code
            personGrade.setAreaCode(currentUser.getAreaCode());
            personGrade.setIdBackImg(getPhotoPath(personGrade.getIdBackImg()));
            personGrade.setIdFrontImg(getPhotoPath(personGrade.getIdFrontImg()));
            // 设置personId
            SecurityPerson person = securityPersonDao.findByIdCard(personGrade.getIdNum());
            personGrade.setPersonId(person.getId());

            // 设置合同时间
            ComContract comContract = comContractDao.findValidByPerId(person.getId());
            if (comContract != null) {
                personGrade.setContractStart(comContract.getEffectStartDate());
                personGrade.setContractEnd(comContract.getEffectEndDate());
            }
            personGradeDaoAop.updatePast(personGrade);

            // 添加到third_train_background
            ThirdTrainBackground thirdTrainBackground = new ThirdTrainBackground();
            thirdTrainBackground.setId(idWorker.nextId());
            thirdTrainBackground.setBusinessType(Constants.BUSINESS_TYPE_GRADE);
            thirdTrainBackground.setRealName(personGrade.getName());
            thirdTrainBackground.setIdNumber(personGrade.getIdNum());
            // 系统业务id存等级证id
            thirdTrainBackground.setArsBusinessId(id);
            thirdTrainBackground.setBusinessId(personGrade.getBusinessId());
            thirdTrainBackground.setActive(true);
            thirdTrainBackground.setUpdateBy(currentUser.getUsername());
            thirdTrainBackground.setUpdateTime(new Date());
            thirdTrainBackground.setCreateTime(new Date());
            thirdTrainBackground.setUpdateflag(true);
            thirdTrainBackground.setUserid(currentUser.getId());

            int count = thirdTrainBackgroundDao.selectCount(thirdTrainBackground);

            if (count == 0) {
                thirdTrainBackgroundDao.save(thirdTrainBackground);
            }
            ajaxResult.setData(JwtUtil.createJWT(String.valueOf(id)));
        } else {
            BeanUtils.copyPropertiesIgnore(personGrade, dbPersonGrade, true);
            BeanUtils.copyPropertiesIgnore(dbPersonGrade, personGrade, false);
        }
        personGrade.setActive(true);
        personGrade.setUpdateTime(new Date());
        personGrade.setUpdateflag(true);

        if (StringUtil.isEmpty(personGrade.getMakeUp())) {
            personGrade.setMakeUp(Constants.MAKEUP_NO);
        } else if (Constants.MAKEUP_YES.equals(personGrade.getMakeUp())) {

            GradeSubsidyRoster roster = gradeSubsidyRosterDao.findByIdNumAndType(personGrade.getIdNum(), Constants.SUBSIDYCERTYPE_DJZ);

            //没申请过补贴 或者 补贴审批不通过
            if (roster != null && Constants.USED_N.equals(roster.getUsed())) {
                roster.setGradeId(personGrade.getId());
                roster.setUpdateTime(new Date());
                gradeSubsidyRosterDao.updateSelective(roster);
            }
        }
        // 设置areaCode
        if (StringUtil.isEmpty(personGrade.getAreaCode())) {
            SecurityCompany company = securityCompanyDao.findByComId(personGrade.getComId());
            if (company != null) {
                personGrade.setAreaCode(company.getAreaCode());
                if (StringUtil.isNotEmpty(company.getOrgId())) {
                    personGrade.setOrgId(Long.parseLong(company.getOrgId()));
                }
            }
        }
        personGrade.setUserid(currentUser.getId());
        personGradeDaoAop.save(personGrade);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("成功");
        return ajaxResult;
    }

    @Override
    public AjaxResult syncGradeCertificateInformation(String personGrades) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(personGrades).getSubject();
        List<PersonGrade> list = JSON.parseArray(subject, PersonGrade.class);
        List<PersonGrade> dbList = personGradeDao.findByBatchIdOnApproval(list);

        if (dbList.size() > 0) {
            Map<Long, PersonGrade> personGradeMap = dbList.stream().collect(Collectors.toMap(PersonGrade::getId, Function.identity()));
            List<GradeSubsidyRoster> rosterList = new ArrayList<>();
            List<GradeCertificate> gradeCerList = new ArrayList<>();
            List<GradeCompleteCer> completeCerList = new ArrayList<>();

            //补贴花名册
            GradeSubsidyRoster roster;
            //鉴定证书
            GradeCertificate gradeCertificate;
            //结业证书
            GradeCompleteCer completeCer = null;
            PersonGrade personGrade;
            SecurityCompany trainCom;
            SecurityPerson person;
            GradeClass gradeClass;
            SubsidyConfig subsidyConfig;
            List<SecurityPerson> personList = new ArrayList<>();

            SubsidyConfigDto dto = new SubsidyConfigDto();
            dto.setActive(true);
            List<SubsidyConfig> subsidyConfigs = subsidyConfigDao.findAll();
            Map<String, SubsidyConfig> subsidyConfigMap = subsidyConfigs.stream().collect(Collectors.toMap(SubsidyConfig::getBusinessType, Function.identity()));
            subsidyConfig = subsidyConfigMap.get(Constants.SUBSIDYBUSINESSTYPE_005);
            Integer amount = subsidyConfig.getAmount();
            SubsidyConfig platSerFeeSubsidyConfig = subsidyConfigMap.get(Constants.SUBSIDYBUSINESSTYPE_006);

            //默认结业证信息
            String subsidyBusinessType = Constants.SUBSIDYBUSINESSTYPE_001;
            String platSerFeeType = Constants.SUBSIDYBUSINESSTYPE_007;
            for (PersonGrade dbPersonGrade : dbList) {
                trainCom = securityCompanyDao.findByComId(dbPersonGrade.getTrainId());
                personGrade = personGradeMap.get(dbPersonGrade.getId());
                BeanUtils.copyPropertiesIgnore(personGrade, dbPersonGrade, true);
                dbPersonGrade.setUpdateTime(new Date());
                dbPersonGrade.setUpdateflag(true);

                gradeClass = gradeClassDao.findById(dbPersonGrade.getClassId());
                if (Constants.TEST_STATE_TG.equals(personGrade.getTestStateComplete())) {
                    //结业成绩通过
                    completeCer = this.createCompleteCer(dbPersonGrade, gradeClass, completeCerList);
                }

                if (Constants.TEST_STATE_TG.equals(personGrade.getTestState())) {
                    //鉴定成绩通过
                    person = securityPersonDao.findByIdCard(dbPersonGrade.getIdNum());
                    person.setProfessionLevel(dbPersonGrade.getGradeLevel());
                    ////证书编号
                    person.setCredential(dbPersonGrade.getCerNo());
                    ////培训机构
                    person.setTraincompanyname(dbPersonGrade.getTrainName());
                    person.setUpdateTime(new Date());
                    personList.add(person);

                    //鉴定证信息
                    gradeCertificate = gradeCertificateDao.findByIdNumAndGradeLevel(dbPersonGrade.getIdNum(), dbPersonGrade.getGradeLevel());
                    if (gradeCertificate == null) {
                        gradeCertificate = new GradeCertificate();
                        gradeCertificate.setId(idWorker.nextId());
                        gradeCertificate.setCreateTime(new Date());
                        gradeCertificate.setAppraisalGrade(dbPersonGrade.getGradeLevel());
                        gradeCertificate.setCompanyId(dbPersonGrade.getComId());
                        gradeCertificate.setCompanyName(dbPersonGrade.getComName());
                        gradeCertificate.setIdnum(dbPersonGrade.getIdNum());
                        gradeCertificate.setName(dbPersonGrade.getName());
                        gradeCertificate.setPersonGradeId(dbPersonGrade.getId());
                        gradeCertificate.setPersonId(dbPersonGrade.getPersonId());
                        gradeCertificate.setTrainId(dbPersonGrade.getTrainId());
                        gradeCertificate.setTrainOrgName(dbPersonGrade.getTrainName());
                        gradeCertificate.setProfession(Constants.PROFESSION_BAY);
                        //等级证管理-鉴定证书中的鉴定时间为实操培训的最后一天时间
                        gradeCertificate.setAppraisalTime(gradeClass.getPracticeEndDate());
                        //#6216527 【公安端】结业电子证的培训起止时间，开始时间取材料核对通过时间、结束时间取确认成绩时间。
                        if (personGrade.getCheckDate() == null) {
                            gradeCertificate.setTrainTime(gradeClass.getPracticeStartDate());
                            gradeCertificate.setTrainStartTime(DateUtil.convertDateToString(gradeClass.getPracticeStartDate(), DateUtil.FORMAT2));
                            gradeCertificate.setTrainEndTime(DateUtil.convertDateToString(gradeClass.getPracticeEndDate(), DateUtil.FORMAT2));
                        } else {
                            gradeCertificate.setTrainTime(personGrade.getCheckDate());
                            gradeCertificate.setTrainStartTime(DateUtil.convertDateToString(personGrade.getCheckDate(), DateUtil.FORMAT2));
                            gradeCertificate.setTrainEndTime(DateUtil.getCurrentDate(DateUtil.FORMAT2));
                        }

                        if (trainCom != null) {
                            gradeCertificate.setUserId(trainCom.getUserid());
                        }
                        gradeCertificate.setGender(IdNumUtil.getGenderByIdCard(dbPersonGrade.getIdNum()));
                    }
                    try {
                        if (StringUtil.isNotEmpty(dbPersonGrade.getCerDate())) {
                            gradeCertificate.setCerDate(DateUtil.convertStringToDate(dbPersonGrade.getCerDate()));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    gradeCertificate.setCertificateNo(dbPersonGrade.getCerNo());
                    gradeCertificate.setPersonId(person.getId());
                    gradeCertificate.setUpdateTime(new Date());
                    gradeCertificate.setActive(true);
                    gradeCerList.add(gradeCertificate);
                }

                if (Constants.TEST_STATE_TG.equals(personGrade.getTestStateComplete())) {
                    roster = gradeSubsidyRosterDao.findByIdNumAndType(dbPersonGrade.getIdNum(), Constants.SUBSIDYCERTYPE_DJZ);

                    //没申请过补贴 或者 补贴审批不通过
                    if (roster != null && Constants.USED_Y.equals(roster.getUsed())) {
                        continue;
                    }

                    if (roster == null) {
                        roster = new GradeSubsidyRoster();
                        roster.setId(idWorker.nextId());
                        roster.setCreateTime(new Date());

                        roster.setGradeId(dbPersonGrade.getId());
                        roster.setActive(true);
                        roster.setUsed(Constants.USED_N);
                        roster.setUpdateflag(false);
                        roster.setSubsidyCerType(SubsidyCerType.GRADE.getCode());
                        roster.setName(dbPersonGrade.getName());
                        roster.setIdNum(dbPersonGrade.getIdNum());
                        roster.setPhone(dbPersonGrade.getPhone());
                        roster.setOrgId(dbPersonGrade.getOrgId());
                        roster.setTrainId(dbPersonGrade.getTrainId());
                        roster.setTrainName(dbPersonGrade.getTrainName());
                        roster.setCompanyId(dbPersonGrade.getComId());
                        roster.setCompanyName(dbPersonGrade.getComName());
                        roster.setResidentNature(dbPersonGrade.getResidentType());
                        roster.setResidentPlace(dbPersonGrade.getResidentPlaceType());
                        roster.setCerDate(dbPersonGrade.getCerDate());
                        roster.setCerNo(dbPersonGrade.getCerNo());

                        roster.setSubsidyType("保安员培训补贴");
                        roster.setSubsidyPeopleType("培训机构");
                        roster.setCertificateProfession("保安员");
                        roster.setCertificateGrade("五级");
                        roster.setTrainProfession("保安员");
                        roster.setTrainGrade("五级");
                        roster.setClassHour("161");

                        roster.setSex(IdNumUtil.getSexByIdCard(dbPersonGrade.getIdNum()));
                        if (dbPersonGrade.getOrgId() != null) {
                            Police police = policeDao.findById(dbPersonGrade.getOrgId());
                            roster.setOrgName(police.getOrgname());
                        }
                        roster.setAreaCode(dbPersonGrade.getAreaCode());

                        //结业证信息
                        subsidyBusinessType = Constants.SUBSIDYBUSINESSTYPE_001;
                        platSerFeeType = Constants.SUBSIDYBUSINESSTYPE_007;
                        roster.setCertificateType("结业证");
                        roster.setCompleteCerDate(completeCer.getCerDate());
                        roster.setCompleteCerNo(completeCer.getCerNo());

                        //补贴金额
                        try {
                            subsidyConfig = subsidyConfigMap.get(subsidyBusinessType);
                            roster.setCompleteMoneyRate(subsidyConfig.getPercent());
                            roster.setCompleteMoney(subsidyConfig.getAmount().toString());
                        } catch (Exception e) {
                            throw new ArsException("补贴金额配置错误");
                        }
                        if (trainCom != null) {
                            roster.setSocialCode(trainCom.getSocialCode());
                        }
                        // 培训开始日期*（课程授权的日期 即 材料核对时间）  培训结束日期*（实操开班结束日期）
                        roster.setTrainBeginDate(dbPersonGrade.getCheckDate());
                        roster.setTrainEndDate(gradeClass.getPracticeEndDate());

                        roster.setCertificateDate(completeCer.getCerDate());
                        roster.setCertificateNumber(completeCer.getCerNo());
                    }

                    roster.setUpdateTime(new Date());
                    roster.setSubsidyStatus(Constants.SUBSIDYSTATUS_DBD);

                    roster.setContractStartTime(dbPersonGrade.getContractStart());
                    roster.setContractEndTime(dbPersonGrade.getContractEnd());

                    roster.setInAppraisal(true);
                    if (Constants.TEST_STATE_TG.equals(personGrade.getTestState())) {
                        //鉴定成绩通过
                        subsidyBusinessType = Constants.SUBSIDYBUSINESSTYPE_002;
                        platSerFeeType = Constants.SUBSIDYBUSINESSTYPE_008;
                        //补贴金额
                        try {
                            subsidyConfig = subsidyConfigMap.get(subsidyBusinessType);
                            roster.setAppraisalMoneyRate(subsidyConfig.getPercent());
                            roster.setAppraisalMoney(subsidyConfig.getAmount().toString());
                        } catch (Exception e) {
                            throw new ArsException("补贴金额配置错误");
                        }

                        roster.setCertificateDate(dbPersonGrade.getCerDate());
                        roster.setCertificateNumber(dbPersonGrade.getCerNo());
                        roster.setCertificateType("技能等级证");
                    } else {
                        //只有结业证，没有鉴定证书号的，且鉴定两个成绩都为0的补贴申请：1900*60%
                        if ("0".equals(personGrade.getWrittenScore())
                                && "0".equals(personGrade.getOperateScore())) {
                            roster.setInAppraisal(false);
                        }
                    }

                    //补贴金额
                    try {
                        subsidyConfig = subsidyConfigMap.get(subsidyBusinessType);
                        roster.setSubsidyMoneyRate(subsidyConfig.getPercent());
                        if (roster.getInAppraisal()) {
                            roster.setSubsidyMoney(String.valueOf(subsidyConfig.getAmount() + amount));
                        } else {
                            roster.setSubsidyMoney(subsidyConfig.getAmount().toString());
                        }
                    } catch (Exception e) {
                        throw new ArsException("补贴金额配置错误");
                    }
                    //平台服务费金额
                    try {
                        roster.setPlatSerFee(platSerFeeSubsidyConfig.getAmount().toString());
                    } catch (Exception e) {
                        throw new ArsException("平台服务费金额配置错误");
                    }
                    rosterList.add(roster);
                }
            }
            personGradeDaoAop.saveBatch(dbList);

            if (completeCerList.size() > 0) {
                // 推送给SAAS
                gradeCompleteCerDao.saveBatch(completeCerList);
                this.sendCompleteCerToSAAS(completeCerList);
            }

            if (personList.size() > 0) {
                securityPersonDaoAop.updateBatch(personList);
            }

            if (rosterList.size() > 0) {
                gradeSubsidyRosterDaoAop.saveBatch(rosterList);
            }

            if (gradeCerList.size() > 0) {
                gradeCertificateDao.saveBatch(gradeCerList);
                this.sendAppraisalCerToSAAS(gradeCerList);
            }
        } else {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("报名列表为空或背景筛查未通过");
            return ajaxResult;
        }
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }


    @Override
    public AjaxResult cancelGradeCertificateApply(String gradeCertificateId) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(gradeCertificateId).getSubject();
        PersonGrade personGrade = personGradeDao.findById(Long.valueOf(subject));
        if (personGrade == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("该记录不存在");
            return ajaxResult;
        }

        // 背景筛查中、申诉中、开班审核中、已开班不能撤销
        // 背景筛查状态
        String censorStatus = personGrade.getCensorStatus();
        // 申诉状态
        List<Appeal> appealList = appealDao.findByBusinessIdAndType(subject, Constants.APPEALTYPE_PERSONGRADE);
        boolean isAppeal = false;
        for (Appeal appeal : appealList) {
            if (Constants.APPEALSTATE_ING.equals(appeal.getAppealState())) {
                isAppeal = true;
                break;
            }
        }
        // 获取班级信息
        GradeClass gradeClass = gradeClassDao.findById(personGrade.getClassId());
        // 开班状态
        String classState = personGrade.getClassState();
        if ((censorStatus != null && censorStatus.equals(Constants.BACKGROUNDSTATUS_SHZ))
                || isAppeal
                || (classState != null && classState.equals(Constants.CLASSSTATE_YKB))
                || (gradeClass != null && gradeClass.getApprovalState() != null && gradeClass.getApprovalState().equals(Constants.APPROVALSTATE_DSP))) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("背景筛查中、申诉中、开班审核中、已开班不能撤销");
            return ajaxResult;
        }

        // 设置审批状态为撤销
        personGrade.setApprovalState(Constants.APPLYSTATUS_CX);
        personGradeDaoAop.update(personGrade);
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }


    @Override
    public AjaxResult canSignUpGradeCertificate(String idNumbers) {
        String subject = JwtUtil.parseJWT(idNumbers).getSubject();
        List<String> idNumbersList = JSON.parseArray(subject, String.class);
        HashSet<String> idNumbersSet = Sets.newHashSet(idNumbersList);
        AjaxResult ajaxResult = new AjaxResult();
        if (CollectionUtil.isEmpty(idNumbersSet)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("请输入正确参数");
            return ajaxResult;
        }
        // 结果类
        Map<String, Object> resultData = Maps.newHashMap();

        // 查询已经报名的申报中/申报通过的
        List<String> appliedIdNumbers = personGradeDao.findAppliedByIdNumbers(idNumbersSet);

        // 查询出数据库中存在的等级证的身份证号集合信息
        List<String> resultIdNumbers = gradeCertificateDao.listIdNumbers(idNumbersSet);

        // 判断是否存在于resultIdNumbers
        for (String idNumber : idNumbersSet) {
            // 不存在于已申报或申报中的且等级证表没有的即可添加, 且须满足添加条件
            resultData.put(idNumber, !resultIdNumbers.contains(idNumber) && !appliedIdNumbers.contains(idNumber) && validApply(idNumber).isSuccessful());
        }

        ajaxResult.setData(JwtUtil.createJWT(JSON.toJSONString(resultData)));
        ajaxResult.setMsg("查询成功");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    private AjaxResult validApply(String idNum) {
        AjaxResult ajaxResult = new AjaxResult();
        ajaxResult.setSuccessful(true);
        if (StringUtil.isNotBlank(idNum)) {
            // 等级证报名添加条件, 有保安员证书, 年龄符合要求
            int age = IdNumUtil.getAgeByIdCard(idNum);
            if (age < 18 || age > 59) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("年龄不符合要求");
                return ajaxResult;
            }
            SecurityPerson securityPerson = securityPersonDao.findByIdCard(idNum);
            String credential = securityPerson.getZgcredential();
            if (StringUtil.isBlank(credential)) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("保安员证书不存在");
                return ajaxResult;
            }
            PersonGrade personGradeInfo = personGradeDao.findByIdNumber(idNum);
            // 申报中 申报通过不能报名
            String approvalState = personGradeInfo.getApprovalState();
            if (Constants.APPLYSTATUS_DSH.equals(approvalState) || Constants.APPLYSTATUS_SHTG.equals(approvalState)) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("重复报名");
                return ajaxResult;
            }
        }
        return ajaxResult;
    }
}
