package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersonAdaptDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.PersonAdaptPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.PersonAdaptService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 保安员岗位适应性报名Service实现类
 *
 * @author linqinglin
 * @Date 2020-04-10 10:39:21
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = PersonAdapt.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = PersonAdapt.class)
public class PersonAdaptServiceImpl extends BaseService implements PersonAdaptService {

    Logger logger = LoggerFactory.getLogger(PersonAdaptServiceImpl.class);

    @Autowired
    private PersonAdaptDao personAdaptDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Override
    public int delete(PersonAdapt personAdapt) {
        User currentUser = arsUtil.getCurrentUser();
        personAdapt.setUpdateTime(new Date());
        personAdapt.setUpdateBy(currentUser.getUsername());
        return personAdaptDao.delete(personAdapt);
    }

    @Override
    public int save(PersonAdapt personAdapt) {
        //User currentUser = arsUtil.getCurrentUser();

        if(StringUtil.isNotEmpty(personAdapt.getConfirmCerUrl())){
            personAdapt.setConfirmCerUrl(getPhotoPath(personAdapt.getConfirmCerUrl()));
        }

        PersonAdapt dbPersonAdapt = personAdaptDao.findById(personAdapt.getId());
        if(dbPersonAdapt == null){
            personAdapt.setCreateTime(new Date());
        }else{
            BeanUtils.copyPropertiesIgnore(personAdapt,dbPersonAdapt,true);
            BeanUtils.copyPropertiesIgnore(dbPersonAdapt,personAdapt,false);
        }

        personAdapt.setActive(true);
        //personAdapt.setUpdateBy(currentUser.getUsername());
        personAdapt.setUpdateTime(new Date());
        personAdapt.setUpdateflag(true);
        //personAdapt.setAreaCode(currentUser.getPolice().getAreacode());
        return personAdaptDao.save(personAdapt);
    }

    @Override
    public PersonAdapt findById(Long id) {
        return personAdaptDao.findById(id);
    }

    @Override
    public void searchForPage(PersonAdaptPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       personAdaptDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<PersonAdapt> list) {
        List<PersonAdapt> dbList = personAdaptDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            Map<Long, PersonAdapt> dbCensorStatusMap = dbList.stream().collect(Collectors.toMap(PersonAdapt::getId,Function.identity()));

            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            for (PersonAdapt personAdapt : list) {
                personAdapt.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        //外网背景筛查为空。内网背景筛查不为空 同步给百课堂
                        if(dbCensorStatusMap.get(personAdapt.getId()) != null
                                && StringUtil.isEmpty(dbCensorStatusMap.get(personAdapt.getId()).getCensorStatus())
                                && StringUtil.isNotEmpty(personAdapt.getCensorStatus())) {
                            param = new JSONObject();
                            param.put("adaptApplyId", personAdapt.getId()+"");
                            param.put("backgroundStatus", personAdapt.getCensorStatus());
                            param.put("approvalState", personAdapt.getApprovalState());
                            param.put("backgroundFailReason", personAdapt.getApprovalReason());
                            /**
                             * 背景筛查类型
                             * 1. 系统自动比对
                             * 2. 申诉通道
                             */
                            param.put("backgroundType", Constants.BACKGROUNDTYPE_SYSTEM);
                            paramArr.add(param);
                        }
                        personAdapt.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, personAdapt.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if(!configUtils.isIntranet() && paramArr.size() > 0){
                //TODO 背景筛查结果同步给百课堂
                Map<String,Object> paramMap = new HashMap<>();
                paramMap.put("personList", JSON.toJSONString(paramArr));
                AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_PERSONADAPT_CENSOR_URL,paramMap);
                if(!result.isSuccessful()){
                    throw new ArsException("【等级证报名背景筛查结果】"+result.getMsg());
                }
            }

            personAdaptDao.saveBatch(list);
        }
    }

    @Override
    public List<PersonAdapt> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return personAdaptDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<PersonAdapt> findDSOutList(String startDate) {
        return personAdaptDao.findDSOutList(startDate);
    }

    @Override
    public List<PersonAdapt> findByBatchId(List<PersonAdapt> list) {
        return personAdaptDao.findByBatchId(list);
    }

    @Override
    public void batchUpdate(List<PersonAdapt> list) {
        List<PersonAdapt> dbList = personAdaptDao.findByBatchId(list);

        if(dbList.size() > 0){
            Map<Long, PersonAdapt> personAdaptMap = list.stream().collect(Collectors.toMap(PersonAdapt::getId, Function.identity()));

            PersonAdapt personAdapt = null;
            for (PersonAdapt dbPersonAdapt : dbList) {
                personAdapt = personAdaptMap.get(dbPersonAdapt.getId());
                BeanUtils.copyPropertiesIgnore(personAdapt,dbPersonAdapt,true);
                dbPersonAdapt.setUpdateTime(new Date());
                dbPersonAdapt.setUpdateflag(true);
            }
            personAdaptDao.saveBatch(dbList);
        }
    }

    @Override
    public void updateSelective(PersonAdapt personAdapt) {
        User currentUser = arsUtil.getCurrentUser();
        personAdapt.setUpdateTime(new Date());
        personAdapt.setUpdateBy(currentUser.getUsername());
        personAdaptDao.updateSelective(personAdapt);
    }
}
