package com.bcxin.ars.service.sb.impl;


import com.bcxin.ars.dao.sb.PerCheckRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.PerCheckRecordPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.PerCheckRecord;
import com.bcxin.ars.service.sb.PerCheckRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

import java.util.List;

/**
 * 抽查记录Service业务层处理
 *
 * @author lin
 * @date 2020-12-09
 */
@Service
public class PerCheckRecordServiceImpl implements PerCheckRecordService {

    Logger logger = LoggerFactory.getLogger(PerCheckRecordServiceImpl.class);

    @Autowired
    private PerCheckRecordDao perCheckRecordDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(PerCheckRecord perCheckRecord) {
        User currentUser = arsUtil.getCurrentUser();
        perCheckRecord.setUpdateTime(new Date());
        perCheckRecord.setUpdateBy(currentUser.getUsername());
        return perCheckRecordDao.delete(perCheckRecord);
    }

    @Override
    public int save(PerCheckRecord perCheckRecord) {
        if (perCheckRecord.getId() == null) {
            perCheckRecord.setCreateTime(new Date());
        } else {
            PerCheckRecord dbPerCheckRecord = perCheckRecordDao.findById(perCheckRecord.getId());
            BeanUtils.copyPropertiesIgnore(perCheckRecord, dbPerCheckRecord, true);
            BeanUtils.copyPropertiesIgnore(dbPerCheckRecord, perCheckRecord, false);
        }

        perCheckRecord.setActive(true);
        perCheckRecord.setUpdateTime(new Date());
        perCheckRecord.setUpdateflag(true);
        return perCheckRecordDao.save(perCheckRecord);
    }

    @Override
    public PerCheckRecord findById(Long id) {
        return perCheckRecordDao.findById(id);
    }

    @Override
    public void searchForPage(PerCheckRecordPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        perCheckRecordDao.searchForPage(dto, page);
    }

    @Override
    public void importBatch(List<PerCheckRecord> list) {
        List<PerCheckRecord> dbList = perCheckRecordDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PerCheckRecord perCheckRecord : list) {
                perCheckRecord.setUpdateflag(false);
                try {
                    if (!configUtils.isIntranet()) {
                        perCheckRecord.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, perCheckRecord.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            perCheckRecordDao.saveBatch(list);
        }
    }

    @Override
    public List<PerCheckRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return perCheckRecordDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<PerCheckRecord> findDSOutList(String startDate) {
        return perCheckRecordDao.findDSOutList(startDate);
    }

    @Override
    public List<PerCheckRecord> findByBatchId(List<PerCheckRecord> list) {
        return perCheckRecordDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(PerCheckRecord perCheckRecord) {
        User currentUser = arsUtil.getCurrentUser();
        perCheckRecord.setUpdateTime(new Date());
        perCheckRecord.setUpdateBy(currentUser.getUsername());
        perCheckRecordDao.updateSelective(perCheckRecord);
    }
}
