package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.ConfesscompanyDao;
import com.bcxin.ars.dao.sb.ConfesscompanyDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ConfesscompanySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompany;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.ConfesscompanyService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Zxzybaydwxx;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Confesscompany.class)
public class ConfesscompanyServiceImpl implements ConfesscompanyService {


    private Logger logger = LoggerFactory.getLogger(ConfesscompanyServiceImpl.class);

    @Autowired
    private ConfesscompanyDao confesscompanyDao;

    @Autowired
    private ConfesscompanyDaoAop confesscompanyDaoAop;

    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private ClientUtil clientUtil;

    @Override
    public Confesscompany findById(long id) {
        Confesscompany result = confesscompanyDao.findById(id);
        if (result != null) {
            //查询审批信息
            result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.ZXZY));

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }
    @Override
    public  List<Confesscompany> findByBatchId(List<Approval> approvalList){
        return  confesscompanyDao.findByBatchId(approvalList);
    }
    @Override
    public  void updateBatch(List<Confesscompany> list){
        confesscompanyDaoAop.updateBatch(list);
    }

    @Override
    public void saveOrUpdateBypolice(Confesscompany confesscompany) {
        User currentUser = arsUtil.getCurrentUser();
        //2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
        if((null!=confesscompany.getCompanytype()&& !confesscompany.getCompanytype().contains("9"))|| null == confesscompany.getCompanytype()){
            confesscompany.setOtherCompanyTypeName(null);
        }
        if((null!=confesscompany.getManagement()&&!confesscompany.getManagement().contains("20"))|| null ==confesscompany.getManagement()){
            confesscompany.setOtherSecScopeType(null);
        }
        //区域赋值
        Police police= currentUser.getPolice();
        String areacode =  police.getAreacode();
        //如果是省级新增的的 ,市级跟区级默认省级.否则区域不变  2018年8月9日09:25:16 wjb
        if(areacode.endsWith("0000")){//省
            if(currentUser.getPlatform() == 1 && confesscompany.getId() == null){
                confesscompany.setProvince(areacode.substring(0,2)+"0000");
                confesscompany.setDistrict(areacode.substring(0,2)+"0000");
                confesscompany.setCity(areacode.substring(0,2)+"0000");
            }
        }else if(areacode.endsWith("00")){
            //如果是市级的  则市级跟区级是一样的
            confesscompany.setProvince(areacode.substring(0,2)+"0000");
            confesscompany.setDistrict(areacode);
            confesscompany.setCity(areacode);
        }else{
            //如果是区级的  则省市区
            confesscompany.setProvince(areacode.substring(0,2)+"0000");
            confesscompany.setCity(areacode.substring(0,4)+"00");
            confesscompany.setDistrict(areacode);
        }

        if (confesscompany.getId() == null) {
            Confesscompany checkConfesscompany = confesscompanyDao.findApproveByCompanyName(confesscompany);
            if(checkConfesscompany != null){
                throw  new ArsException(confesscompany.getCompanyname() + "(名称)重复，不能重复备案！");
            }else{
                checkConfesscompany = confesscompanyDao.findApproveByCreditcode(confesscompany);
                if(checkConfesscompany != null){
                    throw  new ArsException(confesscompany.getCreditcode() + "(社会统一信用代码)重复，不能重复备案！");
                }
            }



            confesscompany.setActive(true);
            confesscompany.setCreateTime(new Date());
            confesscompany.setUpdateTime(new Date());
            confesscompany.setUpdateBy(currentUser.getUsername());
            //TODO
            confesscompany.setUserid(currentUser.getId());
            //待审批或暂存
            confesscompanyDao.save(confesscompany);

        } else {
            Confesscompany checkConfesscompany = confesscompanyDao.findApproveByCompanyName(confesscompany);
            if(checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()){
                throw  new ArsException(confesscompany.getCompanyname() + "(名称)重复，不能重复备案！");
            }else{
                checkConfesscompany = confesscompanyDao.findApproveByCreditcode(confesscompany);
                if(checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()){
                    throw  new ArsException(confesscompany.getCreditcode() + "(社会统一信用代码)重复，不能重复备案！");
                }
            }

            Confesscompany dbConfesscompany = confesscompanyDao.findById(confesscompany.getId());

            if(ApprovalState.WTJ.equals(confesscompany.getApprovalstate())){
                BeanUtils.copyPropertiesIgnore(confesscompany,dbConfesscompany,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(confesscompany,dbConfesscompany,true);
            }

            dbConfesscompany.setUpdateTime(new Date());
            dbConfesscompany.setUpdateBy(currentUser.getUsername());
            dbConfesscompany.setOtherCompanyTypeName(confesscompany.getOtherCompanyTypeName());
            dbConfesscompany.setOtherSecScopeType(confesscompany.getOtherSecScopeType());

            confesscompanyDaoAop.update(dbConfesscompany);
        }
    }

    @Override
    public void searchForPage(ConfesscompanySearchDto dto, AjaxPageResponse<Confesscompany> page) {
        arsUtil.setPoliceSearch(dto);
        confesscompanyDao.searchForPage(dto,page);
    }

    @Override
    public void saveOrUpdate(Confesscompany confesscompany) {
        User currentUser = arsUtil.getCurrentUser();
        /**
         * 最后一级机构id处理
         */
        if(confesscompany.getOrgid() == null){
            if(confesscompany.getDistrictOrgId() != null){
                confesscompany.setOrgid(Long.parseLong(confesscompany.getDistrictOrgId()));
            }else if(confesscompany.getCityOrgId() != null){
                confesscompany.setOrgid(Long.parseLong(confesscompany.getCityOrgId()));
            }
        }

        if(currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4){
            confesscompany.setUserid(currentUser.getId());
        }

        //2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
        if((null!=confesscompany.getCompanytype()&& !confesscompany.getCompanytype().contains("9"))|| null == confesscompany.getCompanytype()){
            confesscompany.setOtherCompanyTypeName(null);
        }
        if (confesscompany.getId() == null) {
            //开发任务 #10165
            if(!Constants.APPROVALSTATE_WTJ.equals(confesscompany.getApprovalstate())){
                Confesscompany checkConfesscompany = confesscompanyDao.findApproveByCompanyName(confesscompany);
                if(checkConfesscompany != null){
                    throw  new ArsException(confesscompany.getCompanyname() + "(名称)重复，不能重复备案！");
                }else{
                    checkConfesscompany = confesscompanyDao.findApproveByCreditcode(confesscompany);
                    if(checkConfesscompany != null){
                        throw  new ArsException(confesscompany.getCreditcode() + "(社会统一信用代码)重复，不能重复备案！");
                    }
                }
            }


            confesscompany.setActive(true);
            confesscompany.setCreateTime(new Date());
            confesscompany.setUpdateTime(new Date());
            confesscompany.setUpdateBy(currentUser.getUsername());
            //待审批或暂存
            confesscompanyDao.save(confesscompany);

            //保存审批信息 手动添加不走流程  isauto 为true 要走流程
            if(confesscompany.isIsauto()){
                if (ApprovalState.DSH.equals(confesscompany.getApprovalstate())) {
                    //TODO 保存审批信息
                    approvalUtil.saveApproval(BusinessType.ZXZY, confesscompany.getId(), Constants.ACTIVITI_PROCESS_CONFESSCOMPANY);
                }
            }
        } else {
            //开发任务 #10165
            if(!confesscompany.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                Confesscompany checkConfesscompany = confesscompanyDao.findApproveByCompanyName(confesscompany);
                if(checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()){
                    throw  new ArsException(confesscompany.getCompanyname() + "(名称)重复，不能重复备案！");
                }else{
                    checkConfesscompany = confesscompanyDao.findApproveByCreditcode(confesscompany);
                    if(checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()){
                        throw  new ArsException(confesscompany.getCreditcode() + "(社会统一信用代码)重复，不能重复备案！");
                    }
                }
            }

            Confesscompany dbConfesscompany = confesscompanyDao.findById(confesscompany.getId());

            boolean activity = true;
            if(StringUtil.isNotEmpty(dbConfesscompany.getApprovalstate()) && dbConfesscompany.getApprovalstate().equals(ApprovalState.DSH)){
                if(dbConfesscompany.getOrgid().toString().equals(confesscompany.getOrgid().toString())){
                    activity = false;
                    if(!dbConfesscompany.getCompanyname().equals(confesscompany.getCompanyname())) {
                        Approval approval = approvalDAO.findBybusinessidAndType(confesscompany.getId(), BusinessType.ZXZY);
                        if (approval != null) {
                            approvalUtil.updateContent(approval, confesscompany.getCompanyname());
                        }
                    }
                }
            }
            if(ApprovalState.WTJ.equals(confesscompany.getApprovalstate())){
                BeanUtils.copyPropertiesIgnore(confesscompany,dbConfesscompany,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(confesscompany,dbConfesscompany,true);
            }


            dbConfesscompany.setUpdateTime(new Date());
            dbConfesscompany.setUpdateBy(currentUser.getUsername());
            dbConfesscompany.setOtherCompanyTypeName(confesscompany.getOtherCompanyTypeName());


            //待审批
            if(!dbConfesscompany.isIsauto()){
                if (confesscompany.getApprovalstate() != null && !"".equals(confesscompany.getApprovalstate()) && !ApprovalState.DSH.equals(confesscompany.getApprovalstate())) {
                    dbConfesscompany.setApprovalstate(confesscompany.getApprovalstate());
                }
            }else {
                //2018年8月23日17:12:15 wjb 增加判断是否已经暂存过的
                if (confesscompany.getApprovalstate() != null && !"".equals(confesscompany.getApprovalstate()) && !ApprovalState.DSH.equals(confesscompany.getApprovalstate())) {
                    dbConfesscompany.setApprovalstate(confesscompany.getApprovalstate());
                } else {
                    dbConfesscompany.setApprovalstate(ApprovalState.DSH);
                    dbConfesscompany.setChargecensorstatus("");
                    dbConfesscompany.setLegalcensorstatus("");
                }

            }


            confesscompanyDaoAop.update(dbConfesscompany);

            //TODO 保存审批信息
            if (activity && ApprovalState.DSH.equals(dbConfesscompany.getApprovalstate())) {
                approvalUtil.saveApproval(BusinessType.ZXZY, dbConfesscompany.getId(), Constants.ACTIVITI_PROCESS_CONFESSCOMPANY);
            }

            //TODO 审批通过之后上报部级
            if(dbConfesscompany.getApprovalstate()!=null && dbConfesscompany.getApprovalstate().equals(ApprovalState.SHTG)){
                //部级接口对接  ---自行招用保安员的单位信息上报
                new Thread(()->{ //异步处理
                    try {
                        //生成实体
                        Zxzybaydwxx zxzybaydwxx =new Zxzybaydwxx();
                        //自行招用保安员的单位编码
                        zxzybaydwxx.setDwbm(dbConfesscompany.getLicencenum());
                        //调用send方法完成对接
                        clientUtil.send(Constants.XXXBA_ZXZYBAYDWXX,zxzybaydwxx);

                    } catch(Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }).start();

            }
        }
    }

    @Override
    public void saveOrUpdateForDS(Confesscompany confesscompany) {

		if(confesscompany.getActive() == null){
			confesscompany.setActive(true);
		}
		
        Confesscompany dbConfesscompany = confesscompanyDao.findById(confesscompany.getId());
        if (dbConfesscompany != null) {
        	if(confesscompany.getUpdateTime().getTime() > dbConfesscompany.getUpdateTime().getTime()){
                confesscompany.setChargecensorstatus(dbConfesscompany.getChargecensorstatus());
                confesscompany.setLegalcensorstatus(dbConfesscompany.getLegalcensorstatus());
        		confesscompanyDaoAop.update(confesscompany);
			}
        } else {
            confesscompanyDao.save(confesscompany);
        }
    }

    @Override
    public ConfesscompanySearchDto search(ConfesscompanySearchDto dto) {
        ConfesscompanySearchDto resultDto = new ConfesscompanySearchDto();

        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        String areacode = "";
        if (dto.getAreaCode() != null) {
            areacode = dto.getAreaCode();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }
        }
        if(areacode.endsWith("0000")){//省
            dto.setDistrict(areacode.substring(0,2)+"____");
        }else if(areacode.endsWith("00")){//市
            dto.setDistrict(areacode.substring(0,4)+"__");
        }else{//区
            dto.setDistrict(areacode);
        }

        List<Confesscompany> list = confesscompanyDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(confesscompanyDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public Confesscompany findByUser(Long userid) {
        return confesscompanyDao.findByUser(userid);
    }

    @Override
    public List<Confesscompany> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return confesscompanyDao.searchForDataSynchronization(dto);
    }

	@Override
	public List<Confesscompany> findAll() {
		return confesscompanyDao.findAll();
	}

    @Override
    public PageResult searchConfesscompanyList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }

        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("district", areacode.substring(0, 4) + "__");
            } else {//区
                p.put("district", areacode);
            }
        }

        if (police != null) {
            if ("4".equals(police.getOrgtype())) {
                p.put("orgid", police.getId());
            }
        }

        //查询走流程的
        p.put("isauto","1");
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                p.put("userid", currentUser.getId());
            }
        }
        return new PageResult(confesscompanyDao.countConfesscompanyList(p), confesscompanyDao.searchConfesscompanyList(p));
    }

    @Override
    public void delete(Confesscompany confesscompany) {
        confesscompany.setUpdateTime(new Date());
        confesscompanyDaoAop.delete(confesscompany);
    }

    @Override
    public void saveOrUpdateForApproval(Confesscompany confesscompany) {
        confesscompany.setUpdateTime(new Date());
        confesscompanyDaoAop.update(confesscompany);
    }

    /**
     * 根据单据id查询申请人信息
     * @param id
     * @return
     */
    @Override
    public Map<String,Object> selectApplyUserInfoWithId(Long id){
        return confesscompanyDao.selectApplyUserInfoWithId(id);
    }

    @Override
    public void updateCensorStatus(Confesscompany confesscompany) {
        confesscompanyDaoAop.update(confesscompany);
    }

    @Override
    public void saveOrUpdateForApprovalImport(Confesscompany confcesscompany) {
        confesscompanyDaoAop.update(confcesscompany);
    }


}
