package com.bcxin.ars.service.sb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.sb.ActivityRepairDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.ActivityRepairApprovalDto;
import com.bcxin.ars.dto.ActivityRepairApprovalSearchDto;
import com.bcxin.ars.dto.ActivityRepairDto;
import com.bcxin.ars.dto.approve.ApproveTempOrgDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.redis.RedisUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.activiti.bpmn.model.*;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author linqinglin
 * @date 2018/09/26 0026 9:45
 */
@Service
@Transactional
public class ActivityRepairServiceImpl implements ActivityRepairService {

    private Logger logger = LoggerFactory.getLogger(ActivityRepairServiceImpl.class);


    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private PctinfoService pctinfoService;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;

    @Autowired
    private ActivityRepairDao activityRepairDao;

    @Resource
    private TaskService taskService;

    @Resource
    private HistoryService historyService;

    @Autowired
    private ApprovalUtil approvalUtil;

    @Resource
    private RepositoryService repositoryService;

    @Resource
    private RuntimeService runtimeService;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ApproveTempDao approveTempDao;

    @Override
    public void resetProcess(Long personcertificateId) {
        Personcertificate personcertificate = personcertificateDao.findById(personcertificateId);
        personcertificate.setApprovalstate(ApprovalState.DSH);
        personcertificate.setCardState(null);
        personcertificate.setSignConfirm(null);
        personcertificate.setSumScore(null);
        personcertificate.setWrittenScore(null);
        personcertificate.setTestState(null);
        personcertificate.setPayConfirm(null);
        personcertificate.setOperateScore(null);
        personcertificate.setFingerprint(null);
        personcertificate.setFingercardState(null);
        personcertificate.setFeeState(null);
        personcertificate.setExamState(null);
        personcertificate.setExamAddress(null);
        personcertificate.setExamEnd(null);
        personcertificate.setExamStart(null);
        personcertificate.setExamSubject(null);
        personcertificate.setExamTimes(null);
        restartProcess(personcertificate);
    }

    @Override
    public void restartProcess(Long personcertificateId) {
        Personcertificate personcertificate = personcertificateDao.findById(personcertificateId);
        restartProcess(personcertificate);
    }

    /**
     * 重新启动流程
     * @param personcertificate
     */
    private void restartProcess(Personcertificate personcertificate) {
        try{
            personcertificate.setUpdateTime(new Date());
            personcertificate.setUpdateflag(true);
            //更新审批信息
            approvalUtil.savePersonApproval(BusinessType.BAYZ, personcertificate.getId(), Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
            Thread.sleep(2000);
            Approval approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
            //如果已缴费未考试通过，则跳到考试安排
            if(StringUtil.isNotEmpty(personcertificate.getFeeState()) &&
                    personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)
                    && (
                    StringUtil.isEmpty(personcertificate.getTestState()) ||
                            !personcertificate.getTestState().equals(Constants.FEE_STATE_YJF))){
                //999考试安排专用的
                while (!"999".equals(approval.getGroupid())) {
                    saveApproval_new(approval);
                    Thread.sleep(2000);
                    approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                }
            }
            personcertificate.setApprovalstate(approval.getApprovalstate());
            personcertificate.setGroupid(approval.getGroupid());
            personcertificateDaoAop.update(personcertificate);
        }catch (Exception e){
            logger.error(e.getMessage());
        }
    }

    @Override
    public void skipProcess(ActivityRepairDto activityRepairDto) {
        activityRepairDao.skipProcess(activityRepairDto);
    }

    @Override
    public void batchRepulse(Long[] personIds) {
        activityRepairDao.batchRepulse(personIds);
    }
    @Override
    public void batchRepulseAndNotFeeState(Long[] personIds) {
        activityRepairDao.batchRepulseAndNotFeeState(personIds);
    }

    private void saveApproval_new(Approval approval) {
        String newGroupid = "";
        String taskDefinitionKey = "";
        String processName = "";
        //User currentUser = arsUtil.getCurrentUser();
        //审批人
        approval.setApprovalperson("system");
        //审批日期
        approval.setApprovaldate(new Date());
        //审批原因
        approval.setApprovalreason("系统自动审批");
        Task task = null;
        if(StringUtil.isEmpty(approval.getProcessInstanceId())){
            return;
        }
        List<HistoricActivityInstance> list1 = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
        if (list1 != null && list1.size() > 0) {
            for (HistoricActivityInstance hai : list1) {
                logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                //判断是否为子流程
                if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                    // 根据流程实例Id查询任务
                    processName = hai.getActivityName();
                    task = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                }
            }
        }
        if (task == null) {
            task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
        }

        Map<String, Object> variables = new HashMap<String, Object>();
        if(ApprovalState.SHBTG.equals(approval.getApprovalstate())){
            variables.put("msg", Constants.APPROVAL_MSG_BTG);
            approval.setApprovalreason("系统自动审批");
        }else{
            variables.put("msg", Constants.APPROVAL_MSG_TG);
            approval.setApprovalreason("系统自动审批");

            if(approval.getGroupid().equals("999")){
                variables.put("testState", "1");
            }
        }

        processName = processName + "--" + task.getName();
        logger.info(processName);
        // 设置用户id
        //Authentication.setAuthenticatedUserId(currentUser.getRealname());
        // 完成任务
        taskService.complete(task.getId(), variables);

        Task newTask = null;
        List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
        if (list != null && list.size() > 0) {
            for (HistoricActivityInstance hai : list) {
                logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                //判断是否为子流程
                if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                    // 根据流程实例Id查询任务
                    newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                }
            }
        }

        if (newTask == null) {
            newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
        }
        // 根据流程实例Id查询任务
        if (newTask != null && !ApprovalState.SHBTG.equals(approval.getApprovalstate())) {
            List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
            if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                IdentityLink identityLink = newTaskEntitys.get(0);
                newGroupid = identityLink.getGroupId();
            }
            taskDefinitionKey = newTask.getTaskDefinitionKey();
            if (StringUtil.isNotEmpty(newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty(newTask.getName()))) {
                approval.setNextPerson(newTask.getName());
                approval.setApprovalstate(ApprovalState.SPZ);
            } else {
                approval.setNextPerson("");
            }
        }else{
            approval.setNextPerson("");
        }
        if(!approval.getApprovalstate().equals(ApprovalState.SHBTG) && StringUtil.isEmpty(approval.getNextPerson())){
            approval.setApprovalstate(ApprovalState.SHTG);
        }
        //设置当前审批候选组
        approval.setTaskDefinitionKey(taskDefinitionKey);
        approval.setGroupid(newGroupid);
        approval.setUpdateTime(new Date());
        approval.setUpdateflag(true);
        approval.setOldRev(false);
        approvalDAO.update(approval);
    }

    /**
     * 旧审批转新审批
     * @param approval
     */
    @Override
    public void approvalOldToNew(Approval approval){
        try{
            if(BusinessType.BAYZ.equals(approval.getBusinesstype())){
                Personcertificate personcertificate = personcertificateDao.findById(approval.getBusinessid());
                //第一种情况：待审批及审批中但未缴费 跳到第一级审批
                if(StringUtil.isEmpty(personcertificate.getFeeState()) || personcertificate.getFeeState().equals(Constants.FEE_STATE_WJF)){
                    if(StringUtil.isNotEmpty(personcertificate.getFingerprint())){
                        //重置activiti流程
                        approvalUtil.savePersonApproval(BusinessType.BAYZ, personcertificate.getId(), Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
                        Thread.sleep(2000);
                        approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                        personcertificate.setGroupid(approval.getGroupid());
                        personcertificate.setUpdateflag(true);
                        personcertificate.setUpdateTime(new Date());
                        personcertificateDaoAop.update(personcertificate);
                    }
                }else if(personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)){
                    //第二种情况：已缴费未考试 跳到 考试安排
                    if(personcertificate.getSumScore() == null || StringUtil.isEmpty(personcertificate.getSumScore().toString())){
                        //重置activiti流程
                        approvalUtil.savePersonApproval(BusinessType.BAYZ, personcertificate.getId(), Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
                        Thread.sleep(2000);
                        approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                        //当没到考试安排时执行
                        while (!"999".equals(approval.getGroupid())) {
                            saveApproval_new(approval);
                            Thread.sleep(2000);
                            approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                            personcertificate.setGroupid(approval.getGroupid());
                            personcertificate.setUpdateflag(true);
                            personcertificate.setUpdateTime(new Date());
                            personcertificateDaoAop.update(personcertificate);
                        }
                    }else{
                        //第三种情况：考试通过 跳到 考试安排之后
                        //重置activiti流程 并跳到考试安排之后
                        approvalUtil.savePersonApproval(BusinessType.BAYZ, personcertificate.getId(), Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
                        Thread.sleep(2000);
                        approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                        personcertificate.setGroupid(approval.getGroupid());
                        personcertificate.setUpdateTime(new Date());
                        personcertificate.setUpdateflag(true);
                        personcertificateDaoAop.update(personcertificate);
                    }
                }
            }else {
                int seq = getApproveSeq(approval);
                restartApproval(approval);
                Thread.sleep(2000);
                while (seq > 0) {
                    saveApproval_new(approval);
                    seq--;
                    Thread.sleep(2000);
                }
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
    }

    /**
     * 旧审批转新审批
     * @param approvalId
     */
    @Override
    public void approvalOldToNew(Long approvalId){
        Approval approval = approvalDAO.getById(approvalId);
        approvalOldToNew(approval);
    }

    /**
     * 重启审批
     * @param approval
     */
    private void restartApproval(Approval approval){
        Config configVersion = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        if (approval != null && configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())) {
            restartApproval_new(approval);
        } else {
            restartApproval_old(approval);
        }
    }




    /**
     * 重启旧审批
     * @param approval
     */
    private void restartApproval_old(Approval approval){
        String newGroupid = "";
        //读取配置文件
        Config config = configUtils.getConfigByKey("police");
        //获取内网的apprvoal outProcessInstanceId不一样代表是修改，一样保持不变
        logger.info("begin startApply process!!!");
        //eidt subh 2019-02-26 　根据审批记录获取流程Key
        String processKey = approvalUtil.getBusinessTypeForActKey(approval);

        String testState = "";
        Long policeId = 0L;
        //指派民警字段
        if (approval.getPoliceid() != null) {
            policeId = approval.getPoliceid();
        }

        if (StringUtil.isNotEmpty(processKey)) {
            // TODO  工作流
            Map<String, Object> variables = new HashMap<String, Object>();
            //业务ID
            variables.put("businessid", approval.getBusinessid());
            variables.put("testState", testState);
            variables.put("policeid", policeId);
            variables.put("areaCode", approval.getAreaCode().substring(0, 4) + "00");
            String processInstanceId = "";
			// 启动流程
            ProcessInstance pi = runtimeService.startProcessInstanceByKey(processKey + approval.getAreaCode().substring(0, 4) + "00", variables);
            processInstanceId = pi.getProcessInstanceId();
            approval.setProcessInstanceId(processInstanceId);
            approval.setInProcessInstanceId(processInstanceId);
            if (config.getValue().equals("1")) {
                approval.setUpdateflag(true);
            }

            // }
            // 根据流程实例Id查询任务
            Task task = taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            // 完成 任务提交
            taskService.complete(task.getId(), variables);

            // 根据流程实例Id查询任务
            Task newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
            if (newTask != null) {
                List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
                if (StringUtil.isNotEmpty(newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty(newTask.getName()))) {
                    approval.setNextPerson(newTask.getName());
                } else {
                    approval.setNextPerson("");
                }
            }

            //设置当前审批候选组
            approval.setGroupid(newGroupid);
            approvalDAO.update(approval);
        }
    }
    /**
     * 重启新审批
     * @param approval
     */
    private void restartApproval_new(Approval approval){
        //User currentUser = arsUtil.getCurrentUser();
        //eidt subh 2019-02-26 　根据审批记录获取流程Key
        String processKey = approvalUtil.getBusinessTypeForActKey(approval);


        //区域编码
        String areaCode = approval.getAreaCode();

        ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
        if(approveTemp == null){
            //区域编码
            areaCode = areaCode.substring(0,4)+"00";
            approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
            if(approveTemp == null) {
                approveTemp = approveTempDao.findByTempCode(processKey);
            }
        }
        Long policeId = 0L;

        Map<String,Object> variables=new HashMap<String,Object>();
        String newGroupid = "";

        //考试状态
        String testState ="";
        //机构ID
        Long orgId = approval.getOrgid();
        //业务ID
        variables.put("businessid", approval.getBusinessid());
        // 启动流程ID
        String processInstanceId = "";
        approval.setApprovaldate(null);
        approval.setApprovalreason(null);
        approval.setReplyreason("");
        approval.setReplyRar("");
        approval.setReplystate("");
        approval.setInfoRar("");
        //指派民警字段
        if(approval.getPoliceid()!=null) {
            policeId = approval.getPoliceid();
        }
        //TODO 根据机构ID判断是否已经配置审批流程
        if(orgId == null) {
            throw  new ArsException(approval.getContext() + " 没有选择办事机构，不能提交审批！");
        }
        processKey = approveTemp.getTempCode();

        ApproveTempOrgDto approveTempOrgDto = new ApproveTempOrgDto();
        approveTempOrgDto.setPoliceId(orgId.toString());
        if(processKey!=null){
            approveTempOrgDto.setTempCode(processKey);
        }
        try {
            //生成流程，唯一标识：业务名称+机构ID
            ProcessInstance pi = runtimeService.startProcessInstanceByKey(processKey +"-"+ orgId, variables);
            processInstanceId = pi.getProcessInstanceId();
            // 根据流程实例Id查询任务
            Task task = taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            // 完成 任务提交
            variables.put("areaCode", areaCode);//区域编码
            variables.put("policeid", policeId);//民警ID
            variables.put("testState", testState);//考试状态
            taskService.complete(task.getId(), variables);

            //查询历史
            Task newTask = null;
            List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
            if(list != null && list.size()>0){
                for(HistoricActivityInstance hai : list){
                    logger.info(hai.getId()+"  "+hai.getActivityName()+"  "+hai.getCalledProcessInstanceId());
                    //判断是否为子流程
                    if(hai.getCalledProcessInstanceId()!=null && hai.getEndTime()==null ){
                        // 根据流程实例Id查询任务
                        newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                    }
                }
            }

            if(newTask != null) {
                //审批对象
                approval.setNextPerson(newTask.getName());//下一个审批人
                approval.setProcessInstanceId(processInstanceId);//子流程ID
                approval.setInProcessInstanceId(processInstanceId);//内网流程ID
                approval.setOutProcessInstanceId(processInstanceId);//外网流程ID

                List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
            }
            approval.setGroupid(newGroupid);
            approval.setUpdateBy("system");//更新者
            approval.setUpdateTime(new Date());//更新时间
            //审批状态：待审批
            approval.setApprovalstate(ApprovalState.DSH);
            //保存信息
            approval.setOldRev(false);
            approvalDAO.update(approval);
        }catch(Exception e){
            e.printStackTrace();
            throw  new ArsException("未配置审批流程，不能提交审批！");
        }
    }

    /**
     * 获取旧审批到第几个环节
     * @param approval
     * @return
     */
    @Override
    public synchronized int getApproveSeq(Approval approval){
        int seq = 0;
        Map<String, Object> flowMap;

        //获取下一级审批信息
        Task task = taskService.createTaskQuery().processInstanceId(approval.getInProcessInstanceId()).singleResult();

        if(task != null){
            //审批环节id
            String targetId = task.getTaskDefinitionKey();

            //业务类型及城市代码对应的key
            String proKey = task.getProcessDefinitionId();
            String value = "";
            try {
                //从缓存中获取相应的审批环节index
                value = redisUtil.get("activiti_process:"+proKey);
            } catch (RuntimeException ex) {
                logger.error("cache缓存获取异常[{}]", "config");
            }

            //缓存中如果有值直接返回
            if (StringUtil.isNotEmpty(value)) {
                JSONObject  jsonObject = JSONObject.parseObject(value);
                //json对象转Map
                flowMap = jsonObject;
            }else {
                logger.info("从数据库中重新获取审批流程[{}]", targetId);
                //获取整个审批流程配置信息
                BpmnModel bpmnModel = repositoryService.getBpmnModel(proKey);
                //主流程
                Process mainProcess = bpmnModel.getMainProcess();
                List<StartEvent> startEvents = mainProcess.findFlowElementsOfType(StartEvent.class);
                String startId = "";
                //获取开始环节id
                for (StartEvent startEvent : startEvents) {
                    startId = startEvent.getId();
                }
                flowMap = Collections.synchronizedMap(new HashMap<String, Object>());
                //获取流程环节关联信息
                List<SequenceFlow> sequenceFlows = mainProcess.findFlowElementsOfType(SequenceFlow.class);

                //循环获取各环节所处位置
                while (true) {
                    //遍历获取下一级审批环节id
                    for (SequenceFlow sequenceFlow : sequenceFlows) {
                        if (startId.equals(sequenceFlow.getSourceRef())) {
                            //排除非正常的流程（不通过，已考试）
                            if (!"${msg=='未通过'}".equals(sequenceFlow.getConditionExpression())
                                    && !"未通过".equals(sequenceFlow.getName())
                                    && !"${testState=='1'}".equals(sequenceFlow.getConditionExpression())
                                    && !"${replystate=='003' }".equals(sequenceFlow.getConditionExpression())
                                    && !"${policeid >0 }".equals(sequenceFlow.getConditionExpression())
                                    ) {
                                startId = sequenceFlow.getTargetRef();
                                break;
                            }
                        }
                    }


                    FlowElement flowElement = mainProcess.getFlowElement(startId);
                    logger.info(flowElement.getName()+"--"+flowElement.getId());
                    //判断下一级审批环节类型
                    if (flowElement instanceof UserTask) {
                        //科长指派民警 新审批无此环节 忽略
                        flowMap.put(startId, seq);
                        if (!"科长指派民警".equals(flowElement.getName())) {
                            seq++;
                        }
                    }
                    //当下一级是结果流程时，跳出循环
                    if (flowElement instanceof EndEvent) {
                        break;
                    }
                }
                //保存到缓存
                if (!flowMap.isEmpty()) {
                    redisUtil.set( "activiti_process:" + proKey, JSON.toJSONString(flowMap));
                }
            }
            //获取下一级审批所在位置
            if(flowMap.get(targetId) != null){
                seq = Integer.parseInt(flowMap.get(targetId).toString());
            }else{
                seq = 0;
            }
        }
        //返回当前审批所在位置
        return seq>0? seq-1:seq;
    }

    /**
     * 分页查询审批记录
     * @param p
     * @return
     */
    @Override
    public PageResult searchApprovalList(Map<Object, Object> p) {
        return new PageResult(activityRepairDao.searchApprovalListCount(p),activityRepairDao.searchApprovalList(p));
    }
    /**
     * 查询哪些数据不能打回
     * @param
     * @return
     */
    @Override
    public List<Personcertificate> checkReturn(Long[] perIds) {
        return activityRepairDao.checkReturn(perIds);
    }
    /**
     * 查询哪些数据能打回的id
     * @param
     * @return
     */
    @Override
    public List<Long> checkCanReturnPerson(Long[] perIds) {
        return activityRepairDao.checkCanReturnPerson(perIds);
    }

    /**
     * 跳到下一级
     * @param approvalId
     */
    @Override
    public void jumpNextProcess(Long approvalId) throws Exception{
        try {
            Approval approval = approvalDAO.getById(approvalId);
            saveApproval_new(approval);
            Thread.sleep(2000);
            activityRepairDao.updateApprovalState(approval);
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            throw e;
        }
    }

    /**
     * 打回流程
     * @param approvalId
     */
    @Override
    public void repulseProcess(Long approvalId) throws Exception{
        try {
            Approval approval = approvalDAO.getById(approvalId);
            activityRepairDao.repulseProcess(approval);
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            throw e;
        }
    }

    /**
     * 重启流程
     * @param approvalId
     */
    @Override
    public void reStartProcess(Long approvalId) throws Exception {
        try {
            Approval approval = approvalDAO.getById(approvalId);
            approval.setApprovalstate(ApprovalState.DSH);
            restartApproval(approval);
            Thread.sleep(2000);
            //approval = approvalDAO.getById(approvalId);
            activityRepairDao.updateApprovalState(approval);
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            throw e;
        }
    }

    @Override
    public void getFinger(Long personId) {
        Personcertificate personcertificate = personcertificateDao.findById(personId);
        Pctinfo pctinfo = pctinfoService.findByIdnumber(personcertificate.getCardnumber());
        if (pctinfo != null) {
            //获取到指纹
            personcertificate.setFingerprint(pctinfo.getBarcode());
            personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
            personcertificateDaoAop.updateSelective(personcertificate);
        }
    }

    /**
     * 搜索审批数据
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     */
    @Override
    public void search(ActivityRepairApprovalSearchDto dto, AjaxPageResponse<ActivityRepairApprovalDto> ajaxPageResponse) {
        activityRepairDao.search(dto,ajaxPageResponse);
    }
}
