package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.msg.SysAttachmentDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.service.msg.SysAttachmentService;
import com.bcxin.ars.service.sys.impl.ApprovalServiceImpl;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SysAttachment.class)
@DataSyncOutAnnotation(getClazz = SysAttachment.class,getImportType = ImportType.BATCH_FILE)
public class SysAttachmentServiceImpl implements SysAttachmentService {
	private Logger logger = LoggerFactory.getLogger(ApprovalServiceImpl.class);

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private IdGeneratorUtil idGeneratorUtil;

	@Value("${sysAttachmentFolder}")
	private String sysAttachmentFolder;


	@Value("${base-folder}")
	private String baseFolder;


	
	@Autowired
	private SysAttachmentDao sysAttachmentDao;
	
	@Override
	public void saveOrUpdate(SysAttachment sysAttachment) {
		User currentUser = arsUtil.getCurrentUser();
		if(sysAttachment.getId() == null) {
			sysAttachment.setId(idGeneratorUtil.createID());
			sysAttachment.setActive(true);
			sysAttachment.setCreateTime(new Date());
			sysAttachment.setUpdateBy(currentUser.getUsername());
			sysAttachment.setUpdateTime(new Date());
			sysAttachment.setUpdateflag(true);
			sysAttachmentDao.save(sysAttachment);
		}else {
			SysAttachment dbSysAttachment = sysAttachmentDao.findById(sysAttachment.getId());
			dbSysAttachment.setBusinessid(sysAttachment.getBusinessid());
			dbSysAttachment.setBusinesstype(sysAttachment.getBusinesstype());
			dbSysAttachment.setPath(sysAttachment.getPath());
			dbSysAttachment.setFileName(sysAttachment.getFileName());
			dbSysAttachment.setFileSize(sysAttachment.getFileSize());
			dbSysAttachment.setUpdateBy(currentUser.getUsername());
			dbSysAttachment.setUpdateTime(new Date());
			dbSysAttachment.setUpdateflag(true);
			sysAttachmentDao.update(dbSysAttachment);
		}
		
	}

	@Override
	public void delete(SysAttachment sysAttachment) {
		User currentUser = arsUtil.getCurrentUser();
		sysAttachment.setActive(false);
		sysAttachment.setUpdateBy(currentUser.getUsername());
		sysAttachment.setUpdateTime(new Date());
		sysAttachmentDao.delete(sysAttachment);
	}

	@Override
	public SysAttachment findById(Long id) {
		return sysAttachmentDao.findById(id);
	}

	@Override
	public void delete(Long id) {
		SysAttachment sysAttachment = sysAttachmentDao.findById(id);
		delete(sysAttachment);
	}
	
	@Override
	public List<SysAttachment> findAllByBusiness(String businessid, String businesstype) {
		return sysAttachmentDao.findAllByBusiness(businessid,businesstype);
	}

	@Override
	public SysAttachment findByBusiness(SysAttachment sysAttachment) {
		return sysAttachmentDao.findByBusiness(sysAttachment.getBusinessid().toString(),sysAttachment.getBusinesstype());
	}

	@Override
	public void importBatch(List<SysAttachment> list, Map<String, String> pathMap) {
		List<SysAttachment> dbList = sysAttachmentDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);

		if (list.size()>0){
			for(SysAttachment detail:list){
				detail.setUpdateflag(false);
				try {
					detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));

					String path = detail.getPath();
					if(StringUtil.isNotEmpty(path)) {
						int lastIndex = path.replaceAll("\\\\", "/").lastIndexOf("/");
						String key = path.substring(lastIndex+1);
						logger.info(key);

						String filePath = path.replace("getResource.do?path=sysAttachment/", "");
						filePath = sysAttachmentFolder + filePath;
						File file = new File(filePath);
						if(!file.exists()) {
							File resFile = new File(pathMap.get(key));
							FileUtil.copyFolder(resFile , new File(filePath.replace(key, "")));
						}
					}
				}catch (Exception e){
					logger.error(e.getMessage(),e);
				}
			}
			//批量保存
			sysAttachmentDao.saveBatch(list);
		}
	}

	@Override
	public List<SysAttachment> findDSOutList(List<String> filePaths,String startDate) {
		List<SysAttachment> list = sysAttachmentDao.searchFromInToOutForExport(startDate);
		list.forEach(sysAttachment->{
			if (StringUtil.isNotEmpty(sysAttachment.getPath())) {
				filePaths.add(sysAttachmentFolder + sysAttachment.getPath().replace("getResource.do?path=sysAttachment/", ""));
			}
		});
		return list;
	}

	@Override
	public void saveOrUpdateForImport(SysAttachment sysAttachment) {
		try {

			sysAttachment.setUpdateflag(false);

			SysAttachment dbSysAttachment = sysAttachmentDao.findById(sysAttachment.getId());
			if(dbSysAttachment == null){
				sysAttachment.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, sysAttachment.getUpdateTime(), 1));
				sysAttachmentDao.saveForDS(sysAttachment);
			}else{
				if(sysAttachment.getUpdateTime().getTime() > dbSysAttachment.getUpdateTime().getTime()){
					sysAttachment.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, sysAttachment.getUpdateTime(), 1));
					sysAttachmentDao.updateForDS(sysAttachment);
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}
	}

	@Override
	public void saveOrUpdateForImport2(SysAttachment sysAttachment, Map<String, String> pathMap) {

		try {
			sysAttachment.setUpdateflag(false);
			boolean isSave = false;

			SysAttachment dbSysAttachment = sysAttachmentDao.findById(sysAttachment.getId());
			if(dbSysAttachment == null){
				sysAttachment.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, sysAttachment.getUpdateTime(), 1));
				sysAttachmentDao.saveForDS(sysAttachment);
				isSave = true;
			}else{
				if(sysAttachment.getUpdateTime().getTime() > dbSysAttachment.getUpdateTime().getTime()){
					sysAttachment.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, sysAttachment.getUpdateTime(), 1));
					sysAttachmentDao.updateForDS(sysAttachment);
					isSave = true;
				}
			}
			if(isSave){
				String path = sysAttachment.getPath();
				if(StringUtil.isNotEmpty(path)) {
					int lastIndex = path.replaceAll("\\\\", "/").lastIndexOf("/");
					String key = path.substring(lastIndex+1);
					logger.info(key);

					String filePath = path.replace("getResource.do?path=sysAttachment/", "");
					filePath = sysAttachmentFolder + filePath;
					File file = new File(filePath);
					if(!file.exists()) {
						File resFile = new File(pathMap.get(key));
						FileUtil.copyFolder(resFile , new File(filePath.replace(key, "")));
					}
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}

	}

	@Override
	public List<SysAttachment> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sysAttachmentDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(SysAttachment sysAttachment) {
		sysAttachment.setUpdateflag(false);
		if(sysAttachment.getActive() == null){
			sysAttachment.setActive(true);
		}
		//和数据进行比较有就更新无就创建
		SysAttachment dbsysAttachment = sysAttachmentDao.findById(sysAttachment.getId());
		if (dbsysAttachment != null) {
			if(sysAttachment.getUpdateTime().getTime() > dbsysAttachment.getUpdateTime().getTime()){
				sysAttachmentDao.updateForDS(sysAttachment);
			}
		} else {
			sysAttachmentDao.saveForDS(sysAttachment);
		}
	}

}
