package com.bcxin.ars.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.ThirdAuthorizationDao;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.ThirdAuthorization;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ThirdAuthorizationService;
import com.bcxin.ars.service.util.ArsUtil;

@Service
@Transactional
public class ThirdAuthorizationServiceImpl implements ThirdAuthorizationService {

	@Autowired
	private ThirdAuthorizationDao thirdAuthorizationDao;

    @Autowired
    private ArsUtil arsUtil;
    
	@Override
	public void saveOrUpdate(ThirdAuthorization thirdAuthorization) {
		User currentUser = arsUtil.getCurrentUser();
		if(thirdAuthorization.getId() == null) {
			ThirdAuthorization dbThirdAuthorization = thirdAuthorizationDao.findByUserIdAndType(thirdAuthorization.getUserId(), thirdAuthorization.getType());
			if(dbThirdAuthorization == null) {
				thirdAuthorization.setActive(true);
				thirdAuthorization.setCreateTime(new Date());
				thirdAuthorization.setUpdateTime(new Date());
				thirdAuthorization.setUpdateBy(currentUser.getUsername());
				thirdAuthorizationDao.save(thirdAuthorization);
			}
		}
	}

	@Override
	public void delete(ThirdAuthorization thirdAuthorization) {
		User currentUser = arsUtil.getCurrentUser();
		if(thirdAuthorization.getId() == null) {
			ThirdAuthorization dbThirdAuthorization = thirdAuthorizationDao.findByUserIdAndType(thirdAuthorization.getUserId(), thirdAuthorization.getType());
			if(dbThirdAuthorization != null) {
				dbThirdAuthorization.setActive(false);
				dbThirdAuthorization.setUpdateTime(new Date());
				dbThirdAuthorization.setUpdateBy(currentUser.getUsername());
				thirdAuthorizationDao.delete(dbThirdAuthorization);
			}
		}else {
			thirdAuthorization.setActive(false);
			thirdAuthorization.setUpdateTime(new Date());
			thirdAuthorization.setUpdateBy(currentUser.getUsername());
			thirdAuthorizationDao.delete(thirdAuthorization);
		}
	}

	@Override
	public ThirdAuthorization findById(Long id) {
		return thirdAuthorizationDao.findById(id);
	}

	@Override
	public List<ThirdAuthorization> findByUserId(Long userid) {
		return thirdAuthorizationDao.findByUserId(userid);
	}

	@Override
	public ThirdAuthorization findByUserIdAndThirdName(Long userid, String thirdName) {
		return thirdAuthorizationDao.findByUserIdAndThirdName(userid, thirdName);
	}

	@Override
	public ThirdAuthorization findByUserIdAndType(Long userid, String type) {
		return thirdAuthorizationDao.findByUserIdAndType(userid, type);
	}

	@Override
	public List<ThirdAuthorization> findByUserIdForApp(Long userid) {
		return thirdAuthorizationDao.findByUserIdForApp(userid);
	}
	
}
