package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.service.SecurityCompanyPersonService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class SecurityCompanyPersonServiceImpl implements SecurityCompanyPersonService {
	
	@Autowired
	private SecurityCompanyPersonDao companyPersonDao;

	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public Long save(SecurityCompanyPerson companyPerson) {
		companyPerson.setActive(true);
		//如果有创建时间，则不设置
		if(companyPerson.getCreateTime()==null) {
			companyPerson.setCreateTime(new Date());
		}
		companyPerson.setUpdateTime(new Date());
		companyPerson.setUpdateBy(arsUtil.getCurrentUser() == null? "system":arsUtil.getCurrentUser().getUsername());
		return companyPersonDao.save(companyPerson);
	}

	@Override
	public void saveBatch(List<SecurityCompanyPerson> list){
		companyPersonDao.saveBatch(list);
	}

	@Override
	public void saveOrUpdateForDS(SecurityCompanyPerson companyPerson) {

		if(companyPerson.getActive() == null){
			companyPerson.setActive(true);
		}
		
		if(!companyPerson.getActive()){
			companyPersonDao.delete(companyPerson);
		}else{
			SecurityCompanyPerson dbCompanyPerson =companyPersonDao.findById(companyPerson.getId());
			if(dbCompanyPerson == null) {
				companyPersonDao.save(companyPerson);
			} else {
				if(companyPerson.getUpdateTime().getTime() > dbCompanyPerson.getUpdateTime().getTime()){
					companyPersonDao.updateForDS(companyPerson);
				}
			}
		}
	}
	@Override
	public void update(SecurityCompanyPerson companyPerson) {
		companyPerson.setUpdateTime(new Date());
		companyPersonDao.update(companyPerson);
	}

	@Override
	public List<SecurityCompanyPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return null;
	}

	@Override
	public void delete(SecurityCompanyPerson companyPerson) {
		companyPerson.setUpdateTime(new Date());
		companyPerson.setUpdateBy(arsUtil.getCurrentUser().getUsername());
		companyPersonDao.delete(companyPerson);
	}

	@Override
	public SecurityCompanyPerson findByPerson(SecurityPerson person) {
		return companyPersonDao.findByPersonId(person.getId());
	}

	@Override
	public SecurityCompanyPerson findSingleByPerson(SecurityPerson person) {
		return companyPersonDao.findSingleByPersonId(person.getId());
	}

	@Override
	public List<SecurityCompanyPerson> findByRoleId(Long roleId) {
		return companyPersonDao.findByRoleId(roleId);
	}

	@Override
	public List<SecurityCompanyPerson> findByOrgId(Long orgId) {
		return companyPersonDao.findByOrgId(orgId);
	}


	@Override
	public SecurityCompanyPerson findByPersonAndCompany(Long personId, Long companyId) {
		return companyPersonDao.findByPersonAndCompany(personId,companyId);
	}

	@Override
	public void deleteByPersonId(Long personId) {
		companyPersonDao.deleteByPersonId(personId);
	}

	@Override
	public SecurityCompanyPerson findById(Long Id) {
		return companyPersonDao.findById(Id);
	}

}
